/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.atualizarsistema.view;

import br.com.bb.plugins.gac.apresentacao.BasicDialog;
import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.action.AtualizarModuloBasicoAction;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.action.AtualizarSistemaAction;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.action.DowloadXMLDescritorAction;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.action.ListarAplicativosSistemaAction;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.action.ProcessarXMLDescritorAction;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.action.RemoverAplicacaoAction;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.form.AtualizarSistemaForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.ReinicializadorDeAplicacao;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelAtualizacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelInstalacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoInstaladoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.VersaoSistemaBO;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBFileDownLoad;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewAtualizarSistema
extends BasicInternalFrame {
    private JPanel jpMain = null;
    private JPanel panelTabelas = null;
    private JPanel jpTabelas = null;
    private JPanel jpBotoes = null;
    private JPanel jpBotaoRemover = null;
    private JPanel jpModuloBasico = null;
    private BBJTableImpl<VersaoSistemaBO> tableSobre = null;
    private BBJTableImpl<VersaoSistemaBO> tableModuloBasicoAtualizar = null;
    private BBJTableImpl<AplicativoInstaladoBO> tableatualizados = null;
    private BBJTableImpl<AplicativoDisponivelAtualizacaoBO> tableDispAtualizar = null;
    private BBJTableImpl<AplicativoDisponivelInstalacaoBO> tableDispInstalar = null;
    private BBJButton bbExecutar = null;
    private BBJButton bbVoltar = null;
    private BBJButton botaoDownloadAtualizacaoModuloBasico = null;
    private BBJButton botaoRemoverAplicacao = null;
    private JPanel tabpInstalados;
    private JPanel tabpSobre;
    private JPanel tabpDispAtualizar;
    private JPanel tabpDispInstalar;
    private JPanel tabpModuloBasicoAtualizar;
    private BBFileDownLoad fileDownload = null;
    private boolean aplicativoIncompativelComAVersao;
    private JPanel jpAtualizacaoModuloBasico = null;
    private String servico;

    public ViewAtualizarSistema() {
        super(null, false, false);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPMain());
        this.setBorder(BorderFactory.createEmptyBorder(5, 20, 8, 20));
        this.setBackground(Color.WHITE);
        this.setTitulo("M\u00f3dulos e Atualiza\u00e7\u00f5es Dispon\u00edveis");
    }

    public BBFileDownLoad getFileDownload() {
        if (this.fileDownload == null) {
            this.fileDownload = new BBFileDownLoad("aplicativos.xml", 0L);
            this.fileDownload.setPath(ConfiguracaoProperties.getConfiguracaoProperties().getDirTemp());
            this.fileDownload.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand() != null && e.getActionCommand().startsWith("CONCLUIDO:")) {
                        ViewAtualizarSistema.this.processaXMLDescritor((AtualizarSistemaForm)ViewAtualizarSistema.this.getForm());
                    } else if (e.getActionCommand() != null && e.getActionCommand().startsWith("ERRO:")) {
                        if (e.getActionCommand().startsWith("ERRO:MI061")) {
                            BBJPopupMensagem.exibirMensagemAlerta(e.getActionCommand().replaceAll("ERRO:MI061:", ""));
                        } else {
                            BBJPopupMensagem.exibirMensagem(ViewAtualizarSistema.this.getMensagem("MI001"));
                        }
                    }
                }
            });
        }
        return this.fileDownload;
    }

    public JPanel getJPMain() {
        if (this.jpMain == null) {
            this.jpMain = new JPanel();
            this.jpMain.setOpaque(false);
            this.jpMain.setLayout(new BorderLayout());
            this.jpMain.add((Component)this.getPanelTabelas(), "North");
        }
        return this.jpMain;
    }

    public JPanel getPanelTabelas() {
        if (this.panelTabelas == null) {
            this.panelTabelas = new JPanel();
            this.panelTabelas.setOpaque(false);
            this.panelTabelas.setLayout(new BorderLayout());
            this.panelTabelas.add((Component)this.getJpTabelas(), "North");
            this.panelTabelas.add((Component)this.getJpBotoes(), "Center");
        }
        return this.panelTabelas;
    }

    public BBJButton getBBExecutar() {
        if (this.bbExecutar == null) {
            this.bbExecutar = new BBJButton("CONFIRMAR");
            this.bbExecutar.setPreferredSize(new Dimension(90, 18));
            AtualizarSistemaAction acao = this.getActionFactory().novoAtualizarSistemaAction();
            this.bbExecutar = this.getBotaoFactory().novoConfirmar(acao);
        }
        return this.bbExecutar;
    }

    public BBJButton getBBVoltar() {
        if (this.bbVoltar == null) {
            this.bbVoltar = this.getBotaoFactory().novoVoltar();
            this.bbVoltar.setPreferredSize(new Dimension(90, 18));
        }
        return this.bbVoltar;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public void posExecucaoAtualizarSistemaAction() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.setAplicativoIncompativelComAVersao(new Boolean(false));
        List<AplicativoDisponivelAtualizacaoBO> listaAtualizar = this.getTableDispAtualizar().getBbtModel().getItensSelecionados();
        List<AplicativoDisponivelInstalacaoBO> listaInstalar = this.getTableDispInstalar().getBbtModel().getItensSelecionados();
        this.removaAtualizacaoIncompativelComAVersao(listaAtualizar);
        this.removaInstalacaoIncompativelComAVersao(listaInstalar);
        if (!(listaAtualizar != null && listaAtualizar.size() != 0 || listaInstalar != null && listaInstalar.size() != 0)) {
            if (this.isAplicativoIncompativelComAVersao()) {
                this.mensagemDeVersaoIncompativel();
                this.carregarTabelas();
            } else {
                BBJPopupMensagem.exibirMensagem(this.getMensagem("MI003"));
            }
            return;
        }
        context.put("LISTAATUALIZAR", listaAtualizar);
        context.put("LISTAINSTALAR", listaInstalar);
        context.put("INCOMPATIVEL", this.isAplicativoIncompativelComAVersao());
        context.put("INCOMPLETO", false);
        ControlableView view = ViewController.getInstance().goToView("GACBAIXARAPLICATIVOS", context, false);
        if (view instanceof BasicDialog) {
            view.doShow(context);
        }
        if (!((Boolean)context.get("INCOMPLETO")).booleanValue() && !((Boolean)context.get("INCOMPATIVEL")).booleanValue()) {
            try {
                BBJPopupMensagem.exibirMensagem("O download do arquivo foi realizado com sucesso. Favor acessar o m\u00f3dulo para finalizar a instala\u00e7\u00e3o");
            }
            catch (Exception e) {
                BBJPopupMensagem.exibirMensagemErro("Ocorreu problema durante a instala\u00e7\u00e3o." + e.getMessage());
            }
        }
        this.carregarTabelas();
        this.atualizarInterface();
    }

    protected boolean isAplicativoIncompativelComAVersao() {
        return this.aplicativoIncompativelComAVersao;
    }

    private void removaInstalacaoIncompativelComAVersao(List<AplicativoDisponivelInstalacaoBO> listaInstalar) {
        HashSet<AplicativoDisponivelInstalacaoBO> listaInstalarVersaoIncompativel = new HashSet<AplicativoDisponivelInstalacaoBO>();
        for (AplicativoDisponivelInstalacaoBO aplicativoDisponivelInstalacaoBO : listaInstalar) {
            if (Util.parseLong(this.getMensagem("versao.gac")) >= Util.parseLong(aplicativoDisponivelInstalacaoBO.getVersaominimagac())) continue;
            listaInstalarVersaoIncompativel.add(aplicativoDisponivelInstalacaoBO);
            this.setAplicativoIncompativelComAVersao(new Boolean(true));
        }
        listaInstalar.removeAll(listaInstalarVersaoIncompativel);
    }

    private void mensagemDeVersaoIncompativel() {
        BBJPopupMensagem.exibirMensagemAlerta(UtilMensagem.getInstancia().getMensagem("MI058"));
    }

    private boolean possuiAplicacaoIncompativelComAVersao(Set<AplicativoDisponivelAtualizacaoBO> listaAtualizarVersaoIncompativel, Set<AplicativoDisponivelInstalacaoBO> listaInstalarVersaoIncompativel) {
        return listaAtualizarVersaoIncompativel.size() > 0 || listaInstalarVersaoIncompativel.size() > 0;
    }

    private void removaAtualizacaoIncompativelComAVersao(List<AplicativoDisponivelAtualizacaoBO> listaAtualizar) {
        HashSet<AplicativoDisponivelAtualizacaoBO> listaAtualizarVersaoIncompativel = new HashSet<AplicativoDisponivelAtualizacaoBO>();
        for (AplicativoDisponivelAtualizacaoBO aplicativoDisponivelAtualizacaoBO : listaAtualizar) {
            if (Util.parseLong(this.getMensagem("versao.gac")) >= Util.parseLong(aplicativoDisponivelAtualizacaoBO.getVersaominimagac())) continue;
            listaAtualizarVersaoIncompativel.add(aplicativoDisponivelAtualizacaoBO);
            this.setAplicativoIncompativelComAVersao(new Boolean(true));
        }
        listaAtualizar.removeAll(listaAtualizarVersaoIncompativel);
    }

    private void setAplicativoIncompativelComAVersao(boolean aplicativoIncompativelComAVersao_) {
        this.aplicativoIncompativelComAVersao = aplicativoIncompativelComAVersao_;
    }

    public void posExecucaoProcessarXMLDescritorAction() {
        AtualizarSistemaForm form = (AtualizarSistemaForm)this.getForm();
        this.getTableDispAtualizar().getBbtModel().setDataListTabela(form.getListaAplicativosDisponiveisAtualizacao());
        this.getTableDispInstalar().getBbtModel().setDataListTabela(form.getListaAplicativosDisponiveisInstalacao());
        this.mostraVersaoNovaModuloBasicoAtualizar(form.getListaModuloBasicoParaAtualizar());
    }

    private void mostraVersaoNovaModuloBasicoAtualizar(List<AplicativoDisponivelAtualizacaoBO> listaModuloBasicoParaAtualizar) {
        this.getTabpModuloBasicoAtualizar().setVisible(false);
        if (listaModuloBasicoParaAtualizar != null && !listaModuloBasicoParaAtualizar.isEmpty()) {
            this.getTabpModuloBasicoAtualizar().setVisible(true);
        }
    }

    private void processaXMLDescritor(AtualizarSistemaForm form) {
        ProcessarXMLDescritorAction acao = this.getActionFactory().novoProcessarXMLDescritorAction();
        try {
            acao.executar(form);
            this.posExecucaoProcessarXMLDescritorAction();
            this.atualizarInterface();
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MI017"));
        }
    }

    @Override
    public void doShow(Map context) {
        this.servico = null;
        if (context != null && context.containsKey("SERVICO")) {
            this.servico = (String)context.get("SERVICO");
        }
        this.setVisible(true);
        this.carregarTabelas();
    }

    private void carregarTabelas() {
        ListarAplicativosSistemaAction acao = this.getActionFactory().novoListarAplicativosSistemaAction();
        AtualizarSistemaForm form = (AtualizarSistemaForm)this.getForm();
        form.setFileDownload(this.getFileDownload());
        try {
            acao.executar(form);
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MI017"));
        }
        this.getTableAtualizados().getBbtModel().setDataListTabela(form.getListaAplicativosInstalados());
        this.getTableAtualizados().validate();
        DowloadXMLDescritorAction acaoDownloadDescritor = this.getActionFactory().novoDowloadXMLDescritorAction();
        try {
            acaoDownloadDescritor.executar(form);
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MI001"));
        }
        this.checkItemTableDisponivelInstalar();
    }

    private void checkItemTableDisponivelInstalar() {
        if (this.servico == null) {
            return;
        }
        int i = 0;
        while (i < this.getTableDispInstalar().getBbtModel().getDataListTabela().size()) {
            if (this.servico.equals(this.getTableDispInstalar().getBbtModel().getDataListTabela().get(i).getCodigo())) {
                this.getTableDispInstalar().getBbtModel().getDataListTabela().get(i).setMarcado(true);
                this.getTableDispInstalar().getBbtModel().marcaLinha();
                this.servico = null;
                return;
            }
            ++i;
        }
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }

    public JPanel getJpBotoes() {
        if (this.jpBotoes == null) {
            this.jpBotoes = new JPanel();
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(2);
            this.jpBotoes.setOpaque(false);
            this.jpBotoes.setLayout(layout);
            this.jpBotoes.add(this.getBBExecutar());
            this.jpBotoes.add(this.getBBVoltar());
        }
        return this.jpBotoes;
    }

    public JPanel getJpBotaoRemover() {
        if (this.jpBotaoRemover == null) {
            this.jpBotaoRemover = new JPanel();
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(2);
            this.jpBotaoRemover.setOpaque(false);
            this.jpBotaoRemover.setLayout(layout);
            this.jpBotaoRemover.add(this.getBotaoRemoverAplicacao());
        }
        return this.jpBotaoRemover;
    }

    public void setJpBotoes(JPanel jpBotoes) {
        this.jpBotoes = jpBotoes;
    }

    public JPanel getJpAtualizacaoModuloBasico() {
        if (this.jpAtualizacaoModuloBasico == null) {
            this.jpAtualizacaoModuloBasico = new JPanel();
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(0);
            this.jpAtualizacaoModuloBasico.setOpaque(false);
            this.jpAtualizacaoModuloBasico.setLayout(layout);
            this.jpAtualizacaoModuloBasico.add(new BBJLabel("Existe uma vers\u00e3o nova do BB Gest\u00e3o Max, clique no bot\u00e3o DOWNLOAD"));
            this.jpAtualizacaoModuloBasico.add(this.getBotaoDownloadAtualizacaoModuloBasico());
        }
        return this.jpAtualizacaoModuloBasico;
    }

    public void setJpAtualizacaoModuloBasico(JPanel jpAtualizacaoModuloBasico_) {
        this.jpAtualizacaoModuloBasico = jpAtualizacaoModuloBasico_;
    }

    public JPanel getJpTabelas() {
        if (this.jpTabelas == null) {
            this.jpTabelas = new JPanel();
            this.jpTabelas.setLayout(new BoxLayout(this.jpTabelas, 1));
            this.jpTabelas.setOpaque(false);
            this.jpTabelas.add(Box.createRigidArea(new Dimension(10, 10)));
            this.jpTabelas.add(this.getTabpModuloBasico());
            this.jpTabelas.add(Box.createRigidArea(new Dimension(10, 10)));
            this.jpTabelas.add(this.getTabpInstalados());
            this.jpTabelas.add(Box.createRigidArea(new Dimension(10, 5)));
            this.jpTabelas.add(this.getJpBotaoRemover());
            this.jpTabelas.add(Box.createRigidArea(new Dimension(10, 10)));
            this.jpTabelas.add(this.getTabpDispAtualizar());
            this.jpTabelas.add(Box.createRigidArea(new Dimension(10, 10)));
            this.jpTabelas.add(this.getTabpDispInstalar());
        }
        return this.jpTabelas;
    }

    private Component getTabpModuloBasico() {
        if (this.jpModuloBasico == null) {
            this.jpModuloBasico = new JPanel();
            this.jpModuloBasico.setLayout(new BorderLayout());
            this.jpModuloBasico.setOpaque(false);
            this.jpModuloBasico.add((Component)this.getTabpSobre(), "Center");
            this.jpModuloBasico.add((Component)this.getTabpModuloBasicoAtualizar(), "East");
        }
        return this.jpModuloBasico;
    }

    public void setJpTabelas(JPanel jpTabelas) {
        this.jpTabelas = jpTabelas;
    }

    public BBJTableImpl<VersaoSistemaBO> getTableSobre() {
        if (this.tableSobre == null) {
            String[] columnNames = new String[]{this.getMensagem("versao.gac"), ""};
            int[] columnSizes = new int[]{100, 100};
            int[] columnAligment = new int[]{2, 2};
            this.tableSobre = new BBJTableImpl(columnNames, columnSizes, columnAligment, 0);
        }
        return this.tableSobre;
    }

    public BBJTableImpl<VersaoSistemaBO> getTableModuloBasicoAtualizar() {
        if (this.tableModuloBasicoAtualizar == null) {
            String[] columnNames = new String[]{this.getMensagem("versao.gac"), ""};
            int[] columnSizes = new int[]{100, 100};
            int[] columnAligment = new int[]{2, 2};
            this.tableModuloBasicoAtualizar = new BBJTableImpl(columnNames, columnSizes, columnAligment, 0);
        }
        return this.tableModuloBasicoAtualizar;
    }

    public BBJTableImpl<AplicativoInstaladoBO> getTableAtualizados() {
        if (this.tableatualizados == null) {
            String[] columnNames = new String[]{"M\u00f3dulo", "Vers\u00e3o", "Data do Pacote", "Data da Baixa", "Usu\u00e1rio"};
            int[] columnSizes = new int[]{250, 100, 150, 150, 150};
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[4] = 2;
            int[] columnAligment = nArray;
            this.tableatualizados = new BBJTableImpl(columnNames, columnSizes, columnAligment, 5);
        }
        return this.tableatualizados;
    }

    public BBJTableImpl<AplicativoDisponivelAtualizacaoBO> getTableDispAtualizar() {
        if (this.tableDispAtualizar == null) {
            String[] columnNames = new String[]{"M\u00f3dulo", "Vers\u00e3o Atual", "Vers\u00e3o Dispon\u00edvel", "Data do Pacote", "Vers\u00e3o M\u00ednima do GAC", ""};
            int[] columnSizes = new int[]{250, 100, 150, 150, 150, 50};
            int[] nArray = new int[6];
            nArray[0] = 2;
            nArray[5] = 2;
            int[] columnAligment = nArray;
            this.tableDispAtualizar = new BBJTableImpl(columnNames, columnSizes, columnAligment, 10);
            this.tableDispAtualizar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        for (AplicativoDisponivelAtualizacaoBO aplicativo : ViewAtualizarSistema.this.tableDispAtualizar.getBbtModel().getDataListTabela()) {
                            if (!"GAC".equalsIgnoreCase(aplicativo.getCodigo())) continue;
                            aplicativo.setMarcado(true);
                        }
                    }
                }
            });
        }
        return this.tableDispAtualizar;
    }

    public BBJTableImpl<AplicativoDisponivelInstalacaoBO> getTableDispInstalar() {
        if (this.tableDispInstalar == null) {
            String[] columnNames = new String[]{"M\u00f3dulo", "Vers\u00e3o", "Data do Pacote", "Vers\u00e3o M\u00ednima do GAC", ""};
            int[] columnSizes = new int[]{250, 100, 150, 150, 50};
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[4] = 2;
            int[] columnAligment = nArray;
            this.tableDispInstalar = new BBJTableImpl(columnNames, columnSizes, columnAligment, 15);
            this.tableDispInstalar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        for (AplicativoDisponivelInstalacaoBO aplicativo : ViewAtualizarSistema.this.tableDispInstalar.getBbtModel().getDataListTabela()) {
                            if (!"GAC".equalsIgnoreCase(aplicativo.getCodigo())) continue;
                            aplicativo.setMarcado(true);
                        }
                    }
                }
            });
        }
        return this.tableDispInstalar;
    }

    public JPanel getTabpDispAtualizar() {
        if (this.tabpDispAtualizar == null) {
            this.tabpDispAtualizar = new JPanelTabTitulo("M\u00f3dulos Dispon\u00edveis para Atualiza\u00e7\u00e3o", this.getTableDispAtualizar());
        }
        return this.tabpDispAtualizar;
    }

    public JPanel getTabpDispInstalar() {
        if (this.tabpDispInstalar == null) {
            this.tabpDispInstalar = new JPanelTabTitulo("M\u00f3dulos Dispon\u00edveis para Instala\u00e7\u00e3o", this.getTableDispInstalar());
        }
        return this.tabpDispInstalar;
    }

    public JPanel getTabpSobre() {
        if (this.tabpSobre == null) {
            this.tabpSobre = new JPanelTabTitulo("Vers\u00e3o atual do BB Gest\u00e3oMax", this.getTableSobre());
        }
        return this.tabpSobre;
    }

    public JPanel getTabpModuloBasicoAtualizar() {
        if (this.tabpModuloBasicoAtualizar == null) {
            this.tabpModuloBasicoAtualizar = new JPanel();
            this.tabpModuloBasicoAtualizar.setVisible(false);
            this.tabpModuloBasicoAtualizar.setLayout(new BorderLayout());
            this.tabpModuloBasicoAtualizar.setOpaque(false);
            JPanel panelTabela = new JPanel();
            panelTabela.setLayout(new BorderLayout());
            panelTabela.add((Component)this.getJpAtualizacaoModuloBasico(), "First");
            this.tabpModuloBasicoAtualizar.add((Component)panelTabela, "Center");
            panelTabela.setBorder(BBJBordaOval.createOvalBorder("BB Gest\u00e3oMax Dispon\u00edvel para Atualiza\u00e7\u00e3o"));
            panelTabela.setOpaque(false);
        }
        return this.tabpModuloBasicoAtualizar;
    }

    public JPanel getTabpInstalados() {
        if (this.tabpInstalados == null) {
            this.tabpInstalados = new JPanelTabTitulo("M\u00f3dulos Instalados", this.getTableAtualizados());
        }
        return this.tabpInstalados;
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoAtualizarSistemaForm();
    }

    private void atualizarInterface() {
        this.validate();
    }

    public static void main(String[] args) {
        ViewAtualizarSistema atualizarSistema = new ViewAtualizarSistema();
        atualizarSistema.doShow(null);
    }

    private BBJButton getBotaoDownloadAtualizacaoModuloBasico() {
        if (this.botaoDownloadAtualizacaoModuloBasico == null) {
            this.botaoDownloadAtualizacaoModuloBasico = this.getBotaoFactory().novoBotao("DOWNLOAD", this.getAcaoBotaoAbrir());
            this.botaoDownloadAtualizacaoModuloBasico.setPreferredSize(new Dimension(80, 18));
        }
        return this.botaoDownloadAtualizacaoModuloBasico;
    }

    private PluginActionAbstrato getAcaoBotaoAbrir() {
        AtualizarModuloBasicoAction acao = this.getActionFactory().novoAtualizarModuloBasicoAction();
        return acao;
    }

    public BBJButton getBotaoRemoverAplicacao() {
        if (this.botaoRemoverAplicacao == null) {
            this.botaoRemoverAplicacao = this.getBotaoFactory().novoBotao("REMOVER", new RemoverAplicacaoAction());
            this.botaoDownloadAtualizacaoModuloBasico.setPreferredSize(new Dimension(80, 18));
        }
        return this.botaoRemoverAplicacao;
    }

    public void setBotaoRemoverAplicacao(BBJButton botaoRemoverAplicacao) {
        this.botaoRemoverAplicacao = botaoRemoverAplicacao;
    }

    public void posExecucaoRemoverAplicacaoAction() {
        this.carregarTabelas();
        this.atualizarInterface();
        if (BBJPopupMensagem.exibirMensagemPerguntaBoolean("M\u00f3dulo removido com sucesso!<br><br> Deseja reiniciar o BB Gest\u00e3oMax para completar a opera\u00e7\u00e3o?")) {
            ReinicializadorDeAplicacao.reiniciaAplicacao(null);
        }
    }

    private class JPanelTabTitulo
    extends JPanel {
        public JPanelTabTitulo(String titulo, BBJTableImpl table) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            JPanel panelTabela = new JPanel();
            panelTabela.setLayout(new BorderLayout());
            panelTabela.add((Component)table.getTableHeader(), "First");
            panelTabela.add((Component)table, "Center");
            this.add((Component)panelTabela, "Center");
            panelTabela.setBorder(BBJBordaOval.createOvalBorder(titulo));
            panelTabela.setOpaque(false);
        }
    }
}

