/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.configurarbancodados.view;

import br.com.bb.plugins.gac.negocio.business.ConfigurarBancoDadosBO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjectIP;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import br.com.bb.plugins.gac.util.view.BBJFormPopup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListaServidoresBancoDadosPopup
extends BBJFormPopup
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel painelPrincipal = null;
    private JPanel painelDados = null;
    private JPanel barraBotoes = null;
    private BBJButton botaoConfirmar = null;
    private BBJButton botaoVoltar = null;
    private BBJTableScrollPane<IObjectIP> tableModel;
    private ArrayList<IObjectIP> listIP;
    private ConfigurarBancoDadosBO configurarBancoDadosBO;
    private boolean selecionou;
    private BBJProgressBar progressBar;
    private static final int TOTAL_ENDERECO_REDE = 254;
    private Thread threadBuscarRede;
    private int cont = 0;

    public ListaServidoresBancoDadosPopup(Frame owner, ConfigurarBancoDadosBO configurarBancoDadosBO) throws HeadlessException {
        super(owner, "BB Gest\u00e3oMax", "", new Dimension(700, 300));
        this.configurarBancoDadosBO = configurarBancoDadosBO;
        this.setBorder();
        this.setResizable(false);
        this.Centralizar();
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void initialize() {
        this.selecionou = false;
        this.remove(this.getBarraBotoes());
        this.add((Component)this.getBarraBotoes(), "South");
        this.add((Component)this.getPainelPrincipal(), "Center");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    ListaServidoresBancoDadosPopup.this.localizarNaRede();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }
        };
        worker.execute();
        this.doShow(null);
    }

    public BBJProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new BBJProgressBar(100L);
            this.progressBar.setSize(new Dimension(240, 22));
            this.progressBar.setPreferredSize(new Dimension(240, 22));
            this.progressBar.setMaximumSize(new Dimension(240, 22));
        }
        return this.progressBar;
    }

    public JPanel getPainelPrincipal() {
        if (this.painelPrincipal == null) {
            this.painelPrincipal = this.getPainelFactory().novoJPainel();
            this.painelPrincipal.setOpaque(false);
            this.painelPrincipal.setLayout(new BorderLayout());
            this.painelPrincipal.add((Component)this.getPainelDados(), "Center");
            this.painelPrincipal.add((Component)this.getProgressBar(), "South");
        }
        return this.painelPrincipal;
    }

    private JPanel getPainelDados() {
        if (this.painelDados == null) {
            this.painelDados = new JPanel();
            this.painelDados.setSize(700, 300);
            this.painelDados.setBorder(BBJBordaOval.createOvalBorder("Configura\u00e7\u00e3o do Banco de Dados - Bancos Localizados na Rede"));
            this.painelDados.setOpaque(false);
            this.painelDados.setLayout(new BorderLayout());
            this.painelDados.add((Component)this.getTableModel().getTable().getTableHeader(), "North");
            this.painelDados.add(this.getTableModel(), "Center");
        }
        return this.painelDados;
    }

    @Override
    public JPanel getBarraBotoes() {
        if (this.barraBotoes == null) {
            this.barraBotoes = this.getPainelFactory().novoJPainel();
            this.barraBotoes.removeAll();
            this.barraBotoes.setOpaque(false);
            FlowLayout flowLayout = this.getLayoutFactory().novoFlowLayout();
            flowLayout.setAlignment(2);
            this.barraBotoes.setLayout(flowLayout);
            this.barraBotoes.add(this.getBotaoConfirmar());
            this.barraBotoes.add(this.getBotaoVoltar());
        }
        return this.barraBotoes;
    }

    public BBJButton getBotaoVoltar() {
        if (this.botaoVoltar == null) {
            this.botaoVoltar = new BBJButton("VOLTAR");
            this.botaoVoltar.setFocusable(false);
            this.botaoVoltar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() instanceof BBJButton) {
                        try {
                            ListaServidoresBancoDadosPopup.this.fechar();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.botaoVoltar;
    }

    public BBJButton getBotaoConfirmar() {
        if (this.botaoConfirmar == null) {
            this.botaoConfirmar = new BBJButton("CONFIRMAR");
            this.botaoConfirmar.setEnabled(false);
            this.botaoConfirmar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() instanceof BBJButton) {
                        try {
                            ListaServidoresBancoDadosPopup.this.fechar();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.botaoConfirmar;
    }

    private void fechar() {
        try {
            try {
                this.doClose(null);
                this.threadBuscarRede.interrupt();
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.selecionou = true;
            }
        }
        finally {
            this.selecionou = true;
        }
    }

    public BBJTableScrollPane<IObjectIP> getTableModel() {
        if (this.tableModel == null) {
            String[] columnNames = new String[]{"IP", "Mensagem"};
            int[] columnSizes = new int[]{200, 500};
            int[] nArray = new int[2];
            nArray[1] = 2;
            int[] columnAligment = nArray;
            this.tableModel = new BBJTableScrollPane(columnNames, columnSizes, columnAligment, 5);
            this.tableModel.getBbtModel().setNomeColunas(new String[]{"ip", "mensagem"});
            this.tableModel.setOrdenacaoAutomatica(false);
            this.tableModel.setAutoscrolls(true);
            this.tableModel.setPreferredSize(new Dimension(0, 230));
            this.tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!e.getActionCommand().equals("EVENTO_ORDENACAO")) {
                        if (e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                            ListaServidoresBancoDadosPopup.this.getBotaoConfirmar().setEnabled(false);
                        } else if (e.getActionCommand().equals("SELECIONADO")) {
                            ListaServidoresBancoDadosPopup.this.getBotaoConfirmar().setEnabled(true);
                        }
                    }
                }
            });
        }
        return this.tableModel;
    }

    public ArrayList<IObjectIP> getListIP() {
        return this.listIP;
    }

    public void setListIP(ArrayList<IObjectIP> listIP) {
        this.listIP = listIP;
    }

    public void localizarNaRede() throws Exception {
        this.cont = 0;
        this.listIP = new ArrayList();
        String porta = this.configurarBancoDadosBO.getPortaTCPBancoDados();
        byte[] address = InetAddress.getLocalHost().getAddress();
        System.out.println("Testando a porta " + porta + " nos IPs...");
        int i = 1;
        while (i <= 254 && !this.selecionou) {
            block6: {
                int j = i;
                Socket socket = null;
                address[3] = (byte)j;
                String ip = InetAddress.getByAddress(address).toString().substring(1);
                try {
                    try {
                        socket = new Socket();
                        socket.connect(new InetSocketAddress(ip, Integer.parseInt(porta)), 100);
                        this.testarConexao(ip);
                    }
                    catch (Exception ex) {
                        System.out.println("Indispon\u00edvel: " + ip);
                        this.atualizarPorcentagemParaBarraProgressoVerificarPorta();
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.atualizarPorcentagemParaBarraProgressoVerificarPorta();
                    throw throwable;
                }
                this.atualizarPorcentagemParaBarraProgressoVerificarPorta();
            }
            ++i;
        }
        System.out.println("FIM VERIFICA\u00c7\u00c3O EM REDE");
    }

    private void testarConexao(final String ip) {
        this.threadBuscarRede = new Thread(new Runnable(){

            public void run() {
                System.out.println("Dispon\u00edvel no IP " + ip + ", testando conex\u00e3o... ");
                try {
                    String usuario = ListaServidoresBancoDadosPopup.this.configurarBancoDadosBO.getNomeUsuarioBancoDados();
                    String senha = ListaServidoresBancoDadosPopup.this.configurarBancoDadosBO.getSenhaBancoDados();
                    String porta = ListaServidoresBancoDadosPopup.this.configurarBancoDadosBO.getPortaTCPBancoDados();
                    Class.forName(ConfiguracaoProperties.getConfiguracaoProperties().getDriver()).newInstance();
                    String urlConexao = "jdbc:firebirdsql://" + ip + ":" + porta + "/BBGACA";
                    Connection db_connection = DriverManager.getConnection(urlConexao, usuario, senha);
                    db_connection.close();
                    if (ListaServidoresBancoDadosPopup.this.selecionou) {
                        return;
                    }
                    ListaServidoresBancoDadosPopup.this.listIP.add(new IObjectIP(ip, "conectou!"));
                    ListaServidoresBancoDadosPopup.this.tableModel.getBbtModel().addDataListTabela(ListaServidoresBancoDadosPopup.this.getListIP());
                    ListaServidoresBancoDadosPopup.this.tableModel.updateUI();
                    System.out.println(String.valueOf(ip) + " conectou!");
                }
                catch (Throwable t) {
                    System.out.println("fim verificacao: " + ip);
                    if (t.getMessage().contains("335544344")) {
                        ListaServidoresBancoDadosPopup.this.listIP.add(new IObjectIP(ip, "conectou EMBEDDED!"));
                        ListaServidoresBancoDadosPopup.this.tableModel.getBbtModel().addDataListTabela(ListaServidoresBancoDadosPopup.this.getListIP());
                        ListaServidoresBancoDadosPopup.this.tableModel.updateUI();
                        System.out.println(String.valueOf(ip) + " conectou EMBEDDED!");
                    }
                }
            }
        });
        this.threadBuscarRede.start();
    }

    public ConfigurarBancoDadosBO getConfigurarBancoDadosBO() {
        return this.configurarBancoDadosBO;
    }

    public void setConfigurarBancoDadosBO(ConfigurarBancoDadosBO configurarBancoDadosBO) {
        this.configurarBancoDadosBO = configurarBancoDadosBO;
    }

    public boolean isSelecionou() {
        return this.selecionou;
    }

    public void setSelecionou(boolean selecionou) {
        this.selecionou = selecionou;
    }

    public void atualizarPorcentagemParaBarraProgressoVerificarPorta() {
        ++this.cont;
        double divisao = (double)this.cont / 254.0;
        double porcentagem = divisao * 100.0;
        if (porcentagem <= 100.0) {
            this.getProgressBar().setValoratual((int)porcentagem);
        }
    }

    public static void main(String[] args) {
        try {
            Class.forName(ConfiguracaoProperties.getConfiguracaoProperties().getDriver()).newInstance();
            String urlConexao = "jdbc:firebirdsql:embedded:C:\\bancobrasil\\aplicativos\\BBGAC\\dados\\BBGACA.FDB";
            Connection db_connection = DriverManager.getConnection(urlConexao, "sysdba", "masterkey");
            String sql = "SELECT * FROM PSS P";
            PreparedStatement pstmt = db_connection.prepareStatement(sql);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

