/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.consultarremessagerar.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.consultarremessagerar.action.AvancarGerarRemessaAction;
import br.com.bb.plugins.gac.apresentacao.consultarremessagerar.action.ProcessarRemessaAction;
import br.com.bb.plugins.gac.apresentacao.consultarremessagerar.form.ConsultarRemessaGerarForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.decorator.GerarRemessaNegocioDecorator;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGerarRemessaProcessar
extends BasicInternalFrame {
    private final String[] columnNames = new String[]{"", "", ""};
    private final int[] columnSizes = new int[]{250, 200, 200};
    private final int[] columnAligment = new int[]{2, 2, 2};
    private BBJTableScrollPane<IObjectTableModel> tableModel;
    private JPanel panelTabela;
    private JPanel panelMain = null;
    private JPanel panelCentro = null;
    private JPanel panelSuperior = null;
    private JPanel panelInferior = null;
    private JPanel panelTotalRegistros = null;
    private JPanel panelBotoes = null;
    private BBJButton botaoMarcarTodos = null;
    private BBJButton botaoDesmarcarTodos = null;
    private BBJButton botaoProcessar = null;
    private BBJButton botaoVoltar = null;
    private BBJLabel lblTotalRegistros = null;
    private BBJLabel lblValorTotal = null;
    private BBJProgressBar bbprogress;
    private JPanel panelProgresso = null;
    private Map context;

    public ViewGerarRemessaProcessar() {
        super("Processar Remessa", false, false);
        this.initComponents();
    }

    private void initComponents() {
        this.add(this.getPanelMain());
    }

    public JPanel getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JPanel();
            this.panelMain.setOpaque(false);
            this.panelMain.setLayout(new BorderLayout());
            this.panelMain.add((Component)this.getPanelCentro(), "Center");
        }
        return this.panelMain;
    }

    private JPanel getTotalRegistros() {
        if (this.panelTotalRegistros == null) {
            this.panelTotalRegistros = new JPanel();
            this.panelTotalRegistros.setOpaque(false);
            this.panelTotalRegistros.setLayout(new BorderLayout());
            this.panelTotalRegistros.add((Component)this.getLblTotalRegistros(), "West");
            this.panelTotalRegistros.add((Component)this.getLblValorTotal(), "East");
            this.panelTotalRegistros.setPreferredSize(new Dimension(200, 30));
        }
        return this.panelTotalRegistros;
    }

    public BBJLabel getLblTotalRegistros() {
        if (this.lblTotalRegistros == null) {
            this.lblTotalRegistros = new BBJLabel("0");
            this.lblTotalRegistros.setOpaque(false);
        }
        return this.lblTotalRegistros;
    }

    public BBJLabel getLblValorTotal() {
        if (this.lblValorTotal == null) {
            this.lblValorTotal = new BBJLabel("0");
            this.lblValorTotal.setOpaque(false);
        }
        return this.lblValorTotal;
    }

    private JPanel GetPanelSuperior() {
        if (this.panelSuperior == null) {
            this.panelSuperior = new JPanel();
            this.panelSuperior.setOpaque(false);
            this.panelSuperior.setLayout(new BorderLayout());
            this.panelSuperior.add((Component)this.getPanelTabela(), "Center");
        }
        return this.panelSuperior;
    }

    public JPanel getPanelCentro() {
        if (this.panelCentro == null) {
            this.panelCentro = new JPanel();
            this.panelCentro.setLayout(new BorderLayout());
            this.panelCentro.setOpaque(false);
            this.panelCentro.add((Component)this.GetPanelSuperior(), "North");
            this.panelCentro.add((Component)this.getPanelInferior(), "Center");
        }
        return this.panelCentro;
    }

    private JPanel getPanelTabela() {
        if (this.panelTabela == null) {
            this.panelTabela = new JPanel();
            this.panelTabela.setLayout(new BorderLayout());
            Dimension d = new Dimension(600, 260);
            this.panelTabela.setSize(d);
            this.panelTabela.setPreferredSize(d);
            this.panelTabela.setOpaque(false);
            this.panelTabela.setBorder(BBJBordaOval.createOvalBorder());
            this.panelTabela.add(this.getTableModel(), "North");
        }
        return this.panelTabela;
    }

    public BBJTableScrollPane<IObjectTableModel> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BBJTableScrollPane(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.tableModel.setOrdenacaoAutomatica(true);
            this.tableModel.setPreferredSize(new Dimension(0, 230));
            this.tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        ViewGerarRemessaProcessar.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                        ViewGerarRemessaProcessar.this.habilitarBotoes();
                    } else {
                        e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO");
                    }
                }
            });
        }
        return this.tableModel;
    }

    private void habilitarBotoes() {
        int registrosMarcados = this.getTableModel().getItensChecadosCheckBox() != null ? this.getTableModel().getItensChecadosCheckBox().size() : 0;
        int totalRegistros = this.getTableModel().getDataListTabela() != null ? this.getTableModel().getDataListTabela().size() : 0;
        this.getBotaoProcessar().setEnabled(registrosMarcados > 0);
        this.getBotaoDesmarcarTodos().setEnabled(registrosMarcados > 0);
        this.getBotaoMarcarTodos().setEnabled(registrosMarcados < totalRegistros);
    }

    public JPanel getPanelInferior() {
        if (this.panelInferior == null) {
            this.panelInferior = new JPanel();
            this.panelInferior.setLayout(new BorderLayout());
            this.panelInferior.setOpaque(false);
            JPanel panelTotalBarraProgresso = new JPanel();
            panelTotalBarraProgresso.setOpaque(false);
            panelTotalBarraProgresso.setLayout(new BoxLayout(panelTotalBarraProgresso, 1));
            panelTotalBarraProgresso.add(this.getTotalRegistros());
            panelTotalBarraProgresso.add(this.getPanelProgresso());
            this.panelInferior.add((Component)panelTotalBarraProgresso, "North");
            this.panelInferior.add((Component)this.getPanelBotoes(), "Center");
        }
        return this.panelInferior;
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.setPreferredSize(new Dimension(0, 40));
            FlowLayout flayout = new FlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add(this.getBotaoMarcarTodos());
            this.panelBotoes.add(this.getBotaoDesmarcarTodos());
            this.panelBotoes.add(this.getBotaoProcessar());
            this.panelBotoes.add(this.getBotaoVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBotaoProcessar() {
        if (this.botaoProcessar == null) {
            this.botaoProcessar = this.getBotaoFactory().novoBotao("CONFIRMAR", this.getProcessarRemessaAction());
            this.botaoProcessar.setEnabled(false);
        }
        return this.botaoProcessar;
    }

    private ProcessarRemessaAction getProcessarRemessaAction() {
        return this.getActionFactory().novoProcessarRemessaAction();
    }

    public void preExecucaoProcessarRemessaAction() {
        this.getConsultarRemessaGerarForm().setLancamentosSelecionados(this.getTableModel().getItensChecadosCheckBox());
        this.getPanelProgresso().setVisible(true);
        this.getPanelInferior().validate();
    }

    public void posExecucaoProcessarRemessaAction() {
        GerarRemessaNegocioDecorator decorator = this.getConsultarRemessaGerarForm().getDecoratorGerarRemessa();
        if (decorator.getJasperViewer() != null) {
            decorator.getJasperViewer().setVisible(true);
        }
        ConsultarRemessaGerarForm form = this.getConsultarRemessaGerarForm();
        form.avancarRemessa();
        if (form.getGerarRemessaBO() == null) {
            form.recuarRemessa();
        }
        AvancarGerarRemessaAction action = this.getActionFactory().novoAvancarGerarRemessaAction();
        try {
            action.executar(form);
            this.popularTabelaLancamentos(form.getDecoratorGerarRemessa());
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(e.getMessage());
        }
    }

    public void posExecucaoFinalProcessarRemessaAction() {
        this.zerarBarraProgresso();
    }

    public BBJButton getBotaoDesmarcarTodos() {
        if (this.botaoDesmarcarTodos == null) {
            this.botaoDesmarcarTodos = new BBJButton("DESMARCAR TODOS");
            this.botaoDesmarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerarRemessaProcessar.this.marcarTodosRegistros(false);
                    ViewGerarRemessaProcessar.this.habilitarBotoes();
                }
            });
        }
        return this.botaoDesmarcarTodos;
    }

    public BBJButton getBotaoMarcarTodos() {
        if (this.botaoMarcarTodos == null) {
            this.botaoMarcarTodos = new BBJButton("MARCAR TODOS");
            this.botaoMarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerarRemessaProcessar.this.marcarTodosRegistros(true);
                    ViewGerarRemessaProcessar.this.habilitarBotoes();
                }
            });
        }
        return this.botaoMarcarTodos;
    }

    private void marcarTodosRegistros(boolean selected) {
        this.getTableModel().marcaTodos(selected);
    }

    public BBJButton getBotaoVoltar() {
        if (this.botaoVoltar == null) {
            this.botaoVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.botaoVoltar;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(this.getContext());
    }

    public Map getContext() {
        if (!UtilObjeto.isReferencia(this.context)) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        this.setContext(context);
        GerarRemessaNegocioDecorator decorator = (GerarRemessaNegocioDecorator)this.getContext().get("to");
        List listaRemessasSelecionados = (List)this.getContext().get("colecao");
        this.getConsultarRemessaGerarForm().setDecoratorGerarRemessa(decorator);
        this.getConsultarRemessaGerarForm().setListaRemessasSelecionados(listaRemessasSelecionados);
        this.getConsultarRemessaGerarForm().setPosicaoRemessa(0);
        if (decorator != null) {
            this.popularTabelaLancamentos(decorator);
        }
    }

    private void popularTabelaLancamentos(GerarRemessaNegocioDecorator decorator) {
        this.getTableModel().setDataListTabela(decorator.getListaDados());
        this.getTableModel().setConfiguracoes(decorator.getNomeColunas(), decorator.getTamanhoColunas(), decorator.getAlinhamentoColunas());
        String totalRegistros = "  Total de registros: " + decorator.getListaDados().size();
        this.getLblTotalRegistros().setText(totalRegistros);
        this.getLblValorTotal().setText("Valor Total: " + UtilFormatadorDeReal.formatar(decorator.getValorTotalLancamentos()) + "  ");
        this.configurarObserver(decorator);
        this.habilitarBotoes();
        this.revalidate();
    }

    private void configurarObserver(GerarRemessaNegocioDecorator decorator) {
        decorator.getNotificaProcessarRemessa().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Integer porcentagem = (Integer)arg;
                ViewGerarRemessaProcessar.this.atualizaProgressBar(porcentagem);
            }
        });
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }

    public ConsultarRemessaGerarForm getConsultarRemessaGerarForm() {
        return (ConsultarRemessaGerarForm)this.getForm();
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoConsultarRemessaGerarForm();
    }

    public JPanel getPanelProgresso() {
        if (this.panelProgresso == null) {
            this.panelProgresso = new JPanel();
            this.panelProgresso.setLayout(new BorderLayout());
            this.panelProgresso.setPreferredSize(new Dimension(0, 65));
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder("Progresso", 10));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
            this.panelProgresso.setVisible(false);
        }
        return this.panelProgresso;
    }

    public BBJProgressBar getBbprogress() {
        if (this.bbprogress == null) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    private void zerarBarraProgresso() {
        this.getBotaoVoltar().setEnabled(true);
        this.habilitarBotoes();
        this.getPanelProgresso().setVisible(false);
        this.atualizaProgressBar(0);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual(porcentagem.intValue());
        this.getBbprogress().updateUI();
    }
}

