/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.consultarremessaspendentes.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.consultarremessaspendentes.action.ConsultarRemessaPendenteAction;
import br.com.bb.plugins.gac.apresentacao.consultarremessaspendentes.action.ImprimirRemessaPendenteAction;
import br.com.bb.plugins.gac.apresentacao.consultarremessaspendentes.action.RecuperarRemessaAction;
import br.com.bb.plugins.gac.apresentacao.consultarremessaspendentes.form.ConsultarRemessaPendenteForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ActionFactory;
import br.com.bb.plugins.gac.negocio.business.RecuperarRemessasBO;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJPanelCheckBox;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewRecuperarRemessa
extends BasicInternalFrame {
    private final String[] columnNames = new String[]{"Tipo de Remessa", "N\u00ba da Remessa", "Data da Remessa", "N\u00ba do Conv\u00eanio", "Valor da Remessa", "Nome do Arquivo"};
    private final int[] columnSizes = new int[]{180, 100, 120, 100, 130, 180};
    private final int[] columnAligment;
    private BBJTableScrollPane tblRemessa;
    private JPanel pnlTabela;
    private BBJPanelCheckBox panelCheckBox;
    private JPanel panelBotoes;
    private JLabel lblDica;
    private BBJEstilos estiloLabel;
    private BBJProgressBar bbprogress;
    private JPanel panelProgresso;
    private BBJButton btnConfirmar;
    private BBJButton btnMarcarTodos;
    private BBJButton btnDesmarcarTodos;
    private BBJButton btnImprimir;
    private BBJButton btnVoltar;

    public ViewRecuperarRemessa() {
        super("Recuperar Remessa", false, false);
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[1] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        this.columnAligment = nArray;
        this.panelCheckBox = null;
        this.panelProgresso = null;
        this.initComponents();
    }

    public BBJPanelCheckBox getPanelCheckBox() {
        if (this.panelCheckBox == null) {
            this.panelCheckBox = new BBJPanelCheckBox(4, this.getConsultarRemessaAction());
            this.panelCheckBox.setBorder(BBJBordaOval.createOvalBorder());
            this.panelCheckBox.setPreferredSize(new Dimension(200, 60));
        }
        return this.panelCheckBox;
    }

    private void setDimension(JPanel pnl, Dimension dim) {
        pnl.setPreferredSize(dim);
        pnl.setMaximumSize(dim);
        pnl.setSize(dim);
        pnl.setMinimumSize(dim);
    }

    private void initComponents() {
        this.add((Component)this.getPnlTabela(), "North");
        this.setSize(800, 400);
    }

    public BBJProgressBar getBbprogress() {
        if (this.bbprogress == null) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    private void zerarBarraProgresso() {
        this.getBtnVoltar().setEnabled(true);
        this.habilitarBotoes();
        this.getPanelProgresso().setVisible(false);
        this.atualizaProgressBar(0);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual(porcentagem.intValue());
        this.getBbprogress().updateUI();
    }

    public JPanel getPanelProgresso() {
        if (this.panelProgresso == null) {
            this.panelProgresso = new JPanel();
            this.panelProgresso.setLayout(new BorderLayout());
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder("Progresso", 10));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
            this.panelProgresso.setVisible(false);
        }
        return this.panelProgresso;
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        super.doShow(context);
        try {
            this.getPanelCheckBox().getChkPagamento().setSelected(false);
            this.getPanelCheckBox().getChkServico().setSelected(false);
            this.getPanelCheckBox().getChkRecebimento().setSelected(true);
            this.getConsultarRemessaPendenteForm().setPagamento(false);
            this.getConsultarRemessaPendenteForm().setServico(false);
            this.getConsultarRemessaPendenteForm().setRecebimento(true);
            this.getConsultarRemessaAction().executar(this.getForm());
            this.getPanelCheckBox().getChkPagamento().requestFocus();
            this.preencherTblRemessa(false);
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(e.getMessage());
        }
    }

    public void posExecucaoConsultarRemessaPendenteAction() {
        this.preencherTblRemessa(true);
    }

    private void preencherTblRemessa(boolean exibirMensagem) {
        List list = this.getColecaoFactory().novoArrayList();
        for (RemessaTODecorator remessaTODecorator : this.getConsultarRemessaPendenteForm().getListaRemessaPendente()) {
            list.add(new RecuperarRemessasBO(remessaTODecorator));
        }
        this.getTblRemessa().getBbtModel().setDataListTabela(list);
        if (list.size() == 0 && exibirMensagem) {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MP004"));
        }
        this.habilitarBotoes();
    }

    private void habilitarBotoes() {
        int registrosMarcados = this.getTblRemessa().getBbtModel().getItensChecadosCheckBox() != null ? this.getTblRemessa().getBbtModel().getItensChecadosCheckBox().size() : 0;
        int totalRegistros = this.getTblRemessa().getBbtModel().getDataListTabela() != null ? this.getTblRemessa().getBbtModel().getDataListTabela().size() : 0;
        this.getBtnConfirmar().setEnabled(registrosMarcados > 0);
        this.getBtnDesmarcarTodos().setEnabled(registrosMarcados > 0);
        this.getBtnMarcarTodos().setEnabled(registrosMarcados < totalRegistros);
        this.getBtnImprimir().setEnabled(totalRegistros > 0);
    }

    private ConsultarRemessaPendenteForm getConsultarRemessaPendenteForm() {
        return (ConsultarRemessaPendenteForm)this.getForm();
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoConsultarRemessaPendenteForm();
    }

    private ConsultarRemessaPendenteAction getConsultarRemessaAction() {
        return this.getActionFactory().novoConsultarRemessaPendenteAction();
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }

    public JPanel getPnlDica() {
        if (this.lblDica == null) {
            this.estiloLabel = BBJEstilos.TEXTODICA;
            this.lblDica = new JLabel("Para sele\u00e7\u00e3o parcial utilize 'Shift' ou 'Ctrl' ");
            this.lblDica.setFont(this.estiloLabel.getFont());
            JPanel pnlDica = new JPanel(new FlowLayout(0));
            pnlDica.add(this.lblDica);
            pnlDica.setBackground(Color.white);
            return pnlDica;
        }
        return null;
    }

    private JPanel getPnlTabela() {
        this.pnlTabela = new JPanel();
        this.pnlTabela.setLayout(new BorderLayout());
        this.setDimension(this.pnlTabela, new Dimension(0, 380));
        this.pnlTabela.setOpaque(false);
        this.pnlTabela.setLayout(new BorderLayout());
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        pnl.setLayout(new BorderLayout());
        pnl.add(this.getTblRemessa(), "Center");
        this.pnlTabela.add((Component)this.getPanelCheckBox(), "North");
        this.pnlTabela.add((Component)pnl, "Center");
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getPanelProgresso(), "North");
        panel.add((Component)this.getPanelBotoes(), "Center");
        this.pnlTabela.add((Component)panel, "South");
        return this.pnlTabela;
    }

    public BBJTableScrollPane<RecuperarRemessasBO> getTblRemessa() {
        if (this.tblRemessa == null) {
            this.tblRemessa = new BBJTableScrollPane(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.tblRemessa.setPreferredSize(this.getLayoutFactory().novoDimension(0, 200));
            this.tblRemessa.setOpaque(false);
            this.tblRemessa.setOpaque(false);
            this.tblRemessa.getTable().setBorder(null);
            this.tblRemessa.getViewport().setOpaque(false);
            this.tblRemessa.setBorder(BBJBordaOval.createOvalBorder());
            this.tblRemessa.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        ViewRecuperarRemessa.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                        ViewRecuperarRemessa.this.habilitarBotoes();
                    }
                }
            });
        }
        return this.tblRemessa;
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = this.getPainelFactory().novoJPainel();
            this.panelBotoes.setOpaque(false);
            FlowLayout flayout = this.getLayoutFactory().novoFlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add(this.getBtnConfirmar());
            this.panelBotoes.add(this.getBtnMarcarTodos());
            this.panelBotoes.add(this.getBtnDesmarcarTodos());
            this.panelBotoes.add(this.getBtnImprimir());
            this.panelBotoes.add(this.getBtnVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBtnConfirmar() {
        RecuperarRemessaAction action = ActionFactory.getInstancia().novoRecuperarRemessaAction();
        if (this.btnConfirmar == null) {
            this.btnConfirmar = this.getBotaoFactory().novoConfirmar(action);
        }
        return this.btnConfirmar;
    }

    public void preExecucaoRecuperarRemessaAction() {
        ConsultarRemessaPendenteForm form = (ConsultarRemessaPendenteForm)this.getForm();
        form.setItensSelecionados(this.getTblRemessa().getItensChecadosCheckBox());
        this.getPanelProgresso().setVisible(true);
        this.getPanelProgresso().validate();
        this.getBtnConfirmar().setEnabled(false);
        this.getBtnDesmarcarTodos().setEnabled(false);
        this.getBtnMarcarTodos().setEnabled(false);
        this.getBtnImprimir().setEnabled(false);
        this.getBtnVoltar().setEnabled(false);
        this.atualizaProgressBar(0);
    }

    public void posExecucaoRecuperarRemessaAction() {
        BBJPopupMensagem.exibirMensagem(this.getMensagem("DBTMN045"));
    }

    public void posExecucaoFinalRecuperarRemessaAction() {
        try {
            this.getConsultarRemessaAction().executar(this.getForm());
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(e.getMessage());
        }
        this.preencherTblRemessa(false);
        this.zerarBarraProgresso();
    }

    public BBJButton getBtnMarcarTodos() {
        if (this.btnMarcarTodos == null) {
            this.btnMarcarTodos = new BBJButton("MARCAR TODOS");
            this.btnMarcarTodos.addActionListener(this.marcarCheckBoxTabela(true));
        }
        return this.btnMarcarTodos;
    }

    private ActionListener marcarCheckBoxTabela(final boolean marcar) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewRecuperarRemessa.this.getTblRemessa().getBbtModel().marcaTodos(marcar);
                ViewRecuperarRemessa.this.habilitarBotoes();
            }
        };
        return actionListener;
    }

    public BBJButton getBtnDesmarcarTodos() {
        if (this.btnDesmarcarTodos == null) {
            this.btnDesmarcarTodos = new BBJButton("DESMARCAR TODOS");
            this.btnDesmarcarTodos.addActionListener(this.marcarCheckBoxTabela(false));
        }
        return this.btnDesmarcarTodos;
    }

    public BBJButton getBtnImprimir() {
        if (this.btnImprimir == null) {
            ImprimirRemessaPendenteAction acao = this.getActionFactory().novoImprimirRemessaPendenteAction();
            this.btnImprimir = this.getBotaoFactory().novoImprimir(acao);
        }
        return this.btnImprimir;
    }

    public BBJButton getBtnVoltar() {
        if (this.btnVoltar == null) {
            this.btnVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.btnVoltar;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public void posExecucaoImprimirRemessaPendenteAction() {
        this.imprimirRemessaPendente();
    }

    private void imprimirRemessaPendente() {
        JasperPrint impressao = null;
        try {
            impressao = UtilRelatorioJasper.imprimirRelatorio(Arquivo.JASPER_REMESSAS_PENDENTES_RECUPERAR, this.getMapaParametros(), this.getConsultarRemessaPendenteForm().getListaRemessaPendente());
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (BBException e) {
            this.processarMensagemDeErro(this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro(this, e);
        }
    }

    private Map getMapaParametros() {
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        return mapa;
    }
}

