/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.consultarretornospendentes.action;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.consultarretornospendentes.form.ConsultarRetornosPendentesForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.ManterRetornosPendentesFacade;
import br.com.bb.plugins.gac.negocio.to.decorator.RetornoTODecorator;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoSegmento;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsultarRetornosPendentesAction
extends PluginActionAbstrato {
    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ConsultarRetornosPendentesForm pendentesForm = (ConsultarRetornosPendentesForm)form;
        pendentesForm.setListaRetornos(null);
        List<RetornoTODecorator> listaRetornos = this.getRetornoPendenteFacade().consultarRetornosPendentes();
        this.filtrarListaDeServicos(pendentesForm, listaRetornos);
        return null;
    }

    private void filtrarListaDeServicos(ConsultarRetornosPendentesForm retornosPendentesForm, List<RetornoTODecorator> listaRetornosPendentes) {
        ArrayList<RetornoTODecorator> listaRetornosFiltrados = new ArrayList<RetornoTODecorator>();
        for (RetornoTODecorator retornoTO : listaRetornosPendentes) {
            if (!this.isPagamento(retornoTO.getTipoSegmento(), retornosPendentesForm) && !this.isRecebimento(retornoTO.getTipoSegmento(), retornosPendentesForm) && !this.isServico(retornoTO.getTipoSegmento(), retornosPendentesForm)) continue;
            listaRetornosFiltrados.add(retornoTO);
        }
        retornosPendentesForm.setListaRetornos(listaRetornosFiltrados);
    }

    private boolean isPagamento(int tipoSegmento, ConsultarRetornosPendentesForm retornosPendentesForm) {
        Integer codigoTipoSegmento = new Integer(tipoSegmento);
        return retornosPendentesForm.isPagamento() && codigoTipoSegmento.equals(UtilDominioTipoSegmento.PAGAMENTO);
    }

    private boolean isRecebimento(int tipoSegmento, ConsultarRetornosPendentesForm retornosPendentesForm) {
        Integer codigoTipoSegmento = new Integer(tipoSegmento);
        return retornosPendentesForm.isRecebimento() && codigoTipoSegmento.equals(UtilDominioTipoSegmento.RECEBIMENTO);
    }

    private boolean isServico(int tipoSegmento, ConsultarRetornosPendentesForm retornosPendentesForm) {
        Integer codigoTipoSegmento = new Integer(tipoSegmento);
        return retornosPendentesForm.isServico() && codigoTipoSegmento.equals(UtilDominioTipoSegmento.SERVICO);
    }

    private ManterRetornosPendentesFacade getRetornoPendenteFacade() {
        return this.getFacadeFactory().novoManterRetornosPendentesFacade();
    }
}

