/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.consultarretornospendentes.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.consultarretornospendentes.action.ConsultarRetornosPendentesAction;
import br.com.bb.plugins.gac.apresentacao.consultarretornospendentes.action.ImprimirRetornosPendentesAction;
import br.com.bb.plugins.gac.apresentacao.consultarretornospendentes.form.ConsultarRetornosPendentesForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.decorator.RetornoTODecorator;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.constante.Excecao;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjRecuperarRetornos;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPanelCheckBox;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewProcessarRetorno
extends BasicInternalFrame {
    private String[] columnNames = new String[]{"Nome do Arquivo", "N\u00ba Conv\u00eanio", "N\u00ba Retorno", "N\u00ba Processo", "Data do Retorno", "Tipo Retorno"};
    private int[] columnSizes = new int[]{150, 100, 100, 100, 150, 120};
    private int[] columnAligment;
    private JPanel jpMain;
    private JPanel jpTabela;
    private JPanel panelBotoes;
    private BBJPanelCheckBox panelCheckBox;
    private BBJProgressBar bbprogress;
    private JPanel panelProgresso;
    private JPanel panelTabelaRetornos;
    private BBJTableScrollPane<IObjRecuperarRetornos> tblRetorno;
    private BBJButton btnMarcarTodos;
    private BBJButton btnDesmarcarTodos;
    private BBJButton botaoImprimir;
    private BBJButton botaoConfirmar;
    private BBJButton btnVoltar;

    public ViewProcessarRetorno() {
        super("Processamento de RetornoBBB", false, false);
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[5] = 2;
        this.columnAligment = nArray;
        this.jpMain = null;
        this.jpTabela = null;
        this.panelBotoes = null;
        this.panelCheckBox = null;
        this.panelProgresso = null;
        this.panelTabelaRetornos = null;
        this.initialize();
    }

    private void initialize() {
        this.add(this.getJPMain());
        this.configurarObserver();
    }

    public JPanel getJPMain() {
        if (this.jpMain == null) {
            this.jpMain = this.getPainelFactory().novoJPainel();
            this.jpMain.setOpaque(false);
            this.jpMain.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.jpMain.setBackground(Color.WHITE);
            this.jpMain.add((Component)this.getJpTabela(), "North");
        }
        return this.jpMain;
    }

    public BBJPanelCheckBox getPanelCheckBox() {
        if (this.panelCheckBox == null) {
            this.panelCheckBox = new BBJPanelCheckBox(4, this.getConsultarRetornosPendentesAction());
            this.panelCheckBox.setBorder(BBJBordaOval.createOvalBorder());
            this.panelCheckBox.setPreferredSize(this.getLayoutFactory().novoDimension(200, 60));
        }
        return this.panelCheckBox;
    }

    public void posExecucaoConsultarRetornosPendentesAction() {
        this.preencherTblRetorno(true);
    }

    public JPanel getJpTabela() {
        if (!this.isReferencia(this.jpTabela)) {
            this.jpTabela = this.getPainelFactory().novoJPainel();
            this.jpTabela.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.jpTabela.setOpaque(false);
            this.jpTabela.add((Component)this.getPanelCheckBox(), "North");
            this.jpTabela.add((Component)this.getPanelTabelaRetornos(), "Center");
            JPanel panel = this.getPainelFactory().novoJPainel();
            panel.setOpaque(false);
            panel.setLayout(this.getLayoutFactory().novoBorderLayout());
            panel.add((Component)this.getPanelProgresso(), "North");
            panel.add((Component)this.getPanelBotoes(), "Center");
            this.jpTabela.add((Component)panel, "South");
        }
        return this.jpTabela;
    }

    public JPanel getPanelTabelaRetornos() {
        if (this.panelTabelaRetornos == null) {
            this.panelTabelaRetornos = this.getPainelFactory().novoJPainel();
            this.panelTabelaRetornos.setOpaque(false);
            this.panelTabelaRetornos.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelTabelaRetornos.add(this.getTblRetornos(), "North");
            this.panelTabelaRetornos.setBorder(BBJBordaOval.createOvalBorder());
        }
        return this.panelTabelaRetornos;
    }

    public BBJProgressBar getBbprogress() {
        if (this.bbprogress == null) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    private void configurarObserver() {
        this.getConsultarRetornosPendentesForm().getNotificacaoRetorno().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Integer porcentagem = (Integer)arg;
                ViewProcessarRetorno.this.atualizaProgressBar(porcentagem);
            }
        });
    }

    public JPanel getPanelProgresso() {
        if (this.panelProgresso == null) {
            this.panelProgresso = new JPanel();
            this.panelProgresso.setLayout(new BorderLayout());
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder("Progresso", 10));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
            this.panelProgresso.setVisible(false);
        }
        return this.panelProgresso;
    }

    protected JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = this.getPainelFactory().novoJPainel();
            this.panelBotoes.setOpaque(false);
            FlowLayout flayout = this.getLayoutFactory().novoFlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add(this.getBotaoConfirmar());
            this.panelBotoes.add(this.getBtnMarcarTodos());
            this.panelBotoes.add(this.getBtnDesmarcarTodos());
            this.panelBotoes.add(this.getBotaoImprimir());
            this.panelBotoes.add(this.getBotaoVoltar());
        }
        return this.panelBotoes;
    }

    private BBJButton getBotaoImprimir() {
        if (!this.isReferencia(this.botaoImprimir)) {
            ImprimirRetornosPendentesAction acao = this.getActionFactory().novoImprimirRetornosPendentesAction();
            this.botaoImprimir = this.getBotaoFactory().novoImprimir(acao);
            this.botaoImprimir.setEnabled(false);
        }
        return this.botaoImprimir;
    }

    private BBJButton getBotaoConfirmar() {
        if (this.botaoConfirmar == null) {
            this.botaoConfirmar = this.getBotaoFactory().novoConfirmar(this.getActionFactory().novoProcessarRetornosPendentesAction());
            this.botaoConfirmar.setEnabled(false);
        }
        return this.botaoConfirmar;
    }

    private BBJButton getBotaoVoltar() {
        if (this.btnVoltar == null) {
            this.btnVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.btnVoltar;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    @Override
    public void doClose(Map context) {
        this.setVisible(false);
        super.doClose(context);
    }

    public void posExecucaoImprimirRetornosPendentesAction() {
        this.imprimirRelatorioRetornosPendentes();
    }

    private void imprimirRelatorioRetornosPendentes() {
        List listaRetornos = this.getColecaoFactory().novoArrayList();
        for (IObjRecuperarRetornos iObjRecuperarRetornos : this.getTblRetornos().getBbtModel().getItensSelecionados()) {
            listaRetornos.add(iObjRecuperarRetornos.getRetornoTODecorator());
        }
        JasperPrint imprimirRelatorio = null;
        try {
            imprimirRelatorio = UtilRelatorioJasper.imprimirRelatorio(Arquivo.JASPER_RETORNO, this.getMapaDeParametros(), listaRetornos);
            JasperViewer viewer = new JasperViewer(imprimirRelatorio, false);
            viewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
            viewer.setVisible(true);
        }
        catch (BBException e) {
            this.processarMensagemDeErro(this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro(this, e);
        }
    }

    private Map getMapaDeParametros() {
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        return mapa;
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        super.doShow(context);
        this.getPanelCheckBox().getChkPagamento().setSelected(false);
        this.getPanelCheckBox().getChkServico().setSelected(false);
        this.getPanelCheckBox().getChkRecebimento().setSelected(true);
        this.getConsultarRetornosPendentesForm().setPagamento(false);
        this.getConsultarRetornosPendentesForm().setServico(false);
        this.getConsultarRetornosPendentesForm().setRecebimento(true);
        this.consultarArquivosRetorno();
        if (this.getTblRetornos().getBbtModel().getDataListTabela() != null && this.getTblRetornos().getBbtModel().getDataListTabela().size() > 0) {
            this.getPanelCheckBox().getChkPagamento().requestFocus();
        } else {
            this.getBotaoVoltar().requestFocus();
        }
    }

    private void consultarArquivosRetorno() {
        try {
            this.getConsultarRetornosPendentesAction().executar(this.getConsultarRetornosPendentesForm());
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(this.getUtilMensagem().getMensagem(Excecao.getErroDeSistema(), e.getMessage()));
        }
        this.preencherTblRetorno(false);
    }

    private ConsultarRetornosPendentesAction getConsultarRetornosPendentesAction() {
        ConsultarRetornosPendentesAction action = this.getActionFactory().novoConsultarRetornosPendentesAction();
        return action;
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoConsultarRetornosPendentesForm();
    }

    private void preencherTblRetorno(boolean exibirMensagem) {
        List list = this.getColecaoFactory().novoArrayList();
        for (RetornoTODecorator retornoTODecorator : this.getConsultarRetornosPendentesForm().getListaRetornos()) {
            list.add(new IObjRecuperarRetornos(retornoTODecorator));
        }
        this.getTblRetornos().getBbtModel().setDataListTabela(list);
        if (list.size() == 0 && exibirMensagem) {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MP004"));
        }
        this.getBtnMarcarTodos().setEnabled(list.size() != 0);
        this.getBtnDesmarcarTodos().setEnabled(false);
    }

    public BBJTableScrollPane<IObjRecuperarRetornos> getTblRetornos() {
        if (this.tblRetorno == null) {
            this.tblRetorno = new BBJTableScrollPane(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.tblRetorno.setPreferredSize(this.getLayoutFactory().novoDimension(0, 200));
            this.tblRetorno.getBbtModel().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean checkSelecionado = e.getActionCommand().equalsIgnoreCase("SELECIONADO");
                    ViewProcessarRetorno.this.habilitarBotoes(checkSelecionado);
                    ViewProcessarRetorno.this.getBtnDesmarcarTodos().setEnabled(checkSelecionado);
                    if (ViewProcessarRetorno.this.tblRetorno.getBbtModel().getDataListTabela() != null) {
                        boolean isTodosSelecionados = ViewProcessarRetorno.this.tblRetorno.getBbtModel().getDataListTabela().size() == ViewProcessarRetorno.this.tblRetorno.getBbtModel().getItensSelecionados().size();
                        ViewProcessarRetorno.this.getBtnMarcarTodos().setEnabled(!isTodosSelecionados);
                    }
                }
            });
        }
        return this.tblRetorno;
    }

    private void habilitarBotoes(boolean habilitar) {
        this.getBotaoConfirmar().setEnabled(habilitar);
        this.getBotaoImprimir().setEnabled(habilitar);
    }

    private ConsultarRetornosPendentesForm getConsultarRetornosPendentesForm() {
        return (ConsultarRetornosPendentesForm)this.getForm();
    }

    public BBJButton getBtnMarcarTodos() {
        if (this.btnMarcarTodos == null) {
            this.btnMarcarTodos = new BBJButton("MARCAR TODOS");
            this.btnMarcarTodos.addActionListener(this.marcarCheckBoxTabela(true));
            this.btnMarcarTodos.setEnabled(false);
        }
        return this.btnMarcarTodos;
    }

    private ActionListener marcarCheckBoxTabela(final boolean marcar) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewProcessarRetorno.this.getTblRetornos().getBbtModel().marcaTodos(marcar);
                ViewProcessarRetorno.this.getBtnMarcarTodos().setEnabled(!marcar);
                ViewProcessarRetorno.this.getBtnDesmarcarTodos().setEnabled(marcar);
                ViewProcessarRetorno.this.habilitarBotoes(marcar);
            }
        };
        return actionListener;
    }

    public BBJButton getBtnDesmarcarTodos() {
        if (this.btnDesmarcarTodos == null) {
            this.btnDesmarcarTodos = new BBJButton("DESMARCAR TODOS");
            this.btnDesmarcarTodos.addActionListener(this.marcarCheckBoxTabela(false));
            this.btnDesmarcarTodos.setEnabled(false);
        }
        return this.btnDesmarcarTodos;
    }

    public void preExecucaoProcessarRetornosPendentesAction() {
        this.popularFormSelecionados();
        this.getBbprogress().setValoratual(0L);
        this.getPanelProgresso().setVisible(true);
        this.habilitarTodosBotoes(false);
    }

    public void posExecucaoProcessarRetornosPendentesAction() {
        List<RetornoTODecorator> listaRetornosProcessados = this.getConsultarRetornosPendentesForm().getListaRetornosProcessados();
        for (RetornoTODecorator decorator : listaRetornosProcessados) {
            if (decorator.getJasperViewer() == null) continue;
            decorator.getJasperViewer().setVisible(true);
        }
        this.consultarArquivosRetorno();
    }

    public void posExecucaoFinalProcessarRetornosPendentesAction() {
        this.zerarBarraProgresso();
        this.habilitarTodosBotoes(true);
    }

    private void zerarBarraProgresso() {
        this.getBotaoVoltar().setEnabled(true);
        this.getPanelProgresso().setVisible(false);
        this.atualizaProgressBar(0);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual(porcentagem.intValue());
        this.getBbprogress().updateUI();
    }

    private void habilitarTodosBotoes(boolean habilitar) {
        if (habilitar) {
            List<IObjRecuperarRetornos> selecionados = this.getTblRetornos().getBbtModel().getItensSelecionados();
            List<IObjRecuperarRetornos> todosItens = this.getTblRetornos().getBbtModel().getDataListTabela();
            this.getBotaoConfirmar().setEnabled(selecionados.size() > 0);
            this.getBotaoImprimir().setEnabled(selecionados.size() > 0);
            this.getBtnDesmarcarTodos().setEnabled(selecionados.size() != todosItens.size() || selecionados.size() == 0);
            this.getBtnMarcarTodos().setEnabled(selecionados.size() != todosItens.size());
        } else {
            this.getBotaoConfirmar().setEnabled(false);
            this.getBotaoImprimir().setEnabled(false);
            this.getBtnDesmarcarTodos().setEnabled(habilitar);
            this.getBtnMarcarTodos().setEnabled(habilitar);
        }
        this.getBotaoVoltar().setEnabled(habilitar);
    }

    private void popularFormSelecionados() {
        List<IObjRecuperarRetornos> selecionados = this.getTblRetornos().getBbtModel().getItensSelecionados();
        this.getConsultarRetornosPendentesForm().setListaRetornosSelecionados(selecionados);
    }
}

