/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.login.action;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.login.form.LoginForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.facade.ManterUsuarioFacade;
import br.com.bb.plugins.gac.negocio.facade.SenhaMestraFacade;
import br.com.bb.plugins.gac.negocio.to.EstadoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.negocio.to.decorator.UsuarioTODecorator;
import br.com.bb.plugins.gac.util.Criptografia;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoEstadoUsuario;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import br.com.bb.plugins.gac.util.view.ViewLogin;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;

public class LoginAction
extends PluginActionAbstrato {
    public String executar(PluginFormAbstrato form) throws BBException {
        LoginForm loginForm = (LoginForm)form;
        ManterUsuarioFacade usuarioFacade = this.getFacadeFactory().novoManterUsuarioFacade();
        UsuarioTODecorator usuarioTODecorator = loginForm.getUsuarioTODecorator();
        UsuarioTO usuarioTO = usuarioTODecorator.getUsuarioTO();
        UsuarioTO usuarioTOResultado = usuarioFacade.listarPorNome(usuarioTO);
        String forward = null;
        if (!UtilObjeto.isReferencia(usuarioTOResultado)) {
            this.registrarMensagem("MP036");
            ((ViewLogin)loginForm.getView()).getTxtChaveDeAcesso().getJtfCampo().requestFocus();
            loginForm.setTextField(((ViewLogin)loginForm.getView()).getTxtChaveDeAcesso().getJtfCampo());
            forward = "viewLogin";
        } else if (!this.isSenhaValida(usuarioTO, usuarioTOResultado)) {
            if (this.isAdmin(usuarioTO)) {
                if (this.verificarSeChaveMestra(usuarioTO.getTextoSenha())) {
                    loginForm.setAlteracaoComChaveMestra(true);
                    if (this.chaveConsumida()) {
                        this.prepararAlteracaoDeSenha(loginForm, usuarioTOResultado);
                        loginForm.setChaveMestraJaUtilizada(false);
                    } else {
                        loginForm.setChaveMestraJaUtilizada(true);
                    }
                } else {
                    this.registrarMensagem("MP037");
                    ((ViewLogin)loginForm.getView()).getTxtSenhaDeAcesso().getJtfSenha().selectAll();
                    ((ViewLogin)loginForm.getView()).getTxtSenhaDeAcesso().getJtfSenha().requestFocus();
                    loginForm.setTextField(((ViewLogin)loginForm.getView()).getTxtSenhaDeAcesso().getJtfSenha());
                    forward = "viewLogin";
                }
            }
        } else if (this.isSituacaoDesabilitado(usuarioTOResultado)) {
            this.registrarMensagem("MP006");
            forward = "viewLogin";
        } else {
            loginForm.setAlteracaoComChaveMestra(false);
            this.prepararAlteracaoDeSenha(loginForm, usuarioTOResultado);
            this.registrarUsuarioNoControlador(usuarioTOResultado);
            loginForm.setIndicadorAlteracaoSenha(usuarioTOResultado.getIndicadorAlteracaoSenha());
        }
        return forward;
    }

    private boolean chaveConsumida() throws BBException {
        return this.getSenhaMestraFacade().chaveConsumida();
    }

    private void prepararAlteracaoDeSenha(LoginForm loginForm, UsuarioTO usuarioTOResultado) {
        this.registrarUsuarioNoControlador(usuarioTOResultado);
        loginForm.setIndicadorAlteracaoSenha(usuarioTOResultado.getIndicadorAlteracaoSenha());
    }

    private boolean verificarSeChaveMestra(String textoSenha) throws BBException {
        return this.getSenhaMestraFacade().verificarSeChaveMestra(textoSenha);
    }

    private SenhaMestraFacade getSenhaMestraFacade() {
        return FacadeFactory.getInstancia().novoSenhaMestraFacade();
    }

    private boolean isSituacaoDesabilitado(UsuarioTO usuarioTOResultado) {
        EstadoUsuarioTO estadoUsuarioTO = usuarioTOResultado.getEstadoUsuarioTO();
        boolean resultado = false;
        if (this.isReferencia(estadoUsuarioTO)) {
            Integer codigoEstadoUsuarioTO = estadoUsuarioTO.getCodigoEstadoUsuario();
            resultado = UtilDominioTipoEstadoUsuario.EXCLU\u00cdDO.equals(codigoEstadoUsuarioTO) || UtilDominioTipoEstadoUsuario.INATIVO.equals(codigoEstadoUsuarioTO);
        }
        return resultado;
    }

    private void registrarUsuarioNoControlador(UsuarioTO usuarioTO) {
        PluginControladorDeAcesso acesso = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
        acesso.novoProfile(usuarioTO);
    }

    private boolean isSenhaValida(UsuarioTO usuarioTO, UsuarioTO usuarioTOResultado) {
        return UtilString.isStringsIguais(UtilString.minuscula(usuarioTO.getTextoSenha()), Criptografia.decifrar(UtilString.minuscula(usuarioTOResultado.getTextoSenha())));
    }

    private boolean isAdmin(UsuarioTO usuarioTO) {
        return usuarioTO.getTextoNomeUsuarioSistema().equalsIgnoreCase("ADMIN");
    }
}

