/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.form;

import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ContaCorrenteClienteTODecorator;
import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.Log;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.reflexao.UtilReflexaoGet;
import br.com.politec.reflexao.exception.ReflexaoException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterContaCorrenteForm
extends PluginFormAbstrato {
    private static final long serialVersionUID = 1L;
    private List<ContaCorrenteClienteTO> lista;
    private Collection<ContaCorrenteClienteTODecorator> listaContaCorrenteClienteTODecorator;
    private ContaCorrenteClienteTODecorator contaCorrenteClienteTODecorator;
    private PaginadorTO paginadorTO;
    private String nomePessoa;
    private Integer codigoPessoa;
    private ConvenentePessoaTO convenentePessoaTO;
    private String mensagem;
    private Map context;
    private int acao;
    private int tipoMensagem;
    private PessoaTO pessoaTO;
    private String numeroDaConta = null;
    private String codigoContaCorrente;
    private String textoDescricaoContaCorrente;
    private boolean bancoSelecionado = true;
    private char codigoDigitoVerificadorContaOutraInstituicaoFinanceira;

    @Override
    protected void doCarregarValidadores() {
        this.validarCamposBasicos();
    }

    private void validarCamposBasicos() {
        if (this.getAcao() == 1) {
            this.adicionarValidadorDeObrigatoriedadeParaObjeto("codigoInstituicaoFinanceira", "Institui\u00e7\u00e3o Financeira");
            this.adicionarValidadorDeObrigatoriedadeParaObjeto("codigoAgenciaInstituicaoFinanceira", "Ag\u00eancia");
            this.adicionarValidadorDeObrigatoriedadeParaCamposContaCorrente("Conta");
        }
    }

    protected void adicionarValidadorDeExistenciaContaCorrente() {
        ContaCorrenteClienteTOId id = new ContaCorrenteClienteTOId();
        id.setCodigoAgencia(this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().getCodigoAgencia());
        id.setCodigoContaCorrente(this.getContaSemDv(this.getCodigoContaCorrente()));
        id.setCodigoInstituicaoFinanceira(this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().getCodigoInstituicaoFinanceira());
        ContaCorrenteClienteTO contaExistente = new ContaCorrenteClienteTO();
        contaExistente.setPessoaTO(this.getPessoaTO());
        contaExistente.setId(id);
        if (FacadeFactory.getInstancia().novoManterContaCorrenteFacade().contaJaExisteParaPessoa(contaExistente)) {
            String mensagem = "Conta Corrente j\u00e1 cadastrada para essa pessoa.";
            this.adicionarValidador("textoConta", mensagem);
        }
    }

    private Long getContaSemDv(String codigoContaCorrente) {
        String contaSemDv = codigoContaCorrente.replace(".", "").replace("-", "");
        return Long.parseLong(contaSemDv.substring(0, contaSemDv.length() - 1));
    }

    protected void adicionarValidadorDeObrigatoriedadeParaCamposContaCorrente(String propriedade) {
        Object valor = this.getValor(propriedade);
        if (!this.isReferencia(valor) || UtilObjeto.isString(valor) && UtilString.isVazio((String)valor)) {
            this.adicionarValidadorDeObrigatoriedadeParaString(propriedade, "Conta Corrente de preenchimento obrigat\u00f3rio.");
        } else if (valor.toString().length() == 1) {
            this.adicionarValidadorDeTamanhoString(propriedade, "D\u00edgito verificador inv\u00e1lido", 1);
        } else {
            this.adicionaValidadorContaCorrente();
            this.adicionarValidadorDeExistenciaContaCorrente();
        }
    }

    protected void adicionarValidadorDeObrigatoriedadeContaCorrente(String valor, String nome) {
        if (valor.equals("") || valor == null) {
            String mensagem = this.getUtilMensagem().getValidacaoObrigatorio(nome);
            this.adicionarValidador(valor, mensagem);
        }
    }

    protected void adicionaValidadorContaCorrente() {
        String dv = "";
        String textoSomenteConta = null;
        String contaCorrenteSemCaracterEspecial = this.getConta().replace(".", "").replace("-", "");
        if (contaCorrenteSemCaracterEspecial.contains("X")) {
            textoSomenteConta = contaCorrenteSemCaracterEspecial.replace("X", "");
            dv = "X";
            this.setDVContaCorrente(dv);
        } else {
            char ultimoDigito = contaCorrenteSemCaracterEspecial.charAt(contaCorrenteSemCaracterEspecial.length() - 1);
            dv = String.valueOf(ultimoDigito);
            this.setDVContaCorrente(dv);
            textoSomenteConta = contaCorrenteSemCaracterEspecial.substring(0, contaCorrenteSemCaracterEspecial.length() - 1);
        }
        try {
            this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().setCodigoContaCorrente(Long.parseLong(textoSomenteConta));
        }
        catch (NumberFormatException nfe) {
            this.adicionarValidadorContaNumerica();
            nfe.printStackTrace();
        }
        if (this.getCodigoInstituicaoFinanceira() == 1 && !CalculaDigitoVerificador.verificaContaCorrente(Long.toString(this.getContaSemDv(this.getCodigoContaCorrente())), this.getDv().toString())) {
            String mensagem = "D\u00edgito da conta corrente inv\u00e1lido.";
            this.adicionarValidador("textoConta", mensagem);
        }
        if (this.getDv() == null || this.getDv().charValue() == ' ') {
            this.adicionarValidadorDeObrigatoriedadeParaObjeto("codigoDigitoVerificadorContaOutraInstituicaoFinanceira", "DV");
        }
    }

    public Character getDv() {
        return this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente();
    }

    private void adicionarValidadorContaNumerica() {
        String mensagem = this.getUtilMensagem().getMensagem("D\u00edgito da conta corrente inv\u00e1lido.");
        BBJPopupMensagem.exibirMensagem(mensagem);
    }

    private Object getValor(String propriedade) {
        Object valor = null;
        if (!UtilString.isVazio(propriedade)) {
            try {
                valor = UtilReflexaoGet.get(this, propriedade);
            }
            catch (ReflexaoException e) {
                Log.getInstance().logInfo("N\u00e3o foi poss\u00edvel recuperar o valor do atributo " + propriedade + " do FORM " + UtilObjeto.getNome(this));
                Log.getInstance().logMsg(e);
            }
        }
        return valor;
    }

    public List<ContaCorrenteClienteTO> getLista() {
        return this.lista;
    }

    public void setLista(List<ContaCorrenteClienteTO> lista) {
        this.lista = lista;
    }

    public ContaCorrenteClienteTODecorator getContaCorrenteClienteTODecorator() {
        if (this.contaCorrenteClienteTODecorator == null) {
            this.contaCorrenteClienteTODecorator = new ContaCorrenteClienteTODecorator();
        }
        return this.contaCorrenteClienteTODecorator;
    }

    public void setContaCorrenteClienteTODecorator(ContaCorrenteClienteTODecorator contaCorrenteClienteTODecorator) {
        this.contaCorrenteClienteTODecorator = contaCorrenteClienteTODecorator;
    }

    public PaginadorTO getPaginatorTO() {
        return this.paginadorTO;
    }

    public void setPaginatorTO(PaginadorTO paginatorTO) {
        this.paginadorTO = paginatorTO;
        this.setTotalDeRegistros(paginatorTO.getTotalDeRegistros());
    }

    public void setPaginaAtual(Integer paginaAtual) {
        this.getContaCorrenteClienteTODecorator().setPaginaAtual(paginaAtual);
    }

    public Integer getPaginaAtual() {
        return this.getContaCorrenteClienteTODecorator().getPaginaAtual();
    }

    public Integer getCodigoPessoa() {
        return this.codigoPessoa;
    }

    public void setCodigoPessoa(Integer codigoPessoa) {
        this.codigoPessoa = codigoPessoa;
    }

    public ConvenentePessoaTO getConvenentePessoaTO() {
        return this.convenentePessoaTO;
    }

    public void setConvenentePessoaTO(ConvenentePessoaTO convenentePessoaTO) {
        this.convenentePessoaTO = convenentePessoaTO;
    }

    public Collection<ContaCorrenteClienteTODecorator> getListaContaCorrenteClienteTODecorator() {
        return this.listaContaCorrenteClienteTODecorator;
    }

    public void setListaContaCorrenteClienteTODecorator(Collection<ContaCorrenteClienteTODecorator> listaContaCorrenteClienteTODecorator) {
        this.listaContaCorrenteClienteTODecorator = listaContaCorrenteClienteTODecorator;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    protected static String separarContaDoDV(String conta) {
        conta = conta.replace(".", "").replace("-", "");
        return conta.substring(0, conta.length() - 1);
    }

    protected static String getDv(String conta) {
        return conta.substring(conta.length() - 1, conta.length());
    }

    public void setCodigoInstituicaoFinanceira(InstituicaoFinanceiraTO instituicaoFinanceira) {
        this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().setCodigoInstituicaoFinanceira(instituicaoFinanceira.getCodigoInstituicaoFinanceira());
    }

    public void setCodigoAgenciaInstituicaoFinanceira(AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceira) {
        this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().setCodigoAgencia(agenciaInstituicaoFinanceira.getCodigoAgencia());
    }

    public void setDVContaCorrente(String dv) {
        this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().setDigitoVerificadorContaCorrente(Character.valueOf(dv.charAt(0)));
    }

    public void setTextoDescricaoContaCorrente(String textoDescricaoContaCorrente) {
        if (textoDescricaoContaCorrente == null) {
            textoDescricaoContaCorrente = "";
        } else {
            this.textoDescricaoContaCorrente = textoDescricaoContaCorrente;
        }
    }

    public void setCodigoDigitoVerificadorContaOutraInstituicaoFinanceira(String dv) {
        if (this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().getCodigoInstituicaoFinanceira() != 1) {
            this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().setDigitoVerificadorContaCorrente(Character.valueOf(dv.charAt(0)));
        } else if (this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente() == null) {
            this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().setDigitoVerificadorContaCorrente(Character.valueOf(' '));
        }
    }

    public void setStatusConta(Object statusConta) {
        this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().setIndicadorEstadoContaCorrente(Character.valueOf(statusConta.toString().charAt(0)));
    }

    public String getCodigoContaCorrente() {
        return this.codigoContaCorrente;
    }

    public Integer getCodigoInstituicaoFinanceira() {
        return this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().getId().getCodigoInstituicaoFinanceira();
    }

    public Integer getCodigoAgenciaInstituicaoFinanceira() {
        return this.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().getId().getCodigoAgencia();
    }

    public String getNomePessoa() {
        return this.nomePessoa;
    }

    public void setNomePessoa(String nomePessoa) {
        this.nomePessoa = nomePessoa;
    }

    public int getTipoDeMensagem() {
        return this.tipoMensagem;
    }

    public void setTipoDeMensagem(int tipoMensagem) {
        this.tipoMensagem = tipoMensagem;
    }

    public int getAcao() {
        return this.acao;
    }

    public void setAcao(int acao) {
        this.acao = acao;
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public PessoaTO getPessoaTO() {
        return this.pessoaTO;
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.pessoaTO = pessoaTO;
    }

    public String getNumeroDaConta() {
        return this.numeroDaConta;
    }

    public void setNumeroDaConta(String numeroDaConta) {
        this.numeroDaConta = numeroDaConta;
    }

    public String getConta() {
        return this.codigoContaCorrente;
    }

    public void setCodigoContaCorrente(String codigoContaCorrente) {
        if (codigoContaCorrente != null || !codigoContaCorrente.equals("")) {
            this.codigoContaCorrente = codigoContaCorrente;
        } else {
            this.setCodigoContaCorrente("");
        }
    }

    public boolean isBancoSelecionado() {
        return this.bancoSelecionado;
    }

    public void setBancoSelecionado(boolean bancoSelecionado) {
        this.bancoSelecionado = bancoSelecionado;
    }

    public char getCodigoDigitoVerificadorContaOutraInstituicaoFinanceira() {
        return this.codigoDigitoVerificadorContaOutraInstituicaoFinanceira;
    }
}

