/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.form.ManterContaCorrenteForm;
import br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.view.ViewManterContaCorrente;
import br.com.bb.plugins.gac.factory.BotaoFactory;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.facade.ManterContaCorrenteFacade;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTOId;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ContaCorrenteClienteTODecorator;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjectContaCorrente;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJButtonChooser;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboAutoSugestaoLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabelConta;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButtonLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterContaCorrentePopup
extends BasicInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jpCentral = null;
    private JPanel painelConta = null;
    private BBJButton btConfirmar = null;
    private BBJButton btLimpar = null;
    private BBJButton btVoltar = null;
    private BBJComboAutoSugestaoLabel<InstituicaoFinanceiraTO> comboInstituicaoFinanceira = null;
    private BBJComboBoxLabel<AgenciaInstituicaoFinanceiraTO> comboAgencia = null;
    private BBJMaskLabelConta txtConta = null;
    public ViewManterContaCorrente viewManterContaCorrente;
    private InstituicaoFinanceiraTO instituicaoFinanceiraTO;
    private BBJButtonChooser botaoExecutarAG;
    private Map<Object, Object> context;
    private BBJTextLabel txtDescricaoConta;
    private BBJTextLabel txtPessoa;
    private BBJRadioButtonLabel radioStatusConta;
    private BBJRadioButton statusContaInativo;
    private BBJRadioButton statusContaAtivo;
    private PluginActionAbstrato acaoConfirmar;
    private JPanel painelBotoes;
    private BBJButtonChooser botaoManterBanco;
    private BBJButtonChooser botaoManterAgencia;

    public ViewManterContaCorrentePopup() {
        super(null, false, false);
    }

    public InstituicaoFinanceiraTO getInstituicaoFinanceiraTO() {
        return this.instituicaoFinanceiraTO;
    }

    private void selecionaItemBanco() {
        this.getComboInstituicaoFinanceira().setSelectedItem(this.getInstituicaoFinanceiraTO());
    }

    public void setInstituicaoFinanceiraTO(InstituicaoFinanceiraTO instituicaoFinanceiraTOF) {
        this.instituicaoFinanceiraTO = instituicaoFinanceiraTOF;
        this.selecionaItemBanco();
    }

    public void initialize(int tipoTela) {
        this.iniciaPainelCentral();
        this.habilitaBotoes(tipoTela);
    }

    private void iniciaPainelCentral() {
        if (this.jpCentral == null) {
            this.jpCentral = new JPanel();
            this.jpCentral.setOpaque(false);
            this.jpCentral.setLayout(new BorderLayout());
            this.jpCentral.add((Component)this.getPainelConta(), "North");
            this.jpCentral.add((Component)this.getPainelBotoes(), "Center");
            FlowLayout flw = new FlowLayout();
            flw.setAlignment(1);
            this.setAlinhamento(0);
            this.setLayout(flw);
            this.add(this.jpCentral);
        }
    }

    private void habilitaBotoes(int tipoTela) {
        switch (tipoTela) {
            case 1: {
                this.habilitarTodosCampos(true);
                this.padronizarAtivacaoDeConta();
                break;
            }
            case 2: {
                this.getTextPessoa().setEnabled(false);
                this.getComboInstituicaoFinanceira().setEnabled(false);
                this.getComboAgencia().setEnabled(false);
                this.getTextConta().setEnabled(false);
                this.getRadioStatusConta().setEnabled(true);
                this.getTextDescricaoConta().setEnabled(true);
                break;
            }
            case 5: {
                this.habilitarTodosCampos(false);
                break;
            }
            case 3: {
                this.habilitarTodosCampos(false);
            }
        }
    }

    private void habilitarTodosCampos(boolean habilitar) {
        this.getTextPessoa().setEnabled(habilitar);
        this.getComboInstituicaoFinanceira().setEnabled(habilitar);
        this.getComboAgencia().setEnabled(habilitar);
        this.getTextConta().setEnabled(habilitar);
        this.getRadioStatusConta().setEnabled(habilitar);
        this.getTextDescricaoConta().setEnabled(habilitar);
    }

    private void padronizarAtivacaoDeConta() {
        this.getRadioStatusConta().setSelected(this.getStatusContaAtivo());
        this.getRadioStatusConta().setEnabled(false);
    }

    public JPanel getPainelBotoes() {
        if (this.painelBotoes == null) {
            this.painelBotoes = this.getPainelFactory().novoJPainel();
            Dimension dimension = new Dimension(200, 50);
            this.painelBotoes.setSize(dimension);
            this.painelBotoes.setPreferredSize(dimension);
            this.painelBotoes.setMinimumSize(dimension);
            this.painelBotoes.setOpaque(false);
            FlowLayout flowLayout = this.getLayoutFactory().novoFlowLayout();
            flowLayout.setAlignment(2);
            this.painelBotoes.setLayout(flowLayout);
            this.painelBotoes.add(this.getBotaoConfirmar());
            this.painelBotoes.add(this.getBotaoLimpar());
            this.painelBotoes.add(this.getBotaoVoltar());
        }
        return this.painelBotoes;
    }

    private Component getBotaoLimpar() {
        if (this.btLimpar == null) {
            this.btLimpar = BotaoFactory.getInstancia().novoLimpar();
            this.btLimpar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent paramActionEvent) {
                    ViewManterContaCorrentePopup.this.getComboInstituicaoFinanceira().setSelectedIndex(0);
                    ViewManterContaCorrentePopup.this.getComboAgencia().setSelectedIndex(0);
                    ViewManterContaCorrentePopup.this.getTextConta().setText("");
                    ViewManterContaCorrentePopup.this.getTextDescricaoConta().setText("");
                }
            });
        }
        return this.btLimpar;
    }

    private JPanel getPainelConta() {
        GridBagConstraints gc = new GridBagConstraints();
        if (this.painelConta == null) {
            this.painelConta = new JPanel();
            this.painelConta.setOpaque(false);
            this.painelConta.setLayout(new GridBagLayout());
            this.painelConta.setBorder(BBJBordaOval.createOvalBorder("Manter Conta Corrente"));
            gc.insets = new Insets(2, 10, 3, 1);
            gc.anchor = 17;
            gc.fill = 2;
            gc.weightx = 0.99;
            gc.gridy = 0;
            gc.gridx = 0;
            this.painelConta.add((Component)this.getTextPessoa(), gc);
            gc.gridy = 1;
            this.painelConta.add(this.getComboInstituicaoFinanceira(), gc);
            gc.gridx = 1;
            this.painelConta.add((Component)this.getBotaoManterBanco(), gc);
            gc.gridx = 0;
            gc.gridy = 2;
            this.painelConta.add(this.getComboAgencia(), gc);
            gc.gridx = 1;
            this.painelConta.add((Component)this.getBotaoManterAgencia(), gc);
            gc.gridx = 0;
            gc.gridy = 3;
            this.painelConta.add((Component)this.getTextConta(), gc);
            gc.gridx = 0;
            gc.gridy = 4;
            this.painelConta.add((Component)this.getTextDescricaoConta(), gc);
            gc.gridy = 5;
            gc.gridx = 0;
            this.painelConta.add((Component)this.getRadioStatusConta(), gc);
        }
        return this.painelConta;
    }

    private BBJButton getBotaoVoltar() {
        if (this.btVoltar == null) {
            this.btVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.btVoltar;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.getBotaoVoltar().addActionListener(this);
    }

    public void Show() {
        this.setVisible(true);
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }

    @Override
    public void doShow(Map context) {
        if (context != null) {
            this.setContext(context);
            this.setForm((ManterContaCorrenteForm)context.get("form"));
        }
        this.initialize(this.getManterContaCorrenteForm().getAcao());
        if (this.getContext().containsKey("migalha")) {
            this.preencherCamposAoVoltar();
        } else {
            this.preencherTela(context);
        }
        this.setAcaoConfirmar();
        this.setVisible(true);
    }

    private void setAcaoConfirmar() {
        switch (this.getManterContaCorrenteForm().getAcao()) {
            case 3: {
                this.acaoConfirmar = this.getActionFactory().novoExcluirContaCorrenteAction();
                break;
            }
            case 2: {
                this.acaoConfirmar = this.getActionFactory().novoEditarContaCorrenteAction();
                break;
            }
            case 1: {
                this.acaoConfirmar = this.getActionFactory().novoIncluirContaCorrenteAction();
            }
        }
        this.getBotaoConfirmar().setAcao(this.acaoConfirmar);
    }

    private void preencherTela(Map context) {
        switch (this.getManterContaCorrenteForm().getAcao()) {
            case 5: {
                this.limparDadosDaTela();
                this.preencheTelaComDados(context);
                this.getBotaoConfirmar().setVisible(false);
                this.getBotaoLimpar().setVisible(false);
                break;
            }
            case 2: {
                this.limparDadosDaTela();
                this.preencheTelaComDados(context);
                this.getBotaoConfirmar().setVisible(true);
                break;
            }
            case 1: {
                this.limparDadosDaTela();
                this.preenchePessoa(context);
                this.getBotaoConfirmar().setVisible(true);
                this.carregaComboInstituicaoFinanceira();
                break;
            }
            case 3: {
                this.limparDadosDaTela();
                this.preencheTelaComDados(context);
                this.getBotaoConfirmar().setVisible(true);
            }
        }
    }

    private void carregaComboInstituicaoFinanceira() {
        this.getComboInstituicaoFinanceira().preencherCombo(this.getManterContaCorrenteFacade().listarInstituicoesFinanceiras());
    }

    private void preencheTelaComDados(Map context) {
        IObjectContaCorrente dados = (IObjectContaCorrente)context.get("dados");
        ContaCorrenteClienteTODecorator contaCorrenteClienteTODecorator = dados.getContaCorrenteClienteTODecorator();
        this.getManterContaCorrenteForm().setContaCorrenteClienteTODecorator(contaCorrenteClienteTODecorator);
        ContaCorrenteClienteTOId idConta = contaCorrenteClienteTODecorator.getContaCorrenteClienteTOId();
        InstituicaoFinanceiraTO instituicaoFinanceiraTO = this.getManterContaCorrenteFacade().recuperarInstituicaoFinanceira(idConta.getCodigoInstituicaoFinanceira());
        this.preenchePessoa(context);
        this.getComboInstituicaoFinanceira().getComboBox().setSelectedItem(instituicaoFinanceiraTO);
        if (instituicaoFinanceiraTO.getCodigoInstituicaoFinanceira() != 1) {
            this.getTextConta().setText(Long.toString(contaCorrenteClienteTODecorator.getContaCorrenteClienteTOId().getCodigoContaCorrente()));
        } else {
            this.getTextConta().setText(contaCorrenteClienteTODecorator.getContaCorrenteClienteTO().toString());
        }
        this.getComboAgencia().getComboBox().setSelectedItem(contaCorrenteClienteTODecorator.getAgenciaInstituicaoFinanceiraTO());
        this.getTextDescricaoConta().setText(contaCorrenteClienteTODecorator.getContaCorrenteClienteTO().getTextoDescricaoContaCorrente());
        this.selecionarRadioEstadoConta(contaCorrenteClienteTODecorator);
    }

    private void preenchePessoa(Map context) {
        PessoaTO pessoaTO = this.getManterContaCorrenteForm().getPessoaTO();
        this.getTextPessoa().setText(pessoaTO.getTextoNome());
        if (this.getTextPessoa().isEnabled()) {
            this.getTextPessoa().setEnabled(false);
        }
    }

    public void selecionarRadioEstadoConta(ContaCorrenteClienteTODecorator contaCorrenteClienteTODecorator) {
        try {
            if (contaCorrenteClienteTODecorator.getContaCorrenteClienteTO().getIndicadorEstadoContaCorrente().charValue() == '1') {
                this.getRadioStatusConta().setSelected(this.getStatusContaAtivo());
            } else if (contaCorrenteClienteTODecorator.getContaCorrenteClienteTO().getIndicadorEstadoContaCorrente().charValue() == '0') {
                this.getRadioStatusConta().setSelected(this.getStatusContaInativo());
            }
        }
        catch (NullPointerException npe) {
            this.getRadioStatusConta().clearSelection(this.getRadioStatusConta().getGrupo());
        }
    }

    public BBJRadioButton getStatusContaInativo() {
        if (this.statusContaInativo == null) {
            this.statusContaInativo = new BBJRadioButton("Inativo");
            this.statusContaInativo.setCodigo(0);
            this.statusContaInativo.setName("radioContaInativo");
        }
        return this.statusContaInativo;
    }

    public BBJRadioButton getStatusContaAtivo() {
        if (this.statusContaAtivo == null) {
            this.statusContaAtivo = new BBJRadioButton("Ativo");
            this.statusContaAtivo.setCodigo(1);
            this.statusContaAtivo.setName("radioContaAtivo");
        }
        return this.statusContaAtivo;
    }

    public BBJRadioButtonLabel getRadioStatusConta() {
        if (this.radioStatusConta == null) {
            HashMap<String, BBJRadioButton> opcoesRadio = new HashMap<String, BBJRadioButton>();
            opcoesRadio.put("0", this.getStatusContaInativo());
            opcoesRadio.put("1", this.getStatusContaAtivo());
            this.radioStatusConta = new BBJRadioButtonLabel("Indicador Status da Conta:", 0, opcoesRadio, 150);
            this.radioStatusConta.loadRadios();
            this.radioStatusConta.setSelected(1);
            this.radioStatusConta.setName("statusConta");
        }
        return this.radioStatusConta;
    }

    public BBJMaskLabelConta getTextConta() {
        if (this.txtConta == null) {
            this.txtConta = new BBJMaskLabelConta(30, true, 0, 150, 155);
            this.txtConta.setName("codigoContaCorrente");
        }
        return this.txtConta;
    }

    public BBJComboBoxLabel<AgenciaInstituicaoFinanceiraTO> getComboAgencia() {
        if (this.comboAgencia == null) {
            this.comboAgencia = new BBJComboBoxLabel("Ag\u00eancia", false, 0, 150, 155);
            this.comboAgencia.setPreferredSize(new Dimension(160, 20));
            this.comboAgencia.setName("codigoAgenciaInstituicaoFinanceira");
        }
        return this.comboAgencia;
    }

    public BBJButtonChooser getBotaoExecutarAG() {
        if (this.botaoExecutarAG == null) {
            this.botaoExecutarAG = new BBJButtonChooser();
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterContaCorrentePopup.this.getContext().put("ACAO", "");
                    ViewManterContaCorrentePopup.this.getContext().put("view", "DBTVIEWIDENTDEBTO");
                    ViewController.getInstance().goToView("GACMANTERAGENCIA", ViewManterContaCorrentePopup.this.getContext());
                }
            };
            this.botaoExecutarAG.addActionListener(listener);
        }
        return this.botaoExecutarAG;
    }

    public BBJButtonChooser getBotaoManterBanco() {
        if (this.botaoManterBanco == null) {
            this.botaoManterBanco = new BBJButtonChooser();
            this.botaoManterBanco.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterContaCorrentePopup.this.armazenarEstadoView();
                    ControlableView view = ViewController.getInstance().goToView("GACMANTERBANCO", null, true);
                }
            });
        }
        return this.botaoManterBanco;
    }

    public BBJButtonChooser getBotaoManterAgencia() {
        if (this.botaoManterAgencia == null) {
            this.botaoManterAgencia = new BBJButtonChooser();
            this.botaoManterAgencia.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterContaCorrentePopup.this.armazenarEstadoView();
                    ControlableView view = ViewController.getInstance().goToView("GACMANTERAGENCIA", null, true);
                }
            });
        }
        return this.botaoManterAgencia;
    }

    public Map<Object, Object> getContext() {
        if (this.context == null) {
            this.context = new HashMap<Object, Object>();
        }
        return this.context;
    }

    public BBJButton getBotaoConfirmar() {
        if (this.btConfirmar == null) {
            this.btConfirmar = this.getBotaoFactory().novoConfirmar(this.getAcaoConfirmar());
        }
        return this.btConfirmar;
    }

    private void setPessoaNoIdDaConta() {
        PessoaTO pessoaTO = this.getManterContaCorrenteForm().getPessoaTO();
        this.getManterContaCorrenteForm().getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().setCodigoPessoa(pessoaTO.getCodigoPessoa());
        this.getManterContaCorrenteForm().getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId().setPessoaTO(pessoaTO);
    }

    public void preExecucaoIncluirContaCorrenteAction() {
        this.setPessoaNoIdDaConta();
    }

    public void posExecucaoIncluirContaCorrenteAction() {
        if (this.getManterContaCorrenteForm().getMensagem() != null) {
            this.exibirMensagemFinal();
        }
        if (this.getManterContaCorrenteForm().getTipoDeMensagem() == 1) {
            this.limparDadosDaTela();
        }
    }

    private void limparDadosDaTela() {
        this.getComboInstituicaoFinanceira().setSelectedItem(null);
        this.getComboAgencia().setSelectedItem(null);
        this.getTextConta().setText("");
        this.getTextDescricaoConta().setText("");
        this.getRadioStatusConta().setSelected(this.getStatusContaAtivo());
    }

    public void preExecucaoEditarContaCorrenteAction() {
        this.setPessoaNoIdDaConta();
    }

    public void posExecucaoEditarContaCorrenteAction() {
        if (this.getManterContaCorrenteForm().getMensagem() != null) {
            this.exibirMensagemFinal();
        }
        if (this.getManterContaCorrenteForm().getTipoDeMensagem() == 1) {
            this.doClose(null);
        }
    }

    public void preExecucaoExcluirContaCorrenteAction() {
        this.setPessoaNoIdDaConta();
    }

    public void posExecucaoExcluirContaCorrenteAction() {
        if (this.getManterContaCorrenteForm().getMensagem() != null) {
            this.exibirMensagemFinal();
            this.doClose(null);
        }
    }

    protected ManterContaCorrenteForm getManterContaCorrenteForm() {
        return (ManterContaCorrenteForm)this.getForm();
    }

    private void exibirMensagemFinal() {
        if (this.getManterContaCorrenteForm().getTipoDeMensagem() == 1) {
            BBJPopupMensagem.exibirMensagemSucesso(this.getManterContaCorrenteForm().getMensagem());
        } else if (this.getManterContaCorrenteForm().getTipoDeMensagem() == 0) {
            BBJPopupMensagem.exibirMensagemErro(this.getManterContaCorrenteForm().getMensagem());
        }
    }

    public ManterContaCorrenteFacade getManterContaCorrenteFacade() {
        return FacadeFactory.getInstancia().novoManterContaCorrenteFacade();
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public BBJTextLabel getTextDescricaoConta() {
        if (this.txtDescricaoConta == null) {
            this.txtDescricaoConta = new BBJTextLabel("Descri\u00e7\u00e3o da Conta: ", 40, true, 0, 50, 155);
            this.txtDescricaoConta.getJtfCampo().setName("textoDescricaoContaCorrente");
            this.txtDescricaoConta.getJtfCampo().setToolTipText("Informe a descri\u00e7\u00e3o da conta");
        }
        return this.txtDescricaoConta;
    }

    public BBJTextLabel getTextPessoa() {
        if (this.txtPessoa == null) {
            this.txtPessoa = new BBJTextLabel("Pessoa: ", 40, true, 0, 150, 155);
            this.txtPessoa.getJtfCampo().setName("nomePessoa");
            this.txtPessoa.getJtfCampo().setToolTipText("Pessoa que possui a conta");
        }
        return this.txtPessoa;
    }

    @Override
    public void actionPerformed(ActionEvent paramActionEvent) {
        this.getContext().clear();
        this.doClose(null);
    }

    public PluginActionAbstrato getAcaoConfirmar() {
        return this.acaoConfirmar;
    }

    public void setAcaoConfirmar(PluginActionAbstrato acaoConfirmar) {
        this.acaoConfirmar = acaoConfirmar;
    }

    public void preencherCamposAoVoltar() {
        this.getTextPessoa().setEnabled(false);
        this.carregaComboInstituicaoFinanceira();
        if (this.getManterContaCorrenteForm().getCodigoInstituicaoFinanceira() != null) {
            this.carregaComboAgencia();
            this.getTextConta().getJtfCampo().setText("");
        } else if (!this.getManterContaCorrenteForm().isBancoSelecionado()) {
            this.getComboInstituicaoFinanceira().setSelectedIndex(0);
        } else {
            this.carregaComboAgencia();
        }
        if (this.getManterContaCorrenteForm().getCodigoAgenciaInstituicaoFinanceira() != null) {
            AgenciaInstituicaoFinanceiraTOId id = new AgenciaInstituicaoFinanceiraTOId();
            id.setCodigoAgencia(this.getManterContaCorrenteForm().getCodigoAgenciaInstituicaoFinanceira());
            id.setCodigoInstituicaoFinanceira(this.getManterContaCorrenteForm().getCodigoInstituicaoFinanceira());
            this.getComboAgencia().setSelectedItem(this.getManterContaCorrenteFacade().recuperarAgenciaInstituicaoFinanceira(id));
        }
        this.getTextConta().setText(this.getManterContaCorrenteForm().getConta());
        this.getContext().remove("migalha");
    }

    private void carregaComboAgencia() {
        Collection<AgenciaInstituicaoFinanceiraTO> lista = this.getManterContaCorrenteFacade().listarAgenciasParaInstituicaoFinanceira(this.getComboInstituicaoFinanceira().getSelectedItem());
        if (!lista.isEmpty()) {
            this.getComboAgencia().preencherCombo(lista);
            this.getComboAgencia().setEnabled(true);
        } else {
            this.getComboAgencia().getJcbCombo().setModel(new DefaultComboBoxModel());
            this.getComboAgencia().setEnabled(false);
        }
    }

    private void armazenarEstadoView() {
        if (this.getComboInstituicaoFinanceira().getSelectedItem() instanceof InstituicaoFinanceiraTO) {
            InstituicaoFinanceiraTO instituicaoFinanceiraTO = this.getComboInstituicaoFinanceira().getSelectedItem();
            this.getManterContaCorrenteForm().setCodigoInstituicaoFinanceira(instituicaoFinanceiraTO);
        } else {
            this.getManterContaCorrenteForm().setBancoSelecionado(false);
        }
        if (this.getComboAgencia().getSelectedItem() instanceof AgenciaInstituicaoFinanceiraTO) {
            AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO = this.getComboAgencia().getSelectedItem();
            this.getManterContaCorrenteForm().setCodigoAgenciaInstituicaoFinanceira(agenciaInstituicaoFinanceiraTO);
        }
        if (this.getTextConta() != null && !this.getTextConta().getText().equals("")) {
            this.getManterContaCorrenteForm().setCodigoContaCorrente(this.getTextConta().getJtfCampo().getText());
        }
        if (this.getTextDescricaoConta() != null && !this.getTextConta().getText().equals("")) {
            this.getManterContaCorrenteForm().getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO().setTextoDescricaoContaCorrente(this.getTextConta().getJtfCampo().getText());
        }
        String conta = this.getTextConta().getText();
        this.getManterContaCorrenteForm().setCodigoContaCorrente(conta);
        this.getContext().put("migalha", true);
    }

    public BBJComboAutoSugestaoLabel<InstituicaoFinanceiraTO> getComboInstituicaoFinanceira() {
        if (this.comboInstituicaoFinanceira == null) {
            ArrayList<InstituicaoFinanceiraTO> list = new ArrayList<InstituicaoFinanceiraTO>(this.getManterContaCorrenteFacade().listarInstituicoesFinanceiras());
            this.comboInstituicaoFinanceira = new BBJComboAutoSugestaoLabel<InstituicaoFinanceiraTO>(list, "C\u00f3digo da IF:", true, 0, 150, 155);
            this.comboInstituicaoFinanceira.setName("codigoInstituicaoFinanceira");
            this.comboInstituicaoFinanceira.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ViewManterContaCorrentePopup.this.carregaComboAgencia();
                        ViewManterContaCorrentePopup.this.getTextConta().getJtfCampo().setText("");
                    }
                }
            });
        }
        return this.comboInstituicaoFinanceira;
    }
}

