/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.relatorio.action;

import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.action.ImprimirCadastroPessoaAction;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.form.ListarCadastroPessoaForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaFisicaFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterCadastroPessoaJuridicaFacade;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprimirRelatorioGACAction
extends ImprimirCadastroPessoaAction {
    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ListarCadastroPessoaForm listarCadastroPessoaForm = (ListarCadastroPessoaForm)form;
        switch (listarCadastroPessoaForm.getOpcaoRelatorio()) {
            case 1: {
                this.basicoPessoaTodos(listarCadastroPessoaForm);
                break;
            }
            case 2: {
                this.basicoPessoaFisica(listarCadastroPessoaForm);
                break;
            }
            case 3: {
                this.basicoPessoaJuridica(listarCadastroPessoaForm);
                break;
            }
            case 4: {
                this.completoPessoaFisica(listarCadastroPessoaForm);
                break;
            }
            case 5: {
                this.completoPessoJuridico(listarCadastroPessoaForm);
                break;
            }
        }
        return null;
    }

    private void basicoPessoaJuridica(ListarCadastroPessoaForm listarCadastroPessoaForm) {
        PessoaTODecorator pessoaTODecorator = new PessoaTODecorator();
        pessoaTODecorator.setCodigoTipoPessoa(UtilDominioTipoDocumento.CNPJ_PJ);
        ManterCadastroPessoaFacade facade = this.getFacadeFactory().novoManterCadastroPessoaFacade();
        listarCadastroPessoaForm.getPessoaTODecorator().setPaginaAtual(null);
        Collection<PessoaTO> colecao = facade.consultarPor(pessoaTODecorator);
        listarCadastroPessoaForm.setColecaoPessoaTODecorator(this.converterParaDecorator(colecao));
    }

    private void completoPessoJuridico(ListarCadastroPessoaForm listarCadastroPessoaForm) {
        ManterCadastroPessoaJuridicaFacade facade3 = this.getFacadeFactory().novoManterCadastroPessoaJuridicaFacade();
        Collection<ComplementoPessoaJuridicaTO> colecao3 = facade3.consultarTodosComplementosPJ();
        listarCadastroPessoaForm.setNomeColunaOrdenada("objPessoaTO.textoNome");
        listarCadastroPessoaForm.setComplementoPessoaJuridicaTO(colecao3);
    }

    private void completoPessoaFisica(ListarCadastroPessoaForm listarCadastroPessoaForm) {
        ManterCadastroPessoaFisicaFacade facade2 = this.getFacadeFactory().novoManterCadastroPessoaFisicaFacade();
        Collection<ComplementoPessoaFisicaTO> colecao2 = facade2.consultarTodosComplementosPF();
        listarCadastroPessoaForm.setNomeColunaOrdenada("objPessoaTO.textoNome");
        listarCadastroPessoaForm.setComplementoPessoaFisicaTO(colecao2);
    }

    private void basicoPessoaFisica(ListarCadastroPessoaForm listarCadastroPessoaForm) {
        PessoaTODecorator pessoaTODecorator = new PessoaTODecorator();
        pessoaTODecorator.setCodigoTipoPessoa(UtilDominioTipoDocumento.CPF_PF);
        ManterCadastroPessoaFacade facade = this.getFacadeFactory().novoManterCadastroPessoaFacade();
        listarCadastroPessoaForm.getPessoaTODecorator().setPaginaAtual(null);
        Collection<PessoaTO> colecao = facade.consultarPor(pessoaTODecorator);
        listarCadastroPessoaForm.setColecaoPessoaTODecorator(this.converterParaDecorator(colecao));
    }

    private void basicoPessoaTodos(ListarCadastroPessoaForm listarCadastroPessoaForm) {
        ManterCadastroPessoaFacade facade = this.getFacadeFactory().novoManterCadastroPessoaFacade();
        listarCadastroPessoaForm.setNomeColunaOrdenada("objPessoaTO.textoNome");
        listarCadastroPessoaForm.getPessoaTODecorator().setPaginaAtual(null);
        PessoaTODecorator pessoaTODecorator = new PessoaTODecorator();
        Collection<PessoaTO> colecao = facade.consultarPor(pessoaTODecorator);
        listarCadastroPessoaForm.setColecaoPessoaTODecorator(this.converterParaDecorator(colecao));
    }

    private Collection<PessoaTODecorator> converterParaDecorator(Collection<PessoaTO> colecao) {
        ArrayList<PessoaTODecorator> colecaoDecorator = new ArrayList<PessoaTODecorator>();
        for (PessoaTO pessoaTO : colecao) {
            PessoaTODecorator pessoaDecorator = this.getTOFactory().novoPessoaTODecorator();
            pessoaDecorator.setPessoaTO(pessoaTO);
            colecaoDecorator.add(pessoaDecorator);
        }
        return colecaoDecorator;
    }
}

