/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.factory;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.util.ConfigHelper;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionFactoryBean
extends LocalSessionFactoryBean {
    private static Log log = LogFactory.getLog(HibernateSessionFactoryBean.class);
    protected Set<String> tmpMappingResources = new HashSet<String>();

    public Configuration newConfiguration() throws HibernateException {
        Configuration config = super.newConfiguration();
        log.debug("Configuring hibernate sessionFactory properties");
        try {
            InputStream propertyStream = ConfigHelper.getResourceAsStream((String)"/hibernate.default.properties");
            Properties props = new Properties();
            props.load(propertyStream);
            propertyStream.close();
            config.mergeProperties(props);
        }
        catch (IOException e) {
            log.fatal("Unable to load default hibernate properties", e);
        }
        String driver = config.getProperty("hibernate.connection.driver_class");
        String username = config.getProperty("hibernate.connection.username");
        String password = config.getProperty("hibernate.connection.password");
        String url = config.getProperty("hibernate.connection.url");
        int check = this.checkDatabaseConnection(driver, username, password, url);
        if (check == 0) {
            return config;
        }
        throw new HibernateException("Error connecting to database. See error log for details.");
    }

    private int checkDatabaseConnection(String driver, String user, String pw, String url) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            log.error("Error while starting up. Bad driver class: " + driver, e);
            System.err.println(e.getMessage());
            System.err.println("Could not find driver_class '" + driver + "'.  Can be set with runtime property: 'connection.driver_class'");
            return 1;
        }
        log.debug("checking database connection");
        try {
            Connection db_connection = DriverManager.getConnection(url, user, pw);
            log.debug("Successful database connection");
            db_connection.close();
        }
        catch (Exception e) {
            log.error("Error while starting up.  Unable to connection using ", e);
            System.err.println(e.getMessage());
            pw = pw.replaceAll(".", "*");
            System.err.println("Could not connect to database using url '" + url + "', username '" + user + "', and pw '" + pw + "'. Connection properties can be set with runtime property: 'connection.username', 'connection.password', and 'connection.url'");
            return 1;
        }
        return 0;
    }

    public void setMappingResources(String[] mappingResources) {
        String[] stringArray = mappingResources;
        int n = mappingResources.length;
        int n2 = 0;
        while (n2 < n) {
            String resource = stringArray[n2];
            this.tmpMappingResources.add(resource);
            ++n2;
        }
        super.setMappingResources(this.tmpMappingResources.toArray(new String[0]));
    }

    public Set<String> getModuleMappingResources() {
        return this.tmpMappingResources;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, HibernateException, IOException {
        super.afterPropertiesSet();
    }

    public void destroy() throws HibernateException {
        try {
            super.destroy();
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage());
        }
    }

    public void setMappingJarLocations(Resource[] mappingJarLocations) {
        super.setMappingJarLocations(mappingJarLocations);
    }
}

