/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.controle.JDBCDAOSuport;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.UtilMensagem;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AtualizarBancoDadosDAO
extends JDBCDAOSuport {
    private ConfiguracaoProperties config = ConfiguracaoProperties.getConfiguracaoProperties();

    public AtualizarBancoDadosDAO() {
        super("BDGERAL");
    }

    public boolean verificarAtualizacaoNoGAC(int update) throws BBException {
        boolean precisaAtualizar = true;
        switch (update) {
            case 1000101: {
                return this.precisaCriarTipIfc();
            }
            case 1000102: {
                return this.atualizarEnderecoDeAtualizacaoGAC();
            }
            case 1000103: {
                return this.incluirEnderecoAtualizacaoReceitasDARF();
            }
            case 1000104: {
                return this.precisaCriarINST_PGTOTabelaIFC();
            }
        }
        return precisaAtualizar;
    }

    private boolean incluirEnderecoAtualizacaoReceitasDARF() throws BBException {
        boolean atualizado = false;
        String url = "";
        try {
            url = this.config.getUrlAtualizarReceitasDarf();
            atualizado = true;
        }
        catch (NullPointerException e) {
            this.config.setUrlAtualizarReceitasDARF("www14.bancobrasil.com.br/office/plugins/darf/");
        }
        return atualizado;
    }

    private boolean atualizarEnderecoDeAtualizacaoGAC() throws BBException {
        boolean atualizado = false;
        if (!this.config.getUrlAtualizarGac().contains("www.bb.com.br/aplicativos")) {
            this.config.setUrlAtualizarGac("www.bb.com.br/aplicativos");
            this.config.salvaPropriedades();
            atualizado = true;
        }
        return atualizado;
    }

    private boolean verificarInstituicaoFinanceiraSemTipIfc() throws BBException {
        String sql = "SELECT * FROM IFC WHERE TIP_IFC IS NULL";
        try {
            PreparedStatement stmt = this.getConexao().prepareStatement(sql);
            ResultSet rs = stmt.executeQuery(sql);
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    private void preencheCodTipIfc() throws BBException {
        String sql = "UPDATE IFC SET TIP_IFC = ? WHERE TIP_IFC IS NULL";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(sql);
            pstmt.setString(1, "COMPE");
            this.processaStatement(pstmt, sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    protected void processaStatement(PreparedStatement pstmt, String sql) throws SQLException {
        pstmt.executeUpdate();
        System.out.println("[Atualiza\u00e7\u00e3o da base de dados] " + sql);
    }

    public void atualizarGAC(int idAtualizacao) throws BBException {
        switch (idAtualizacao) {
            case 1000101: {
                if (!this.verificarInstituicaoFinanceiraSemTipIfc()) break;
                this.preencheCodTipIfc();
            }
        }
    }

    private void criarTipIfc() throws BBException {
        String sql = "ALTER TABLE IFC ADD TIP_IFC VARCHAR(5)";
        try {
            PreparedStatement stmt = this.getConexao().prepareStatement(sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    private boolean precisaCriarTipIfc() throws BBException {
        try {
            DatabaseMetaData dbmd = this.getConexao().getMetaData();
            ResultSet columns = dbmd.getColumns(null, null, "IFC", "TIP_IFC");
            if (columns.next()) {
                return false;
            }
            this.criarTipIfc();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        finally {
            this.atualizarGAC(1000101);
        }
    }

    private boolean precisaCriarINST_PGTOTabelaIFC() throws BBException {
        block3: {
            try {
                DatabaseMetaData dbmd = this.getConexao().getMetaData();
                ResultSet columns = dbmd.getColumns(null, null, "IFC", "INST_PGTO");
                if (!columns.next()) break block3;
                return false;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        this.incluirCampoINST_PGTOTabelaIFC();
        return true;
    }

    private void incluirCampoINST_PGTOTabelaIFC() throws BBException {
        String sql = "ALTER TABLE IFC ADD INST_PGTO CHAR(1)";
        try {
            PreparedStatement stmt = this.getConexao().prepareStatement(sql);
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }
}

