/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.ContaCorrenteClienteTODecorator;
import br.com.politec.generico.calculadores.UtilSomadoresDeNumero;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContaCorrenteClienteDAOImpl
extends HibernateDAO<ContaCorrenteClienteTO, ContaCorrenteClienteTOId>
implements ContaCorrenteClienteDAO {
    @Override
    protected Class<ContaCorrenteClienteTO> novoTipoDeObjetoPersistente() {
        return ContaCorrenteClienteTO.class;
    }

    @Override
    protected ContaCorrenteClienteTOId getChavePrimaria(ContaCorrenteClienteTO to) {
        return to.getId();
    }

    @Override
    public boolean isExistePelaInstituicaoAgenciaEConta(ContaCorrenteClienteTO to) {
        ContaCorrenteClienteTODecorator decorator = this.novoContaCorrenteClienteTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPelaContaCorrente(query, decorator);
        this.adicionarCriterioConsultarPelaInstituicaoEAgencia(query, decorator);
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public boolean isExisteInstistituicaoFinanceira(Integer instituicao) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoInstituicaoFinanceira", instituicao));
        return !UtilColecao.isVazio(query.list());
    }

    private void adicionarCriterioConsultarPelaContaCorrente(Criteria query, ContaCorrenteClienteTODecorator decorator) {
        Long conta = decorator.getCodigoContaCorrente();
        if (conta != null && conta != 0L) {
            query.add(this.novoCriterioEQ("id.codigoContaCorrente", conta));
        }
    }

    private void adicionarCriterioConsultarPelaInstituicaoEAgencia(Criteria query, ContaCorrenteClienteTODecorator decorator) {
        Integer instituicao = decorator.getCodigoInstituicaoFinanceira();
        Integer agencia = decorator.getCodigoAgencia();
        if (!this.isZero(instituicao) && !this.isZero(agencia)) {
            query.add(this.novoCriterioEQ("id.codigoInstituicaoFinanceira", instituicao));
            query.add(this.novoCriterioEQ("id.codigoAgencia", agencia));
        }
    }

    private ContaCorrenteClienteTODecorator novoContaCorrenteClienteTODecorator(ContaCorrenteClienteTO to) {
        return this.getTOFactory().novoContaCorrenteClienteTODecorator(to);
    }

    @Override
    protected void incrementarChaveComposta(ContaCorrenteClienteTOId chave) {
        if (chave.getCodigoContaCorrente() == null) {
            Criteria query = this.novaCriteria();
            query.add(this.novoCriterioEQ("id.codigoPessoa", chave.getCodigoPessoa()));
            query.add(this.novoCriterioEQ("id.codigoInstituicaoFinanceira", chave.getCodigoInstituicaoFinanceira()));
            query.add(this.novoCriterioEQ("id.codigoAgencia", chave.getCodigoAgencia()));
            query.setProjection((Projection)Projections.max((String)"id.codigoContaCorrente"));
            List colecao = query.list();
            Long max = (Long)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
            max = UtilSomadoresDeNumero.somar(max, 1L);
            chave.setCodigoContaCorrente(max);
        }
    }

    @Override
    public ContaCorrenteClienteTO listarPorBancoAgenciaConta(ContaCorrenteClienteTO to) {
        ContaCorrenteClienteTODecorator decorator = this.novoContaCorrenteClienteTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPelaContaCorrente(query, decorator);
        this.adicionarCriterioConsultarPelaInstituicaoEAgencia(query, decorator);
        List colecao = query.list();
        if (colecao.size() == 0) {
            return null;
        }
        return (ContaCorrenteClienteTO)colecao.get(0);
    }

    @Override
    public ContaCorrenteClienteTO consultar(Integer instituicao, Integer agencia, Long conta) {
        List lista = null;
        ContaCorrenteClienteTO retorno = null;
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoInstituicaoFinanceira", instituicao));
        query.add(this.novoCriterioEQ("id.codigoAgencia", agencia));
        query.add(this.novoCriterioEQ("id.codigoContaCorrente", conta));
        lista = query.list();
        if (!lista.isEmpty()) {
            retorno = (ContaCorrenteClienteTO)lista.get(0);
        }
        return retorno;
    }

    @Override
    public void excluir(PessoaTO pessoaTO) {
        String hql = "delete from ContaCorrenteClienteTO contaTO where contaTO.id.codigoPessoa = :codigoPessoa ";
        Query query = this.novaQuery(hql);
        query.setInteger("codigoPessoa", pessoaTO.getCodigoPessoa().intValue());
        query.executeUpdate();
    }

    @Override
    public PaginadorTO consultarPorUsuario(ContaCorrenteClienteTODecorator decorator) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoPessoa", decorator.getPessoaTO().getCodigoPessoa()));
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public boolean existeConta(ContaCorrenteClienteTO to) {
        Criteria criteria = this.getSession().createCriteria(this.getTipoDeObjetoPersistente());
        criteria.add((Criterion)Restrictions.eq((String)"id.codigoInstituicaoFinanceira", (Object)to.getId().getCodigoInstituicaoFinanceira()));
        criteria.add((Criterion)Restrictions.eq((String)"id.codigoAgencia", (Object)to.getId().getCodigoAgencia()));
        criteria.add((Criterion)Restrictions.eq((String)"id.codigoContaCorrente", (Object)to.getId().getCodigoContaCorrente()));
        return criteria.list().size() > 0;
    }

    @Override
    public PaginadorTO paginarListaConta(Collection<ContaCorrenteClienteTO> listaContasClienteDecorator, ContaCorrenteClienteTODecorator decorator) {
        return this.novoPaginadorTO(listaContasClienteDecorator, decorator.getPaginaAtual(), listaContasClienteDecorator.size());
    }

    @Override
    public List<ContaCorrenteClienteTO> listarContas(PessoaTO pessoa) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoPessoa", pessoa.getCodigoPessoa()));
        return query.list();
    }

    @Override
    public void removerConta(ContaCorrenteClienteTOId contaCorrenteClienteTOId) {
        Query query = this.getSession().createQuery("delete from ContaCorrenteClienteTO contaTO where contaTO.id.codigoContaCorrente = :codigoContaCorrente AND contaTO.id.codigoInstituicaoFinanceira = :codigoInstituicaoFinanceira AND contaTO.id.codigoAgencia = :codigoAgencia AND contaTO.id.codigoPessoa = :codigoPessoa");
        query.setParameter("codigoContaCorrente", (Object)contaCorrenteClienteTOId.getCodigoContaCorrente());
        query.setParameter("codigoInstituicaoFinanceira", (Object)contaCorrenteClienteTOId.getCodigoInstituicaoFinanceira());
        query.setParameter("codigoAgencia", (Object)contaCorrenteClienteTOId.getCodigoAgencia());
        query.setParameter("codigoPessoa", (Object)contaCorrenteClienteTOId.getCodigoPessoa());
        query.executeUpdate();
    }

    @Override
    public boolean existeContaParaPessoa(ContaCorrenteClienteTO to) {
        Criteria criteria = this.getSession().createCriteria(this.getTipoDeObjetoPersistente());
        criteria.add((Criterion)Restrictions.eq((String)"id.codigoInstituicaoFinanceira", (Object)to.getId().getCodigoInstituicaoFinanceira()));
        criteria.add((Criterion)Restrictions.eq((String)"id.codigoAgencia", (Object)to.getId().getCodigoAgencia()));
        criteria.add((Criterion)Restrictions.eq((String)"id.codigoContaCorrente", (Object)to.getId().getCodigoContaCorrente()));
        criteria.add((Criterion)Restrictions.eq((String)"pessoaTO", (Object)to.getPessoaTO()));
        return criteria.list().size() > 0;
    }
}

