/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.ContatoDAO;
import br.com.bb.plugins.gac.integracao.dao.ContatoDAOImpl;
import br.com.bb.plugins.gac.integracao.dao.DAOTestAbstrato;
import br.com.bb.plugins.gac.negocio.to.ContatoTO;
import br.com.bb.plugins.gac.negocio.to.ContatoTOId;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.TipoContatoTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import java.util.Collection;

public class ContatoDAOTest
extends DAOTestAbstrato {
    public void testID() {
        ContatoTOId id = new ContatoTOId();
        id.setCodigoPessoa(500);
        id.setCodigoTipoContato(6);
        PessoaTO pessoaTO = new PessoaTO();
        pessoaTO.setCodigoPessoa(500);
        TipoContatoTO tipoContatoTO = new TipoContatoTO();
        tipoContatoTO.setCodigoTipoContato(1);
        ContatoTO to = new ContatoTO();
        to.setId(id);
        to.setTextoContato("3355-0000");
        to.setTipoContatoTO(tipoContatoTO);
        ContatoDAO dao = (ContatoDAO)this.novaDAO(ContatoDAOImpl.class);
        Collection<ContatoTO> c = dao.consultarPelaPessoa(pessoaTO);
        System.out.println(c.size());
        System.out.println("foi");
    }

    public void _testConsultarPessoa() {
        PessoaTO p = new PessoaTO();
        p.setCodigoPessoa(2);
        ContatoDAO dao = (ContatoDAO)this.novaDAO(ContatoDAOImpl.class);
        Collection<ContatoTO> c = dao.consultarPelaPessoa(p);
        ContatoDAOTest.assertNotNull(c);
    }

    public void _testIncluir() {
        ContatoTO to = this.novoContatoTO(1, 1, 1, "Texto");
        ContatoDAO dao = this.novaContatoDAO();
        dao.incluir(to);
    }

    public void _testAlterar() {
        ContatoTO to = this.novoContatoTO(1, 1, 1, "Texto Novo");
        ContatoDAO dao = this.novaContatoDAO();
        dao.alterar(to);
        ContatoDAOTest.assertNotNull((Object)to);
        ContatoDAOTest.assertEquals((String)"Texto Novo", (String)to.getTextoContato());
    }

    public void _testExcluir() {
        ContatoTO to = this.novoContatoTO(1, 1, 1, "Texto Novo");
        ContatoDAO dao = this.novaContatoDAO();
        PessoaTO p = new PessoaTO();
        p.setCodigoPessoa(1);
        Collection<ContatoTO> lista = dao.consultarPelaPessoa(p);
        for (ContatoTO contatoTO : lista) {
            dao.excluir(contatoTO);
        }
        ContatoDAOTest.assertNotNull((Object)to);
    }

    protected TipoPessoaTO novoTipoPessoaTO(int tipo) {
        TipoPessoaTO to = new TipoPessoaTO();
        to.setCodigoTipoPessoa(tipo);
        return to;
    }

    protected ContatoTO novoContatoTO(int codigoPessoa, int codigoTipoContato, int numeroIdentificadorContato, String texto) {
        ContatoTO to = this.novoContatoTO();
        to.setPessoaTO(new PessoaTO());
        to.getPessoaTO().setCodigoPessoa(codigoPessoa);
        to.setTipoContatoTO(new TipoContatoTO());
        to.getTipoContatoTO().setCodigoTipoContato(codigoTipoContato);
        to.setTextoContato(texto);
        return to;
    }

    protected ContatoTO novoContatoTO() {
        return new ContatoTO();
    }

    protected ContatoDAO novaContatoDAO() {
        return (ContatoDAO)this.novaDAO(ContatoDAOImpl.class);
    }
}

