/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.integracao.dao.DAO;
import br.com.bb.plugins.gac.integracao.dao.UtilRestricaoDAO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.util.Log;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeNumerosIguais;
import br.com.politec.reflexao.UtilReflexaoGet;
import br.com.politec.reflexao.exception.ReflexaoException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.transform.ResultTransformer;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateDAO<T, PK extends Serializable>
extends HibernateDaoSupport
implements DAO<T, PK> {
    private Class<T> tipoDeObjetoPersistente;

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public T incluir(T object) {
        try {
            this.validarChaveComposta(object);
            this.getSession().save(object);
            return object;
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected void validarChaveComposta(T objeto) {
        PK chave = this.getChavePrimaria(objeto);
        if (UtilObjeto.isObjetoDoTipo(chave, PluginTOAbstrato.class)) {
            this.incrementarChaveComposta((Serializable)chave);
        }
    }

    protected void incrementarChaveComposta(PK chave) {
        System.out.println("Chave composta n\u00e3o ajustada");
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public T incluirOuAlterar(T object) {
        try {
            this.getSession().saveOrUpdate(object);
            return object;
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void alterar(T object) {
        try {
            this.getSession().merge(object);
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void excluir(T object) {
        try {
            T removeTO = this.listar(object);
            this.getSession().delete(removeTO);
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void excluir(PK object) {
        try {
            PK removeTO = this.listar((T)object);
            this.getSession().delete(removeTO);
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    public Collection<T> consultar() {
        try {
            Class<T> tipo = this.getTipoDeObjetoPersistente();
            Criteria c = this.getSession().createCriteria(tipo);
            return c.list();
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    public Collection<T> consultar(T to) {
        try {
            Class<T> tipo = this.getTipoDeObjetoPersistente();
            Criteria c = this.getSession().createCriteria(tipo);
            c.add((Criterion)Example.create(to).enableLike(MatchMode.ANYWHERE));
            return c.list();
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    public T listar(PK to) {
        try {
            return (T)this.getSession().get(this.getTipoDeObjetoPersistente(), to);
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    public T listar(T to) {
        try {
            PK pk = this.getChavePrimaria(to);
            return (T)this.listar((T)pk);
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected abstract PK getChavePrimaria(T var1);

    protected abstract Class<T> novoTipoDeObjetoPersistente();

    protected Class<T> getTipoDeObjetoPersistente() {
        if (!this.isReferencia(this.tipoDeObjetoPersistente)) {
            this.tipoDeObjetoPersistente = this.novoTipoDeObjetoPersistente();
        }
        return this.tipoDeObjetoPersistente;
    }

    protected Class<?> getTipoDeObjetoPersistente(T to) {
        return to.getClass();
    }

    protected boolean isReferencia(Object objeto) {
        boolean resultado = false;
        resultado = UtilObjeto.isObjetoDoTipo(objeto, String.class) ? !UtilString.isVazio((String)objeto) : UtilObjeto.isReferencia(objeto);
        return resultado;
    }

    protected boolean isReferencia(Object objeto0, Object objeto1) {
        return UtilObjeto.isReferencia(objeto0, objeto1);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    protected void atualizar(T to) {
        try {
            this.getSession().refresh(to);
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected int getQuantidadeDeRegistros(T to) {
        try {
            Collection<T> l = this.consultar(to);
            Integer i = new Integer(l.size());
            return i;
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected int getQuantidadeDeRegistros() {
        try {
            Collection<T> l = this.consultar();
            Integer i = new Integer(l.size());
            return i;
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected List<T> consultarPeloHQL(String hql) {
        Query query = this.getSession().createQuery(hql);
        return query.list();
    }

    protected List<T> consultar(T to, int primeiroRegistro, int quantidade) {
        try {
            Class<T> tipo = this.getTipoDeObjetoPersistente();
            Criteria c = this.getSession().createCriteria(tipo);
            c.add((Criterion)Example.create(to));
            if (primeiroRegistro != 0) {
                c.setFirstResult(primeiroRegistro);
            }
            if (quantidade != 0) {
                c.setMaxResults(quantidade);
            }
            return c.list();
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected List<T> consultar(int primeiroRegistro, int quantidade) {
        try {
            Class<T> tipo = this.getTipoDeObjetoPersistente();
            Criteria c = this.getSession().createCriteria(tipo);
            if (primeiroRegistro != 0) {
                c.setFirstResult(primeiroRegistro);
            }
            if (quantidade != 0) {
                c.setMaxResults(quantidade);
            }
            return c.list();
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected void persistir(T object) {
        try {
            this.getSession().persist(object);
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    protected Query novaQuery(String hql) {
        return this.getSession().createQuery(hql);
    }

    protected Criteria novaCriteria() {
        return this.getSession().createCriteria(this.getTipoDeObjetoPersistente());
    }

    protected Criterion novoCriterioBetween(String propriedade, Object arg0, Object arg1) {
        return Restrictions.between((String)propriedade, (Object)arg0, (Object)arg1);
    }

    protected Criterion novoCriterioLikeDireita(String propriedade, String arg0) {
        SimpleExpression se = null;
        se = Restrictions.like((String)propriedade, (String)arg0, (MatchMode)MatchMode.START);
        se.ignoreCase();
        return se;
    }

    protected Criterion novoCriterioLike(String propriedade, String arg0) {
        SimpleExpression se = null;
        se = Restrictions.like((String)propriedade, (String)arg0, (MatchMode)MatchMode.ANYWHERE);
        se.ignoreCase();
        return se;
    }

    protected Criterion novoCriterioEQ(String propriedade, Object arg0) {
        return Restrictions.eq((String)propriedade, (Object)arg0);
    }

    protected Criterion novoCriterioNE(String propriedade, Object arg0) {
        return Restrictions.ne((String)propriedade, (Object)arg0);
    }

    protected Criterion novoCriterioMenorIgual(String propriedade, Object arg0) {
        return Restrictions.le((String)propriedade, (Object)arg0);
    }

    protected Criterion novoCriterioMaiorIgual(String propriedade, Object arg0) {
        return Restrictions.ge((String)propriedade, (Object)arg0);
    }

    protected Criterion novoCriterioEQIgnoreCase(String propriedade, Object arg0) {
        SimpleExpression se = Restrictions.eq((String)propriedade, (Object)arg0);
        se.ignoreCase();
        return se;
    }

    protected Criterion novoCriterioIN(String propriedade, Collection colecao, String propriedadeDoObjeto) {
        Criterion criterion = null;
        if (!this.isVazio(colecao)) {
            Object[] array = new Object[colecao.size()];
            int indice = 0;
            for (Object o : colecao) {
                try {
                    array[indice] = propriedadeDoObjeto == null || propriedadeDoObjeto.trim().length() == 0 ? o : UtilReflexaoGet.get(o, propriedadeDoObjeto);
                }
                catch (ReflexaoException e) {
                    Log.getInstance().logMsg(e);
                }
                ++indice;
            }
            criterion = Restrictions.in((String)propriedade, (Object[])array);
        }
        return criterion;
    }

    protected boolean isZero(Integer integer) {
        return !this.isReferencia(integer) || UtilValidadorDeNumerosIguais.validar(integer, 0);
    }

    protected boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    protected boolean isVazio(String string0, String string1) {
        return UtilString.isVazio(string0, string1);
    }

    protected boolean isVazio(Collection colecao) {
        return UtilColecao.isVazio(colecao);
    }

    protected PaginadorTO novoPaginadorTO(Criteria query, PluginTODecoratorAbstrato decorator) {
        PaginadorTO to = this.novoPaginadorTOSemResultado(query, decorator);
        this.aplicarOrdenacao(query, decorator);
        to.setColecaoDeRegistros(query.list());
        return to;
    }

    protected PaginadorTO novoPaginadorTO(Query queryList, Query queryTotal, PluginTODecoratorAbstrato decorator) {
        PaginadorTO to = this.getTOFactory().novoPaginadorTO();
        to.setTotalDeRegistros(((Long)queryTotal.list().get(0)).intValue());
        to.setPaginaAtual(decorator.getPaginaAtual());
        this.aplicarPaginacao(queryList, decorator);
        to.setColecaoDeRegistros(queryList.list());
        return to;
    }

    public PaginadorTO novoPaginadorTO(Collection colecao, Integer paginaAtual, Integer totalDeRegistros) {
        int ultimaPagina = 0;
        int quantidade = 10;
        int inicio = quantidade * (paginaAtual - 1);
        int fim = inicio + quantidade;
        if (fim > totalDeRegistros) {
            fim = totalDeRegistros;
        }
        List colecaoPaginada = ((List)colecao).subList(inicio, fim);
        ultimaPagina = totalDeRegistros / quantidade;
        if (totalDeRegistros % quantidade > 0) {
            ++ultimaPagina;
        }
        if (paginaAtual > ultimaPagina) {
            paginaAtual = ultimaPagina;
        }
        PaginadorTO paginadorTO = new PaginadorTO();
        paginadorTO.setPaginaAtual(paginaAtual);
        paginadorTO.setTotalDeRegistros(totalDeRegistros);
        paginadorTO.setColecaoDeRegistros(colecaoPaginada);
        return paginadorTO;
    }

    protected PaginadorTO novoPaginadorTO(Criteria query, PluginTODecoratorAbstrato decorator, Order ordenacao) {
        PaginadorTO to = this.novoPaginadorTOSemResultado(query, decorator);
        this.aplicarOrdenacao(query, ordenacao);
        to.setColecaoDeRegistros(query.list());
        return to;
    }

    protected PaginadorTO novoPaginadorTO(Criteria query, PluginTODecoratorAbstrato decorator, List<Order> ordenacoes) {
        PaginadorTO to = this.novoPaginadorTOSemResultado(query, decorator);
        this.aplicarOrdenacao(query, ordenacoes);
        to.setColecaoDeRegistros(query.list());
        return to;
    }

    protected PaginadorTO novoPaginadorTOComOrdenacaoASC(Criteria query, PluginTODecoratorAbstrato decorator, String propriedadeOrdenada) {
        PaginadorTO to = this.novoPaginadorTOSemResultado(query, decorator);
        this.aplicarOrdenacao(query, this.novaOrdenacaoASC(propriedadeOrdenada));
        to.setColecaoDeRegistros(query.list());
        return to;
    }

    protected PaginadorTO novoPaginadorTOComOrdenacaoDESC(Criteria query, PluginTODecoratorAbstrato decorator, String propriedadeOrdenada) {
        PaginadorTO to = this.novoPaginadorTOSemResultado(query, decorator);
        this.aplicarOrdenacao(query, this.novaOrdenacaoDESC(propriedadeOrdenada));
        to.setColecaoDeRegistros(query.list());
        return to;
    }

    protected PaginadorTO novoPaginadorTO(Collection colecao, PluginTODecoratorAbstrato decorator) {
        return this.getTOFactory().novoPaginadorTO(colecao, decorator);
    }

    protected Order novaOrdenacaoASC(String propriedade) {
        return Order.asc((String)propriedade);
    }

    protected Order novaOrdenacaoDESC(String propriedade) {
        return Order.desc((String)propriedade);
    }

    protected void aplicarPaginacao(Criteria query, PluginTODecoratorAbstrato to) {
        Integer pagina = to.getPaginaAtual();
        if (!this.isZero(pagina)) {
            int quantidade = 10;
            int inicio = pagina * quantidade - quantidade;
            query.setFirstResult(inicio);
            query.setMaxResults(10);
        }
    }

    protected void aplicarPaginacao(Query query, PluginTODecoratorAbstrato to) {
        Integer pagina = to.getPaginaAtual();
        if (!this.isZero(pagina)) {
            int quantidade = 10;
            int inicio = pagina * quantidade - quantidade;
            query.setFirstResult(inicio);
            query.setMaxResults(10);
        }
    }

    protected void aplicarOrdenacao(Criteria query, Order ordenacao) {
        query.addOrder(ordenacao);
    }

    protected void aplicarOrdenacao(Criteria query, List<Order> ordenacoes) {
        for (Order ordenacao : ordenacoes) {
            this.aplicarOrdenacao(query, ordenacao);
        }
    }

    protected void aplicarOrdenacao(Criteria query, PluginTODecoratorAbstrato decorator) {
        String propriedade;
        String tipo = decorator.getTipoOrdenacao();
        if (!this.isVazio(tipo, propriedade = decorator.getNomeColunaOrdenada())) {
            propriedade = this.getPropriedade(query, propriedade);
            this.aplicarOrdenacao(query, this.getOrder(tipo, propriedade));
        }
    }

    protected String aplicarOrdenacao(String sql, PluginTODecoratorAbstrato decorator) {
        String propriedade;
        String tipo = decorator.getTipoOrdenacao();
        if (!this.isVazio(tipo, propriedade = decorator.getNomeColunaOrdenada())) {
            String pattern = "{orderby}";
            String orderby = this.getOrderString(tipo, propriedade);
            if (UtilString.isTemString(sql, pattern)) {
                pattern = "\\{orderby}";
                sql = UtilString.substituirString(sql, pattern, orderby);
            }
        }
        return sql;
    }

    protected Criteria getCriteria(Criteria query, String alias) {
        Criteria resultado = this.recuperarSubCriteria(query, alias);
        if (!this.isReferencia(resultado)) {
            resultado = query.createCriteria(alias, alias);
        }
        return resultado;
    }

    protected Criteria getCriteria(Criteria query, String alias, int tipojoin) {
        Criteria resultado = this.recuperarSubCriteria(query, alias);
        if (!this.isReferencia(resultado)) {
            resultado = query.createCriteria(alias, alias, tipojoin);
        }
        return resultado;
    }

    protected Criteria getCriteria(Criteria query, String nomeCriteria, String alias, int tipojoin) {
        Criteria resultado = this.recuperarSubCriteria(query, alias);
        if (!this.isReferencia(resultado)) {
            resultado = query.createCriteria(nomeCriteria, alias, tipojoin);
        }
        return resultado;
    }

    protected Criteria getAlias(Criteria query, String alias) {
        Criteria resultado = this.recuperarSubCriteria(query, alias);
        if (!this.isReferencia(resultado)) {
            resultado = query.createAlias(alias, alias);
        }
        return resultado;
    }

    protected Integer getTotalDeRegistros(Criteria query) {
        ResultTransformer rt = null;
        if (UtilObjeto.isObjetoDoTipo(query, CriteriaImpl.class)) {
            rt = ((CriteriaImpl)query).getResultTransformer();
        }
        query.setProjection(Projections.rowCount());
        List colecao = query.list();
        Integer qtd = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
        query.setProjection(null);
        if (this.isReferencia(rt)) {
            query.setResultTransformer(rt);
        }
        return qtd;
    }

    protected TOFactory getTOFactory() {
        return TOFactory.getInstancia();
    }

    private Criteria recuperarSubCriteria(Criteria query, String alias) {
        Criteria resultado = null;
        Criteria principal = this.getCriteriaPrincipal(query);
        Iterator i = ((CriteriaImpl)principal).iterateSubcriteria();
        while (i.hasNext() && !this.isReferencia(resultado)) {
            Criteria criteria = (Criteria)i.next();
            if (!UtilString.isStringsIguais(criteria.getAlias(), alias)) continue;
            resultado = criteria;
        }
        return resultado;
    }

    private Criteria getCriteriaPrincipal(Criteria query) {
        Criteria resultado = query;
        Class<CriteriaImpl.Subcriteria> subcriteria = CriteriaImpl.Subcriteria.class;
        while (UtilObjeto.isObjetoDoTipo(resultado, subcriteria)) {
            resultado = ((CriteriaImpl.Subcriteria)resultado).getParent();
        }
        return resultado;
    }

    private String getPropriedade(Criteria query, String propriedade) {
        List lista = UtilString.split(propriedade, ".");
        StringBuffer path = this.novoStringBuffer();
        String alias = null;
        int indice = 0;
        while (indice < lista.size() - 1) {
            alias = (String)lista.get(indice);
            if (path.length() != 0) {
                path.append(".");
            }
            path.append(alias);
            if (!this.isReferencia(this.recuperarSubCriteria(query, alias))) {
                query.createAlias(path.toString(), alias);
            }
            ++indice;
        }
        return this.getUltimoPathDaPropriedade(lista);
    }

    private Order getOrder(String tipo, String propriedade) {
        Map<String, Order> mapa = this.novoMapaDoTipoDeOrdenacao(propriedade);
        return mapa.get(tipo);
    }

    private String getOrderString(String tipo, String propriedade) {
        Map<String, String> mapa = this.novoMapaDoTipoDeOrdenacaoString(propriedade);
        return mapa.get(tipo);
    }

    private Map<String, Order> novoMapaDoTipoDeOrdenacao(String propriedade) {
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("ASC", this.novaOrdenacaoASC(propriedade));
        mapa.put("DESC", this.novaOrdenacaoDESC(propriedade));
        return mapa;
    }

    private Map<String, String> novoMapaDoTipoDeOrdenacaoString(String propriedade) {
        String asc = "order by " + propriedade;
        String desc = "order by " + propriedade + " desc";
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("ASC", asc);
        mapa.put("DESC", desc);
        return mapa;
    }

    private ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    protected PaginadorTO novoPaginadorTOSemResultado(Criteria query, PluginTODecoratorAbstrato decorator) {
        PaginadorTO to = this.getTOFactory().novoPaginadorTO();
        to.setTotalDeRegistros(this.getTotalDeRegistros(query));
        this.aplicarPaginacao(query, decorator);
        to.setPaginaAtual(decorator.getPaginaAtual());
        return to;
    }

    protected PaginadorTO novoPaginadorTOSemResultado(Query query, PluginTODecoratorAbstrato decorator) {
        PaginadorTO to = this.getTOFactory().novoPaginadorTO();
        to.setTotalDeRegistros(this.getTotalDeRegistros(query));
        this.aplicarPaginacao(query, decorator);
        to.setPaginaAtual(decorator.getPaginaAtual());
        return to;
    }

    private Integer getTotalDeRegistros(Query query) {
        return query.list().size();
    }

    private String getUltimoPathDaPropriedade(List<String> lista) {
        StringBuffer propriedade = this.novoStringBuffer();
        if (UtilColecao.getTamanho(lista) > 1) {
            propriedade.append(this.getElementoDoIndice(lista, lista.size() - 2));
            propriedade.append(".");
            propriedade.append(this.getElementoDoIndice(lista, lista.size() - 1));
        } else {
            propriedade.append(this.getElementoDoIndice(lista, 0));
        }
        return propriedade.toString();
    }

    private String getElementoDoIndice(List<String> lista, int indice) {
        return (String)UtilColecao.getElementoDoIndice(lista, indice);
    }

    private StringBuffer novoStringBuffer() {
        return new StringBuffer();
    }

    @Override
    public void closeSession() {
        this.getSession().flush();
        this.getSession().close();
        this.getSession().disconnect();
    }

    @Override
    public void flushSession() {
        this.getSession().flush();
    }

    @Override
    public void atualizaObjeto(T to) {
        this.atualizar(to);
    }

    public void montaHQLFiltroConvenio(StringBuilder hql) {
        UtilRestricaoDAO.montaHQLFiltroConvenio(hql);
    }

    public void montaHQLFiltroImpressaoDaAutorizacaoDeDebito(StringBuilder hql) {
        UtilRestricaoDAO.montaHQLFiltroImpressaoDaAutorizacaoDeDebito(hql);
    }

    public void montaHQLFiltroTextoIdentificadorDeDebito(StringBuilder hql) {
        UtilRestricaoDAO.montaHQLFiltroTextoIdentificadorDeDebito(hql);
    }

    public void montaHQLFiltroSituacaoAutorizacaoDeDebito(StringBuilder hql) {
        UtilRestricaoDAO.montaHQLFiltroSituacaoAutorizacaoDeDebito(hql);
    }

    public void montaHQLFiltroGrupoClienteRecebimento(StringBuilder hql) {
        UtilRestricaoDAO.montaHQLFiltroGrupoClienteRecebimento(hql);
    }

    public void montaHQLFiltroSemGrupoClienteRecebimento(StringBuilder hql) {
        UtilRestricaoDAO.montaHQLFiltroSemGrupoClienteRecebimento(hql);
    }
}

