/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificacaoDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTOId;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificacaoTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentificacaoDAOImpl
extends HibernateDAO<IdentificacaoTO, IdentificacaoTOId>
implements IdentificacaoDAO {
    @Override
    public Collection<IdentificacaoTO> consultarPelaPessoa(PessoaTO to) {
        Integer codigoPessoa = to.getCodigoPessoa();
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("pessoaTO.codigoPessoa", codigoPessoa));
        return query.list();
    }

    @Override
    public boolean isExisteTextoIdentificacao(IdentificacaoTO identificacaoTO) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.textoIdentificacao", identificacaoTO.getTextoIdentificacao()));
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public IdentificacaoTO listarTextoComplemento(IdentificacaoTO identificacaoTO) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("textoComplemento", identificacaoTO.getTextoComplemento()));
        return (IdentificacaoTO)query.uniqueResult();
    }

    @Override
    public boolean isExistePorIdentificacaoETipoDocumento(IdentificacaoTO to) {
        IdentificacaoTODecorator decorator = this.novoIdentificacaoTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorIdentificacao(query, decorator);
        this.adicionarCriterioConsultarPorTipoDeDocumento(query, decorator);
        return !UtilColecao.isVazio(query.list());
    }

    private void adicionarCriterioConsultarPorTipoDeDocumento(Criteria query, IdentificacaoTODecorator decorator) {
        Integer tipo = decorator.getCodigoTipoDocumento();
        if (!this.isZero(tipo)) {
            Criteria documento = query.createCriteria("tipoDocumentoTO");
            documento.add(this.novoCriterioEQ("codigoTipoDocumento", tipo));
        }
    }

    private IdentificacaoTODecorator novoIdentificacaoTODecorator(IdentificacaoTO to) {
        return this.getTOFactory().novoIdentificacaoTODecorator(to);
    }

    private void adicionarCriterioConsultarPorIdentificacao(Criteria query, IdentificacaoTODecorator decorator) {
        String texto = decorator.getIdentificacaoTO().getTextoComplemento();
        String textoIdentificacao = decorator.getIdentificacaoTO().getTextoIdentificacao();
        if (!this.isVazio(texto)) {
            query.add(this.novoCriterioEQ("textoComplemento", texto));
        }
        if (!this.isVazio(textoIdentificacao)) {
            query.add(this.novoCriterioEQ("id.textoIdentificacao", texto));
        }
    }

    @Override
    public IdentificacaoTO consultarIdentificacaoPorIdProprioEConvenente(String textoIdentificadorProprio, ConvenenteTO convenenteTO) {
        IdentificacaoTO retorno = null;
        List lista = null;
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.textoIdentificacao", textoIdentificadorProprio));
        query.createCriteria("identificadorTO").createCriteria("convenenteTOs", "convenente").add(this.novoCriterioEQ("convenente.codigoPessoaConvenente", convenenteTO.getCodigoPessoaConvenente()));
        lista = query.list();
        if (lista.size() > 0) {
            retorno = (IdentificacaoTO)lista.get(0);
        }
        return retorno;
    }

    @Override
    protected Class<IdentificacaoTO> novoTipoDeObjetoPersistente() {
        return IdentificacaoTO.class;
    }

    @Override
    protected IdentificacaoTOId getChavePrimaria(IdentificacaoTO to) {
        return to.getId();
    }

    @Override
    public void excluirIdentificadorProprio(IdentificacaoTOId id) {
        String hql = "delete from IdentificacaoTO  where id.codigoPessoa = :codigoPessoa  and id.codigoTipoDocumento = :codigoTipoDocumento  and id.textoIdentificador = :textoIdentificador ";
        Query query = this.novaQuery(hql);
        query.setInteger("codigoPessoa", id.getCodigoPessoa().intValue());
        query.setInteger("codigoTipoDocumento", id.getCodigoTipoDocumento().intValue());
        query.setString("textoIdentificador", id.getTextoIdentificador());
        int linhasAfetadas = query.executeUpdate();
    }

    @Override
    public IdentificacaoTO consultarIdentificacao(IdentificacaoTO identificacaoTO) {
        List lista = null;
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.textoIdentificacao", identificacaoTO.getTextoIdentificacao()));
        lista = query.list();
        if (lista.size() > 0) {
            return (IdentificacaoTO)lista.get(0);
        }
        return null;
    }

    @Override
    public IdentificacaoTO consultarIdentificacaoEmModulo(IdentificacaoTO identificacaoTO, String modulo) {
        Criteria criteria = this.getSession().createCriteria(IdentificacaoTO.class);
        criteria.add((Criterion)Restrictions.eq((String)"id.textoIdentificacao", (Object)identificacaoTO.getTextoIdentificacao()));
        criteria.createAlias("pessoaTO", "pessoaTO");
        criteria.createAlias("pessoaTO.convenenteTOs", "convenenteTO");
        criteria.createAlias("convenenteTO.servicoConvenenteTOs", "servicoConvenenteTO");
        criteria.add((Criterion)Restrictions.eq((String)"servicoConvenenteTO.id.textoIdentificadorServico", (Object)modulo));
        if (!criteria.list().isEmpty()) {
            return (IdentificacaoTO)criteria.list().get(0);
        }
        return null;
    }
}

