/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificadorDAO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTOId;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.politec.generico.calculadores.UtilSomadoresDeNumero;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeString;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentificadorDAOImpl
extends HibernateDAO<IdentificadorTO, IdentificadorTOId>
implements IdentificadorDAO {
    @Override
    protected Class<IdentificadorTO> novoTipoDeObjetoPersistente() {
        return IdentificadorTO.class;
    }

    @Override
    protected IdentificadorTOId getChavePrimaria(IdentificadorTO to) {
        return to.getId();
    }

    @Override
    public Collection<IdentificadorTO> consultarListaTipoDocumento(TipoPessoaTO pessoaTO, ServicoTO servicoTO) {
        String identificacao = servicoTO.getTextoIdentificadorServico();
        Integer tipo = pessoaTO.getCodigoTipoPessoa();
        Query query = this.novaQuery(this.getSQLConsultarListaTipoDocumento());
        query.setInteger("tipoPessoa", tipo.intValue());
        query.setString("servico", identificacao);
        return query.list();
    }

    @Override
    public boolean isDocumentoUtilizado(IdentificadorTO to, PessoaTO pessoa) {
        boolean resultado = false;
        if (to != null && to.getId().getTextoIdentificador() != null && to.getId().getCodigoTipoDocumento() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select objIdentificacao                ");
            sql.append(" from IdentificadorTO objIdentificador, ");
            sql.append("      IdentificacaoTO objIdentificacao, ");
            sql.append("\t  TipoDocumentoTO objTipoDocumento  ");
            sql.append("where                                   ");
            sql.append("      (objIdentificacao.id.codigoTipoDocumento  = objIdentificador.id.codigoTipoDocumento )");
            sql.append("  and (objIdentificacao.identificadorTO.id.textoIdentificador  = objIdentificador.id.textoIdentificador )");
            sql.append("  and (objIdentificacao.id.codigoTipoDocumento  = objTipoDocumento.codigoTipoDocumento)");
            sql.append("  and (objIdentificacao.id.codigoTipoDocumento  = '" + to.getId().getCodigoTipoDocumento() + "')");
            sql.append("  and (objIdentificacao.identificadorTO.id.textoIdentificador = '" + to.getId().getTextoIdentificador() + "')");
            sql.append("  and (objIdentificacao.id.codigoPessoa <> '" + pessoa.getCodigoPessoa() + "')");
            resultado = this.getSession().createQuery(sql.toString()).list().size() > 1;
        }
        return resultado;
    }

    private String getSQLConsultarListaTipoDocumento() {
        return "select objIdentificadorTO from IdentificadorTO objIdentificadorTO \tinner join objIdentificadorTO.tipoDocumentoTO objTipoDocumentoTO \tinner join objTipoDocumentoTO.servicoTipoDocumentoTOs as objServicoTipoDocumentoTOs \tinner join objServicoTipoDocumentoTOs.servicoTO as objServicoTO  where objIdentificadorTO.tipoDocumentoTO.tipoPessoaTO.codigoTipoPessoa = :tipoPessoa and  objServicoTO.textoIdentificadorServico = :servico ";
    }

    @Override
    public Integer consultarProximoIdentificador(Integer codigoTipoDoc) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoTipoDocumento", codigoTipoDoc));
        query.setProjection((Projection)Projections.max((String)"id.textoIdentificador"));
        List colecao = query.list();
        String max = (String)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
        Integer maxInt = UtilSomadoresDeNumero.somar(UtilConversorDeString.converterParaInt(max), 1);
        return maxInt;
    }
}

