/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.DAOTestAbstrato;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAOImpl;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import java.util.Collection;

public class InstituicaoFinanceiraDAOTest
extends DAOTestAbstrato {
    private static int codigoInstituicaoFinanceira;

    public void testIncluir() {
        InstituicaoFinanceiraTO to = this.novoInstituicaoFinanceiraTO(Character.valueOf('S'), "Cobra");
        this.novaInstituicaoFinanceiraDAO().incluir(to);
        this.setCodigoInstituicaoFinanceira(to.getCodigoInstituicaoFinanceira());
    }

    public void testAlterar() {
        Integer c = this.getCodigoInstituicaoFinanceira();
        InstituicaoFinanceiraTO to = (InstituicaoFinanceiraTO)((Object)this.novaInstituicaoFinanceiraDAO().listar(c));
        to.setTextoNomeInstituicaoFinanceira("Nova Cobra");
        this.novaInstituicaoFinanceiraDAO().alterar(to);
    }

    public void testListar() {
        Collection colecao = this.novaInstituicaoFinanceiraDAO().consultar();
        InstituicaoFinanceiraDAOTest.assertNotNull(colecao);
        InstituicaoFinanceiraDAOTest.assertTrue((colecao.size() > 0 ? 1 : 0) != 0);
    }

    public void testConsultar() {
        InstituicaoFinanceiraTO to = this.novoInstituicaoFinanceiraTO();
        to.setCodigoInstituicaoFinanceira(1);
        InstituicaoFinanceiraDAO dao = this.novaInstituicaoFinanceiraDAO();
        Collection<InstituicaoFinanceiraTO> colecao = dao.consultar(to);
        InstituicaoFinanceiraDAOTest.assertNotNull(colecao);
        InstituicaoFinanceiraDAOTest.assertTrue((colecao.size() > 0 ? 1 : 0) != 0);
    }

    public void testExcluir() {
        Integer c = this.getCodigoInstituicaoFinanceira();
        this.novaInstituicaoFinanceiraDAO().excluir(c);
    }

    protected InstituicaoFinanceiraTO novoInstituicaoFinanceiraTO(Character indicador, String texto) {
        InstituicaoFinanceiraTO to = this.novoInstituicaoFinanceiraTO();
        to.setIndicadorEstadoInstituicaoFinanceira(indicador);
        to.setTextoNomeInstituicaoFinanceira(texto);
        return to;
    }

    protected InstituicaoFinanceiraTO novoInstituicaoFinanceiraTO() {
        return new InstituicaoFinanceiraTO();
    }

    protected InstituicaoFinanceiraDAO novaInstituicaoFinanceiraDAO() {
        return (InstituicaoFinanceiraDAO)this.novaDAO(InstituicaoFinanceiraDAOImpl.class);
    }

    private int getCodigoInstituicaoFinanceira() {
        return codigoInstituicaoFinanceira;
    }

    private void setCodigoInstituicaoFinanceira(int codigoPessoa) {
        codigoInstituicaoFinanceira = codigoPessoa;
    }
}

