/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.UtilRestricaoDAO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO2;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.bb.plugins.gac.util.UtilIdentificadorProprio;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.string.UtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PessoaDAOImpl
extends HibernateDAO<PessoaTO, Integer>
implements PessoaDAO {
    @Override
    public PaginadorTO consultar(PessoaTODecorator decorator) {
        Criteria query = this.novaCriteria();
        return this.novoPaginadorTOComOrdenacaoASC(query, decorator, "textoNome");
    }

    @Override
    public Collection<PessoaTO> consultarPorTipo(PessoaTODecorator to) {
        Criteria query = this.novaCriteria();
        query.add(this.getCriterioConsultarPorTipo(to));
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPorNomeInicialFinal(PessoaTODecorator to) {
        Criteria query = this.novaCriteria();
        query.add(this.getCriterioConsultarPorNomeInicialFinal(to));
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPorData(PessoaTODecorator to) {
        Criteria query = this.novaCriteria();
        query.add(this.getCriterioConsultarPorData(to));
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPorDataEDebito(PessoaTO to) {
        Query query = this.novaQuery(this.getSQLConsultarPorDataEDebito());
        query.setDate("data", to.getDataUltimaOperacao());
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPorDataEDebito(PessoaTODecorator decorator) {
        Query query = this.novaQuery(this.getSQLConsultarPorDataEDebito());
        query.setDate("data", decorator.getDataUltimaOperacao());
        return query.list();
    }

    @Override
    public Integer getQuantidadePorDataEDebito(PessoaTO to) {
        Query query = this.novaQuery(this.getSQLConsultarPorDataEDebito());
        query.setDate("data", to.getDataUltimaOperacao());
        List lista = query.list();
        return lista.size();
    }

    @Override
    public Integer getQuantidadePorServicoDataEDebito(PessoaTODecorator decorator) {
        Query query = this.novaQuery(this.getSQLConsultarPorServicoDataEDebito());
        query.setDate("data", decorator.getDataUltimaOperacao());
        List lista = query.list();
        return lista.size();
    }

    @Override
    public Integer getQuantidadePorDataEDebito(PessoaTODecorator decorator) {
        Query query = this.novaQuery(this.getSQLConsultarPorDataEDebito());
        query.setDate("data", decorator.getDataUltimaOperacao());
        List lista = query.list();
        return lista.size();
    }

    @Override
    public Collection<PessoaTO> consultarPorServicoDataEDebito(PessoaTODecorator decorator) {
        Query query = this.novaQuery(this.getSQLConsultarPorServicoDataEDebito());
        query.setDate("data", decorator.getDataUltimaOperacao());
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPorCPFouCNPJ(PessoaTODecorator to) {
        Criteria query = this.novaCriteria();
        Criteria identificacao = this.getCriteria(query, "identificacaoTOs");
        identificacao.add(this.getCriterioConsultarPorCPFouCNPJ(to));
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPorIntervaloCodigo(int codigoInicial, int codigoFinal) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioBetween("codigoPessoa", codigoInicial, codigoFinal));
        return query.list();
    }

    @Override
    public PaginadorTO consultarPorIdentificadorTipoNomeData(PessoaTODecorator to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorCPFouCNPJ(query, to);
        this.adicionarCriterioConsultarPorTipo(query, to);
        this.adicionarCriterioConsultarPorNomeInicialFinal(query, to);
        this.adicionarCriterioConsultarPorNome(query, to);
        this.adicionarCriterioConsultarPorData(query, to);
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)to);
    }

    @Override
    public PaginadorTO consultarPorIdentificadorTipoNomeDataParaTabela(PessoaTODecorator to) {
        ArrayList<String> wheres = new ArrayList<String>();
        wheres.add("objIdentificacaoTO.textoIdentificacao = ?");
        wheres.add("objPessoaTO.tipoPessoaTO.codigoTipoPessoa = ?");
        wheres.add("objPessoaTO.textoNome >= ?");
        wheres.add("objPessoaTO.textoNome <= ?");
        wheres.add("objPessoaTO.dataUltimaOperacao >= ?");
        wheres.add("objPessoaTO.dataUltimaOperacao <= ?");
        ArrayList<Object> parametros = new ArrayList<Object>();
        parametros.add(to.getCpfCnpj());
        parametros.add(to.getCodigoTipoPessoa());
        parametros.add(to.getNomeInicio());
        parametros.add(to.getNomeFim());
        parametros.add(to.getNomeParte());
        parametros.add(to.getDataInicio());
        parametros.add(to.getDataFim());
        String sql = "select \tobjPessoaTO from \tPessoaTO objPessoaTO \t\tleft outer join objPessoaTO.identificacaoTOs objIdentificacaoTO {where} {orderby}";
        StringBuffer sbWhere = new StringBuffer();
        int indice = 0;
        while (indice < wheres.size()) {
            String where = (String)wheres.get(indice);
            Object parametro = parametros.get(indice);
            if (this.isReferencia(parametro)) {
                if (sbWhere.indexOf(" where") == -1) {
                    sbWhere.append(" where");
                } else {
                    sbWhere.append(" and ");
                }
                sbWhere.append(" ").append(where);
            } else {
                wheres.remove(indice);
                parametros.remove(indice);
                --indice;
            }
            ++indice;
        }
        sql = UtilString.substituirString(sql, "\\{where}", sbWhere.toString());
        sql = this.aplicarOrdenacao(sql, (PluginTODecoratorAbstrato)to);
        Query query = this.novaQuery(sql);
        int indice2 = 0;
        while (indice2 < parametros.size()) {
            query.setParameter(indice2, parametros.get(indice2));
            ++indice2;
        }
        this.aplicarPaginacao(query, (PluginTODecoratorAbstrato)to);
        PaginadorTO p = new PaginadorTO();
        p.setColecaoDeRegistros(query.list());
        return p;
    }

    @Override
    public Collection<PessoaTO> consultarColecaoPorIntervaloNomeData(PessoaTODecorator to) {
        List resultado = this.consultarQuerySimples("select objPessoaTO ", to, true).list();
        return resultado;
    }

    public Collection<ComplementoPessoaFisicaTO> consultarTodosComplementosPF() {
        Criteria query = this.novaCriteria();
        return query.list();
    }

    private Query getHQLPorIntervaloNomeData(String objetoRetorno, PessoaTODecorator to, boolean ordenar) {
        Query query = null;
        if (to.getCodigoTipoPessoa() != null && (to.getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CPF_PF.intValue() || to.getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CNPJ_PJ.intValue())) {
            String sql = String.valueOf(objetoRetorno) + " from " + "\tPessoaTO objPessoaTO " + "\t\tleft outer join objPessoaTO.identificacaoTOs objIdentificacaoTO" + "     where objPessoaTO.tipoPessoaTO.codigoTipoPessoa = ? " + "     and objIdentificacaoTO.id.textoIdentificacao = ?";
            query = this.novaQuery(sql);
            query.setParameter(0, (Object)to.getCodigoTipoPessoa());
            query.setParameter(1, (Object)to.getNumeroInscricao());
        } else if (to.getNomeInicio() != null && to.getNomeFim() != null && (to.getNomeInicio().trim().length() > 0 || to.getNomeFim().trim().length() > 0)) {
            boolean fimMaior = to.getNomeFim().trim().length() > 0 && to.getNomeFim().compareToIgnoreCase(to.getNomeInicio()) >= 0;
            boolean temDataInicial = this.isReferencia(to.getDataInicio());
            boolean temDataFinal = this.isReferencia(to.getDataFim());
            StringBuilder selectDataOperacao = new StringBuilder("");
            selectDataOperacao.append(temDataInicial ? "objPessoaTO.dataUltimaOperacao >= ?" : "");
            selectDataOperacao.append(temDataFinal ? String.valueOf(temDataInicial ? " and " : "") + "objPessoaTO.dataUltimaOperacao <= ?" : "");
            selectDataOperacao.append(temDataInicial || temDataFinal ? " and (" + selectDataOperacao + ")" : "");
            StringBuilder selectOBJ = new StringBuilder();
            selectOBJ.append(String.valueOf(objetoRetorno) + " from " + "\tPessoaTO objPessoaTO " + "\t\tleft outer join objPessoaTO.identificacaoTOs objIdentificacaoTO " + "     where (objIdentificacaoTO.tipoDocumentoTO.codigoTipoDocumento is null " + "     or objIdentificacaoTO.tipoDocumentoTO.codigoTipoDocumento in (1,2) " + "     or objIdentificacaoTO.tipoDocumentoTO.codigoTipoDocumento>30)");
            String orderBy = " order by " + to.getNomeColunaOrdenada() + " " + to.getTipoOrdenacao();
            String sql = String.valueOf(selectOBJ.toString()) + " and objPessoaTO.textoNome >= ?" + (fimMaior ? " and objPessoaTO.textoNome <= ? " : "") + selectDataOperacao.toString() + " " + (ordenar ? orderBy : "");
            query = this.novaQuery(sql);
            int iposic = 0;
            query.setParameter(iposic, (Object)to.getNomeInicio());
            if (fimMaior) {
                query.setParameter(++iposic, (Object)(String.valueOf(to.getNomeFim()) + "ZZZZ"));
            }
            if (temDataInicial) {
                query.setParameter(++iposic, (Object)to.getDataInicio());
            }
            if (temDataFinal) {
                query.setParameter(++iposic, (Object)to.getDataFim());
            }
        } else {
            boolean temDataInicial = this.isReferencia(to.getDataInicio());
            boolean temDataFinal = this.isReferencia(to.getDataFim());
            StringBuilder selectDataOperacao = new StringBuilder();
            selectDataOperacao.append(temDataInicial ? "objPessoaTO.dataUltimaOperacao >= ?" : "");
            selectDataOperacao.append(temDataFinal ? String.valueOf(temDataInicial ? " and " : "") + "objPessoaTO.dataUltimaOperacao <= ?" : "");
            selectDataOperacao.append(temDataInicial || temDataFinal ? " and (" + selectDataOperacao + ")" : "");
            String selectOBJ = String.valueOf(objetoRetorno) + " from " + "\tPessoaTO objPessoaTO " + "\t\tleft outer join objPessoaTO.identificacaoTOs objIdentificacaoTO " + "     where (objIdentificacaoTO.tipoDocumentoTO.codigoTipoDocumento is null " + "     or objIdentificacaoTO.tipoDocumentoTO.codigoTipoDocumento in (1,2) " + "     or objIdentificacaoTO.tipoDocumentoTO.codigoTipoDocumento>30) ";
            String orderBy = to.getNomeColunaOrdenada() == null ? "" : " order by " + to.getNomeColunaOrdenada() + " " + (to.getTipoOrdenacao() == null ? "" : to.getTipoOrdenacao());
            String sql = String.valueOf(selectOBJ) + selectDataOperacao + " " + (ordenar ? orderBy : "");
            query = this.novaQuery(sql);
            int iposic = -1;
            if (temDataInicial) {
                query.setParameter(++iposic, (Object)to.getDataInicio());
            }
            if (temDataFinal) {
                query.setParameter(++iposic, (Object)to.getDataFim());
            }
        }
        return query;
    }

    @Override
    public PaginadorTO consultarPorIntervaloNomeData(PessoaTODecorator to) {
        Query queryList = this.getHQLPorIntervaloNomeData("select distinct objPessoaTO ", to, true);
        Query queryTotal = this.getHQLPorIntervaloNomeData("select count(distinct objPessoaTO) ", to, false);
        PaginadorTO p = this.novoPaginadorTO(queryList, queryTotal, to);
        return p;
    }

    @Override
    public boolean isExisteRegistro(PessoaTO to) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("codigoPessoa", to.getCodigoPessoa()));
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public boolean isPossuiDocumentoPorNome(PessoaTO to) {
        PessoaTODecorator decorator = this.novoPessoaTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorNome(query, decorator);
        this.adicionarCriterioConsultarPossuiDocumento(query, to);
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public Collection<PessoaTO> consultarPorNome(PessoaTODecorator to) {
        Criteria query = this.novaCriteria();
        query.add(this.getCriterioConsultarPorNome(to));
        return query.list();
    }

    private void adicionarCriterioConsultarPorData(Criteria query, PessoaTODecorator to) {
        Date dataFim;
        Date dataInicio = to.getDataInicio();
        if (this.isReferencia(dataInicio, dataFim = to.getDataFim())) {
            query.add(this.getCriterioConsultarPorData(to));
        }
    }

    private void adicionarCriterioConsultarPorNomeInicialFinal(Criteria query, PessoaTODecorator to) {
        String nomeInicio = to.getNomeInicio();
        String nomeFim = to.getNomeFim();
        if (!this.isVazio(nomeInicio) || !this.isVazio(nomeFim)) {
            query.add(this.getCriterioConsultarPorNomeInicialFinal(to));
        }
    }

    private void adicionarCriterioConsultarPorNome(Criteria query, PessoaTODecorator to) {
        String nome = to.getTextoNome();
        if (!this.isVazio(nome)) {
            query.add(this.novoCriterioLikeDireita("textoNome", nome));
        }
    }

    private void adicionarCriterioConsultarPorCodigoGrupoClienteRecebimento(Criteria query, PessoaTODecorator to) {
        Integer codigo = to.getCodigoGrupoClienteRecebimento();
        if (!this.isZero(codigo)) {
            UtilRestricaoDAO.adicionaRestricaoPessoaPertenceAoGrupoClienteDebito(codigo, query);
        }
    }

    private void adicionarCriterioConsultarPossuiDocumento(Criteria query, PessoaTO to) {
        Criteria tipo = query.createCriteria("tipoPessoaTO");
        tipo.add(Restrictions.isNotEmpty((String)"tipoDocumentoTOs"));
    }

    private void adicionarCriterioConsultarPorTipo(Criteria query, PessoaTODecorator to) {
        Integer tipo = to.getCodigoTipoPessoa();
        if (!this.isZero(tipo)) {
            query.add(this.getCriterioConsultarPorTipo(to));
        }
    }

    private void adicionarCriterioConsultarPorCPFouCNPJ(Criteria query, PessoaTODecorator to) {
        String inscricao = to.getNumeroInscricao();
        if (!this.isVazio(UtilString.removerCaracteres(inscricao))) {
            Criteria identificacao = query.createCriteria("identificacaoTOs");
            identificacao.add(this.getCriterioConsultarPorCPFouCNPJ(to));
        }
    }

    private Criterion getCriterioConsultarPorCPFouCNPJ(PessoaTODecorator to) {
        String inscricao = to.getNumeroInscricao();
        return this.novoCriterioEQ("textoIdentificacao", inscricao);
    }

    private Criterion getCriterioConsultarPorNomeInicialFinal(PessoaTODecorator to) {
        String nomeInicio = to.getNomeInicio();
        String nomeFim = to.getNomeFim();
        return this.novoCriterioBetween("textoNome", nomeInicio, nomeFim);
    }

    private Criterion getCriterioConsultarPorNome(PessoaTODecorator to) {
        String nome = to.getNome();
        return this.novoCriterioLikeDireita("textoNome", nome);
    }

    private Criterion getCriterioConsultarPorData(PessoaTODecorator to) {
        Date dataInicio = to.getDataInicio();
        Date dataFim = to.getDataFim();
        return this.novoCriterioBetween("dataUltimaOperacao", dataInicio, dataFim);
    }

    private Criterion getCriterioConsultarPorTipo(PessoaTODecorator to) {
        Integer tipo = to.getCodigoTipoPessoa();
        return this.novoCriterioEQ("tipoPessoaTO.codigoTipoPessoa", tipo);
    }

    @Override
    protected Integer getChavePrimaria(PessoaTO to) {
        return to.getCodigoPessoa();
    }

    @Override
    protected Class<PessoaTO> novoTipoDeObjetoPersistente() {
        return PessoaTO.class;
    }

    private String getSQLConsultarPorDataEDebito() {
        return "select objPessoaTO from PessoaTO objPessoaTO where       objPessoaTO.codigoPessoa not in (        select convenentePessoaTO.pessoaTO.codigoPessoa \t\t     from ConvenentePessoaTO convenentePessoaTO)      and objPessoaTO.codigoPessoa not in (        select convenenteTO.codigoPessoaConvenente from ConvenenteTO convenenteTO)     and objPessoaTO.dataUltimaOperacao < :data";
    }

    private String getSQLConsultarPorServicoDataEDebito() {
        return "select objPessoaTO from PessoaTO objPessoaTO where       objPessoaTO.codigoPessoa not in (        select convenentePessoaTO.pessoaTO.codigoPessoa \t\t     from ConvenentePessoaTO convenentePessoaTO)      and objPessoaTO.codigoPessoa not in (        select convenenteTO.codigoPessoaConvenente from ConvenenteTO convenenteTO)     and objPessoaTO.dataUltimaOperacao < :data";
    }

    @Override
    public PessoaTO consultarPorIndentificacao(IdentificacaoTO identificacaoTO) {
        Query query = this.novaQuery(this.getSQLConsultarPorIndentificacao());
        if (identificacaoTO.getIdentificadorTO() != null) {
            query.setString("nomeIdentificador", identificacaoTO.getIdentificadorTO().getNomeIdentificador());
        } else {
            query.setString("textoIdentificador", ((IdentificadorTO)identificacaoTO.getTipoDocumentoTO().getIdentificadorTOs().toArray()[0]).getId().getTextoIdentificador());
        }
        query.setString("textoIdentificacao", UtilString.removerCaracteres(identificacaoTO.getTextoIdentificacao()));
        int codPessoa = identificacaoTO != null && identificacaoTO.getPessoaTO() != null && identificacaoTO.getPessoaTO().getCodigoPessoa() != null ? identificacaoTO.getPessoaTO().getCodigoPessoa() : 0;
        query.setInteger("codigoPessoa", codPessoa);
        return (PessoaTO)query.uniqueResult();
    }

    @Override
    public PessoaTO consultarPorTextoIndentificacao(IdentificacaoTO identificacaoTO) {
        Query query = this.novaQuery("select objIdentificacaoTO.pessoaTO from PessoaTO objPessoaTO \tinner join objPessoaTO.identificacaoTOs objIdentificacaoTO where objIdentificacaoTO.id.textoIdentificador = :textoIdentificador \tand  objIdentificacaoTO.id.textoIdentificacao= :textoIdentificacao ");
        if (identificacaoTO.getIdentificadorTO() != null) {
            query.setString("textoIdentificador", identificacaoTO.getIdentificadorTO().getId().getTextoIdentificador());
        } else {
            query.setString("textoIdentificador", ((IdentificadorTO)identificacaoTO.getTipoDocumentoTO().getIdentificadorTOs().toArray()[0]).getId().getTextoIdentificador());
        }
        query.setString("textoIdentificacao", identificacaoTO.getTextoIdentificacao());
        return (PessoaTO)query.uniqueResult();
    }

    @Override
    public IdentificacaoTO consultarIdPessoaTOCodigo(int codigoPessoa) {
        Query query = this.novaQuery("select objIdentificacaoTO from IdentificacaoTO objIdentificacaoTO where objIdentificacaoTO.pessoaTO.codigoPessoa = " + codigoPessoa);
        return (IdentificacaoTO)query.uniqueResult();
    }

    @Override
    public PessoaTO consultarPessoaTOCodigo(int codigoPessoa) {
        Query query = this.novaQuery("select objPessoaTO from PessoaTO objPessoaTO where objPessoaTO.codigoPessoa = " + codigoPessoa);
        return (PessoaTO)query.uniqueResult();
    }

    private String getSQLConsultarPorIndentificacao() {
        return "select objIdentificacaoTO.pessoaTO from PessoaTO objPessoaTO \tinner join objPessoaTO.identificacaoTOs objIdentificacaoTO where objIdentificacaoTO.identificadorTO.nomeIdentificador = :nomeIdentificador \tand  objIdentificacaoTO.id.textoIdentificacao= :textoIdentificacao \tand objPessoaTO.codigoPessoa <> :codigoPessoa";
    }

    @Override
    public Collection<PessoaTO> consultarOrdenadoPorNome() {
        Criteria query = this.novaCriteria();
        this.aplicarOrdenacao(query, this.novaOrdenacaoASC("textoNome"));
        return query.list();
    }

    private void adicionarCriterioConsultarPelaAgencia(Criteria query, PessoaTODecorator decorator) {
        Integer codigo = decorator.getCodigoAgencia();
        if (!this.isZero(codigo)) {
            Criteria cc = this.getCriteria(query, "contaCorrenteClienteTOs");
            Criteria instituicao = this.getCriteria(cc, "agenciaInstituicaoFinanceiraTO");
            instituicao.add(this.novoCriterioEQ("id.codigoAgencia", codigo));
        }
    }

    private void adicionarCriterioConsultarPelaInstituicaoFinanceira(Criteria query, PessoaTODecorator decorator) {
        Integer codigo = decorator.getCodigoInstituicaoFinanceira();
        if (!this.isZero(codigo)) {
            Criteria cc = this.getCriteria(query, "contaCorrenteClienteTOs");
            Criteria instituicao = this.getCriteria(cc, "agenciaInstituicaoFinanceiraTO");
            instituicao.add(this.novoCriterioEQ("id.codigoInstituicaoFinanceira", codigo));
        }
    }

    private void adicionarCriterioConsultarPeloNumeroDoConvenio(Criteria query, PessoaTODecorator decorator) {
        Integer codigo = decorator.getNumeroConvenio();
        if (!this.isZero(codigo)) {
            Criteria cc = this.getCriteria(query, "contaCorrenteClienteTOs");
            Criteria convenio = this.getCriteria(cc, "convenioTOs");
            convenio.add(this.novoCriterioEQ("numeroConvenio", codigo));
        }
    }

    private void adicionarCriterioConsultarPelaDataDaRemessa(Criteria query, PessoaTODecorator decorator) {
        Date data = decorator.getDataRemessa();
        if (this.isReferencia(data)) {
            Criteria cc = this.getCriteria(query, "contaCorrenteClienteTOs");
            Criteria convenio = this.getCriteria(cc, "convenioTOs");
            Criteria remessa = this.getCriteria(convenio, "remessaTOs");
            remessa.add(this.novoCriterioEQ("dataRemessa", data));
        }
    }

    private void adicionarCriterioConsultarPorContaCorrente(Criteria query, PessoaTODecorator decorator) {
        Long codigo = decorator.getCodigoContaCorrente();
        if (codigo != null && codigo != 0L) {
            Criteria cc = this.getCriteria(query, "contaCorrenteClienteTOs");
            cc.add(this.novoCriterioEQ("codigoContaCorrente", codigo));
        }
    }

    private void adicionarCriterioConsultarPorTextoDaIdentificacao(Criteria query, PessoaTODecorator decorator) {
        String texto = decorator.getTextoIdentificacao();
        if (!this.isVazio(texto)) {
            Criteria idfc = this.getCriteria(query, "identificacaoTOs");
            idfc.add(this.novoCriterioEQ("textoIdentificacao", texto));
        }
    }

    private void adicionarCriterioConsultarPorTipoDeDocumento(Criteria query, PessoaTODecorator decorator) {
        Integer codigo = decorator.getCodigoTipoDocumento();
        if (!this.isZero(codigo)) {
            Criteria tipo = this.getCriteria(query, "tipoPessoaTO");
            Criteria doc = this.getCriteria(tipo, "tipoDocumentoTOs");
            doc.add(this.novoCriterioEQ("codigoTipoDocumento", codigo));
        }
    }

    private PessoaTODecorator novoPessoaTODecorator(PessoaTO to) {
        return this.getTOFactory().novoPessoaTODecorator(to);
    }

    @Override
    public PessoaTO incluir(PessoaTO pessoa) {
        return super.incluir(pessoa);
    }

    @Override
    public Integer consultarCodigoPessoaMaior500() {
        Criteria criteria = this.novaCriteria();
        criteria.setProjection((Projection)Projections.max((String)"codigoPessoa"));
        List colecao = criteria.list();
        Integer codigoPessoa = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
        codigoPessoa = codigoPessoa + 1;
        if (codigoPessoa <= 500) {
            codigoPessoa = 501;
        }
        return codigoPessoa;
    }

    @Override
    public PaginadorTO consultarPaginadorSimples(PessoaTODecorator to) {
        Query queryList = this.consultarQuerySimples(this.getSQLObjetoPessoaTO2(), to, true);
        Query queryTotal = this.consultarQuerySimples("select count(distinct objPessoaTO) ", to, false);
        PaginadorTO p = this.novoPaginadorTO(queryList, queryTotal, to);
        return p;
    }

    @Override
    public Collection<PessoaTO2> consultarSimples(PessoaTODecorator to) {
        return this.consultarQuerySimples(this.getSQLObjetoPessoaTO2(), to, false).list();
    }

    private String getSQLObjetoPessoaTO2() {
        return "select new br.com.bb.plugins.gac.negocio.to.PessoaTO2(objPessoaTO.codigoPessoa,      objPessoaTO.textoNome,       (select max(objIdentificacaoTO.textoIdentificacao)          from objPessoaTO.identificacaoTOs objIdentificacaoTO          where objIdentificacaoTO.pessoaTO.codigoPessoa=objPessoaTO.codigoPessoa                and objIdentificacaoTO.id.codigoTipoDocumento in (1,2)) as col_2_0_, " + this.montaHQLIdentificadorProprioConvenenteServico() + " as col_3_0_) ";
    }

    private String montaHQLIdentificadorProprioConvenenteServico() {
        int codigoTipoDocumento = UtilIdentificadorProprio.getInstancia().getCodigoTipoDocumento();
        String textoIdentificador = UtilIdentificadorProprio.getInstancia().getTextoIdentificador();
        return UtilIdentificadorProprio.getInstancia().existeIdenfificador() ? "     (select objIdentificacaoTO.textoIdentificacao          from objPessoaTO.identificacaoTOs objIdentificacaoTO          where objIdentificacaoTO.pessoaTO.codigoPessoa=objPessoaTO.codigoPessoa                and ( objIdentificacaoTO.id.codigoTipoDocumento = " + codigoTipoDocumento + " " + "               and objIdentificacaoTO.id.textoIdentificador = " + textoIdentificador + " ) " + "  )" : "''";
    }

    private Query consultarQuerySimples(String objetoRetorno, PessoaTODecorator to, boolean ordenar) {
        int opcao = 0;
        String parametro = to.getNomeParte();
        boolean fimMaior = false;
        boolean temDataInicial = this.isReferencia(to.getDataInicio());
        boolean temDataFinal = this.isReferencia(to.getDataFim());
        StringBuilder hql = new StringBuilder("");
        hql.append(String.valueOf(objetoRetorno) + "     from PessoaTO objPessoaTO where objPessoaTO.codigoPessoa>0 and objPessoaTO.codigoPessoa != 400 ");
        if (to.getCodigoTipoPessoa() != null && (to.getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CPF_PF.intValue() || to.getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CNPJ_PJ.intValue())) {
            hql.append("        and (select objIdentificacaoTO.textoIdentificacao          from objPessoaTO.identificacaoTOs objIdentificacaoTO          where objIdentificacaoTO.pessoaTO.codigoPessoa=objPessoaTO.codigoPessoa                and objIdentificacaoTO.id.codigoTipoDocumento = ?) = ?");
            opcao = 1;
        } else if (to.getNomeInicio() != null && to.getNomeFim() != null && (to.getNomeInicio().trim().length() > 0 || to.getNomeFim().trim().length() > 0)) {
            fimMaior = to.getNomeFim().trim().length() > 0 && to.getNomeFim().compareToIgnoreCase(to.getNomeInicio()) >= 0;
            hql.append(" and objPessoaTO.textoNome >= ?" + (fimMaior ? " and objPessoaTO.textoNome <= ? " : ""));
            hql.append(temDataInicial ? " and objPessoaTO.dataUltimaOperacao >= ?" : "");
            hql.append(temDataFinal ? " and objPessoaTO.dataUltimaOperacao <= ?" : "");
            opcao = 2;
        } else if (to.getNomeInicio() != null && to.getNomeFim() != null && to.getNomeInicio().equals("") && to.getNomeFim().equals("") && !to.getNomeParte().equals("")) {
            hql.append(" and objPessoaTO.textoNome like '%" + parametro + "%'");
            hql.append(temDataInicial ? " and objPessoaTO.dataUltimaOperacao >= ?" : "");
            hql.append(temDataFinal ? " and objPessoaTO.dataUltimaOperacao <= ?" : "");
            opcao = 3;
        } else {
            hql.append(temDataInicial ? " and objPessoaTO.dataUltimaOperacao >= ?" : "");
            hql.append(temDataFinal ? " and objPessoaTO.dataUltimaOperacao <= ?" : "");
            opcao = 4;
        }
        String orderBy = to.getNomeColunaOrdenada() == null ? "" : " order by " + to.getNomeColunaOrdenada() + " " + (to.getTipoOrdenacao() == null ? "" : to.getTipoOrdenacao());
        hql.append(" " + (ordenar ? orderBy : ""));
        Query queryList = this.novaQuery(hql.toString());
        int iposic = -1;
        switch (opcao) {
            case 1: {
                queryList.setParameter(0, (Object)to.getCodigoTipoPessoa());
                queryList.setParameter(1, (Object)to.getNumeroInscricao());
                break;
            }
            case 2: {
                queryList.setParameter(++iposic, (Object)to.getNomeInicio());
                if (fimMaior) {
                    queryList.setParameter(++iposic, (Object)(String.valueOf(to.getNomeFim()) + "Z"));
                }
                if (temDataInicial) {
                    queryList.setParameter(++iposic, (Object)to.getDataInicio());
                }
                if (!temDataFinal) break;
                queryList.setParameter(++iposic, (Object)to.getDataFim());
                break;
            }
            case 3: {
                if (temDataInicial) {
                    queryList.setParameter(++iposic, (Object)to.getDataInicio());
                }
                if (!temDataFinal) break;
                queryList.setParameter(++iposic, (Object)to.getDataFim());
                break;
            }
            case 4: {
                if (temDataInicial) {
                    queryList.setParameter(++iposic, (Object)to.getDataInicio());
                }
                if (!temDataFinal) break;
                queryList.setParameter(++iposic, (Object)to.getDataFim());
            }
        }
        return queryList;
    }

    @Override
    public Collection<PessoaTO2> consultarClientes(ConvenentePessoaTODecorator to) {
        return UtilRestricaoDAO.adicionaFiltroConvenentePessoa(to, to.isOrdenar(), new StringBuilder(String.valueOf(this.getSQLObjetoPessoaTO2()) + "from PessoaTO objPessoaTO where objPessoaTO.codigoPessoa in"), this).list();
    }

    @Override
    public Collection<PessoaTO> consultarClientesPessoaTO(ConvenentePessoaTODecorator to) {
        return UtilRestricaoDAO.adicionaFiltroConvenentePessoa(to, true, new StringBuilder("select objPessoaTO from PessoaTO objPessoaTO where objPessoaTO.codigoPessoa in "), this).list();
    }

    @Override
    public PaginadorTO consultarClientesPaginador(ConvenentePessoaTODecorator to) {
        Query queryList = UtilRestricaoDAO.adicionaFiltroConvenentePessoa(to, true, new StringBuilder(String.valueOf(this.getSQLObjetoPessoaTO2()) + " from PessoaTO objPessoaTO where objPessoaTO.codigoPessoa in"), this);
        Query queryTotal = UtilRestricaoDAO.adicionaFiltroConvenentePessoa(to, false, new StringBuilder("select count(distinct objPessoaTO) from PessoaTO objPessoaTO where objPessoaTO.codigoPessoa in "), this);
        PaginadorTO p = this.novoPaginadorTO(queryList, queryTotal, to);
        return p;
    }

    @Override
    public Collection<PessoaTO> consultar() {
        Criteria query = this.novaCriteria();
        this.aplicarOrdenacao(query, this.novaOrdenacaoASC("textoNome"));
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPor(PessoaTODecorator pessoaTODecorator) {
        StringBuffer sb = new StringBuffer();
        sb.append("select objPessoaTO ");
        sb.append(" from ");
        sb.append(" PessoaTO objPessoaTO ");
        sb.append(" where ");
        sb.append(" objPessoaTO.codigoPessoa>0 and objPessoaTO.codigoPessoa != 400 ");
        if (pessoaTODecorator.getCodigoTipoPessoa() != null && pessoaTODecorator.getCodigoTipoPessoa() > 0) {
            sb.append(" and objPessoaTO.tipoPessoaTO.codigoTipoPessoa = ? ");
        }
        Query query = this.novaQuery(sb.toString());
        if (pessoaTODecorator.getCodigoTipoPessoa() != null && pessoaTODecorator.getCodigoTipoPessoa() > 0) {
            query.setParameter(0, (Object)pessoaTODecorator.getCodigoTipoPessoa());
        }
        sb.append(" order by objPessoaTO.textoNome ");
        return query.list();
    }

    @Override
    public Collection<PessoaTO> consultarPor(List<Integer> listaCodigoPessoa) {
        String listaTemp = listaCodigoPessoa.toString();
        listaTemp = listaTemp.replace('[', ' ').replace(']', ' ');
        StringBuffer sb = new StringBuffer();
        sb.append("select objPessoaTO ");
        sb.append(" from ");
        sb.append(" PessoaTO objPessoaTO ");
        sb.append(" where ");
        sb.append(" objPessoaTO.codigoPessoa>0 and objPessoaTO.codigoPessoa != 400 ");
        sb.append(" and objPessoaTO.codigoPessoa in (:pListaCodigoPessoa)");
        sb.append(" order by objPessoaTO.textoNome ");
        Query query = this.novaQuery(sb.toString());
        query.setParameterList("pListaCodigoPessoa", listaCodigoPessoa);
        return query.list();
    }

    @Override
    public Integer proximoCodigoPessoa() {
        Criteria criteria = this.getSession().createCriteria(PessoaTO.class);
        criteria.setProjection((Projection)Projections.max((String)"codigoPessoa"));
        if (!criteria.list().isEmpty() && (Integer)criteria.uniqueResult() < 500) {
            return 501;
        }
        return (Integer)criteria.uniqueResult() + 1;
    }

    @Override
    public PessoaTO consultar(int codigoPessoa) {
        Criteria criteria = this.getSession().createCriteria(PessoaTO.class);
        criteria.add((Criterion)Restrictions.eq((String)"codigoPessoa", (Object)codigoPessoa));
        return (PessoaTO)criteria.uniqueResult();
    }
}

