/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.ContatoDAO;
import br.com.bb.plugins.gac.integracao.dao.ContatoDAOImpl;
import br.com.bb.plugins.gac.integracao.dao.DAOTestAbstrato;
import br.com.bb.plugins.gac.integracao.dao.LogradouroDAO;
import br.com.bb.plugins.gac.integracao.dao.LogradouroDAOImpl;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAOImpl;
import br.com.bb.plugins.gac.integracao.dao.TipoContatoDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoContatoDAOImpl;
import br.com.bb.plugins.gac.integracao.dao.TipoDocumentoDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoDocumentoDAOImpl;
import br.com.bb.plugins.gac.integracao.dao.TipoPessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoPessoaDAOImpl;
import br.com.bb.plugins.gac.negocio.to.ContatoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.TipoContatoTO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoLogradouroTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.UnidadeFederativaBrasilTO;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.politec.generico.fabrica.DataFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class PessoaDAOTest
extends DAOTestAbstrato {
    private static int codigoPessoa;

    public void _testConsultar_Decorator() {
        PessoaTODecorator decorator = new PessoaTODecorator();
        decorator.setPaginaAtual(2);
        PessoaDAO dao = this.novaPessoaDAO();
        PaginadorTO paginador = dao.consultar(decorator);
        Collection colecao = paginador.getColecaoDeRegistros();
        System.out.println("Total: " + paginador.getTotalDeRegistros());
        for (PessoaTO pessoaTO : colecao) {
            System.out.println(pessoaTO.getTextoNome());
        }
        PessoaDAOTest.assertNotNull((Object)colecao);
        PessoaDAOTest.assertEquals((boolean)true, (colecao.size() > 0 ? 1 : 0) != 0);
    }

    public void _testConsultarPorDataEDebito() {
        PessoaTO to = new PessoaTO();
        to.setDataUltimaOperacao(this.getDataFactory().novoDate(29, 1, 2008));
        Collection<PessoaTO> c = this.novaPessoaDAO().consultarPorDataEDebito(to);
        for (PessoaTO p : c) {
            System.out.println(p.getCodigoPessoa() + " - " + p.getTextoNome() + "\t" + p.getDataUltimaOperacao());
        }
    }

    public void _testGetQuantidadePorDataEDebito() {
        PessoaTO to = new PessoaTO();
        to.setDataUltimaOperacao(this.getDataFactory().novoDate(29, 1, 2008));
        Integer i = this.novaPessoaDAO().getQuantidadePorDataEDebito(to);
        System.out.println(i);
    }

    public void _testConsultarPorNome_PessoaTODecorator() {
        PessoaTODecorator to = new PessoaTODecorator();
        to.setNome("bel");
        PessoaDAO dao = this.novaPessoaDAO();
        Collection<PessoaTO> c = dao.consultarPorNome(to);
        for (PessoaTO t : c) {
            System.out.println(t.getTextoNome());
        }
    }

    public void _testGetIsExisteRegistro() {
        PessoaTO to = new PessoaTO();
        to.setCodigoPessoa(1);
        PessoaDAO dao = this.novaPessoaDAO();
        System.out.println(dao.isExisteRegistro(to));
    }

    public void _testIncluir() {
        PessoaTO pessoa = new PessoaTO();
        pessoa.setTipoPessoaTO(this.novoTipoPessoaTO(1));
        pessoa.setTextoNome("Adriano");
        pessoa.setTextoObservacao("Observa\u00e7\u00e3o");
        pessoa.setDataUltimaOperacao(this.getDataFactory().novoDate());
        this.atribuiContato(pessoa);
        this.atribuiIdentificacao(pessoa);
        this.atribuiLogradouro(pessoa);
        PessoaDAO dao = this.novaPessoaDAO();
        dao.incluir(pessoa);
        PessoaDAOTest.assertNotNull((Object)pessoa);
        PessoaDAOTest.assertNotNull((Object)pessoa.getCodigoPessoa());
        this.setCodigoPessoa(pessoa.getCodigoPessoa());
    }

    private void atribuiContato(PessoaTO pessoa) {
        TipoContatoDAO tipoContatoDAO = this.novaTipoContatoDAO();
        Collection tipoContatoTOs = tipoContatoDAO.consultar();
        TipoContatoTO tipo = null;
        Iterator iterator = tipoContatoTOs.iterator();
        while (iterator.hasNext()) {
            TipoContatoTO tipoContatoTO;
            tipo = tipoContatoTO = (TipoContatoTO)iterator.next();
        }
        ContatoTO contatoTO = new ContatoTO();
        contatoTO.setPessoaTO(pessoa);
        contatoTO.setTextoContato("dsadjasdja");
        contatoTO.setTipoContatoTO(tipo);
        pessoa.setContatoTOs(new LinkedHashSet<ContatoTO>());
        pessoa.getContatoTOs().add(contatoTO);
    }

    private void atribuiIdentificacao(PessoaTO pessoa) {
        TipoDocumentoDAO tipoDocumentoDAO = this.novaTipoDocumentoDAO();
        Collection tipoDocumentoTOs = tipoDocumentoDAO.consultar();
        TipoDocumentoTO tipoDoc = null;
        Iterator iterator = tipoDocumentoTOs.iterator();
        while (iterator.hasNext()) {
            TipoDocumentoTO tipoDocumentoTO;
            tipoDoc = tipoDocumentoTO = (TipoDocumentoTO)iterator.next();
        }
        IdentificacaoTO identificacaoTO = new IdentificacaoTO();
        identificacaoTO.setPessoaTO(pessoa);
        identificacaoTO.setTextoComplemento("dasdasdasd");
        identificacaoTO.setTipoDocumentoTO(tipoDoc);
        identificacaoTO.setIdentificadorTO(new IdentificadorTO());
        pessoa.setIdentificacaoTOs(new LinkedHashSet<IdentificacaoTO>());
        pessoa.getIdentificacaoTOs().add(identificacaoTO);
    }

    private void atribuiLogradouro(PessoaTO pessoa) {
        LogradouroTO logradouroTO = new LogradouroTO();
        logradouroTO.setTextoBairro("bairro");
        logradouroTO.setTextoCep("2");
        logradouroTO.setTextoCidade("cidade");
        logradouroTO.setTextoLogradouro("logradouro");
        logradouroTO.setTipoLogradouroTO(new TipoLogradouroTO());
        logradouroTO.getTipoLogradouroTO().setCodigoTipoLogradouro(1);
        logradouroTO.setIndicadorLogradouroParaCorrespondencia(Character.valueOf('S'));
        logradouroTO.setUnidadeFederativaBrasilTO(new UnidadeFederativaBrasilTO());
        logradouroTO.getUnidadeFederativaBrasilTO().setCodigoUnidadeFederativaTributosEstaduais(1);
        logradouroTO.setPessoaTO(pessoa);
        pessoa.setLogradouroTOs(new LinkedHashSet<LogradouroTO>());
        pessoa.getLogradouroTOs().add(logradouroTO);
    }

    public void _testAlterar() {
        PessoaDAO dao = this.novaPessoaDAO();
        PessoaTO to = new PessoaTO();
        to.setCodigoPessoa(this.getCodigoPessoa());
        String nome = "Novo Nome";
        PessoaTO pessoa = dao.listar(to);
        String nomeAntigo = pessoa.getTextoNome();
        pessoa.setTextoNome("Novo Nome");
        dao.alterar(pessoa);
        PessoaDAOTest.assertNotNull((Object)pessoa);
        PessoaDAOTest.assertEquals((String)nome, (String)pessoa.getTextoNome());
        pessoa.setTextoNome(nomeAntigo);
        dao.alterar(pessoa);
    }

    public void _testConsultar() {
        PessoaDAO dao = this.novaPessoaDAO();
        Collection colecao = dao.consultar();
        for (PessoaTO pessoaTO : colecao) {
            System.out.println(pessoaTO.getTextoNome());
        }
        PessoaDAOTest.assertNotNull(colecao);
        PessoaDAOTest.assertEquals((boolean)true, (colecao.size() > 0 ? 1 : 0) != 0);
    }

    public void _testConsultarPessoaTODecorator() {
        PessoaTODecorator to = new PessoaTODecorator();
        to.setCodigoTipoPessoa(1);
        PessoaDAO dao = this.novaPessoaDAO();
        PaginadorTO paginador = dao.consultarPorIdentificadorTipoNomeData(to);
        Collection colecao = paginador.getColecaoDeRegistros();
        Integer total = paginador.getTotalDeRegistros();
        System.out.println("Total: " + total);
        for (PessoaTO t : colecao) {
            System.out.println(t.getCodigoPessoa() + " - " + t.getTextoNome());
        }
    }

    public void _testConsultarPessoa_TODecoratorSQL() {
        DataFactory df = DataFactory.getInstance();
        PessoaTODecorator to = new PessoaTODecorator();
        to.setCodigoTipoPessoa(1);
        to.setNomeInicio("Adriano");
        to.setNomeFim("Andre");
        to.setPaginaAtual(1);
        to.setTipoOrdenacao("ASC");
        to.setNomeColunaOrdenada("objIdentificacaoTO.textoComplemento");
        PessoaDAO dao = this.novaPessoaDAO();
        PaginadorTO paginador = dao.consultarPorIdentificadorTipoNomeDataParaTabela(to);
        Collection colecao = paginador.getColecaoDeRegistros();
        Integer total = paginador.getTotalDeRegistros();
        System.out.println("Total: " + total);
        for (PessoaTO t : colecao) {
            PessoaTODecorator decorator = new PessoaTODecorator();
            decorator.setPessoaTO(t);
            System.out.println(decorator.getCodigoPessoa() + " - " + decorator.getTextoNome() + "(" + decorator.getNumeroInscricao() + ")");
        }
    }

    public void _testConsultarPorTipo() {
        PessoaTODecorator to = new PessoaTODecorator();
        to.setCodigoTipoPessoa(this.novoInteger(1));
        PessoaDAO dao = this.novaPessoaDAO();
        Collection<PessoaTO> colecao = dao.consultarPorTipo(to);
        PessoaDAOTest.assertNotNull(colecao);
        PessoaDAOTest.assertEquals((boolean)true, (colecao.size() > 0 ? 1 : 0) != 0);
    }

    public void _testConsultarPorNome() {
        PessoaTODecorator to = new PessoaTODecorator();
        to.setNomeInicio("Beltrano");
        to.setNomeFim("Cacilda");
        PessoaDAO dao = this.novaPessoaDAO();
        Collection<PessoaTO> colecao = dao.consultarPorNomeInicialFinal(to);
        PessoaDAOTest.assertNotNull(colecao);
        PessoaDAOTest.assertEquals((boolean)true, (colecao.size() > 0 ? 1 : 0) != 0);
    }

    public void _testConsultarPorData() {
        DataFactory df = DataFactory.getInstance();
        PessoaTODecorator to = new PessoaTODecorator();
        to.setDataInicio(df.novoDate(1, 2, 2008));
        to.setDataFim(df.novoDate(29, 2, 2008));
        PessoaDAO dao = this.novaPessoaDAO();
        Collection<PessoaTO> colecao = dao.consultarPorData(to);
        PessoaDAOTest.assertNotNull(colecao);
        PessoaDAOTest.assertEquals((boolean)true, (colecao.size() > 0 ? 1 : 0) != 0);
    }

    public void _testExcluir() {
        PessoaTO to = new PessoaTO();
        to.setCodigoPessoa(501);
        PessoaDAO dao = this.novaPessoaDAO();
        dao.excluir(to);
    }

    protected TipoPessoaTO novoTipoPessoaTO(int tipo) {
        TipoPessoaTO to = new TipoPessoaTO();
        to.setCodigoTipoPessoa(tipo);
        return to;
    }

    protected TipoPessoaDAO novaTipoPessoaDAO() {
        return (TipoPessoaDAO)this.novaDAO(TipoPessoaDAOImpl.class);
    }

    protected PessoaDAO novaPessoaDAO() {
        return (PessoaDAO)this.novaDAO(PessoaDAOImpl.class);
    }

    private int getCodigoPessoa() {
        return codigoPessoa;
    }

    private void setCodigoPessoa(int codigoPessoa) {
        PessoaDAOTest.codigoPessoa = codigoPessoa;
    }

    protected TipoDocumentoDAO novaTipoDocumentoDAO() {
        return (TipoDocumentoDAO)this.novaDAO(TipoDocumentoDAOImpl.class);
    }

    protected ContatoDAO novaContatoDAO() {
        return (ContatoDAO)this.novaDAO(ContatoDAOImpl.class);
    }

    protected TipoContatoDAO novaTipoContatoDAO() {
        return (TipoContatoDAO)this.novaDAO(TipoContatoDAOImpl.class);
    }

    protected LogradouroDAO novaLogradouroDAO() {
        return (LogradouroDAO)this.novaDAO(LogradouroDAOImpl.class);
    }
}

