/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoDocumentoDAO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TipoDocumentoDAOImpl
extends HibernateDAO<TipoDocumentoTO, Integer>
implements TipoDocumentoDAO {
    @Override
    public Collection<TipoDocumentoTO> consultarPorPessoaFisica() {
        return this.consultarPorTipo(this.getTOFactory().novoTipoPessoaFisica());
    }

    @Override
    public Collection<TipoDocumentoTO> consultarPorPessoaJuridica() {
        return this.consultarPorTipo(this.getTOFactory().novoTipoPessoaJuridica());
    }

    @Override
    public Collection<TipoDocumentoTO> consultarPorTipo(TipoPessoaTO to) {
        Criteria query = this.novaCriteria();
        query.add(this.getCriterioConsultarPorTipo(to));
        return query.list();
    }

    @Override
    public Collection<TipoDocumentoTO> consultarPorTextoDescricao(TipoDocumentoTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorDescricao(query, to);
        return query.list();
    }

    @Override
    protected Class<TipoDocumentoTO> novoTipoDeObjetoPersistente() {
        return TipoDocumentoTO.class;
    }

    @Override
    protected Integer getChavePrimaria(TipoDocumentoTO to) {
        return to.getCodigoTipoDocumento();
    }

    private Criterion getCriterioConsultarPorTipo(TipoPessoaTO to) {
        Integer tipo = to.getCodigoTipoPessoa();
        return this.novoCriterioEQ("tipoPessoaTO.codigoTipoPessoa", tipo);
    }

    private void adicionarCriterioConsultarPorDescricao(Criteria query, TipoDocumentoTO to) {
        String descricao = to.getTextoDescricao();
        if (!this.isVazio(descricao)) {
            query.add(this.novoCriterioLike("textoDescricao", descricao));
        }
    }
}

