/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.TransacaoDAO;
import br.com.bb.plugins.gac.negocio.to.TransacaoTO;
import br.com.bb.plugins.gac.negocio.to.TransacaoTOId;
import br.com.bb.plugins.gac.negocio.to.decorator.TransacaoTODecorator;
import br.com.politec.generico.calculadores.UtilSomadoresDeNumero;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransacaoDAOImpl
extends HibernateDAO<TransacaoTO, TransacaoTOId>
implements TransacaoDAO {
    @Override
    protected TransacaoTOId getChavePrimaria(TransacaoTO to) {
        return to.getId();
    }

    @Override
    protected Class<TransacaoTO> novoTipoDeObjetoPersistente() {
        return TransacaoTO.class;
    }

    @Override
    public Collection<TransacaoTO> consultarPeloServicoEMenu(TransacaoTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioPorServico(query, to);
        this.adicionarCriterioPorOpcaoDeMenu(query, to);
        return query.list();
    }

    private void adicionarCriterioPorServico(Criteria query, TransacaoTO to) {
        TransacaoTODecorator decorator = this.novoTransacaoTODecorator(to);
        String servico = decorator.getTextoIdentificadorServico();
        query.add(this.novoCriterioEQ("id.textoIdentificadorServico", servico));
    }

    private void adicionarCriterioPorOpcaoDeMenu(Criteria query, TransacaoTO to) {
        TransacaoTODecorator decorator = this.novoTransacaoTODecorator(to);
        String menu = decorator.getTextoCodigoOpcaoMenu();
        query.add(this.novoCriterioEQ("id.textoCodigoOpcaoMenu", menu));
    }

    private TransacaoTODecorator novoTransacaoTODecorator(TransacaoTO to) {
        return this.getTOFactory().novoTransacaoTODecorator(to);
    }

    @Override
    protected void incrementarChaveComposta(TransacaoTOId chave) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.textoIdentificadorServico", chave.getTextoIdentificadorServico()));
        query.add(this.novoCriterioEQ("id.textoCodigoOpcaoMenu", chave.getTextoCodigoOpcaoMenu()));
        query.setProjection((Projection)Projections.max((String)"id.textoCodigoTransacao"));
        List colecao = query.list();
        Integer max = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
        max = UtilSomadoresDeNumero.somar(max, 1);
        chave.setTextoCodigoTransacao("" + max);
    }
}

