/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.UsuarioDAO;
import br.com.bb.plugins.gac.negocio.to.EstadoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.negocio.to.decorator.GrupoUsuarioTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.UsuarioTODecorator;
import br.com.bb.plugins.gac.util.constante.EstadoDoUsuario;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsuarioDAOImpl
extends HibernateDAO<UsuarioTO, Integer>
implements UsuarioDAO {
    @Override
    protected Class<UsuarioTO> novoTipoDeObjetoPersistente() {
        return UsuarioTO.class;
    }

    @Override
    public List<UsuarioTO> consultar() {
        String hql = "from UsuarioTO usu inner join fetch usu.grupoUsuarioTO as grp inner join fetch usu.estadoUsuarioTO as sit";
        return super.consultarPeloHQL(hql);
    }

    @Override
    public Collection<UsuarioTO> consultar(String usuario, int grupo, int situacao) {
        StringBuffer s_hql = new StringBuffer();
        if (situacao > 0) {
            s_hql.append("where usu.estadoUsuarioTO.codigoEstadoUsuario=" + situacao);
        }
        if (grupo > 0) {
            s_hql.append(s_hql.length() == 0 ? " where " : " and ");
            s_hql.append("usu.grupoUsuarioTO.numeroIdentificadorGrupoUsuario=" + grupo);
        }
        if (usuario != null && usuario.trim().length() > 0) {
            s_hql.append(s_hql.length() == 0 ? " where " : " and ");
            s_hql.append("usu.textoNome like '%" + usuario + "%'");
        }
        return this.consultarPeloHQL("from UsuarioTO usu inner join fetch usu.grupoUsuarioTO as grp inner join fetch usu.estadoUsuarioTO as sit " + s_hql);
    }

    @Override
    public Collection<UsuarioTO> consultarPorNomeNoSistema(String nome, int grupo, int situacao) {
        StringBuffer s_hql = new StringBuffer();
        if (situacao > 0) {
            s_hql.append("where usu.estadoUsuarioTO.cdEstUsu=" + situacao);
        }
        if (grupo > 0) {
            s_hql.append(s_hql.length() == 0 ? " where " : " and ");
            s_hql.append("usu.grupoUsuarioTO.nrIdfrGrUsu=" + grupo);
        }
        if (nome != null && nome.trim().length() > 0) {
            s_hql.append(s_hql.length() == 0 ? " where " : " and ");
            s_hql.append("usu.txNmUsuSis like '%" + nome + "%'");
        }
        return this.consultarPeloHQL("from UsuarioTO usu inner join fetch usu.grupoUsuarioTO as grp inner join fetch usu.estadoUsuarioTO as sit " + s_hql);
    }

    @Override
    public UsuarioTO listarPorNome(UsuarioTO to) {
        Criteria query = this.novaCriteria();
        query.add(this.getCriterioConsultarPorNome(to));
        return (UsuarioTO)query.uniqueResult();
    }

    @Override
    public UsuarioTO listarOutroUsuarioPorNome(UsuarioTO to) {
        Criteria query = this.novaCriteria();
        query.add(this.getCriterioConsultarPorNome(to));
        query.add(this.getCriterioIdentificadorUsuarioDiferente(to));
        return (UsuarioTO)query.uniqueResult();
    }

    @Override
    protected Integer getChavePrimaria(UsuarioTO to) {
        return to.getNumeroIdentificadorUsuario();
    }

    @Override
    public PaginadorTO consultarTodos(UsuarioTODecorator decorator) {
        String sql = "select usuarioTO from UsuarioTO usuarioTO left outer join usuarioTO.grupoUsuarioTO grupoUsuarioTO left outer join usuarioTO.estadoUsuarioTO estadoUsuarioTO {orderby}";
        sql = this.aplicarOrdenacao(sql, (PluginTODecoratorAbstrato)decorator);
        Query query = this.novaQuery(sql);
        return this.novoPaginadorTO(query.list(), (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public void ativar(UsuarioTO to) {
        this.alterarEstado(to, EstadoDoUsuario.getAtivo());
        UsuarioTODecorator decorator = this.novoUsuarioTODecorator(to);
        this.alterar(decorator.getUsuarioTO());
    }

    protected void alterarEstado(UsuarioTO to, Integer codigoEstado) {
        EstadoUsuarioTO estado = this.getTOFactory().novoEstadoUsuarioTO();
        estado.setCodigoEstadoUsuario(codigoEstado);
        to.setEstadoUsuarioTO(estado);
    }

    @Override
    public void ativar(UsuarioTODecorator decorator) {
        this.alterarEstado(decorator.getUsuarioTO(), EstadoDoUsuario.getAtivo());
        this.ativar(decorator.getUsuarioTO());
    }

    @Override
    public void desativar(UsuarioTO to) {
        this.alterarEstado(to, EstadoDoUsuario.getInativo());
        UsuarioTODecorator decorator = this.novoUsuarioTODecorator(to);
        this.alterar(decorator.getUsuarioTO());
    }

    @Override
    public void desativar(UsuarioTODecorator decorator) {
        this.alterarEstado(decorator.getUsuarioTO(), EstadoDoUsuario.getInativo());
        this.desativar(decorator.getUsuarioTO());
    }

    @Override
    public boolean isExisteRegistro(GrupoUsuarioTODecorator to) {
        Integer numero = to.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario();
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("grupoUsuarioTO.numeroIdentificadorGrupoUsuario", numero));
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public boolean isExisteRegistro(GrupoUsuarioTO to) {
        Integer numero = to.getNumeroIdentificadorGrupoUsuario();
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("grupoUsuarioTO.numeroIdentificadorGrupoUsuario", numero));
        return !UtilColecao.isVazio(query.list());
    }

    private UsuarioTODecorator novoUsuarioTODecorator(UsuarioTO to) {
        return this.getTOFactory().novoUsuarioTODecorator(to);
    }

    private Criterion getCriterioConsultarPorNome(UsuarioTO to) {
        String nome = to.getTextoNomeUsuarioSistema();
        return this.novoCriterioEQIgnoreCase("textoNomeUsuarioSistema", nome);
    }

    private Criterion getCriterioIdentificadorUsuarioDiferente(UsuarioTO to) {
        Integer codigo = to.getNumeroIdentificadorUsuario();
        return this.novoCriterioNE("numeroIdentificadorUsuario", codigo);
    }

    @Override
    public String consultarSenha(UsuarioTO usuario) {
        Criteria criteria = this.getSession().createCriteria(this.getTipoDeObjetoPersistente());
        criteria.add((Criterion)Restrictions.eq((String)"textoNomeUsuarioSistema", (Object)usuario.getTextoNomeUsuarioSistema()));
        UsuarioTO usuarioEncontrado = (UsuarioTO)criteria.uniqueResult();
        return usuarioEncontrado.getTextoSenha();
    }
}

