/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao.controle;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.business.CampoTabelaBO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilMensagem;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;

public class JDBCDAOSuport {
    public static final String BDGERAL = "BDGERAL";
    public static final String BDCONTROLE = "BDCONTROLE";
    private Connection connection = null;
    private String driver = null;
    private String urlbanco = null;
    private String usuarioBanco = null;
    private String senhaBanco = null;
    private String opcaoBancoDados = "";

    public JDBCDAOSuport(String opcaoBancoDados) {
        this.opcaoBancoDados = opcaoBancoDados;
        this.initialize();
    }

    private void initialize() {
        this.setDriver(this.getConfig().getDriver());
        if (BDCONTROLE.equalsIgnoreCase(this.opcaoBancoDados)) {
            this.setUrlbanco(this.getConfig().getUrlControle());
        } else {
            this.setUrlbanco(this.getConfig().getUrl());
        }
        this.setUsuarioBanco(this.getConfig().getNomeUsuario());
        this.setSenhaBanco(this.getConfig().getSenha());
    }

    private ConfiguracaoProperties getConfig() {
        return ConfiguracaoProperties.getConfiguracaoProperties();
    }

    public Connection getConexao() throws BBException {
        return this.getConexao(true);
    }

    protected Connection getConexao(boolean inicializarConfiguracoes) throws BBException {
        if (this.connection == null) {
            try {
                if (inicializarConfiguracoes) {
                    this.initialize();
                } else {
                    this.setDriver(this.getConfig().getDriver());
                }
                Class.forName(this.driver).newInstance();
                System.out.println(this.getUrlbanco());
                this.connection = DriverManager.getConnection(this.getUrlbanco().trim(), this.getUsuarioBanco(), this.getSenhaBanco());
                this.connection.setAutoCommit(true);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        return this.connection;
    }

    protected Date getDateFromResultSet(ResultSet rs, String nomeCampo) throws SQLException {
        if (rs.getString(nomeCampo) == null) {
            return new Date();
        }
        return rs.getDate(nomeCampo);
    }

    protected long getLongFromResultSet(ResultSet rs, String nomeCampo) throws SQLException {
        if (rs.getString(nomeCampo) == null) {
            return 0L;
        }
        return rs.getLong(nomeCampo);
    }

    protected String getStringFromResultSet(ResultSet rs, String nomeCampo) throws SQLException {
        if (rs.getString(nomeCampo) == null) {
            return "";
        }
        return rs.getString(nomeCampo);
    }

    protected int getIntFromResultSet(ResultSet rs, String nomeCampo) throws SQLException {
        if (rs.getString(nomeCampo) == null) {
            return 0;
        }
        return rs.getInt(nomeCampo);
    }

    protected java.sql.Date parseToSQLDate(Date data) {
        java.sql.Date dataSQL = null;
        if (data != null) {
            dataSQL = new java.sql.Date(data.getTime());
        }
        return dataSQL;
    }

    protected boolean testarExistenciaTabela(String nomeTabela) throws BBException {
        ResultSet rs;
        block6: {
            String schema;
            String[] types;
            String catalog;
            DatabaseMetaData meta;
            block5: {
                try {
                    meta = this.getConexao().getMetaData();
                    rs = meta.getCatalogs();
                    catalog = "";
                    if (rs.next()) {
                        catalog = rs.getString(1);
                    }
                    rs.close();
                    types = new String[]{"TABLE"};
                    schema = null;
                    rs = meta.getTables(catalog, schema, nomeTabela, types);
                    if (!rs.next() || !nomeTabela.equalsIgnoreCase(rs.getString("TABLE_NAME"))) break block5;
                    return true;
                }
                catch (SQLException e) {
                    throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
                }
            }
            rs = meta.getTables(catalog, schema, nomeTabela.toLowerCase(), types);
            if (!rs.next() || !nomeTabela.equalsIgnoreCase(rs.getString("TABLE_NAME"))) break block6;
            return true;
        }
        rs.close();
        return false;
    }

    protected void executarQuery(String query) throws BBException {
        try {
            Statement stmt = this.getConexao().createStatement();
            stmt.executeUpdate(query);
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(query);
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    protected ResultSet executarQueryResult(String s_sql) throws SQLException, BBException {
        ResultSet rs = null;
        try {
            rs = this.getConexao().createStatement().executeQuery(s_sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BBException("");
        }
        return rs;
    }

    public String getStringFromCampo(CampoTabelaBO campo, ResultSet rs) throws Throwable {
        String retorno = "";
        if (campo.getTipoCampo().toUpperCase().indexOf("CHAR") != -1) {
            retorno = rs.getString(campo.getNomeCampo());
        } else if (campo.getTipoCampo().toUpperCase().indexOf("INT") != -1) {
            if (rs.getObject(campo.getNomeCampo()) == null) {
                return "";
            }
            retorno = String.valueOf(rs.getInt(campo.getNomeCampo()));
            if ("CD_PSS_CNJG".equals(campo.getNomeCampo())) {
                System.out.println("Campo Chave com valor Zerado: " + campo.getNomeCampo());
            }
        } else if (campo.getTipoCampo().toUpperCase().indexOf("LONG") != -1) {
            retorno = String.valueOf(rs.getLong(campo.getNomeCampo()));
        } else if (campo.getTipoCampo().toUpperCase().indexOf("DOUBLE") != -1) {
            retorno = String.valueOf(rs.getDouble(campo.getNomeCampo()));
        } else if (campo.getTipoCampo().toUpperCase().indexOf("DECIMAL") != -1) {
            retorno = String.valueOf(rs.getDouble(campo.getNomeCampo()));
        } else if (campo.getTipoCampo().toUpperCase().indexOf("DATE") != -1 || campo.getTipoCampo().toUpperCase().indexOf("TIMESTAMP") != -1) {
            GregorianCalendar gc = new GregorianCalendar();
            if (rs.getDate(campo.getNomeCampo()) == null) {
                retorno = "";
            } else {
                gc.setTime(rs.getDate(campo.getNomeCampo()));
                retorno = String.valueOf(Util.strZero(String.valueOf(gc.get(5)), 2)) + "/" + Util.strZero(String.valueOf(gc.get(2) + 1), 2) + "/" + gc.get(1) + "'";
            }
        } else {
            System.out.println("*** N\u00c3O ENCONTRADO***");
            System.out.println("*** CAMPO " + campo.getNomeCampo() + " - " + campo.getTipoCampo());
        }
        if (retorno == null) {
            retorno = "";
        }
        return retorno;
    }

    protected boolean testarExistenciaColuna(String nomeTabela, String nomeCampo) throws BBException {
        try {
            DatabaseMetaData meta = this.getConexao().getMetaData();
            ResultSet rs = meta.getColumns(null, null, nomeTabela, nomeCampo);
            if (rs.next() && nomeCampo.equalsIgnoreCase(rs.getString("COLUMN_NAME"))) {
                rs.close();
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public String getUrlbanco() {
        return this.urlbanco;
    }

    public void setUrlbanco(String urlbanco) {
        this.urlbanco = urlbanco;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUsuarioBanco() {
        return this.usuarioBanco;
    }

    public void setUsuarioBanco(String usuarioBanco) {
        this.usuarioBanco = usuarioBanco;
    }

    public String getSenhaBanco() {
        return this.senhaBanco;
    }

    public void setSenhaBanco(String senhaBanco) {
        this.senhaBanco = senhaBanco;
    }
}

