/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao.controle;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.controle.JDBCDAOSuport;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoControleTO;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelAtualizacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelInstalacaoBO;
import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;
import br.com.bb.plugins.gac.util.view.FramePrincipal;
import br.com.politec.generico.string.UtilString;
import br.com.politec.infra.util.UtilLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicoControleDAO
extends JDBCDAOSuport {
    public ServicoControleDAO() {
        super("BDCONTROLE");
    }

    public ServicoControleTO consultarServico(String nomePacote) throws BBException {
        ServicoControleTO servicoControle = null;
        String s_sql = "SELECT TX_IDFR_SRVC, TX_DCR, TX_VSR, TX_VSR_MIN, NR_TAM_PKGE, TX_NM_PKGE, DT_PKGE, TX_USU, DT_DLOD FROM SERVICOS WHERE TX_IDFR_SRVC=?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, nomePacote);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                servicoControle = new ServicoControleTO();
                servicoControle.setNomePacote(this.getStringFromResultSet(rs, "TX_IDFR_SRVC"));
                servicoControle.setDescricaoPacote(this.getStringFromResultSet(rs, "TX_DCR"));
                servicoControle.setVersaoPacote(this.getStringFromResultSet(rs, "TX_VSR"));
                servicoControle.setVersaoMinimaGAC(this.getStringFromResultSet(rs, "TX_VSR_MIN"));
                servicoControle.setTamanhoPacote(this.getLongFromResultSet(rs, "NR_TAM_PKGE"));
                servicoControle.setNomeFisicoPacote(this.getStringFromResultSet(rs, "TX_NM_PKGE"));
                servicoControle.setDataPacote(this.getDateFromResultSet(rs, "DT_PKGE"));
                servicoControle.setNomeUsuarioInstalador(this.getStringFromResultSet(rs, "TX_USU"));
                servicoControle.setDataDownload(this.getDateFromResultSet(rs, "DT_DLOD"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return servicoControle;
    }

    public void gravarServico(ServicoControleTO servico) throws BBException {
        String s_sql = "SELECT TX_IDFR_SRVC FROM SERVICOS WHERE TX_IDFR_SRVC=?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, servico.getNomePacote());
            ResultSet rs = pstmt.executeQuery();
            s_sql = rs.next() ? "UPDATE SERVICOS SET TX_DCR=?, TX_VSR=?, TX_VSR_MIN=?, NR_TAM_PKGE=?, TX_NM_PKGE=?, DT_PKGE=?, TX_USU=?, DT_DLOD=? WHERE TX_IDFR_SRVC=?" : "INSERT INTO SERVICOS (TX_DCR, TX_VSR, TX_VSR_MIN, NR_TAM_PKGE, TX_NM_PKGE, DT_PKGE, TX_USU, DT_DLOD, TX_IDFR_SRVC) VALUES (?, ?, ?, ?, ?, ? ,?, ?, ?)";
            PreparedStatement pstmt2 = this.getConexao().prepareStatement(s_sql);
            pstmt2.setString(1, servico.getDescricaoPacote());
            pstmt2.setString(2, UtilString.removerCaracteres(servico.getVersaoPacote()));
            pstmt2.setString(3, UtilString.removerCaracteres(servico.getVersaoMinimaGAC()));
            pstmt2.setLong(4, servico.getTamanhoPacote());
            pstmt2.setString(5, servico.getNomeFisicoPacote());
            if (servico.getDataPacote() == null) {
                pstmt2.setDate(6, null);
            } else {
                pstmt2.setDate(6, new Date(servico.getDataPacote().getTime()));
            }
            pstmt2.setString(7, servico.getNomeUsuarioInstalador());
            pstmt2.setDate(8, new Date(new java.util.Date().getTime()));
            pstmt2.setString(9, servico.getNomePacote());
            pstmt2.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public byte[] lerCampoBLOB(String nomePacote) throws BBException {
        byte[] returndata = null;
        try {
            Statement sment = this.getConexao().createStatement();
            String sql = "SELECT BLB_PKGE FROM SERVICOS WHERE TX_IDFR_SRVC='" + nomePacote + "'";
            ResultSet rs = sment.executeQuery(sql);
            if (rs.next()) {
                returndata = rs.getBytes("BLB_PKGE");
            }
            rs.close();
            sment.close();
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return returndata;
    }

    public void gravarCampoBLOB(String nomePacote, FileInputStream inputStream, int tamanhoArquivo) throws BBException {
        try {
            String s_sql = "UPDATE SERVICOS SET BLB_PKGE=? WHERE TX_IDFR_SRVC=?";
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setBinaryStream(1, (InputStream)inputStream, tamanhoArquivo);
            pstmt.setString(2, nomePacote);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public void deletarServico(String nomePacote) throws BBException {
        try {
            String s_sql = "DELETE FROM SERVICOS WHERE SERVICOS.TX_IDFR_SRVC=?";
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, nomePacote);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public List<ServicoControleTO> consultarServicos() throws BBException {
        ArrayList<ServicoControleTO> servicos = new ArrayList<ServicoControleTO>();
        String s_sql = "SELECT TX_IDFR_SRVC, TX_DCR, TX_VSR, TX_VSR_MIN, NR_TAM_PKGE, TX_NM_PKGE, DT_PKGE, TX_USU, DT_DLOD FROM SERVICOS ";
        try {
            Statement sment = this.getConexao().createStatement();
            ResultSet rs = sment.executeQuery(s_sql);
            while (rs.next()) {
                ServicoControleTO servico = new ServicoControleTO();
                servico.setNomePacote(this.getStringFromResultSet(rs, "TX_IDFR_SRVC"));
                servico.setDescricaoPacote(this.getStringFromResultSet(rs, "TX_DCR"));
                servico.setVersaoPacote(this.getStringFromResultSet(rs, "TX_VSR"));
                servico.setVersaoMinimaGAC(this.getStringFromResultSet(rs, "TX_VSR_MIN"));
                servico.setTamanhoPacote(this.getLongFromResultSet(rs, "NR_TAM_PKGE"));
                servico.setNomeFisicoPacote(this.getStringFromResultSet(rs, "TX_NM_PKGE"));
                servico.setDataPacote(this.getDateFromResultSet(rs, "DT_PKGE"));
                servico.setNomeUsuarioInstalador(this.getStringFromResultSet(rs, "TX_USU"));
                servico.setDataDownload(this.getDateFromResultSet(rs, "DT_DLOD"));
                servicos.add(servico);
            }
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return servicos;
    }

    public boolean testarExistenciaTabela() throws BBException {
        return super.testarExistenciaTabela("SRVC");
    }

    public void salvarAplicacoes(List aplicativosAtualizados, List aplicativosInstalados, String pastaTemp) throws BBException {
        try {
            FileInputStream inputStream;
            File arquivo;
            String nomeArquivo;
            ServicoControleTO servicoControleTO;
            this.getConexao().setAutoCommit(false);
            for (IObjectTableModel aplicativo : aplicativosAtualizados) {
                servicoControleTO = new ServicoControleTO();
                servicoControleTO.setNomePacote(((AplicativoDisponivelAtualizacaoBO)aplicativo).getCodigo());
                servicoControleTO.setDescricaoPacote(((AplicativoDisponivelAtualizacaoBO)aplicativo).getAplicativo());
                servicoControleTO.setVersaoPacote(((AplicativoDisponivelAtualizacaoBO)aplicativo).getVersaodisponivel());
                servicoControleTO.setVersaoMinimaGAC(((AplicativoDisponivelAtualizacaoBO)aplicativo).getVersaominimagac());
                servicoControleTO.setNomeFisicoPacote(((AplicativoDisponivelAtualizacaoBO)aplicativo).getNomejar());
                servicoControleTO.setTamanhoPacote(((AplicativoDisponivelAtualizacaoBO)aplicativo).getTamanho());
                servicoControleTO.setNomeUsuarioInstalador(FramePrincipal.getInstance().getPanelInferior().getUsuario());
                this.gravarServico(servicoControleTO);
                nomeArquivo = String.valueOf(pastaTemp) + File.separator + ((AplicativoDisponivelAtualizacaoBO)aplicativo).getNomejar();
                arquivo = new File(nomeArquivo);
                inputStream = new FileInputStream(arquivo);
                this.gravarCampoBLOB(((AplicativoDisponivelAtualizacaoBO)aplicativo).getCodigo(), inputStream, (int)((AplicativoDisponivelAtualizacaoBO)aplicativo).getTamanho());
            }
            for (IObjectTableModel aplicativo : aplicativosInstalados) {
                servicoControleTO = new ServicoControleTO();
                servicoControleTO.setNomePacote(((AplicativoDisponivelInstalacaoBO)aplicativo).getCodigo());
                servicoControleTO.setDataPacote(this.converteData(((AplicativoDisponivelInstalacaoBO)aplicativo).getDatapacote()));
                servicoControleTO.setDescricaoPacote(((AplicativoDisponivelInstalacaoBO)aplicativo).getAplicativo());
                servicoControleTO.setVersaoPacote(((AplicativoDisponivelInstalacaoBO)aplicativo).getVersao());
                servicoControleTO.setVersaoMinimaGAC(((AplicativoDisponivelInstalacaoBO)aplicativo).getVersaominimagac());
                servicoControleTO.setNomeFisicoPacote(((AplicativoDisponivelInstalacaoBO)aplicativo).getNomejar());
                servicoControleTO.setTamanhoPacote(((AplicativoDisponivelInstalacaoBO)aplicativo).getTamanho());
                servicoControleTO.setNomeUsuarioInstalador(FramePrincipal.getInstance().getPanelInferior().getUsuario());
                this.gravarServico(servicoControleTO);
                nomeArquivo = String.valueOf(pastaTemp) + "/" + ((AplicativoDisponivelInstalacaoBO)aplicativo).getNomejar();
                arquivo = new File(nomeArquivo);
                inputStream = new FileInputStream(arquivo);
                this.gravarCampoBLOB(((AplicativoDisponivelInstalacaoBO)aplicativo).getCodigo(), inputStream, (int)((AplicativoDisponivelInstalacaoBO)aplicativo).getTamanho());
            }
            this.getConexao().commit();
            this.getConexao().setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public void salvarAplicacoes(List<AplicativoDisponivelInstalacaoBO> aplicativosInstalar, String pastaTemp) throws BBException {
        try {
            this.getConexao().setAutoCommit(false);
            for (AplicativoDisponivelInstalacaoBO aplicativo : aplicativosInstalar) {
                ServicoControleTO servicoControleTO = new ServicoControleTO();
                servicoControleTO.setNomePacote(aplicativo.getCodigo());
                servicoControleTO.setDataPacote(this.converteData(aplicativo.getDatapacote()));
                servicoControleTO.setDescricaoPacote(aplicativo.getAplicativo());
                servicoControleTO.setVersaoPacote(aplicativo.getVersao());
                servicoControleTO.setVersaoMinimaGAC(aplicativo.getVersaominimagac());
                servicoControleTO.setNomeFisicoPacote(aplicativo.getNomejar());
                servicoControleTO.setTamanhoPacote(aplicativo.getTamanho());
                servicoControleTO.setNomeUsuarioInstalador(FramePrincipal.getInstance().getPanelInferior().getUsuario());
                this.gravarServico(servicoControleTO);
                String nomeArquivo = String.valueOf(pastaTemp) + "/" + aplicativo.getNomejar();
                File arquivo = new File(nomeArquivo);
                FileInputStream inputStream = new FileInputStream(arquivo);
                this.gravarCampoBLOB(aplicativo.getCodigo(), inputStream, (int)aplicativo.getTamanho());
            }
            this.getConexao().commit();
            this.getConexao().setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    private java.util.Date converteData(String dataPacote) {
        if (dataPacote.length() == 10) {
            int i = 0;
            int dia = 0;
            int mes = 0;
            int ano = 0;
            String[] stringArray = dataPacote.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String valor = stringArray[n2];
                System.out.println(valor);
                if (i == 0) {
                    dia = new Integer(valor);
                } else if (i == 1) {
                    mes = new Integer(valor);
                } else if (i == 2) {
                    ano = new Integer(valor);
                }
                ++i;
                ++n2;
            }
            if (dia != 0 && mes != 0 && ano != 0) {
                GregorianCalendar data = new GregorianCalendar();
                data.set(ano, mes - 1, dia);
                System.out.println(data.getTime());
                return data.getTime();
            }
        }
        return null;
    }

    public boolean testarConexaoBancoDados() throws BBException {
        try {
            Connection connection = this.getConexao(false);
            return connection != null;
        }
        catch (BBException e) {
            UtilLog.getLog().debug(e);
            return false;
        }
    }
}

