/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.bo;

import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;
import br.com.politec.generico.conversor.instancia.ConversorDeUtilDateParaStringNoPadrao;
import br.com.politec.generico.excecao.ConversorException;
import br.com.politec.infra.util.UtilLog;

public class RecuperarRemessasBO
extends IObjectTableModel {
    private RemessaTODecorator remessaTODecorator;

    public RecuperarRemessasBO(RemessaTODecorator decorator) {
        this.setRemessaTODecorator(decorator);
    }

    public Object getColumn(int column) {
        switch (column) {
            case 0: {
                return this.getRemessaTODecorator().getServicoTO().getTextoDescricao();
            }
            case 1: {
                return this.getNumeroRemessa();
            }
            case 2: {
                return this.getDataRemessa();
            }
            case 3: {
                return this.getConvenioTO().getId().getNumeroConvenio();
            }
            case 4: {
                return this.getRemessaTODecorator().getValorRemessa();
            }
            case 5: {
                return this.getTextoNomeArquivo();
            }
        }
        return null;
    }

    public PluginTOAbstrato getTO() {
        return this.getRemessaTODecorator();
    }

    public RemessaTODecorator getRemessaTODecorator() {
        return this.remessaTODecorator;
    }

    public String getNumeroRemessa() {
        return this.getRemessaTODecorator().getNumeroRemessa().toString();
    }

    public ConvenioTO getConvenioTO() {
        return this.getRemessaTODecorator().getConvenioTO();
    }

    public String getDataRemessa() {
        ConversorDeUtilDateParaStringNoPadrao padrao = new ConversorDeUtilDateParaStringNoPadrao();
        String converter = "";
        try {
            converter = (String)padrao.converter(this.getRemessaTODecorator().getDataRemessa());
        }
        catch (ConversorException e) {
            UtilLog.getLog().debug(e);
        }
        return converter;
    }

    public String getTextoNomeArquivo() {
        return this.getRemessaTODecorator().getTextoNomeArquivo();
    }

    public String getTipoRegistro() {
        return this.getRemessaTODecorator().getTipoRegistro();
    }

    public void setRemessaTODecorator(RemessaTODecorator remessaTODecorator) {
        this.remessaTODecorator = remessaTODecorator;
    }
}

