/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.apresentacao.manterinstituicaofinanceira.view.ViewAtualizarInstituicaoFinanceira;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class AtualizarInstituicaoFinanceiraModel
extends PluginModelAbstrato {
    private InstituicaoFinanceiraDAO instituicaoFinanceiraDAO;
    private int totalLinhas = Integer.MIN_VALUE;
    private int linhaAtual = 0;
    private double baseCalculoProgressBar = 0.0;
    private int valorAtualBarraProgresso = 0;
    private String versaoDoArquivo;
    private BufferedReader bufferArquivoRemoto;
    private BufferedReader bufferArquivoRemotoCount;
    private String arquivoInstituicoesFinanceira = "http://" + ConfiguracaoProperties.getConfiguracaoProperties().getUrlAtualizarInstituicaoFinanceira() + "caf504.txt";
    private ViewAtualizarInstituicaoFinanceira view;
    private String erroConexao = "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o Banco do Brasil para verificar se existe atualiza\u00e7\u00e3o de Institui\u00e7\u00f5es Financeiras.\nVerifique as configura\u00e7\u00f5es de Rede para permitir o acesso do BB Gest\u00e3oMax.";

    private void atualizaProgressBarESetaValorAtual(int valor) {
        this.view.atualizaProgressBar(valor);
        this.valorAtualBarraProgresso = valor;
    }

    public void atualizarVersaoProperties(String versao) throws BBException {
        ConfiguracaoProperties.getConfiguracaoProperties().setInstituicaoFinanceiraVersaoArquivo(versao);
        ConfiguracaoProperties.getConfiguracaoProperties().salvaPropriedades();
    }

    public String lerVersaoDoArquivo() throws BBException {
        try {
            this.abrirArquivoRemoto();
            this.versaoDoArquivo = this.bufferArquivoRemoto.readLine();
            this.fecharArquivoRemoto();
            return this.versaoDoArquivo;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BBException("Erro ao ler aruivo: " + ex.getMessage());
        }
    }

    private void abrirArquivoRemoto() throws BBException, IOException {
        try {
            URL url = new URL(this.arquivoInstituicoesFinanceira);
            if (url == null) {
                throw new BBException("Arquivo n\u00e3o existe.");
            }
            this.bufferArquivoRemoto = new BufferedReader(new InputStreamReader(url.openStream()));
            this.bufferArquivoRemotoCount = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (UnknownHostException ue) {
            throw new BBException(this.erroConexao);
        }
        catch (ConnectException ce) {
            throw new BBException(this.erroConexao);
        }
    }

    private void fecharArquivoRemoto() {
        try {
            if (this.bufferArquivoRemoto != null) {
                this.bufferArquivoRemoto.close();
            }
            if (this.bufferArquivoRemotoCount != null) {
                this.bufferArquivoRemotoCount.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void atualizarPorcentagemParaBarraProgresso() {
        int porcentagem = (int)((double)this.linhaAtual / this.baseCalculoProgressBar);
        if (porcentagem > this.valorAtualBarraProgresso && porcentagem < 99) {
            this.valorAtualBarraProgresso = porcentagem;
            this.view.atualizaProgressBar(porcentagem);
        }
    }

    public InstituicaoFinanceiraDAO getInstituicaoFinanceiraDAO() {
        return this.instituicaoFinanceiraDAO;
    }

    public void setInstituicaoFinanceiraDAO(InstituicaoFinanceiraDAO instituicaoFinanceiraDAO) {
        this.instituicaoFinanceiraDAO = instituicaoFinanceiraDAO;
    }

    public void atualizar() throws BBException {
        System.out.println("Atualizando Institui\u00e7\u00f5es Financeiras...");
        try {
            try {
                String linha;
                this.abrirArquivoRemoto();
                this.versaoDoArquivo = this.bufferArquivoRemoto.readLine();
                this.atualizaProgressBarESetaValorAtual(1);
                InstituicaoFinanceiraTO instituicaoFinanceiraTO = new InstituicaoFinanceiraTO();
                this.baseCalculoProgressBar = (double)this.getTotalRegistros() / 100.0;
                ArrayList<Integer> listInstituicoesFinanceira = new ArrayList<Integer>(0);
                this.atualizaProgressBarESetaValorAtual(5);
                int cont = 0;
                while ((linha = this.bufferArquivoRemoto.readLine()) != null) {
                    if (linha.trim().length() <= 1) continue;
                    int codigoCOMPE = Integer.parseInt(linha.substring(0, 3));
                    instituicaoFinanceiraTO.setCodigoInstituicaoFinanceira(codigoCOMPE);
                    instituicaoFinanceiraTO.setTipoInstituicaoFinanceira("COMPE");
                    instituicaoFinanceiraTO.setTextoNomeInstituicaoFinanceira(linha.substring(11, 40).trim().toUpperCase());
                    instituicaoFinanceiraTO.setIndicadorEstadoInstituicaoFinanceira(Character.valueOf('1'));
                    listInstituicoesFinanceira.add(instituicaoFinanceiraTO.getCodigoInstituicaoFinanceira());
                    this.getInstituicaoFinanceiraDAO().incluirOuAlterar(instituicaoFinanceiraTO);
                    this.atualizarPorcentagemParaBarraProgresso();
                    this.linhaAtual = cont++;
                }
                this.atualizaProgressBarESetaValorAtual(99);
                this.atualizaProgressBarESetaValorAtual(100);
                this.atualizarVersaoProperties(this.versaoDoArquivo);
            }
            catch (IOException ioe) {
                throw new BBException("Erro: " + ioe.getMessage());
            }
            catch (BBException e) {
                throw new BBException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BBException("Erro inesperado: " + e.getMessage());
            }
        }
        finally {
            this.fecharArquivoRemoto();
        }
    }

    public int getTotalRegistros() throws IOException {
        if (this.totalLinhas == Integer.MIN_VALUE) {
            LineNumberReader lineNumberReader = new LineNumberReader(this.bufferArquivoRemotoCount);
            lineNumberReader.skip(Long.MAX_VALUE);
            this.totalLinhas = lineNumberReader.getLineNumber() - 1;
            this.bufferArquivoRemotoCount.close();
        }
        return this.totalLinhas;
    }

    public ViewAtualizarInstituicaoFinanceira getView() {
        return this.view;
    }

    public void setView(ViewAtualizarInstituicaoFinanceira view) {
        this.view = view;
    }
}

