/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.apresentacao.configurarbancodados.form.ConfigurarBancoDadosForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ControleCopiaSegurancaDAO;
import br.com.bb.plugins.gac.negocio.business.ConfigurarBancoDadosBO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurarBancoDadosModel
extends PluginModelAbstrato {
    private ControleCopiaSegurancaDAO controleCopiaSegurancaDAO;
    final String TIPO_INSTALACAL_LOCAL = "1";
    private ArrayList<String> listIPsValidos = new ArrayList();

    public void setConfiguracoes(ConfigurarBancoDadosBO configurarBancoDadosBO) throws BBException {
        this.getConfiguracaoProperties().setTipoInstalacaoBancoDados(configurarBancoDadosBO.getTipoCompartilhamento());
        this.getConfiguracaoProperties().setNomeHost(configurarBancoDadosBO.getNomeIPServidor());
        this.getConfiguracaoProperties().setLocalBD(configurarBancoDadosBO.getPastaBancoDados());
        this.getConfiguracaoProperties().setNomeUsuario(configurarBancoDadosBO.getNomeUsuarioBancoDados());
        this.getConfiguracaoProperties().setSenha(configurarBancoDadosBO.getSenhaBancoDados());
        this.getConfiguracaoProperties().setPorta(configurarBancoDadosBO.getPortaTCPBancoDados());
        this.getConfiguracaoProperties().setDirBackup(configurarBancoDadosBO.getPastaCopiaSeguranca());
    }

    public void salvarConfiguracoes() throws BBException {
        this.getConfiguracaoProperties().salvaPropriedades();
    }

    public ConfigurarBancoDadosBO buscarConfiguracoes() throws BBException {
        ConfigurarBancoDadosBO configBO = new ConfigurarBancoDadosBO();
        configBO.setTipoCompartilhamento(this.getConfiguracaoProperties().getTipoInstalacaoBancoDados());
        configBO.setNomeIPServidor(this.getConfiguracaoProperties().getNomeHost());
        configBO.setPastaBancoDados(this.getConfiguracaoProperties().getLocalBD());
        configBO.setNomeUsuarioBancoDados(this.getConfiguracaoProperties().getNomeUsuario());
        configBO.setSenhaBancoDados(this.getConfiguracaoProperties().getSenha());
        configBO.setPortaTCPBancoDados(this.getConfiguracaoProperties().getPorta());
        configBO.setPastaCopiaSeguranca(this.getConfiguracaoProperties().getDirBackup());
        return configBO;
    }

    public ConfiguracaoProperties getConfiguracaoProperties() {
        return ConfiguracaoProperties.getConfiguracaoProperties();
    }

    public ControleCopiaSegurancaDAO getControleCopiaSegurancaDAO() {
        return this.controleCopiaSegurancaDAO;
    }

    public void setControleCopiaSegurancaDAO(ControleCopiaSegurancaDAO controleCopiaSegurancaDAO) {
        this.controleCopiaSegurancaDAO = controleCopiaSegurancaDAO;
    }

    public boolean arquivoEncontradoNormal() throws BBException {
        return this.getConfiguracaoProperties().arquivoEncontradoNormal();
    }

    public boolean validaConfiguracao(ConfigurarBancoDadosForm configurarBancoDadosForm) {
        boolean valido = true;
        if (configurarBancoDadosForm.getConfigurarBancoDadosBO().getTipoCompartilhamento().equals("1")) {
            File pastaBanco = new File(configurarBancoDadosForm.getConfigurarBancoDadosBO().getPastaBancoDados());
            FilenameFilter filtro = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".FDB");
                }
            };
            try {
                if (pastaBanco.listFiles(filtro).length < 2) {
                    valido = false;
                }
            }
            catch (NullPointerException npe) {
                valido = false;
                npe.printStackTrace();
            }
        }
        return valido;
    }

    public ArrayList<String> testar(ConfigurarBancoDadosBO configurarBancoDadosBO) {
        if (configurarBancoDadosBO.getTipoCompartilhamento().equals("1")) {
            return this.testarConexaoLocal(configurarBancoDadosBO);
        }
        return this.testarConexaoEmRede(configurarBancoDadosBO);
    }

    private ArrayList<String> testarConexaoLocal(ConfigurarBancoDadosBO configurarBancoDadosBO) {
        ArrayList<String> logs = new ArrayList<String>();
        try {
            Class.forName(this.getConfiguracaoProperties().getDriver());
            logs.add("Iniciando conex\u00e3o LOCAL...");
            logs.add("jdbc:firebirdsql:embedded:" + configurarBancoDadosBO.getPastaBancoDados() + "\\BBGACA.FDB");
            Connection db_connection = DriverManager.getConnection("jdbc:firebirdsql:embedded:" + configurarBancoDadosBO.getPastaBancoDados() + "/BBGACA.FDB", configurarBancoDadosBO.getNomeUsuarioBancoDados(), configurarBancoDadosBO.getSenhaBancoDados());
            db_connection.close();
            logs.add("Conex\u00e3o estabelecida com sucesso!!!");
            return logs;
        }
        catch (Throwable t) {
            return this.diagnosticoConexaoLocal(configurarBancoDadosBO, logs, t);
        }
    }

    private ArrayList<String> testarConexaoEmRede(ConfigurarBancoDadosBO configurarBancoDadosBO) {
        ArrayList<String> logs = new ArrayList<String>();
        try {
            Class.forName(this.getConfiguracaoProperties().getDriver()).newInstance();
            logs.add("Iniciando conex\u00e3o EM REDE...");
            String urlConexao = "jdbc:firebirdsql://" + configurarBancoDadosBO.getNomeIPServidor() + ":" + configurarBancoDadosBO.getPortaTCPBancoDados() + "/BBGACA";
            logs.add(urlConexao);
            Connection db_connection = DriverManager.getConnection(urlConexao, configurarBancoDadosBO.getNomeUsuarioBancoDados(), configurarBancoDadosBO.getSenhaBancoDados());
            db_connection.close();
            logs.add("Conex\u00e3o estabelecida com sucesso!!!");
            return logs;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return this.diagnosticoConexaoEmRede(configurarBancoDadosBO, logs, t);
        }
    }

    private ArrayList<String> diagnosticoConexaoLocal(ConfigurarBancoDadosBO configurarBancoDadosBO, ArrayList<String> logs, Throwable t) {
        if (t.getMessage().contains("335544344")) {
            logs.add("Conex\u00e3o estabelecida com sucesso!!!");
            logs.add("Obs.: Banco de Dados est\u00e1 em uso como EMBEDDED (EMBARCADO) no servidor \"" + configurarBancoDadosBO.getNomeIPServidor() + "\", ");
            logs.add(" encerre o BB Gest\u00e3oMax neste computador antes de utilizar a nova conex\u00e3o.");
            return logs;
        }
        logs.add("Erro conex\u00e3o: " + t.getMessage());
        logs.add("Verificando diret\u00f3rio...");
        File dir = new File(configurarBancoDadosBO.getPastaBancoDados());
        if (!dir.exists()) {
            logs.add("Diret\u00f3rio n\u00e3o localizado: " + configurarBancoDadosBO.getPastaBancoDados());
            return logs;
        }
        logs.add("Diret\u00f3rio localizado!");
        logs.add("Verificando arquivo BBGACA.FDB...");
        dir = new File(String.valueOf(configurarBancoDadosBO.getPastaBancoDados()) + "\\BBGACA.FDB");
        if (!dir.exists()) {
            logs.add("Banco de dados \"BBGACA.FDB\" n\u00e3o localizado no diret\u00f3rio: " + configurarBancoDadosBO.getPastaBancoDados());
        }
        return logs;
    }

    private ArrayList<String> diagnosticoConexaoEmRede(ConfigurarBancoDadosBO configurarBancoDadosBO, ArrayList<String> logs, Throwable t) {
        if (t.getMessage().contains("335544344")) {
            logs.add("Conex\u00e3o estabelecida com sucesso!!!");
            logs.add("Obs.: Banco de Dados est\u00e1 em uso como EMBEDDED (EMBARCADO) no servidor \"" + configurarBancoDadosBO.getNomeIPServidor() + "\", ");
            logs.add(" encerre o BB Gest\u00e3oMax neste computador antes de utilizar a nova conex\u00e3o.");
            return logs;
        }
        logs.add("Erro conex\u00e3o: " + t.getMessage());
        logs.add("Verificando IP...");
        if (configurarBancoDadosBO.getNomeIPServidor().toLowerCase().contains("localhost")) {
            logs.add("Evite utilizar \"localhost\", utilize o endere\u00e7o IP do computador servidor. ");
            return logs;
        }
        if (configurarBancoDadosBO.getNomeIPServidor().toLowerCase().contains("embedded")) {
            logs.add("Para o Tipo de Uso \"Compartilhado\", substitua o \"embedded\" pelo Endere\u00e7o IP do computador servidor. ");
            return logs;
        }
        if (!this.IPExiste(configurarBancoDadosBO.getNomeIPServidor())) {
            logs.add("O IP \"" + configurarBancoDadosBO.getNomeIPServidor() + "\" n\u00e3o foi localizado!");
            return logs;
        }
        logs.add("Verifique no Servidor \"" + configurarBancoDadosBO.getNomeIPServidor() + "\":");
        logs.add("1. se o Firebird 2 foi instalado corretamente;");
        logs.add("2. Se o arquivo \"aliases.conf\" foi configurado;");
        logs.add("3. se a porta \"" + configurarBancoDadosBO.getPortaTCPBancoDados() + "\" foi liberada no Firewall.");
        logs.add("Obs.: mais informa\u00e7\u00f5es na p\u00e1gina 53 do \"GAC - Manual de instala\u00e7\u00e3o.pdf\" localizado no diret\u00f3rio \"C:\\BancoBrasil\\Aplicativos\\BBGAC\\manualdeinstalacao\". ");
        return logs;
    }

    private boolean IPExiste(String ipAddress) {
        try {
            InetAddress inet = InetAddress.getByName(ipAddress);
            return inet.isReachable(5000);
        }
        catch (Throwable t) {
            return false;
        }
    }
}

