/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.DadosServidorProxyTO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;

public class ConfigurarDadosServidorProxyModel
extends PluginModelAbstrato {
    private static final String HABILITADO = "1";
    private static final String DESABILITADO = "2";

    private UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public ConfiguracaoProperties getConfiguracaoProperties() {
        return ConfiguracaoProperties.getConfiguracaoProperties();
    }

    public Boolean proxyHabilitado() throws BBException {
        try {
            UtilArquivoConfiguracao util = this.getUtilArquivoConfiguracao();
            return HABILITADO.equalsIgnoreCase(util.getValorPropertie("usa.servidor.proxy"));
        }
        catch (Exception e) {
            throw new BBException("Erro ao obter configura\u00e7\u00e3o do proxy.");
        }
    }

    public void salva(DadosServidorProxyTO dadosServidorProxyTO) throws BBException {
        try {
            this.getUtilArquivoConfiguracao().setValor("servidor.proxy", dadosServidorProxyTO.getServidorProxy());
            this.getUtilArquivoConfiguracao().setValor("porta.servidor.proxy", dadosServidorProxyTO.getPortaServidorProxy());
            this.getUtilArquivoConfiguracao().setValor("usa.servidor.proxy", dadosServidorProxyTO.getUsaServidorProxy() != false ? HABILITADO : DESABILITADO);
            this.getUtilArquivoConfiguracao().setValor("autentica.servidor.proxy", dadosServidorProxyTO.getAutenticaServidorProxy() != false ? HABILITADO : DESABILITADO);
            this.getUtilArquivoConfiguracao().salvar();
        }
        catch (Exception e) {
            throw new BBException("Erro ao salvar configura\u00e7\u00e3o do proxy.");
        }
    }

    public DadosServidorProxyTO recupera() throws BBException {
        try {
            DadosServidorProxyTO dadosServidorProxyTO = new DadosServidorProxyTO();
            UtilArquivoConfiguracao util = this.getUtilArquivoConfiguracao();
            dadosServidorProxyTO.setServidorProxy(util.getValorPropertie("servidor.proxy"));
            dadosServidorProxyTO.setPortaServidorProxy(util.getValorPropertie("porta.servidor.proxy"));
            dadosServidorProxyTO.setUsaServidorProxy(HABILITADO.equalsIgnoreCase(util.getValorPropertie("usa.servidor.proxy")));
            dadosServidorProxyTO.setAutenticaServidorProxy(HABILITADO.equalsIgnoreCase(util.getValorPropertie("autentica.servidor.proxy")));
            return dadosServidorProxyTO;
        }
        catch (Exception e) {
            throw new BBException("Erro ao recuperar configura\u00e7\u00e3o do proxy.");
        }
    }
}

