/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.integracao.dao.controle.ServicoAplicacaoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ServicoTODecorator;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.politec.generico.calculadores.UtilSomadoresDeData;
import br.com.politec.generico.fabrica.DataFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurarExpurgoModel
extends PluginModelAbstrato {
    private ServicoDAO servicoDAO;
    private ServicoAplicacaoDAO servicoAplicacaoDAO;

    public ServicoTO listar(ServicoTO servicoTO) {
        return this.getServicoDAO().listar(servicoTO);
    }

    public ServicoTODecorator filtrarData(ServicoTODecorator servicoTODecorator) {
        ServicoTO servicoTO = servicoTODecorator.getServicoTO();
        servicoTO.setTextoIdentificadorServico("DBT");
        servicoTO = this.getServicoDAO().listar(servicoTO);
        servicoTODecorator.setServicoTO(servicoTO);
        Date dataInicio = UtilSomadoresDeData.adicionarDias(servicoTO.getDataExecucaoUltimoExpurgo(), -servicoTO.getNumeroDiasRetencaoDados());
        servicoTODecorator.setDataInicioExpurgo(dataInicio);
        Date dataFim = UtilSomadoresDeData.adicionarDias(this.getDataAtual(), -servicoTO.getNumeroDiasRetencaoDados());
        servicoTODecorator.setDataFimExpurgo(dataFim);
        return servicoTODecorator;
    }

    public List<ServicoTO> consultarListaDeServicosTO(List<Plugin> listaDeAplicationsInstalados) {
        ArrayList<ServicoTO> listaDeServicoTOInstalados = new ArrayList<ServicoTO>();
        for (Plugin plugin : listaDeAplicationsInstalados) {
            ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
            servicoTO.setTextoIdentificadorServico(plugin.getNome());
            listaDeServicoTOInstalados.add(this.listar(servicoTO));
        }
        Plugin pluginDefault = new Plugin();
        pluginDefault.setNome("GAC");
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        servicoTO.setTextoIdentificadorServico(pluginDefault.getNome());
        listaDeServicoTOInstalados.add(this.listar(servicoTO));
        return listaDeServicoTOInstalados;
    }

    public void alterar(ServicoTO servicoTO) {
        this.getServicoDAO().alterar(servicoTO);
    }

    public void atualizarExpurgo(HashMap<String, ServicoTO> lista) throws BBException {
        this.getServicoAplicacaoDAO().atualizarExpurgo(lista);
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public ServicoAplicacaoDAO getServicoAplicacaoDAO() {
        if (this.servicoAplicacaoDAO == null) {
            this.servicoAplicacaoDAO = new ServicoAplicacaoDAO();
        }
        return this.servicoAplicacaoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    private Date getDataAtual() {
        return DataFactory.getInstance().novoDate();
    }
}

