/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivo;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivoFactory;
import br.com.bb.plugins.gac.util.parserarquivo.ParserArquivoFactory;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.string.UtilString;
import java.io.File;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsultarRemessaPendenteModel
extends PluginModelAbstrato {
    private RemessaDAO remessaDAO;
    private ServicoDAO servicoDAO;
    private IParserArquivo parserArquivo;

    public List<RemessaTODecorator> listar() throws BBException {
        List listaRetorno = this.getColecaoFactory().novoArrayList();
        File[] listaArquivoPastaRemessa = this.processaRecuperarRemessa();
        if (this.isReferencia(listaArquivoPastaRemessa)) {
            int i = 0;
            while (i < listaArquivoPastaRemessa.length) {
                this.setParserArquivo(this.getParserArquivoFactory().novoParserArquivo(listaArquivoPastaRemessa[i]));
                RemessaTODecorator remessaTODecorator = this.criarRemessaTO();
                Collection<RemessaTO> listaRemessa = this.consultarRemessa(remessaTODecorator);
                RemessaTO unicaRemessaLista = this.getUnicaRemessaLista(listaRemessa);
                if (this.isReferencia(unicaRemessaLista) && this.isArquivoTipoServicoInstalado()) {
                    remessaTODecorator.setServicoTO(this.consultarServico(unicaRemessaLista));
                    remessaTODecorator.setRemessaTO(unicaRemessaLista);
                    listaRetorno.add(remessaTODecorator);
                }
                ++i;
            }
        }
        return listaRetorno;
    }

    private boolean isArquivoTipoServicoInstalado() throws BBException {
        boolean retorno = false;
        for (Plugin plugin : this.recuperaServicosInstalados()) {
            if (!this.getIdentificadorServico().equalsIgnoreCase(plugin.getNome())) continue;
            retorno = true;
        }
        return retorno;
    }

    private List<Plugin> recuperaServicosInstalados() {
        return PluginController.getInstance().getPlugins();
    }

    private IParserArquivoFactory getParserArquivoFactory() {
        return ParserArquivoFactory.getInstancia();
    }

    private ServicoTO consultarServico(RemessaTO unicaRemessaLista) {
        return (ServicoTO)((Object)this.getServicoDAO().listar(unicaRemessaLista.getConvenioTO().getId().getTextoIdentificadorServico()));
    }

    private Collection<RemessaTO> consultarRemessa(RemessaTODecorator remessaTO) {
        return this.getRemessaDAO().consultarPelaRemessaConvenioEServico(remessaTO);
    }

    private RemessaTO getUnicaRemessaLista(Collection<RemessaTO> listaRemessa) {
        return (RemessaTO)UtilColecao.getElementoDoIndice(listaRemessa, 0);
    }

    private RemessaTODecorator criarRemessaTO() throws BBException {
        RemessaTODecorator to = this.getFabricaDeTO().novoRemessaTODecorator();
        to.setNumeroConvenio(this.getCodigoConvenio());
        to.setNumeroRemessa(this.getCodigoSequencial());
        to.setTextoIdentificadorServico(this.getIdentificadorServico());
        return to;
    }

    private String getIdentificadorServico() throws BBException {
        return this.subString(this.getParserArquivo().getValorDoCabecalhoString("Debito"), 0, 3);
    }

    private Integer getCodigoSequencial() throws BBException {
        Object obj = this.getParserArquivo().getValorDoCabecalho("SequencialArq");
        Integer retorno = null;
        Long tempLong = null;
        if (obj instanceof Integer) {
            retorno = (Integer)obj;
        } else if (obj instanceof Long) {
            tempLong = (Long)obj;
            retorno = new Integer(tempLong.intValue());
        } else {
            retorno = null;
        }
        return retorno;
    }

    private Integer getCodigoConvenio() throws BBException {
        return this.converterParaInteger(this.getParserArquivo().getValorDoCabecalhoString("Convenio"));
    }

    private Integer converterParaInteger(String valor) {
        return UtilConversorDeInteger.converterParaInteger(valor);
    }

    private String subString(String string, int inicio, int fim) {
        return UtilString.substring(string, inicio, fim);
    }

    private File[] processaRecuperarRemessa() {
        UtilArquivoConfiguracao instanciaUtilArquivoConfiguraca = this.getInstanciaUtilArquivoConfiguraca();
        String diretorioRemessa = this.getDiretorioRemessa(instanciaUtilArquivoConfiguraca);
        File file = this.getPastaRemessa(diretorioRemessa);
        File[] listaArquivoPastaRemessa = file.listFiles();
        return listaArquivoPastaRemessa;
    }

    private File getPastaRemessa(String diretorioRemessa) {
        return new File(diretorioRemessa);
    }

    private String getDiretorioRemessa(UtilArquivoConfiguracao instanciaUtilArquivoConfiguraca) {
        return instanciaUtilArquivoConfiguraca.getValorPropertie("diretorio.remessa");
    }

    private UtilArquivoConfiguracao getInstanciaUtilArquivoConfiguraca() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public IParserArquivo getParserArquivo() {
        return this.parserArquivo;
    }

    public void setParserArquivo(IParserArquivo parserArquivo) {
        this.parserArquivo = parserArquivo;
    }
}

