/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.integracao.dao.ComplementoPessoaFisicaDAO;
import br.com.bb.plugins.gac.integracao.dao.ComplementoPessoaJuridicaDAO;
import br.com.bb.plugins.gac.integracao.dao.LeiauteDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.negocio.model.ManterLeiauteArquivoImportacaoModel;
import br.com.bb.plugins.gac.negocio.model.ManterTipoLeiauteModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ExportarDadosExternoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.LeiauteTODecorator;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.dominio.UtilDominioCamposDeLeiaute;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeCharacter;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportarCadastroModel
extends PluginModelAbstrato {
    private static final String ESPACO_BRANCO = " ";
    private static final String ZERO = "0";
    private static final String CADASTRO_GAC = "CadastroGAC";
    private static final String PONTO = ".";
    private static final String TXT = "txt";
    private ManterTipoLeiauteModel manterTipoLeiauteModel;
    private ManterLeiauteArquivoImportacaoModel manterLeiauteModel;
    private LeiauteDAO leiauteDao;
    private ComplementoPessoaFisicaDAO complementoPessoaFisicaDAO;
    private ComplementoPessoaJuridicaDAO complementoPessoaJuridicaDAO;
    private PessoaDAO pessoaDAO;
    private Map<String, String> mapaCampos;
    private LeiauteTO leiauteTO;
    private ComplementoPessoaFisicaTO pessoaFisicaTO;
    private ComplementoPessoaJuridicaTO pessoaJuridicaTO;
    private PessoaTO pessoaTO;

    public ManterTipoLeiauteModel getManterTipoLeiauteModel() {
        return this.manterTipoLeiauteModel;
    }

    public void setManterTipoLeiauteModel(ManterTipoLeiauteModel manterTipoLeiauteModel) {
        this.manterTipoLeiauteModel = manterTipoLeiauteModel;
    }

    public Collection<TipoLeiauteTO> consultarTipoLeiauteExportacaoGAC() {
        return this.getManterTipoLeiauteModel().consultarExportacaoGAC();
    }

    public Collection<LeiauteTO> consultarLeiaute(ExportarDadosExternoTODecorator exportarDadosExternoTODecorator) {
        LeiauteTO leiauteTO = this.getFabricaDeTO().novoLeiauteTO();
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        servicoTO.setTextoIdentificadorServico("GAC");
        leiauteTO.setTipoLeiauteTO(exportarDadosExternoTODecorator.getTipoLeiauteTO());
        leiauteTO.setServicoTO(servicoTO);
        LeiauteTODecorator leiauteTODecorator = this.getFabricaDeTO().novoLeiauteTODecorator(leiauteTO);
        leiauteTODecorator.setPaginaAtual(0);
        PaginadorTO paginadorTO = this.getLeiauteDao().consultarPorTipoServicoSemTemplate(leiauteTODecorator);
        return paginadorTO.getColecaoDeRegistros();
    }

    public LeiauteDAO getLeiauteDao() {
        return this.leiauteDao;
    }

    public void setLeiauteDao(LeiauteDAO leiauteDao) {
        this.leiauteDao = leiauteDao;
    }

    public ComplementoPessoaFisicaDAO getComplementoPessoaFisicaDAO() {
        return this.complementoPessoaFisicaDAO;
    }

    public void setComplementoPessoaFisicaDAO(ComplementoPessoaFisicaDAO complementoPessoaFisicaDAO) {
        this.complementoPessoaFisicaDAO = complementoPessoaFisicaDAO;
    }

    public ComplementoPessoaJuridicaDAO getComplementoPessoaJuridicaDAO() {
        return this.complementoPessoaJuridicaDAO;
    }

    public void setComplementoPessoaJuridicaDAO(ComplementoPessoaJuridicaDAO complementoPessoaJuridicaDAO) {
        this.complementoPessoaJuridicaDAO = complementoPessoaJuridicaDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    protected String montarStringPessoa() {
        StringBuffer retorno = new StringBuffer();
        this.leiauteTO.getCamposLeiauteTOs();
        for (CamposLeiauteTO camposLeiauteTO : this.getLeiauteTO().getCamposLeiauteTOs()) {
            String valorCampo = this.getMapaCampos().get(camposLeiauteTO.getTextoNomeCampo());
            if (retorno.length() != 0) {
                while (retorno.length() + 1 < camposLeiauteTO.getNumeroPosicaoInicio()) {
                    retorno.insert(retorno.length(), ESPACO_BRANCO.toCharArray());
                }
            }
            if (UtilDominioCamposDeLeiaute.getInstancia().getFormato(camposLeiauteTO) == UtilDominioCamposDeLeiaute.ALFANUMERICO) {
                retorno.append(this.completarADireita(valorCampo, camposLeiauteTO));
                continue;
            }
            retorno.append(this.completarAEsquerda(valorCampo, camposLeiauteTO));
        }
        return retorno.toString();
    }

    public boolean exportar(ExportarDadosExternoTODecorator exportarDadosExternoTODecorator) throws BBException {
        boolean retorno = false;
        this.setLeiauteTO(exportarDadosExternoTODecorator.getLeiauteTO());
        File destinodir = new File(exportarDadosExternoTODecorator.getDestinoArquivoGerado());
        Collection<PessoaTO> colecaoPessoa = this.consultarPessoa();
        int totalRegistros = colecaoPessoa.size();
        Date data = Calendar.getInstance().getTime();
        String dataFormatada = UtilFormatadorDeData.formatar_ddMMyyyy(data);
        dataFormatada = dataFormatada.replaceAll("/", "");
        String destino = destinodir.getAbsolutePath();
        String formato = String.valueOf(destino) + "/" + CADASTRO_GAC + PONTO + dataFormatada + PONTO + TXT;
        formato = formato.replaceAll("\\\\", "/");
        exportarDadosExternoTODecorator.setNomeArquivoGerado(formato);
        int numeroRegistros = 0;
        try {
            File file = new File(formato);
            if (destinodir.isDirectory()) {
                FileWriter fileWriter = new FileWriter(file);
                for (PessoaTO pessoaTO : colecaoPessoa) {
                    PessoaTO to;
                    System.out.println(pessoaTO.getTextoNome());
                    this.setPessoaTO(pessoaTO);
                    if (pessoaTO.getTipoPessoaTO().getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CPF_PF.intValue()) {
                        to = (ComplementoPessoaFisicaTO)((Object)this.getComplementoPessoaFisicaDAO().listar(pessoaTO.getCodigoPessoa()));
                        this.setPessoaFisicaTO((ComplementoPessoaFisicaTO)to);
                    } else if (pessoaTO.getTipoPessoaTO().getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CNPJ_PJ.intValue()) {
                        to = (ComplementoPessoaJuridicaTO)((Object)this.getComplementoPessoaJuridicaDAO().listar(pessoaTO.getCodigoPessoa()));
                        this.setPessoaJuridicaTO((ComplementoPessoaJuridicaTO)to);
                    }
                    fileWriter.write(String.valueOf(this.montarStringPessoa()) + '\n');
                    this.atualizaPorcentagem(exportarDadosExternoTODecorator.getNotificaExportacao(), totalRegistros, ++numeroRegistros);
                }
                fileWriter.flush();
                fileWriter.close();
                retorno = true;
            } else {
                retorno = false;
            }
        }
        catch (IOException e) {
            throw UtilBBException.getErroDeSistema(e);
        }
        return retorno;
    }

    private Map<String, String> getMapaCampos() {
        this.mapaCampos = ColecaoFactory.getInstance().novoHashMap();
        this.mapaCampos.put("TX_NM", this.retornaNaoNulo(this.getPessoaTO().getTextoNome()));
        this.retornaUmMapDoTipoPessoaTO();
        this.retornaUmMapDoTipoLogradouroTO();
        this.retornaUmMapDoTipoPessoaFisicaTO();
        this.retornaUmMapDoTipoIdentificacaoTO();
        if (this.getLogradouroTO().getTipoLogradouroTO() == null) {
            this.mapaCampos.put("CD_TIP_LGR", "");
        } else {
            this.mapaCampos.put("CD_TIP_LGR", UtilConversorDeInteger.converterParaString(this.getLogradouroTO().getTipoLogradouroTO().getCodigoTipoLogradouro()));
        }
        return this.mapaCampos;
    }

    private String retornaNaoNulo(String valorCampo) {
        return valorCampo == null ? "" : valorCampo;
    }

    private int getTipoPessoa() {
        if (this.getPessoaTO() == null || this.getPessoaTO().getTipoPessoaTO() == null || this.getPessoaTO().getTipoPessoaTO().getCodigoTipoPessoa() == null) {
            return 0;
        }
        return this.getPessoaTO().getTipoPessoaTO().getCodigoTipoPessoa();
    }

    private String getTextoIdentificao(Integer codigoTipoDoc) {
        String textoIdenfificacao = "";
        Set<IdentificacaoTO> colecaoIdentificacao = null;
        if (this.getTipoPessoa() == 1) {
            if (this.getPessoaFisicaTO() == null) {
                return "";
            }
            colecaoIdentificacao = this.getPessoaFisicaTO().getIdentificacaoTOs();
        } else if (this.isReferencia(this.getPessoaJuridicaTO())) {
            colecaoIdentificacao = this.getPessoaJuridicaTO().getIdentificacaoTOs();
        }
        if (colecaoIdentificacao != null) {
            for (IdentificacaoTO identificacaoTO : colecaoIdentificacao) {
                if (identificacaoTO.getTipoDocumentoTO().getCodigoTipoDocumento().intValue() != codigoTipoDoc.intValue()) continue;
                textoIdenfificacao = this.retornaNaoNulo(identificacaoTO.getId().getTextoIdentificacao());
                break;
            }
        }
        return textoIdenfificacao;
    }

    protected void retornaUmMapDoTipoPessoaTO() {
        this.mapaCampos.put("CD_TIP_DOC", "" + this.getTipoPessoa());
        this.mapaCampos.put("TX_IDFC", this.getTextoIdentificao(this.getTipoPessoa() == UtilDominioTipoDocumento.CPF_PF.intValue() ? UtilDominioTipoDocumento.CPF_PF : UtilDominioTipoDocumento.CNPJ_PJ));
        this.mapaCampos.put("TX_LGR", this.retornaNaoNulo(this.getLogradouroTO().getTextoLogradouro()));
    }

    protected void retornaUmMapDoTipoLogradouroTO() {
        this.mapaCampos.put("TX_BAI", this.retornaNaoNulo(this.getLogradouroTO().getTextoBairro()));
        this.mapaCampos.put("TX_CID", this.retornaNaoNulo(this.getLogradouroTO().getTextoCidade()));
        this.mapaCampos.put("TX_CEP", this.retornaNaoNulo(this.getLogradouroTO().getTextoCep()));
    }

    protected void retornaUmMapDoTipoIdentificacaoTO() {
        this.mapaCampos.put("TX_IDFC_NR_BENEF", this.getTextoIdentificao(UtilDominioTipoDocumento.NUMERO_BENEFICIO_PF));
        this.mapaCampos.put("TX_IDFC_PISPASEP", this.getTextoIdentificao(UtilDominioTipoDocumento.PIS_PF));
        this.mapaCampos.put("TX_IDFC_NIT", this.getTextoIdentificao(UtilDominioTipoDocumento.NIT_PF));
        if (this.getTipoPessoa() == UtilDominioTipoDocumento.CPF_PF.intValue()) {
            this.mapaCampos.put("TX_IDFC_CEI", this.getTextoIdentificao(UtilDominioTipoDocumento.CEI_PF));
            this.mapaCampos.put("TX_IDFC_REF", this.getTextoIdentificao(UtilDominioTipoDocumento.REFERENCIA_PF));
            this.mapaCampos.put("TX_IDFC_DEBCAD", this.getTextoIdentificao(UtilDominioTipoDocumento.DEBCAD_PF));
            this.mapaCampos.put("TX_IDFC_TIT_COB", this.getTextoIdentificao(UtilDominioTipoDocumento.TITULO_COBRANCA_PF));
        } else {
            this.mapaCampos.put("TX_IDFC_CEI", this.getTextoIdentificao(UtilDominioTipoDocumento.CEI_PJ));
            this.mapaCampos.put("TX_IDFC_REF", this.getTextoIdentificao(UtilDominioTipoDocumento.REFERENCIA_PJ));
            this.mapaCampos.put("TX_IDFC_DEBCAD", this.getTextoIdentificao(UtilDominioTipoDocumento.DEBCAD_PJ));
            this.mapaCampos.put("TX_IDFC_TIT_COB", this.getTextoIdentificao(UtilDominioTipoDocumento.TITULO_COBRANCA_PJ));
        }
    }

    protected void retornaUmMapDoTipoPessoaFisicaTO() {
        if (this.getTipoPessoa() == UtilDominioTipoDocumento.CPF_PF.intValue()) {
            this.mapaCampos.put("TX_SG_UF_END", this.getPessoaFisicaTO().getUnidadeFederativaBrasilTO() == null ? "" : this.retornaNaoNulo(this.getPessoaFisicaTO().getUnidadeFederativaBrasilTO().getTextoSiglaUf()));
            this.mapaCampos.put("CD_NCLD", this.retornaNaoNulo(this.getPessoaFisicaTO().getNacionalidadeTO().getCodigoNacionalidade().toString()));
            this.mapaCampos.put("TX_NTLD", this.retornaNaoNulo(this.getPessoaFisicaTO().getTextoNaturalidade()));
            this.mapaCampos.put("TX_SG_UF_NASC", this.getPessoaFisicaTO().getUnidadeFederativaBrasilTO() == null ? "" : this.retornaNaoNulo(this.getPessoaFisicaTO().getUnidadeFederativaBrasilTO().getTextoSiglaUf()));
        } else {
            this.mapaCampos.put("TX_SG_UF_END", "");
            this.mapaCampos.put("CD_NCLD", "");
            this.mapaCampos.put("TX_NTLD", "");
            this.mapaCampos.put("TX_SG_UF_NASC", "");
        }
    }

    protected String completarADireita(String srcString, CamposLeiauteTO camposLeiauteTO) {
        StringBuffer stringBuffer = new StringBuffer();
        if (srcString == null) {
            srcString = "";
        }
        stringBuffer.append(srcString);
        while (stringBuffer.length() < camposLeiauteTO.getNumeroTamanhoCampo()) {
            stringBuffer.insert(stringBuffer.length(), ESPACO_BRANCO.toCharArray());
        }
        return stringBuffer.substring(0, camposLeiauteTO.getNumeroTamanhoCampo());
    }

    protected String completarAEsquerda(String srcString, CamposLeiauteTO camposLeiauteTO) {
        StringBuffer stringBuffer = new StringBuffer();
        if (srcString == null) {
            srcString = "";
        }
        stringBuffer.append(srcString);
        while (stringBuffer.length() < camposLeiauteTO.getNumeroTamanhoCampo()) {
            stringBuffer.insert(0, ZERO.toCharArray());
        }
        return stringBuffer.substring(0, camposLeiauteTO.getNumeroTamanhoCampo());
    }

    protected LogradouroTO getLogradouroTO() {
        Set<LogradouroTO> colecao = this.getTipoPessoa() == 1 ? (this.getPessoaFisicaTO() != null ? this.getPessoaFisicaTO().getLogradouroTOs() : null) : (this.getPessoaJuridicaTO() != null ? this.getPessoaJuridicaTO().getLogradouroTOs() : null);
        LogradouroTO retorno = TOFactory.getInstancia().novoLogradouroTO();
        if (!UtilColecao.isVazio(colecao)) {
            retorno = colecao.iterator().next();
        }
        return retorno;
    }

    private void atualizaPorcentagem(UtilNotificador notificaExportacao, int totalRegistros, int numeroLinha) {
        int porcentagem = numeroLinha * 100 / totalRegistros;
        notificaExportacao.notifyObservers(porcentagem);
    }

    public Collection<PessoaTO> consultarPessoa() throws BBException {
        return this.getPessoaDAO().consultarOrdenadoPorNome();
    }

    public Collection<LeiauteTO> recuperarLeiaute(LeiauteTO to) {
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        to.setServicoTO(servicoTO);
        to.setIndicadorLeiauteModelo(UtilConversorDeCharacter.converterParaCharacter("1"));
        to.getServicoTO().setTextoIdentificadorServico("GAC");
        return this.getLeiauteDao().consultarPeloServico(to);
    }

    public LeiauteTO getLeiauteTO() {
        return this.leiauteTO;
    }

    public void setLeiauteTO(LeiauteTO leiauteTO) {
        this.leiauteTO = leiauteTO;
    }

    public ComplementoPessoaFisicaTO getPessoaFisicaTO() {
        return this.pessoaFisicaTO;
    }

    public void setPessoaFisicaTO(ComplementoPessoaFisicaTO pessoaFisicaTO) {
        this.pessoaFisicaTO = pessoaFisicaTO;
    }

    public ComplementoPessoaJuridicaTO getPessoaJuridicaTO() {
        return this.pessoaJuridicaTO;
    }

    public void setPessoaJuridicaTO(ComplementoPessoaJuridicaTO pessoaJuridicaTO) {
        this.pessoaJuridicaTO = pessoaJuridicaTO;
    }

    public PessoaTO getPessoaTO() {
        return this.pessoaTO;
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.pessoaTO = pessoaTO;
    }

    public void setMapaCampos(Map<String, String> mapaCampos) {
        this.mapaCampos = mapaCampos;
    }
}

