/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.excecao.RegistroRejeitadoException;
import br.com.bb.plugins.gac.factory.ModelFactory;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.factory.ValidadorFactory;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoDocumentoDAO;
import br.com.bb.plugins.gac.negocio.model.ManterCadastroPessoaFisicaModel;
import br.com.bb.plugins.gac.negocio.model.ManterCadastroPessoaJuridicaModel;
import br.com.bb.plugins.gac.negocio.model.ManterIdentificacaoModel;
import br.com.bb.plugins.gac.negocio.model.ManterLeiauteArquivoImportacaoModel;
import br.com.bb.plugins.gac.negocio.model.ManterTipoLeiauteModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.NacionalidadeTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.TipoLogradouroTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.UnidadeFederativaBrasilTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ImportarDadosExternoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RegistroRejeitadoTODecorator;
import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.dominio.UtilDominioCamposDeLeiaute;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeNumeroNoPeriodo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportarDadosExternoModel
extends PluginModelAbstrato {
    private ManterTipoLeiauteModel manterTipoLeiauteModel;
    private ManterLeiauteArquivoImportacaoModel manterLeiauteArquivoImportacaoModel;
    private Map<String, String> mapaValorCampo;
    private Map<String, CamposLeiauteTO> mapaCamposLeiauteTO;
    private PessoaTO pessoaTO;
    private TipoDocumentoDAO tipoDocumentoDAO;
    private Collection<RegistroRejeitadoTODecorator> colecaoRegistroRejeitadoTO;
    private ManterCadastroPessoaJuridicaModel manterCadastroPessoaJuridicaModel;
    private ManterCadastroPessoaFisicaModel manterCadastroPessoaFisicaModel;
    private ConvenentePessoaDAO convenentePessoaDAO;
    private Collection<UnidadeFederativaBrasilTO> colecaoUnidadeFederativaBrasilTO;
    private ManterIdentificacaoModel manterIdentificacaoModel;

    public TipoDocumentoDAO getTipoDocumentoDAO() {
        return this.tipoDocumentoDAO;
    }

    public void setTipoDocumentoDAO(TipoDocumentoDAO tipoDocumentoDAO) {
        this.tipoDocumentoDAO = tipoDocumentoDAO;
    }

    protected PessoaTO getPessoaTO() {
        if (this.pessoaTO == null) {
            this.pessoaTO = this.getFabricaDeTO().novoPessoaTO();
        }
        return this.pessoaTO;
    }

    protected void setPessoaTO(PessoaTO pessoaTO) {
        this.pessoaTO = pessoaTO;
    }

    public Collection<TipoLeiauteTO> consultarTipoLeiauteImportacao(ImportarDadosExternoTODecorator importarDadosExternoTODecorator) {
        String servico = importarDadosExternoTODecorator.getServico();
        Collection<TipoLeiauteTO> retorno = null;
        retorno = "DBT".equals(servico) ? this.getManterTipoLeiauteModel().consultarImportacaoDBT() : this.getManterTipoLeiauteModel().consultarImportacaoGAC();
        return retorno;
    }

    public ManterTipoLeiauteModel getManterTipoLeiauteModel() {
        return this.manterTipoLeiauteModel;
    }

    public void setManterTipoLeiauteModel(ManterTipoLeiauteModel manterTipoLeiauteModel) {
        this.manterTipoLeiauteModel = manterTipoLeiauteModel;
    }

    public Collection<LeiauteTO> consultarLeiaute(ImportarDadosExternoTODecorator importarDadosExternoTODecorato) {
        Collection<LeiauteTO> retorno = null;
        String servico = importarDadosExternoTODecorato.getServico();
        TipoLeiauteTO tipoLeiauteTO = TOFactory.getInstancia().novoTipoLeiauteTO();
        tipoLeiauteTO.setTextoTipoOperacao("IMPORTACAO");
        importarDadosExternoTODecorato.setTipoLeiauteTO(tipoLeiauteTO);
        retorno = "DBT".equals(servico) ? this.getManterLeiauteArquivoImportacaoModel().consultarDBT(importarDadosExternoTODecorato) : this.getManterLeiauteArquivoImportacaoModel().consultarGAC(importarDadosExternoTODecorato);
        return retorno;
    }

    public ManterLeiauteArquivoImportacaoModel getManterLeiauteArquivoImportacaoModel() {
        return this.manterLeiauteArquivoImportacaoModel;
    }

    public void setManterLeiauteArquivoImportacaoModel(ManterLeiauteArquivoImportacaoModel manterLeiauteArquivoImportacaoModel) {
        this.manterLeiauteArquivoImportacaoModel = manterLeiauteArquivoImportacaoModel;
    }

    public void importar(ImportarDadosExternoTODecorator importarDadosExternoTODecorator) throws BBException {
        File file = importarDadosExternoTODecorator.getArquivo();
        LeiauteTO leiauteTO = importarDadosExternoTODecorator.getLeiauteTO();
        Set<CamposLeiauteTO> colecaoCamposLeiauteTO = leiauteTO.getCamposLeiauteTOs();
        BufferedReader bufferedReader = null;
        this.colecaoRegistroRejeitadoTO = null;
        int totalRegistros = 0;
        int totalAux = 0;
        String linha = null;
        int numeroLinha = 0;
        try {
            try {
                totalRegistros = this.getNumeroDeRegistros(file);
                bufferedReader = UtilArquivo.getBufferedReader(file);
                totalAux = totalRegistros;
                while (totalAux != 0) {
                    linha = bufferedReader.readLine();
                    if (linha != null && linha.trim().length() > 0) {
                        ++numeroLinha;
                        try {
                            try {
                                this.inicializaValores();
                                this.criaMapaDeValores(colecaoCamposLeiauteTO, linha);
                                this.validaRegistro(colecaoCamposLeiauteTO, linha);
                                this.criaPessoaTO();
                                this.incluiPessoaTO();
                            }
                            catch (RegistroRejeitadoException e) {
                                e.getRegistroRejeitadoTODecorator().setNumeroRegistro(numeroLinha);
                                this.getColecaoRegistroRejeitadoTO().add(e.getRegistroRejeitadoTODecorator());
                                this.atualizaPorcentagem(importarDadosExternoTODecorator.getNotificaImportacao(), totalRegistros, numeroLinha);
                                --totalAux;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            this.atualizaPorcentagem(importarDadosExternoTODecorator.getNotificaImportacao(), totalRegistros, numeroLinha);
                            --totalAux;
                            throw throwable;
                        }
                        this.atualizaPorcentagem(importarDadosExternoTODecorator.getNotificaImportacao(), totalRegistros, numeroLinha);
                        --totalAux;
                        continue;
                    }
                    --totalRegistros;
                    --totalAux;
                }
            }
            catch (IOException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
            catch (Exception e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        Collection<RegistroRejeitadoTODecorator> colecaoRegistroRejeitadoTODecorator = this.getColecaoRegistroRejeitadoTO();
        int numeroRegistrosRejeitados = colecaoRegistroRejeitadoTODecorator.size();
        importarDadosExternoTODecorator.setNumeroRegistrosImportados(totalRegistros - numeroRegistrosRejeitados);
        importarDadosExternoTODecorator.setNumeroRegistrosRejeitados(numeroRegistrosRejeitados);
        importarDadosExternoTODecorator.setColecaoRegistroRejeitadoTODecorator(colecaoRegistroRejeitadoTODecorator);
    }

    protected void atualizaPorcentagem(UtilNotificador notificaImportacao, int totalRegistros, int numeroLinha) {
        int porcentagem = numeroLinha * 100 / totalRegistros;
        notificaImportacao.notifyObservers(porcentagem);
    }

    protected void validaRegistro(Set<CamposLeiauteTO> colecaoCamposLeiauteTO, String linha) throws RegistroRejeitadoException {
        this.validaTamanhoDosCampos(colecaoCamposLeiauteTO, linha);
        this.validaObrigatoriedadeDosCampos(colecaoCamposLeiauteTO);
        this.validaTipoInscricao();
        this.validaCPF();
        this.validaCNPJ();
        this.validaNacionalidade();
        this.validaTipoLogradouro();
        this.validaUF();
        this.validaCEI();
        this.validaNB();
        this.validaReferencia();
        this.validaPISPASEP();
        this.validaNIT();
        this.validaDEBCAD();
        this.validaTituloCobranca();
        this.validaInscricao();
    }

    protected void validaTamanhoDosCampos(Set<CamposLeiauteTO> colecaoCamposLeiauteTO, String linha) throws RegistroRejeitadoException {
        for (CamposLeiauteTO camposLeiauteTO : colecaoCamposLeiauteTO) {
            int inicio = camposLeiauteTO.getNumeroPosicaoInicio() - 1;
            int fim = inicio + camposLeiauteTO.getNumeroTamanhoMaximo();
            String valor = "";
            try {
                if (UtilString.isVazio(linha)) continue;
                valor = linha.substring(inicio, fim);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new RegistroRejeitadoException("tamanho.invalido", camposLeiauteTO, valor);
            }
        }
    }

    protected void validaObrigatoriedadeDosCampos(Set<CamposLeiauteTO> colecaoCamposLeiauteTO) throws RegistroRejeitadoException {
        for (CamposLeiauteTO camposLeiauteTO : colecaoCamposLeiauteTO) {
            String valor = this.getMapaValorCampo().get(camposLeiauteTO.getTextoNomeCampo());
            Boolean valido = UtilDominioCamposDeLeiaute.getInstancia().isCampoObrigatorio(camposLeiauteTO);
            if (valido == null || !valido.booleanValue() || !UtilString.isVazio(valor)) continue;
            throw new RegistroRejeitadoException("obrigatoriedade.invalida", camposLeiauteTO, valor);
        }
    }

    protected void validaCPF() throws RegistroRejeitadoException {
        String tipoDeInscricao = this.getMapaValorCampo().get("CD_TIP_DOC");
        Integer codigoTipoDocumento = UtilConversorDeInteger.converterParaInteger(tipoDeInscricao);
        if (codigoTipoDocumento.intValue() == UtilDominioTipoDocumento.CPF_PF.intValue()) {
            String inscricao = this.getMapaValorCampo().get("TX_IDFC");
            while (inscricao.length() > 11) {
                inscricao = inscricao.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC", inscricao);
            if (codigoTipoDocumento != null && !CalculaDigitoVerificador.verificarCPF(inscricao)) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC"), inscricao);
            }
        }
    }

    protected void validaNacionalidade() throws RegistroRejeitadoException {
        String nacionalidade = this.getMapaValorCampo().get("CD_NCLD");
        int codigoNacionalidade = UtilConversorDeInteger.converterParaPrimitivo(nacionalidade);
        if (!UtilString.isVazio(nacionalidade) && !UtilValidadorDeNumeroNoPeriodo.validar(codigoNacionalidade, 1, 5)) {
            throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("CD_NCLD"), nacionalidade);
        }
    }

    protected void validaTipoLogradouro() throws RegistroRejeitadoException {
        String tipoLogradouro = this.getMapaValorCampo().get("CD_TIP_LGR");
        int codigoTipoLogradouro = UtilConversorDeInteger.converterParaPrimitivo(tipoLogradouro);
        if (!UtilValidadorDeNumeroNoPeriodo.validar(codigoTipoLogradouro, 1, 5)) {
            throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("CD_TIP_LGR"), tipoLogradouro);
        }
    }

    protected void validaCNPJ() throws RegistroRejeitadoException {
        String tipoDeInscricao = this.getMapaValorCampo().get("CD_TIP_DOC");
        Integer codigoTipoDocumento = UtilConversorDeInteger.converterParaInteger(tipoDeInscricao);
        String inscricao = this.getMapaValorCampo().get("TX_IDFC");
        if (codigoTipoDocumento != null && codigoTipoDocumento.equals(UtilDominioTipoDocumento.CNPJ_PJ) && !CalculaDigitoVerificador.verificarCNPJ(inscricao)) {
            throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC"), inscricao);
        }
    }

    protected void validaUF() throws RegistroRejeitadoException {
        boolean achouUfNascimento;
        String ufEndereco = this.getMapaValorCampo().get("TX_SG_UF_END");
        String ufNascimento = this.getMapaValorCampo().get("TX_SG_UF_NASC");
        boolean pesquisaUfEndereco = ufEndereco != null && ufEndereco.trim().length() > 0;
        boolean pesquisaUfNascimento = ufNascimento != null && ufNascimento.trim().length() > 0;
        boolean achouUfEndereco = !pesquisaUfEndereco;
        boolean bl = achouUfNascimento = !pesquisaUfNascimento;
        if (pesquisaUfEndereco || pesquisaUfNascimento) {
            for (UnidadeFederativaBrasilTO unidadeFederativaBrasilTO : this.getColecaoUnidadeFederativaBrasilTO()) {
                if (pesquisaUfEndereco && !achouUfEndereco) {
                    achouUfEndereco = unidadeFederativaBrasilTO.getTextoSiglaUf().equals(ufEndereco);
                }
                if (pesquisaUfNascimento && !achouUfNascimento) {
                    achouUfNascimento = unidadeFederativaBrasilTO.getTextoSiglaUf().equals(ufNascimento);
                }
                if (achouUfEndereco && achouUfNascimento) break;
            }
            if (pesquisaUfEndereco && !achouUfEndereco) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_SG_UF_END"), ufEndereco);
            }
            if (pesquisaUfNascimento && !achouUfNascimento) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_SG_UF_NASC"), ufNascimento);
            }
        }
    }

    protected void validaDEBCAD() throws RegistroRejeitadoException {
        String debcad = this.getMapaValorCampo().get("TX_IDFC_DEBCAD");
        if (debcad != null && debcad.trim().length() > 0 && this.direferenteZero(debcad)) {
            while (debcad.length() > 9) {
                debcad = debcad.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC_DEBCAD", debcad);
            CamposLeiauteTO camposLeiauteTO = this.getMapaCamposLeiauteTO().get("TX_IDFC_DEBCAD");
            if (!ValidadorFactory.getInstancia().novoValidadorDEBCAD().isValido(debcad)) {
                throw new RegistroRejeitadoException("conteudo.invalido", camposLeiauteTO, debcad);
            }
        }
    }

    protected void validaPISPASEP() throws RegistroRejeitadoException {
        String PISPASEP = this.getMapaValorCampo().get("TX_IDFC_PISPASEP");
        if (PISPASEP != null && PISPASEP.trim().length() > 0 && this.direferenteZero(PISPASEP)) {
            while (PISPASEP.length() > 11) {
                PISPASEP = PISPASEP.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC_PISPASEP", PISPASEP);
            if (!ValidadorFactory.getInstancia().novoValidadorPASEP().isValido(PISPASEP)) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC_PISPASEP"), PISPASEP);
            }
        }
    }

    protected void validaCEI() throws RegistroRejeitadoException {
        String CEI = this.getMapaValorCampo().get("TX_IDFC_CEI");
        if (CEI != null && CEI.trim().length() > 0 && this.direferenteZero(CEI)) {
            while (CEI.length() > 12) {
                CEI = CEI.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC_CEI", CEI);
            if (!ValidadorFactory.getInstancia().novoValidadorCEI().isValido(CEI)) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC_CEI"), CEI);
            }
        }
    }

    protected void validaNIT() throws RegistroRejeitadoException {
        String NIT = this.getMapaValorCampo().get("TX_IDFC_NIT");
        if (NIT != null && NIT.trim().length() > 0 && this.direferenteZero(NIT)) {
            while (NIT.length() > 11) {
                NIT = NIT.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC_NIT", NIT);
            if (!ValidadorFactory.getInstancia().novoValidadorNIT().isValido(NIT)) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC_NIT"), NIT);
            }
        }
    }

    protected void validaNB() throws RegistroRejeitadoException {
        String NB = this.getMapaValorCampo().get("TX_IDFC_NR_BENEF");
        if (NB != null && NB.trim().length() > 0 && this.direferenteZero(NB)) {
            while (NB.length() > 10) {
                NB = NB.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC_NR_BENEF", NB);
            if (!ValidadorFactory.getInstancia().novoValidadorNB().isValido(NB)) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC_NR_BENEF"), NB);
            }
        }
    }

    protected void validaReferencia() throws RegistroRejeitadoException {
        String Referencia = this.getMapaValorCampo().get("TX_IDFC_REF");
        if (Referencia != null && Referencia.trim().length() > 0 && this.direferenteZero(Referencia)) {
            while (Referencia.length() > 14) {
                Referencia = Referencia.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC_REF", Referencia);
            if (!ValidadorFactory.getInstancia().novoValidadorReferencia().isValido(Referencia)) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC_REF"), Referencia);
            }
        }
    }

    protected void validaTituloCobranca() throws RegistroRejeitadoException {
        String tituloCobranca = this.getMapaValorCampo().get("TX_IDFC_TIT_COB");
        if (tituloCobranca != null && tituloCobranca.trim().length() > 0 && this.direferenteZero(tituloCobranca)) {
            while (tituloCobranca.length() > 14) {
                tituloCobranca = tituloCobranca.substring(1);
            }
            this.getMapaValorCampo().put("TX_IDFC_TIT_COB", tituloCobranca);
            if (!ValidadorFactory.getInstancia().novoValidadorTituloCobranca().isValido(tituloCobranca)) {
                throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC_TIT_COB"), tituloCobranca);
            }
        }
    }

    protected void incluiPessoaTO() throws RegistroRejeitadoException {
        try {
            if (this.isPessoaFisica(this.getPessoaTO().getTipoPessoaTO())) {
                ComplementoPessoaFisicaTO complementoPessoaFisicaTO = this.getComplementoPessoaFisicaTO();
                this.getManterCadastroPessoaFisicaModel().incluir(complementoPessoaFisicaTO);
                this.novoPluginControladorDeAcesso().getServico().equals("GAC");
            } else if (this.isPessoaJuridica(this.getPessoaTO().getTipoPessoaTO())) {
                ComplementoPessoaJuridicaTO complementoPessoaJuridicaTO = this.getComplementoPessoaJuridicaTO();
                this.getManterCadastroPessoaJuridicaModel().incluir(complementoPessoaJuridicaTO);
                this.novoPluginControladorDeAcesso().getServico().equals("GAC");
            }
        }
        catch (BBException e) {
            CamposLeiauteTO camposLeiauteTO = this.getMapaCamposLeiauteTO().get("TX_NM");
            throw new RegistroRejeitadoException("conteudo.invalido", camposLeiauteTO, e.getMessage());
        }
    }

    protected void inicializaValores() {
        this.setMapaValorCampo(null);
        this.setMapaCamposLeiauteTO(null);
        this.setPessoaTO(null);
    }

    protected void criaPessoaTO() {
        this.pessoaTO = null;
        this.atribuiInscricaoPessoaTO();
        this.atribuiNomePessoaTO();
        this.atribuiEnderecoPessoaTO();
        this.atribuiNacionalidadeComplementoPessoaFisicaTO();
        this.atribuiNaturalidadeComplementoPessoaFisicaTO();
        this.atribuiEstadoNascimentoComplementoPessoaFisicaTO();
        this.atribuiCEIPessoaTO();
        this.atribuiNumeroBeneficioPessoaTO();
        this.atribuiRefer\u00eanciaPessoaTO();
        this.atribuiPsiPasepPessoaTO();
        this.atribuiNitPessoaTO();
        this.atribuiDEBCADPessoaTO();
        this.atribuiTituloDeCobrancaPessoaTO();
    }

    protected void atribuiCEIPessoaTO() {
        String valor = this.getMapaValorCampo().get("TX_IDFC_CEI");
        Integer codigoTipoDocumento = UtilDominioTipoDocumento.CEI_PJ;
        this.atribuiNovoIdentificacaoTOPessoaTO(valor, codigoTipoDocumento);
    }

    protected void atribuiNumeroBeneficioPessoaTO() {
        String valor = this.getMapaValorCampo().get("TX_IDFC_NR_BENEF");
        Integer codigoTipoDocumento = UtilDominioTipoDocumento.NUMERO_BENEFICIO_PF;
        this.atribuiNovoIdentificacaoTOPessoaTO(valor, codigoTipoDocumento);
    }

    protected void atribuiRefer\u00eanciaPessoaTO() {
        String valor = this.getMapaValorCampo().get("TX_IDFC_REF");
        Integer codigoTipoDocumento = Integer.parseInt(this.getMapaValorCampo().get("CD_TIP_DOC")) == UtilDominioTipoDocumento.CPF_PF ? UtilDominioTipoDocumento.REFERENCIA_PF : UtilDominioTipoDocumento.REFERENCIA_PJ;
        this.atribuiNovoIdentificacaoTOPessoaTO(valor, codigoTipoDocumento);
    }

    protected void atribuiPsiPasepPessoaTO() {
        String valor = this.getMapaValorCampo().get("TX_IDFC_PISPASEP");
        Integer codigoTipoDocumento = UtilDominioTipoDocumento.PASEP_PF;
        this.atribuiNovoIdentificacaoTOPessoaTO(valor, codigoTipoDocumento);
    }

    protected void atribuiNitPessoaTO() {
        String valor = this.getMapaValorCampo().get("TX_IDFC_NIT");
        Integer codigoTipoDocumento = UtilDominioTipoDocumento.NIT_PF;
        this.atribuiNovoIdentificacaoTOPessoaTO(valor, codigoTipoDocumento);
    }

    protected void atribuiDEBCADPessoaTO() {
        String valor = this.getMapaValorCampo().get("TX_IDFC_DEBCAD");
        Integer codigoTipoDocumento = Integer.parseInt(this.getMapaValorCampo().get("CD_TIP_DOC")) == UtilDominioTipoDocumento.CPF_PF ? UtilDominioTipoDocumento.DEBCAD_PF : UtilDominioTipoDocumento.DEBCAD_PJ;
        this.atribuiNovoIdentificacaoTOPessoaTO(valor, codigoTipoDocumento);
    }

    protected void atribuiTituloDeCobrancaPessoaTO() {
        String valor = this.getMapaValorCampo().get("TX_IDFC_TIT_COB");
        Integer codigoTipoDocumento = Integer.parseInt(this.getMapaValorCampo().get("CD_TIP_DOC")) == UtilDominioTipoDocumento.CPF_PF ? UtilDominioTipoDocumento.TITULO_COBRANCA_PF : UtilDominioTipoDocumento.TITULO_COBRANCA_PJ;
        this.atribuiNovoIdentificacaoTOPessoaTO(valor, codigoTipoDocumento);
    }

    protected void atribuiNovoIdentificacaoTOPessoaTO(String valor, Integer codigoTipoDocumento) {
        if (!UtilString.isVazio(valor) && Integer.parseInt(valor) != 0) {
            IdentificacaoTO identificacaoTO = this.getFabricaDeTO().novoIdentificacaoTO();
            identificacaoTO.setPessoaTO(this.getPessoaTO());
            TipoDocumentoTO tipoDocumentoTO = null;
            tipoDocumentoTO = (TipoDocumentoTO)((Object)this.getTipoDocumentoDAO().listar(codigoTipoDocumento));
            identificacaoTO.setTipoDocumentoTO(tipoDocumentoTO);
            identificacaoTO.setIdentificadorTO(tipoDocumentoTO.getIdentificadorTOs().iterator().next());
            identificacaoTO.getId().setTextoIdentificacao(valor);
            if (UtilColecao.isVazio(this.getPessoaTO().getIdentificacaoTOs())) {
                this.getPessoaTO().setIdentificacaoTOs(new HashSet<IdentificacaoTO>());
            }
            this.getPessoaTO().getIdentificacaoTOs().add(identificacaoTO);
        }
    }

    protected void atribuiEstadoNascimentoComplementoPessoaFisicaTO() {
        String estadoNascimento = this.getMapaValorCampo().get("TX_SG_UF_NASC");
        if (!UtilString.isVazio(estadoNascimento) && this.isPessoaFisica(this.getPessoaTO().getTipoPessoaTO())) {
            ComplementoPessoaFisicaTO complementoPessoaFisicaTO = this.getComplementoPessoaFisicaTO();
            UnidadeFederativaBrasilTO unidadeFederativaBrasilTO = this.getFabricaDeTO().novoUnidadeFederativaBrasilTO();
            unidadeFederativaBrasilTO.setTextoSiglaUf(estadoNascimento);
            complementoPessoaFisicaTO.setUnidadeFederativaBrasilTO(unidadeFederativaBrasilTO);
        }
    }

    protected void atribuiNaturalidadeComplementoPessoaFisicaTO() {
        String naturalidade = this.getMapaValorCampo().get("TX_NTLD");
        if (this.isPessoaFisica(this.getPessoaTO().getTipoPessoaTO())) {
            ComplementoPessoaFisicaTO complementoPessoaFisicaTO = this.getComplementoPessoaFisicaTO();
            complementoPessoaFisicaTO.setTextoNaturalidade(naturalidade);
        }
    }

    protected boolean isPessoaFisica(TipoPessoaTO tipoPessoaTO) {
        int codigo = tipoPessoaTO.getCodigoTipoPessoa();
        return 1 == codigo;
    }

    protected boolean isPessoaJuridica(TipoPessoaTO tipoPessoaTO) {
        int codigo = tipoPessoaTO.getCodigoTipoPessoa();
        return 2 == codigo;
    }

    protected void atribuiNacionalidadeComplementoPessoaFisicaTO() {
        String nacionalidade = this.getMapaValorCampo().get("CD_NCLD");
        Integer codigoNacionalidade = UtilConversorDeInteger.converterParaInteger(nacionalidade);
        ComplementoPessoaFisicaTO complementoPessoaFisicaTO = null;
        if (!UtilString.isVazio(nacionalidade) && this.isPessoaFisica(this.getPessoaTO().getTipoPessoaTO())) {
            NacionalidadeTO nacionalidadeTO = this.getFabricaDeTO().novoNacionalidadeTO();
            nacionalidadeTO.setCodigoNacionalidade(codigoNacionalidade);
            complementoPessoaFisicaTO = this.getComplementoPessoaFisicaTO();
            complementoPessoaFisicaTO.setNacionalidadeTO(nacionalidadeTO);
        }
    }

    protected void atribuiEnderecoPessoaTO() {
        String endere\u00e7o = this.getMapaValorCampo().get("TX_LGR");
        String bairro = this.getMapaValorCampo().get("TX_BAI");
        String cidade = this.getMapaValorCampo().get("TX_CID");
        String cep = this.getMapaValorCampo().get("TX_CEP");
        String estado = this.getMapaValorCampo().get("TX_SG_UF_END");
        String tipoLogradouro = this.getMapaValorCampo().get("CD_TIP_LGR");
        if (UtilString.isVazio(tipoLogradouro)) {
            tipoLogradouro = "1";
        }
        if (!UtilString.isVazio(endere\u00e7o)) {
            LogradouroTO logradouroTO = this.getFabricaDeTO().novoLogradouroTO();
            logradouroTO.setPessoaTO(this.getPessoaTO());
            logradouroTO.setTextoLogradouro(endere\u00e7o);
            logradouroTO.setTextoBairro(bairro);
            logradouroTO.setTextoCidade(cidade);
            logradouroTO.setTextoCep(cep);
            TipoLogradouroTO tipoLogradouroTO = this.getFabricaDeTO().novoTipoLogradouroTO();
            tipoLogradouroTO.setCodigoTipoLogradouro(UtilConversorDeInteger.converterParaInteger(tipoLogradouro));
            logradouroTO.setTipoLogradouroTO(tipoLogradouroTO);
            UnidadeFederativaBrasilTO unidadeFederativaBrasilTO = this.getFabricaDeTO().novoUnidadeFederativaBrasilTO();
            unidadeFederativaBrasilTO.setTextoSiglaUf(estado);
            logradouroTO.setUnidadeFederativaBrasilTO(unidadeFederativaBrasilTO);
            if (UtilColecao.isVazio(this.getPessoaTO().getLogradouroTOs())) {
                this.getPessoaTO().setLogradouroTOs(new HashSet<LogradouroTO>());
            }
            this.getPessoaTO().getLogradouroTOs().add(logradouroTO);
        }
    }

    protected void atribuiInscricaoPessoaTO() {
        String tipoDeInscric\u00e3o = this.getMapaValorCampo().get("CD_TIP_DOC");
        Integer codigoTipoDocumento = UtilConversorDeInteger.converterParaInteger(tipoDeInscric\u00e3o);
        String inscri\u00e7\u00e3o = this.getMapaValorCampo().get("TX_IDFC");
        IdentificacaoTO identificacaoTO = this.getFabricaDeTO().novoIdentificacaoTO();
        identificacaoTO.setPessoaTO(this.getPessoaTO());
        TipoDocumentoTO tipoDocumentoTO = null;
        tipoDocumentoTO = (TipoDocumentoTO)((Object)this.getTipoDocumentoDAO().listar(codigoTipoDocumento));
        identificacaoTO.setIdentificadorTO(tipoDocumentoTO.getIdentificadorTOs().iterator().next());
        TipoPessoaTO tipoPessoaTO = tipoDocumentoTO.getTipoPessoaTO();
        this.instanciaPessoaTOPeloTipoPessoa(tipoPessoaTO);
        identificacaoTO.setTipoDocumentoTO(tipoDocumentoTO);
        identificacaoTO.getId().setTextoIdentificacao(inscri\u00e7\u00e3o);
        if (UtilColecao.isVazio(this.getPessoaTO().getIdentificacaoTOs())) {
            this.getPessoaTO().setIdentificacaoTOs(new HashSet<IdentificacaoTO>());
        }
        this.getPessoaTO().setTipoPessoaTO(tipoPessoaTO);
        this.getPessoaTO().getIdentificacaoTOs().add(identificacaoTO);
    }

    protected void instanciaPessoaTOPeloTipoPessoa(TipoPessoaTO tipoPessoaTO) {
        if (this.isPessoaFisica(tipoPessoaTO)) {
            ComplementoPessoaFisicaTO complementoPessoaFisicaTO = this.getFabricaDeTO().novoComplementoPessoaFisicaTO();
            this.setPessoaTO(complementoPessoaFisicaTO);
        } else if (this.isPessoaJuridica(tipoPessoaTO)) {
            ComplementoPessoaJuridicaTO complementoPessoaJuridicaTO = this.getFabricaDeTO().novoComplementoPessoaJuridicaTO();
            this.setPessoaTO(complementoPessoaJuridicaTO);
        }
    }

    protected ComplementoPessoaJuridicaTO getComplementoPessoaJuridicaTO() {
        return (ComplementoPessoaJuridicaTO)this.getPessoaTO();
    }

    protected ComplementoPessoaFisicaTO getComplementoPessoaFisicaTO() {
        return (ComplementoPessoaFisicaTO)this.getPessoaTO();
    }

    protected void atribuiNomePessoaTO() {
        String nome = this.getMapaValorCampo().get("TX_NM");
        this.getPessoaTO().setTextoNome(nome);
    }

    protected void criaMapaDeValores(Set<CamposLeiauteTO> colecaoCamposLeiauteTO, String linha) {
        for (CamposLeiauteTO camposLeiauteTO : colecaoCamposLeiauteTO) {
            int inicio = camposLeiauteTO.getNumeroPosicaoInicio() - 1;
            int fim = inicio + camposLeiauteTO.getNumeroTamanhoMaximo();
            String valor = UtilString.substring(linha, inicio, fim);
            valor = UtilString.trim(valor);
            this.getMapaValorCampo().put(camposLeiauteTO.getTextoNomeCampo(), valor);
            this.getMapaCamposLeiauteTO().put(camposLeiauteTO.getTextoNomeCampo(), camposLeiauteTO);
        }
    }

    protected Map<String, String> getMapaValorCampo() {
        if (this.mapaValorCampo == null) {
            this.mapaValorCampo = new HashMap<String, String>();
        }
        return this.mapaValorCampo;
    }

    protected void setMapaValorCampo(Map<String, String> mapaValorCampo) {
        this.mapaValorCampo = mapaValorCampo;
    }

    protected Collection<RegistroRejeitadoTODecorator> getColecaoRegistroRejeitadoTO() {
        if (this.colecaoRegistroRejeitadoTO == null) {
            this.colecaoRegistroRejeitadoTO = new ArrayList<RegistroRejeitadoTODecorator>();
        }
        return this.colecaoRegistroRejeitadoTO;
    }

    protected Map<String, CamposLeiauteTO> getMapaCamposLeiauteTO() {
        if (this.mapaCamposLeiauteTO == null) {
            this.mapaCamposLeiauteTO = new HashMap<String, CamposLeiauteTO>();
        }
        return this.mapaCamposLeiauteTO;
    }

    protected void setMapaCamposLeiauteTO(Map<String, CamposLeiauteTO> mapaCamposLeiauteTO) {
        this.mapaCamposLeiauteTO = mapaCamposLeiauteTO;
    }

    public ManterCadastroPessoaJuridicaModel getManterCadastroPessoaJuridicaModel() {
        return this.manterCadastroPessoaJuridicaModel;
    }

    public void setManterCadastroPessoaJuridicaModel(ManterCadastroPessoaJuridicaModel manterCadastroPessoaJuridicaModel) {
        this.manterCadastroPessoaJuridicaModel = manterCadastroPessoaJuridicaModel;
    }

    public ManterCadastroPessoaFisicaModel getManterCadastroPessoaFisicaModel() {
        return this.manterCadastroPessoaFisicaModel;
    }

    public void setManterCadastroPessoaFisicaModel(ManterCadastroPessoaFisicaModel manterCadastroPessoaFisicaModel) {
        this.manterCadastroPessoaFisicaModel = manterCadastroPessoaFisicaModel;
    }

    protected int getNumeroDeRegistros(File file) throws FileNotFoundException, IOException {
        int n;
        FileInputStream fis = UtilArquivo.getFileInputStream(file);
        byte[] buf = new byte[2048];
        int cnt = 1;
        while ((n = fis.read(buf)) != -1) {
            int i = 0;
            while (i < n) {
                if (buf[i] == 10) {
                    ++cnt;
                }
                ++i;
            }
        }
        fis.close();
        return cnt;
    }

    public void setColecaoRegistroRejeitadoTO(Collection<RegistroRejeitadoTODecorator> colecaoRegistroRejeitadoTO) {
        this.colecaoRegistroRejeitadoTO = colecaoRegistroRejeitadoTO;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public Collection<UnidadeFederativaBrasilTO> consultarListaUF() {
        return ModelFactory.getInstancia().novoDominioModel().consultarListaUF();
    }

    public Collection<UnidadeFederativaBrasilTO> getColecaoUnidadeFederativaBrasilTO() {
        if (this.colecaoUnidadeFederativaBrasilTO == null) {
            this.colecaoUnidadeFederativaBrasilTO = this.consultarListaUF();
        }
        return this.colecaoUnidadeFederativaBrasilTO;
    }

    public void setColecaoUnidadeFederativaBrasilTO(Collection<UnidadeFederativaBrasilTO> colecaoUnidadeFederativaBrasilTO) {
        this.colecaoUnidadeFederativaBrasilTO = colecaoUnidadeFederativaBrasilTO;
    }

    private boolean direferenteZero(String numero) {
        return Integer.parseInt(numero.trim()) != 0;
    }

    protected void validaInscricao() throws RegistroRejeitadoException {
        String inscricao = this.getMapaValorCampo().get("TX_IDFC");
        IdentificacaoTO identificacaoTO = this.getFabricaDeTO().novoIdentificacaoTO();
        identificacaoTO.setTextoIdentificacao(inscricao);
        if (this.getManterIdentificacaoModel().isExisteTextoIdentificacao(identificacaoTO)) {
            throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("TX_IDFC"), inscricao);
        }
    }

    protected void validaTipoInscricao() throws RegistroRejeitadoException {
        String tpIns = this.getMapaValorCampo().get("CD_TIP_DOC");
        Integer tipoInscricao = Integer.parseInt(tpIns);
        if (tipoInscricao != UtilDominioTipoDocumento.CPF_PF && tipoInscricao != UtilDominioTipoDocumento.CNPJ_PJ) {
            throw new RegistroRejeitadoException("conteudo.invalido", this.getMapaCamposLeiauteTO().get("CD_TIP_DOC"), tpIns);
        }
    }

    public ManterIdentificacaoModel getManterIdentificacaoModel() {
        return this.manterIdentificacaoModel;
    }

    public void setManterIdentificacaoModel(ManterIdentificacaoModel manterIdentificacaoModel) {
        this.manterIdentificacaoModel = manterIdentificacaoModel;
    }
}

