/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.controle.ServicoAplicacaoDAO;
import br.com.bb.plugins.gac.negocio.business.TabelaBO;
import br.com.bb.plugins.gac.negocio.facade.ExecutarExpurgoAutomaticoFacade;
import br.com.bb.plugins.gac.negocio.facade.ExecutarRotinaPosInstalacaoFacade;
import br.com.bb.plugins.gac.negocio.facade.ExecutarRotinaPosInstalacaoNovaVersaoFacade;
import br.com.bb.plugins.gac.negocio.model.GerarCopiaSegurancaModel;
import br.com.bb.plugins.gac.negocio.model.ManterBancoDadosControleModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoAplicacaoTO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoControleTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ControleCopiaSegurancaTODecorator;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.FileUtils;
import br.com.bb.plugins.gac.util.PluginInfo;
import br.com.bb.plugins.gac.util.ServicoInfo;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.controller.view.ApplicationContextFactory;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipException;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniciarUtilizacaoModel
extends PluginModelAbstrato {
    private ConfiguracaoProperties config = null;
    private GerarCopiaSegurancaModel gerarCopiaSegurancaModel;
    private ServicoAplicacaoDAO servicoAplicacaoDao;
    private ManterBancoDadosControleModel manterBancoDadosControleModel;

    public ManterBancoDadosControleModel getManterBancoDadosControleModel() {
        if (this.manterBancoDadosControleModel == null) {
            this.manterBancoDadosControleModel = new ManterBancoDadosControleModel();
        }
        return this.manterBancoDadosControleModel;
    }

    public void setManterBancoDadosControleModel(ManterBancoDadosControleModel manterBancoDadosControleModel) {
        this.manterBancoDadosControleModel = manterBancoDadosControleModel;
    }

    public ConfiguracaoProperties getConfig() {
        if (this.config == null) {
            this.config = ConfiguracaoProperties.getConfiguracaoProperties();
        }
        return this.config;
    }

    public ServicoAplicacaoDAO getServicoAplicacaoDao() {
        if (this.servicoAplicacaoDao == null) {
            this.servicoAplicacaoDao = new ServicoAplicacaoDAO();
        }
        return this.servicoAplicacaoDao;
    }

    public void setConfig(ConfiguracaoProperties config) {
        this.config = config;
    }

    public boolean verificarAplicativoInstalado(String nomeModulo) throws BBException {
        if ("GAC".equalsIgnoreCase(nomeModulo)) {
            return true;
        }
        return this.getPluginInfo(nomeModulo) != null;
    }

    public void executarExpurgo(String nomeModulo) throws BBException {
        ExecutarExpurgoAutomaticoFacade executarExpurgoAutomaticoFacade = null;
        Plugin plugin = PluginController.getPlugin(nomeModulo);
        try {
            String idBean = plugin.getIdBeanExecutarExpurgoAutomatico();
            executarExpurgoAutomaticoFacade = (ExecutarExpurgoAutomaticoFacade)this.getApplicationContext().getBean(idBean);
            executarExpurgoAutomaticoFacade.executar();
        }
        catch (IllegalArgumentException iae) {
            BBJPopupMensagem.exibirMensagemErro("Funcionalidade de expurgo autom\u00e1tico n\u00e3o implementada para o m\u00f3dulo " + nomeModulo);
            iae.printStackTrace();
        }
    }

    public PluginInfo getPluginInfo(String nomeModulo) throws BBException {
        return this.getPluginInfo(nomeModulo, this.getConfig().getDirTemp());
    }

    public PluginInfo getPluginInfo(String nomeModulo, String s_path) throws BBException {
        try {
            ServicoInfo.getInstance().setPath(s_path);
            if ("GAC".equalsIgnoreCase(nomeModulo)) {
                return ServicoInfo.getInstance().GetFileInfoGAC();
            }
            return ServicoInfo.getInstance().GetFileInfo(this.getArquivoJAR(nomeModulo));
        }
        catch (ZipException ze) {
            ze.printStackTrace();
            if ("GAC".equalsIgnoreCase(nomeModulo)) {
                throw new BBException("M\u00f3dulo basico corrompido! Reinstale a aplica\u00e7\u00e3o.");
            }
            return this.verificarVersaoBaseServicoEstaCorrompida(nomeModulo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return null;
    }

    private PluginInfo verificarVersaoBaseServicoEstaCorrompida(String nomeModulo) throws BBException {
        this.getManterBancoDadosControleModel().lerPacote(nomeModulo);
        ServicoControleTO servicoControle = this.getManterBancoDadosControleModel().consultarServico(nomeModulo);
        File modulo = new File(String.valueOf(this.getManterBancoDadosControleModel().getPastatemp()) + File.separator + servicoControle.getNomeFisicoPacote());
        if (modulo.length() == servicoControle.getTamanhoPacote()) {
            try {
                FileUtils.copiar(modulo, new File(String.valueOf(this.getManterBancoDadosControleModel().getPastaAplicacao()) + File.separator + "plugins" + File.separator + servicoControle.getNomeFisicoPacote()));
                return ServicoInfo.getInstance().GetFileInfo(this.getArquivoJAR(nomeModulo));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (JDOMException e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        String textoDescricaoModulo = "";
        try {
            textoDescricaoModulo = this.getManterBancoDadosControleModel().consultarServico(nomeModulo).getDescricaoPacote();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ConfiguracaoProperties.getConfiguracaoProperties().setRemoverModulo(String.valueOf(ConfiguracaoProperties.getConfiguracaoProperties().getRemoverModulo()) + nomeModulo.toUpperCase().trim() + ";");
        ConfiguracaoProperties.getConfiguracaoProperties().salvaPropriedades();
        throw new BBException("MI064", "bb" + nomeModulo.toLowerCase() + ".jar", textoDescricaoModulo);
    }

    public Map<String, TabelaBO> getTabelasXML(String nomeModulo) throws BBException {
        ServicoInfo.getInstance().setPath(this.getConfig().getDirTemp());
        try {
            if ("GAC".equalsIgnoreCase(nomeModulo)) {
                return ServicoInfo.getInstance().getXMLEstruturaBDGAC();
            }
            return ServicoInfo.getInstance().getXMLEstruturaBD(this.getArquivoJAR(nomeModulo), "tabelas_" + nomeModulo.toLowerCase() + ".xml", nomeModulo, ServicoInfo.getInstance().getXMLEstruturaBDGAC());
        }
        catch (IOException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public String getArquivoJAR(String nomeModulo) {
        return String.valueOf(this.getConfig().getDirProg()) + "/plugins/bb" + nomeModulo.toLowerCase() + ".jar";
    }

    public String versaoInstalada(String nomeModulo) throws BBException {
        return this.getPluginInfo(nomeModulo).getVersao();
    }

    public String getVersaoBancoXML(String nomeModulo) throws BBException {
        try {
            if ("GAC".equalsIgnoreCase(nomeModulo)) {
                return ServicoInfo.getInstance().getVersaoXMLBDGAC(this.getConfig().getDirProg());
            }
            return ServicoInfo.getInstance().getVersaoXMLBD(this.getArquivoJAR(nomeModulo), "tabelas_" + nomeModulo.toLowerCase() + ".xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public boolean verificarVersaoMinimaGAC(String nomeModulo) throws BBException {
        return true;
    }

    public void executarCopiaSeguranca() throws BBException {
        ControleCopiaSegurancaTODecorator to = this.getFabricaDeTO().novoControleCopiaSegurancaTODecorator();
        String diretorio = this.getDiretorioCopiaDeSeguraca();
        to.setTextoNomeDiretorioArquivo(diretorio);
        this.getGerarCopiaSegurancaModel().gerar(to);
    }

    public String getDiretorioCopiaDeSeguraca() {
        String diretorioCopiaSeguranca = this.getUtilArquivoConfiguracao().getValorPropertie("diretorio.copiaseguranca");
        return diretorioCopiaSeguranca;
    }

    protected UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public GerarCopiaSegurancaModel getGerarCopiaSegurancaModel() {
        return this.gerarCopiaSegurancaModel;
    }

    private ApplicationContext getApplicationContext() {
        return ApplicationContextFactory.getInstance().getApplicationContext();
    }

    public void executarRotina(String nomeModulo) throws BBException {
        ExecutarRotinaPosInstalacaoFacade executarRotinaPosInstalacaoFacade = null;
        Plugin plugin = PluginController.getPlugin(nomeModulo);
        try {
            String idBean = plugin.getIdBeanRotinaPosInstalacao();
            executarRotinaPosInstalacaoFacade = (ExecutarRotinaPosInstalacaoFacade)this.getApplicationContext().getBean(idBean);
            executarRotinaPosInstalacaoFacade.executar();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("[Rotina p\u00f3s-instala\u00e7\u00e3o] Nenhuma rotina a ser executada...");
            iae.printStackTrace();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return;
        }
    }

    public void executarRotinaNovaVersao(String nomeModulo) throws BBException {
        ExecutarRotinaPosInstalacaoNovaVersaoFacade executarRotinaPosInstalacaoNovaVersaoFacade = null;
        Plugin plugin = PluginController.getPlugin(nomeModulo);
        try {
            String idBean = plugin.getIdBeanExecutarRotinaPosInstalacaoNovaVersao();
            executarRotinaPosInstalacaoNovaVersaoFacade = (ExecutarRotinaPosInstalacaoNovaVersaoFacade)this.getApplicationContext().getBean(idBean);
            executarRotinaPosInstalacaoNovaVersaoFacade.executar();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("[Rotina p\u00f3s-instala\u00e7\u00e3o de nova vers\u00e3o " + nomeModulo + "] Nenhuma rotina a ser executada...");
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return;
        }
    }

    public void atualizarDataExpurgo(String nomeModulo) throws BBException {
        ServicoAplicacaoTO srvc = this.getServicoAplicacaoDao().consultarServico(nomeModulo);
        srvc.setDataExecucaoUltimoExpurgo(new Date());
        this.getServicoAplicacaoDao().gravarServico(srvc);
    }

    public String getVersaoBancoDadosXML(String nomeModulo) throws BBException {
        return this.getPluginInfo(nomeModulo).getVersaodb();
    }

    public PluginInfo getPluginInfoModuloBasico(String nomeModulo) throws BBException {
        return this.getPluginInfoModuloBasico(nomeModulo, this.getConfig().getDirTemp());
    }

    public PluginInfo getPluginInfoModuloBasico(String nomeModulo, String s_path) throws BBException {
        try {
            ServicoInfo.getInstance().setPath(s_path);
            if ("GAC".equalsIgnoreCase(nomeModulo)) {
                return ServicoInfo.getInstance().getFileInfoGACParaAtualizacao();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return null;
    }
}

