/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ComplementoPessoaJuridicaDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.negocio.model.ManterCadastroPessoaModel;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.ContatoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterCadastroPessoaJuridicaModel
extends ManterCadastroPessoaModel {
    private ComplementoPessoaJuridicaDAO complementoPessoaJuridicaDAO;
    private ConvenentePessoaDAO convenentePessoaDAO;

    public ComplementoPessoaJuridicaTO incluir(ComplementoPessoaJuridicaTO pessoaJuridicaTO) throws BBException {
        this.verificaSeExistePessoaCadastrada(pessoaJuridicaTO);
        this.atribuiDataDaUltimaOperacao(pessoaJuridicaTO);
        this.atribuiIdContato(pessoaJuridicaTO);
        this.atribuiTipoPessoa(pessoaJuridicaTO, 2);
        this.atribuiPessoaTONaColecaoIdentificacaoTO(pessoaJuridicaTO);
        this.atribuiPessoaTONaColecaoContatoTO(pessoaJuridicaTO);
        this.atribuiPessoaTONaColecaoLogradouroTO(pessoaJuridicaTO);
        return this.getComplementoPessoaJuridicaDAO().incluir(pessoaJuridicaTO);
    }

    public void editar(ComplementoPessoaJuridicaTO pessoaJuridicaTO) {
        if (!this.existeVinculoDaPessoaEmAlgumNegocio(pessoaJuridicaTO)) {
            this.excluirIdentificacaoTO(pessoaJuridicaTO);
        }
        this.excluirContatoTO(pessoaJuridicaTO);
        this.excluirLogradouroTO(pessoaJuridicaTO);
        this.atribuiTipoPessoa(pessoaJuridicaTO, 2);
        this.atribuiIdContato(pessoaJuridicaTO);
        this.atribuiPessoaTONaColecaoIdentificacaoTO(pessoaJuridicaTO);
        this.atribuiPessoaTONaColecaoContatoTO(pessoaJuridicaTO);
        this.atribuiPessoaTONaColecaoLogradouroTO(pessoaJuridicaTO);
        this.getComplementoPessoaJuridicaDAO().alterar(pessoaJuridicaTO);
    }

    private void atribuiIdContato(ComplementoPessoaJuridicaTO complementoPessoaJuridicaTO) {
        int icont = 1;
        for (ContatoTO contatoTO : complementoPessoaJuridicaTO.getContatoTOs()) {
            contatoTO.getId().setNumeroIdentificadorContato(icont);
            ++icont;
        }
    }

    public void excluir(ComplementoPessoaJuridicaTO pessoaJuridica) throws BBException {
        if (this.getConvenentePessoaDAO().consultarPorCodigoPessoaRetornandoColecao(pessoaJuridica.getCodigoPessoa()).size() > 0) {
            throw new BBException("MP019");
        }
        if (this.getConvenentePessoaDAO().consultarColecaoPorConvenente(pessoaJuridica.getCodigoPessoa()).size() > 0) {
            throw new BBException("MP019");
        }
        this.getComplementoPessoaJuridicaDAO().excluir(pessoaJuridica);
    }

    public ComplementoPessoaJuridicaDAO getComplementoPessoaJuridicaDAO() {
        return this.complementoPessoaJuridicaDAO;
    }

    public void setComplementoPessoaJuridicaDAO(ComplementoPessoaJuridicaDAO complementoPessoaJuridicaDAO) {
        this.complementoPessoaJuridicaDAO = complementoPessoaJuridicaDAO;
    }

    @Override
    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    @Override
    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public Collection<ComplementoPessoaJuridicaTO> consultarTodosComplementosPJ() {
        return this.getComplementoPessoaJuridicaDAO().consultarTodosComplementosPJ();
    }

    public Collection<ConvenentePessoaTO> consultarConvenentePorCodigoConvenio(Integer codigoConvenente) {
        return this.getConvenentePessoaDAO().consultarColecaoPorConvenente(codigoConvenente);
    }

    public Collection<ComplementoPessoaJuridicaTO> consultarComplementosPessoaJuridicaPor(ConvenentePessoaTODecorator convenentePessoaTODecorator) {
        return this.getComplementoPessoaJuridicaDAO().consultarComplementosPessoaJuridicaPor(convenentePessoaTODecorator);
    }
}

