/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.negocio.model.ManterContatoModel;
import br.com.bb.plugins.gac.negocio.model.ManterIdentificacaoModel;
import br.com.bb.plugins.gac.negocio.model.ManterLogradouroModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ContatoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ContatoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificacaoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.string.UtilString;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterCadastroPessoaModel
extends PluginModelAbstrato {
    private PessoaDAO pessoaDAO;
    private ConvenentePessoaDAO convenentePessoaDAO;
    private ManterIdentificacaoModel manterIdentificacaoModel;
    private ManterLogradouroModel manterLogradouroModel;
    private ManterContatoModel manterContatoModel;
    private ConvenioDebitoDAO convenioDebitoDAO;

    public ManterIdentificacaoModel getManterIdentificacaoModel() {
        return this.manterIdentificacaoModel;
    }

    public void setManterIdentificacaoModel(ManterIdentificacaoModel manterIdentificacaoModel) {
        this.manterIdentificacaoModel = manterIdentificacaoModel;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public PaginadorTO consultar(PessoaTODecorator pessoaTODecorator) throws BBException {
        PaginadorTO paginadorTO = this.getPessoaDAO().consultarPaginadorSimples(pessoaTODecorator);
        return paginadorTO;
    }

    public Collection<PessoaTO> consultarPorNome(PessoaTODecorator pessoaTODecorator) {
        return this.getPessoaDAO().consultarPorNome(pessoaTODecorator);
    }

    protected void excluirLogradouroTO(PessoaTO complementoPessoaFisicaTO) {
        this.getManterLogradouroModel().excluirLogradouroTODaPessoa(complementoPessoaFisicaTO);
    }

    protected void excluirContatoTO(PessoaTO complementoPessoaFisicaTO) {
        this.getManterContatoModel().excluirContatoTODaPessoa(complementoPessoaFisicaTO);
    }

    protected void excluirIdentificacaoTO(PessoaTO complementoPessoaFisicaTO) {
        this.getManterIdentificacaoModel().excluirIdentificacaoTODaPessoa(complementoPessoaFisicaTO);
    }

    protected void atribuiPessoaTONaColecaoIdentificacaoTO(PessoaTO pessoaTO) {
        Set<IdentificacaoTO> identificacaoTOs = pessoaTO.getIdentificacaoTOs();
        for (IdentificacaoTO to : identificacaoTOs) {
            to.setPessoaTO(pessoaTO);
        }
    }

    protected IdentificacaoTODecorator novoIdentificacaoTODecorator(IdentificacaoTO to) {
        return this.getFabricaDeTO().novoIdentificacaoTODecorator(to);
    }

    protected void atribuiPessoaTONaColecaoContatoTO(PessoaTO pessoaTO) {
        Set<ContatoTO> contatoTOs = pessoaTO.getContatoTOs();
        for (ContatoTO contatoTO : contatoTOs) {
            contatoTO.setPessoaTO(pessoaTO);
        }
    }

    protected ContatoTODecorator novoContatoTODecorator(ContatoTO to) {
        return this.getFabricaDeTO().novoContatoTODecorator(to);
    }

    protected void atribuiPessoaTONaColecaoLogradouroTO(PessoaTO pessoaTO) {
        Set<LogradouroTO> logradouroTOs = pessoaTO.getLogradouroTOs();
        for (LogradouroTO logradouroTO : logradouroTOs) {
            logradouroTO.setPessoaTO(pessoaTO);
            logradouroTO.setNumeroLogradouro(0);
            logradouroTO.setTextoCep(this.removeMascara(logradouroTO.getTextoCep()));
        }
    }

    private String removeMascara(String valor) {
        String resultado = valor;
        if (!UtilString.isVazio(valor)) {
            resultado = UtilString.substituirString(valor, "[^0-9]*", "");
        }
        return resultado;
    }

    protected void atribuiTipoPessoa(PessoaTO pessoaTO, Integer codigoTipoPessoa) {
        pessoaTO.setTipoPessoaTO(new TipoPessoaTO());
        pessoaTO.getTipoPessoaTO().setCodigoTipoPessoa(codigoTipoPessoa);
    }

    protected void atribuiDataDaUltimaOperacao(PessoaTO pessoaTO) {
        pessoaTO.setDataUltimaOperacao(new Date());
    }

    protected boolean verificaSeExistePessoaCadastrada(PessoaTO pessoaTO) throws BBException {
        Set<IdentificacaoTO> colecao = pessoaTO.getIdentificacaoTOs();
        if (colecao != null && !UtilColecao.isVazio(colecao)) {
            for (IdentificacaoTO identificacaoTO : colecao) {
                if (!this.getManterIdentificacaoModel().isExisteTextoIdentificacao(identificacaoTO)) continue;
                return true;
            }
        }
        return false;
    }

    public ManterLogradouroModel getManterLogradouroModel() {
        return this.manterLogradouroModel;
    }

    public void setManterLogradouroModel(ManterLogradouroModel manterLogradouroModel) {
        this.manterLogradouroModel = manterLogradouroModel;
    }

    public ManterContatoModel getManterContatoModel() {
        return this.manterContatoModel;
    }

    public void setManterContatoModel(ManterContatoModel manterContatoModel) {
        this.manterContatoModel = manterContatoModel;
    }

    public PessoaTO consultarCadastroDuplicado(IdentificacaoTO identificacaoTO, ConvenenteTO convenenteTO, ServicoTO servicoTO) throws BBException {
        PessoaTO pessoaTO = this.getPessoaDAO().consultarPorIndentificacao(identificacaoTO);
        ConvenentePessoaTO pessoaSistema = null;
        if (pessoaTO != null) {
            pessoaSistema = this.getConvenentePessoaDAO().consultar(identificacaoTO, convenenteTO, servicoTO);
        }
        return pessoaTO;
    }

    public Collection<PessoaTO> consultarColecaoPorIntervaloNomeData(PessoaTODecorator pessoaTODecorator) {
        return this.getPessoaDAO().consultarColecaoPorIntervaloNomeData(pessoaTODecorator);
    }

    public PessoaTO consultarPorCodigo(PessoaTO pessoaTO) {
        return (PessoaTO)((Object)this.getPessoaDAO().listar(pessoaTO.getCodigoPessoa()));
    }

    public void excluir(PessoaTO pessoaTO) throws BBException {
        if (this.existeVinculoDaPessoaEmAlgumNegocio(pessoaTO)) {
            throw new BBException("MP019");
        }
        if (this.getConvenentePessoaDAO().consultarColecaoPorConvenente(pessoaTO.getCodigoPessoa()).size() > 0) {
            throw new BBException("MP019");
        }
        this.getPessoaDAO().excluir(pessoaTO);
    }

    public boolean existeVinculoDaPessoaEmAlgumNegocio(PessoaTO pessoaTO) {
        return this.getConvenentePessoaDAO().consultarPorCodigoPessoaRetornandoColecao(pessoaTO.getCodigoPessoa()).size() > 0;
    }

    public Collection<PessoaTO> consultarPor(PessoaTODecorator pessoaTODecorator) {
        return this.getPessoaDAO().consultarPor(pessoaTODecorator);
    }

    public Collection<PessoaTO> consultarPor(List<Integer> listaCodigoPessoa) {
        return this.getPessoaDAO().consultarPor(listaCodigoPessoa);
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }
}

