/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.form.ManterContaCorrenteForm;
import br.com.bb.plugins.gac.integracao.dao.AgenciaInstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTOId;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ContaCorrenteClienteTODecorator;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterContaCorrenteModel
extends PluginModelAbstrato {
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO;
    private InstituicaoFinanceiraDAO instituicaoFinanceiraDAO;

    public Collection<ContaCorrenteClienteTO> getDadosContaCorrenteCliente() {
        return this.getContaCorrenteClienteDAO().consultar();
    }

    public PaginadorTO listar(ContaCorrenteClienteTODecorator to) {
        return this.getContaCorrenteClienteDAO().consultarPorUsuario(to);
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public void incluirContaCorrente(ManterContaCorrenteForm form) {
        block4: {
            AgenciaInstituicaoFinanceiraTOId id = new AgenciaInstituicaoFinanceiraTOId();
            id.setCodigoAgencia(form.getCodigoAgenciaInstituicaoFinanceira());
            id.setCodigoInstituicaoFinanceira(form.getCodigoInstituicaoFinanceira());
            AgenciaInstituicaoFinanceiraTO agencia = this.getAgenciaInstituicaoFinanceiraDAO().consultarPorId(id);
            ContaCorrenteClienteTO contaCorrenteTO = form.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO();
            contaCorrenteTO.setAgenciaInstituicaoFinanceiraTO(agencia);
            try {
                ContaCorrenteClienteTO contaCorrenteClienteTO = this.getContaCorrenteClienteDAO().incluir(contaCorrenteTO);
                if (contaCorrenteClienteTO.getId() != null) {
                    form.setTipoDeMensagem(1);
                    form.setMensagem("Conta corrente inclu\u00edda com sucesso!");
                } else {
                    form.setTipoDeMensagem(0);
                    form.setMensagem("Erro ao incluir conta corrente!");
                }
            }
            catch (Exception e) {
                if (!e.getMessage().contains("CC_CLI")) break block4;
                form.setTipoDeMensagem(0);
                form.setMensagem("Conta corrente j\u00e1 existe!");
            }
        }
    }

    public void excluirContaCorrente(ManterContaCorrenteForm form) {
        this.getContaCorrenteClienteDAO().excluir(form.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTOId());
    }

    public void editarContaCorrente(ContaCorrenteClienteTO to) {
        this.getContaCorrenteClienteDAO().alterar(to);
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public PaginadorTO paginarListaConta(Collection<ContaCorrenteClienteTO> listaContasClienteDecorator, ContaCorrenteClienteTODecorator decorator) {
        return this.getContaCorrenteClienteDAO().paginarListaConta(listaContasClienteDecorator, decorator);
    }

    public List<ContaCorrenteClienteTO> listarContas(PessoaTO pessoa) {
        return this.getContaCorrenteClienteDAO().listarContas(pessoa);
    }

    public boolean possuiConta(PessoaTO pessoa) {
        return this.listarContas(pessoa).size() > 0;
    }

    public AgenciaInstituicaoFinanceiraDAO getAgenciaInstituicaoFinanceiraDAO() {
        return this.agenciaInstituicaoFinanceiraDAO;
    }

    public void setAgenciaInstituicaoFinanceiraDAO(AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO) {
        this.agenciaInstituicaoFinanceiraDAO = agenciaInstituicaoFinanceiraDAO;
    }

    public InstituicaoFinanceiraDAO getInstituicaoFinanceiraDAO() {
        return this.instituicaoFinanceiraDAO;
    }

    public void setInstituicaoFinanceiraDAO(InstituicaoFinanceiraDAO instituicaoFinanceiraDAO) {
        this.instituicaoFinanceiraDAO = instituicaoFinanceiraDAO;
    }

    public InstituicaoFinanceiraTO recuperarInstituicaoFinanceira(Integer codigoInstituicaoFinanceira) {
        return (InstituicaoFinanceiraTO)((Object)this.getInstituicaoFinanceiraDAO().listar(codigoInstituicaoFinanceira));
    }

    public AgenciaInstituicaoFinanceiraTO recuperarInstituicaoFinanceira(AgenciaInstituicaoFinanceiraTOId agenciaInstituicaoFinanceiraTOId) {
        return (AgenciaInstituicaoFinanceiraTO)((Object)this.getAgenciaInstituicaoFinanceiraDAO().listar(agenciaInstituicaoFinanceiraTOId));
    }

    public boolean contaJaExisteParaPessoa(ContaCorrenteClienteTO to) {
        return this.getContaCorrenteClienteDAO().existeContaParaPessoa(to);
    }
}

