/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ControleCopiaSegurancaDAO;
import br.com.bb.plugins.gac.integracao.dao.ControleCopiaSegurancaDAOImpl;
import br.com.bb.plugins.gac.integracao.dao.controle.JDBCDAOSuport;
import br.com.bb.plugins.gac.integracao.dao.controle.ServicoAplicacaoDAO;
import br.com.bb.plugins.gac.negocio.business.CampoRelacionamentoBO;
import br.com.bb.plugins.gac.negocio.business.CampoTabelaBO;
import br.com.bb.plugins.gac.negocio.business.IndiceTabelaBO;
import br.com.bb.plugins.gac.negocio.business.RegistroTabelaBasicaBO;
import br.com.bb.plugins.gac.negocio.business.RelacionamentoTabelaBO;
import br.com.bb.plugins.gac.negocio.business.TabelaBO;
import br.com.bb.plugins.gac.negocio.model.IniciarUtilizacaoModel;
import br.com.bb.plugins.gac.negocio.to.ControleCopiaSegurancaTO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoAplicacaoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConfiguracaoGerenciadorAplicativoClienteTODecorator;
import br.com.bb.plugins.gac.util.PluginInfo;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.politec.generico.calculadores.UtilSomadoresDeData;
import br.com.politec.generico.comparador.UtilComparadorDeDataMaior;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.string.UtilString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterEstruturaBancoDadosModel
extends JDBCDAOSuport {
    private int contadorIndice = 0;
    private int contadorPK = 0;
    private int contadorFK = 0;
    private Map<String, TabelaBO> tabelasBancoDados = null;
    private ServicoAplicacaoDAO servicoAplicacaoDAO = null;
    private ControleCopiaSegurancaDAO controleCopiaSegurancaDAO;
    private ConfiguracaoGerenciadorAplicativoClienteTODecorator configuracaoGerenciadorAplicativoClienteTODecorator;
    private IniciarUtilizacaoModel iniciarUtilizacaoModel;

    public ManterEstruturaBancoDadosModel() {
        super("BDGERAL");
    }

    public ServicoAplicacaoDAO getServicoAplicacaoDAO() {
        if (this.servicoAplicacaoDAO == null) {
            this.servicoAplicacaoDAO = new ServicoAplicacaoDAO();
        }
        return this.servicoAplicacaoDAO;
    }

    public ServicoAplicacaoTO consultarServico(String nomePacote) throws BBException {
        return this.getServicoAplicacaoDAO().consultarServico(nomePacote);
    }

    public ControleCopiaSegurancaDAO getControleCopiaSegurancaDAO() {
        if (this.controleCopiaSegurancaDAO == null) {
            this.controleCopiaSegurancaDAO = new ControleCopiaSegurancaDAOImpl();
        }
        return this.controleCopiaSegurancaDAO;
    }

    public void atualizarEstruturaBD(String nomePacote, Map<String, TabelaBO> tabelasNovas) throws BBException {
        Map<String, TabelaBO> tabelasInstaladas = this.getTabelasBancoDados();
        try {
            this.getConexao().setAutoCommit(false);
            if (tabelasInstaladas.size() == 0) {
                for (TabelaBO tabelaBO : tabelasNovas.values()) {
                    this.criarTabela(tabelaBO);
                    this.criarChavePrimaria(tabelaBO);
                }
            } else {
                for (TabelaBO tabelaBO : tabelasNovas.values()) {
                    TabelaBO tabelaBOExistente = tabelasInstaladas.get(tabelaBO.getNome().toUpperCase());
                    if (tabelaBOExistente == null) {
                        this.criarTabela(tabelaBO);
                        this.criarChavePrimaria(tabelaBO);
                        continue;
                    }
                    for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
                        CampoTabelaBO campoTabelaBOExistente = tabelaBOExistente.getCampos().get(campoTabelaBO.getNomeCampo().toUpperCase());
                        if (campoTabelaBOExistente == null) {
                            this.adicionarCampoTabela(tabelaBO.getNome(), campoTabelaBO);
                            continue;
                        }
                        if (!campoTabelaBO.getTipoCampo().equalsIgnoreCase(campoTabelaBOExistente.getTipoCampo()) && campoTabelaBO.getTamanho() >= campoTabelaBOExistente.getTamanho()) {
                            this.alterarTipoCampoTabela(tabelaBO.getNome(), campoTabelaBO);
                        }
                        if (campoTabelaBO.isPermiteNulo() != campoTabelaBOExistente.isPermiteNulo()) continue;
                        this.alterarPermiteNuloTabela(tabelaBO.getNome(), campoTabelaBO);
                    }
                }
            }
            this.getConexao().commit();
            for (TabelaBO tabelaBO : tabelasNovas.values()) {
                this.removerRelacionamentos(tabelasInstaladas, tabelaBO.getNome());
            }
            this.getConexao().commit();
            this.popularTabelasBasicas(tabelasNovas);
            this.getConexao().commit();
            this.criarIndices(tabelasNovas);
            this.getConexao().commit();
            for (TabelaBO tabelaBO : tabelasNovas.values()) {
                try {
                    this.criarRelacionamentos(tabelaBO);
                    this.getConexao().commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.out.println("Estrutura do banco de dados atualizada com sucesso!!");
            this.getConexao().setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    private void criarRelacionamentos(TabelaBO tabelaBO) throws BBException {
        try {
            for (RelacionamentoTabelaBO relacionamentoTabelaBO : tabelaBO.getRelacionamentos().values()) {
                this.criarRelacionamento(tabelaBO.getNome(), relacionamentoTabelaBO);
            }
        }
        catch (BBException e) {
            throw new BBException("MI042");
        }
    }

    private void removerRelacionamentos(Map<String, TabelaBO> tabelasInstaladas, String nomeTabela) throws BBException {
        TabelaBO tabelaBO = tabelasInstaladas.get(nomeTabela.toUpperCase());
        if (tabelaBO == null) {
            return;
        }
        for (RelacionamentoTabelaBO relacionamentoTabelaBO : tabelaBO.getRelacionamentos().values()) {
            String s_sql = "ALTER TABLE " + nomeTabela + " DROP CONSTRAINT " + relacionamentoTabelaBO.getNome();
            System.out.println(s_sql);
            this.executaRemoveRelacionamentos(s_sql);
        }
    }

    private void executaRemoveRelacionamentos(String s_sql) throws BBException {
        block2: {
            try {
                this.executarQuery(s_sql);
            }
            catch (BBException e) {
                String trataErro = e.getKey();
                int posicaoErroConstraint = trataErro.indexOf("CONSTRAINT");
                int posicaoNumeroDoErro = trataErro.indexOf("335544351");
                if (posicaoErroConstraint != -1 || posicaoNumeroDoErro != -1) break block2;
                throw new BBException("MI042");
            }
        }
    }

    private void criarRelacionamento(String nomeTabela, RelacionamentoTabelaBO relacionamentoTabelaBO) throws BBException {
        String s_sql = "ALTER TABLE " + nomeTabela + " ADD CONSTRAINT " + relacionamentoTabelaBO.getNome() + " FOREIGN KEY (";
        String camposOrigem = "(";
        int icnt = 0;
        for (CampoRelacionamentoBO campoRelacionamentoBO : relacionamentoTabelaBO.getCampos().values()) {
            String separadorCampos = ++icnt > 1 ? "," : "";
            s_sql = String.valueOf(s_sql) + separadorCampos + campoRelacionamentoBO.getNomeDestino().getNomeCampo();
            camposOrigem = String.valueOf(camposOrigem) + separadorCampos + campoRelacionamentoBO.getNomeOrigem().getNomeCampo();
        }
        s_sql = String.valueOf(s_sql) + ") REFERENCES " + relacionamentoTabelaBO.getTabelaOrigem().getNome() + camposOrigem + ")";
        this.executarQuery(s_sql);
        System.out.println(s_sql);
    }

    private void criarIndices(Map<String, TabelaBO> tabelasNovas) {
    }

    private void popularTabelasBasicas(Map<String, TabelaBO> tabelasNovas) throws BBException, SQLException {
        try {
            for (TabelaBO tabelaBO : tabelasNovas.values()) {
                if (!"S".equalsIgnoreCase(tabelaBO.getBasica())) continue;
                System.out.println("Populando tabela: " + tabelaBO.getNome());
                for (RegistroTabelaBasicaBO registroTabelaBasicaBO : tabelaBO.getRegistroTabelaBasica()) {
                    if (this.verificarRegistro(tabelaBO, registroTabelaBasicaBO)) {
                        this.atualizarRegistro(tabelaBO, registroTabelaBasicaBO);
                        continue;
                    }
                    this.inserirRegistro(tabelaBO, registroTabelaBasicaBO);
                }
            }
        }
        catch (BBException e) {
            throw new BBException("MI038");
        }
    }

    private void inserirRegistro(TabelaBO tabelaBO, RegistroTabelaBasicaBO registroTabelaBasicaBO) throws BBException {
        String s_sql = "INSERT INTO " + tabelaBO.getNome() + "(" + this.getCamposTabela(tabelaBO) + ") VALUES ( " + this.getValoresTabela(tabelaBO, registroTabelaBasicaBO) + " )";
        System.out.println(s_sql);
        this.executarQuery(s_sql);
    }

    private String getValoresTabela(TabelaBO tabelaBO, RegistroTabelaBasicaBO registroTabelaBasicaBO) {
        String s_valoresCampos = "";
        for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
            String valorCampo = "";
            for (CampoTabelaBO campoTabelaBORTB : registroTabelaBasicaBO.getCamposTabela()) {
                if (!campoTabelaBORTB.getNomeCampo().equalsIgnoreCase(campoTabelaBO.getNomeCampo())) continue;
                valorCampo = this.getValorSql(campoTabelaBO, campoTabelaBORTB.getValor());
                break;
            }
            s_valoresCampos = String.valueOf(s_valoresCampos) + (s_valoresCampos.trim().length() == 0 ? "" : ", ") + valorCampo;
        }
        return s_valoresCampos;
    }

    private String getCamposTabela(TabelaBO tabelaBO) {
        String s_campos = "";
        for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
            s_campos = String.valueOf(s_campos) + (s_campos.trim().length() == 0 ? "" : ", ") + campoTabelaBO.getNomeCampo();
        }
        return s_campos;
    }

    private void atualizarRegistro(TabelaBO tabelaBO, RegistroTabelaBasicaBO registroTabelaBasicaBO) throws BBException {
        String s_sql = "UPDATE " + tabelaBO.getNome() + " SET ";
        int icnt = 0;
        for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
            CampoTabelaBO campoTabelaBOPK = tabelaBO.getChavePrimaria().getCampos().get(campoTabelaBO.getNomeCampo().toUpperCase());
            if (campoTabelaBOPK != null) continue;
            String valorCampo = "";
            for (CampoTabelaBO campoTabelaBORTB : registroTabelaBasicaBO.getCamposTabela()) {
                if (!campoTabelaBORTB.getNomeCampo().equalsIgnoreCase(campoTabelaBO.getNomeCampo())) continue;
                valorCampo = this.getValorSql(campoTabelaBO, campoTabelaBORTB.getValor());
                break;
            }
            s_sql = String.valueOf(s_sql) + (++icnt > 1 ? "," : "") + campoTabelaBO.getNomeCampo() + "=" + valorCampo;
        }
        if (icnt > 0) {
            this.executarQuery(String.valueOf(s_sql) + " " + this.getFiltroRegistro(tabelaBO, registroTabelaBasicaBO));
        } else {
            System.out.println("N\u00e3o atualizou a tabela: " + tabelaBO.getNome());
        }
    }

    private boolean verificarRegistro(TabelaBO tabelaBO, RegistroTabelaBasicaBO registroTabelaBasicaBO) throws BBException, SQLException {
        String s_sql = "SELECT " + this.getPrimeiroCampo(tabelaBO) + " FROM " + tabelaBO.getNome() + this.getFiltroRegistro(tabelaBO, registroTabelaBasicaBO);
        ResultSet rs = this.executarQueryResult(s_sql);
        return rs.next();
    }

    private String getFiltroRegistro(TabelaBO tabelaBO, RegistroTabelaBasicaBO registroTabelaBasicaBO) {
        String s_filtro = "";
        for (CampoTabelaBO campoTabelaBO : tabelaBO.getChavePrimaria().getCampos().values()) {
            String valorCampo = "";
            for (CampoTabelaBO campoTabelaBORTB : registroTabelaBasicaBO.getCamposTabela()) {
                if (!campoTabelaBORTB.getNomeCampo().equalsIgnoreCase(campoTabelaBO.getNomeCampo())) continue;
                valorCampo = this.getValorSql(campoTabelaBO, campoTabelaBORTB.getValor());
                break;
            }
            s_filtro = String.valueOf(s_filtro) + (s_filtro.trim().length() == 0 ? " WHERE " : " AND ") + campoTabelaBO.getNomeCampo() + " = " + valorCampo;
        }
        return s_filtro;
    }

    private String getPrimeiroCampo(TabelaBO tabelaBO) {
        Iterator<CampoTabelaBO> iterator = tabelaBO.getCampos().values().iterator();
        if (iterator.hasNext()) {
            CampoTabelaBO campoTabelaBO = iterator.next();
            return campoTabelaBO.getNomeCampo();
        }
        return "";
    }

    private void alterarPermiteNuloTabela(String nomeTabela, CampoTabelaBO campoTabelaBO) throws BBException {
    }

    private void alterarTipoCampoTabela(String nomeTabela, CampoTabelaBO campoTabelaBO) throws BBException {
        String query = "ALTER TABLE " + nomeTabela + " ALTER " + campoTabelaBO.getNomeCampo() + " TYPE " + campoTabelaBO.getTipoCampo();
        try {
            System.out.println(query);
            this.executarQuery(query);
        }
        catch (BBException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void criarChavePrimaria(TabelaBO tabelaBO) throws BBException {
        String query = "ALTER TABLE " + tabelaBO.getNome() + " ADD CONSTRAINT " + tabelaBO.getChavePrimaria().getNome() + " PRIMARY KEY (";
        try {
            int icnt = 1;
            while (icnt <= tabelaBO.getChavePrimaria().getCampos().size()) {
                for (CampoTabelaBO campoTabelaBO : tabelaBO.getChavePrimaria().getCampos().values()) {
                    if (icnt != campoTabelaBO.getSequencial()) continue;
                    query = String.valueOf(query) + (icnt > 1 ? ", " : "");
                    query = String.valueOf(query) + campoTabelaBO.getNomeCampo();
                }
                ++icnt;
            }
            query = String.valueOf(query) + ")";
            System.out.println(query);
            this.executarQuery(query);
        }
        catch (BBException e) {
            throw new BBException("MI041");
        }
    }

    private void adicionarCampoTabela(String nomeTabela, CampoTabelaBO campoTabelaBO) throws BBException {
        String query = "ALTER TABLE " + nomeTabela + " ADD " + campoTabelaBO.getNomeCampo() + " " + campoTabelaBO.getTipoCampo();
        this.executarQuery(query);
    }

    private void criarTabela(TabelaBO tabelaBO) throws BBException {
        try {
            String query = "CREATE TABLE " + tabelaBO.getNome() + " (";
            int icnt = 0;
            for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
                query = String.valueOf(query) + (icnt++ > 0 ? ", " : "");
                query = String.valueOf(query) + campoTabelaBO.getNomeCampo() + " " + campoTabelaBO.getTipoCampo() + (campoTabelaBO.isPermiteNulo() ? "" : " NOT NULL");
            }
            query = String.valueOf(query) + ")";
            System.out.println(query);
            this.executarQuery(query);
        }
        catch (BBException e) {
            throw new BBException("MI041");
        }
    }

    public Map<String, TabelaBO> getTabelasBancoDados() throws BBException {
        if (this.tabelasBancoDados == null) {
            this.tabelasBancoDados = new LinkedHashMap<String, TabelaBO>();
            try {
                TabelaBO tabelaBO;
                DatabaseMetaData meta = this.getConexao().getMetaData();
                ResultSet rs = meta.getCatalogs();
                String catalog = "";
                if (rs.next()) {
                    catalog = rs.getString(1);
                }
                rs.close();
                String[] types = new String[]{"TABLE"};
                String schema = null;
                rs = meta.getTables(catalog, schema, "%", types);
                while (rs.next()) {
                    tabelaBO = new TabelaBO(rs.getString("TABLE_NAME"));
                    tabelaBO.setBasica("N");
                    tabelaBO.setCampos(this.getCamposTabela(meta, tabelaBO.getNome()));
                    tabelaBO.setIndices(this.getIndicesTabela(meta, tabelaBO));
                    tabelaBO.setChavePrimaria(this.getChavePrimariaTabela(meta, tabelaBO));
                    this.tabelasBancoDados.put(tabelaBO.getNome().toUpperCase(), tabelaBO);
                }
                rs.close();
                rs = meta.getTables(catalog, schema, "%", types);
                while (rs.next()) {
                    tabelaBO = this.tabelasBancoDados.get(rs.getString("TABLE_NAME").toUpperCase());
                    this.lerRelacionamentos(meta, tabelaBO, this.tabelasBancoDados);
                }
                rs.close();
            }
            catch (SQLException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        return this.tabelasBancoDados;
    }

    private void lerRelacionamentos(DatabaseMetaData meta, TabelaBO tabelaBO, Map<String, TabelaBO> tabelasBancoDados) throws BBException {
        try {
            ResultSet rs = meta.getImportedKeys("", "", tabelaBO.getNome());
            LinkedHashMap<String, RelacionamentoTabelaBO> nomeRelAnt = new LinkedHashMap<String, RelacionamentoTabelaBO>();
            int iposic = 0;
            while (rs.next()) {
                RelacionamentoTabelaBO relacionamentoTabelaBO = (RelacionamentoTabelaBO)nomeRelAnt.get(rs.getString("FK_NAME").toUpperCase());
                if (relacionamentoTabelaBO == null) {
                    relacionamentoTabelaBO = new RelacionamentoTabelaBO(rs.getString("FK_NAME"));
                    relacionamentoTabelaBO.setTabelaDestino(tabelaBO);
                    tabelaBO.getRelacionamentos().put(relacionamentoTabelaBO.getNome().toUpperCase(), relacionamentoTabelaBO);
                    nomeRelAnt.put(rs.getString("FK_NAME").toUpperCase(), relacionamentoTabelaBO);
                    ++this.contadorFK;
                }
                TabelaBO tabelaBOOrg = tabelasBancoDados.get(rs.getString("PKTABLE_NAME").toUpperCase());
                CampoTabelaBO campoTabelaBOPK = tabelaBOOrg.getCampos().get(rs.getString("PKCOLUMN_NAME").toUpperCase());
                CampoTabelaBO campoTabelaBOFK = tabelaBO.getCampos().get(rs.getString("FKCOLUMN_NAME").toUpperCase());
                CampoRelacionamentoBO campos = new CampoRelacionamentoBO(campoTabelaBOPK, campoTabelaBOFK);
                relacionamentoTabelaBO.getCampos().put("" + ++iposic, campos);
                relacionamentoTabelaBO.setTabelaOrigem(tabelaBOOrg);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    private IndiceTabelaBO getChavePrimariaTabela(DatabaseMetaData meta, TabelaBO tabelaBO) throws BBException {
        IndiceTabelaBO indiceTabelaBO = null;
        try {
            ResultSet rs = meta.getPrimaryKeys("", "", tabelaBO.getNome());
            LinkedHashMap<String, Integer> sequencialCampos = new LinkedHashMap<String, Integer>();
            while (rs.next()) {
                if (indiceTabelaBO == null) {
                    indiceTabelaBO = new IndiceTabelaBO(rs.getString("PK_NAME"));
                    ++this.contadorPK;
                }
                CampoTabelaBO campo = tabelaBO.getCampos().get(rs.getString("COLUMN_NAME").toUpperCase());
                indiceTabelaBO.getCampos().put(rs.getString("COLUMN_NAME").toUpperCase(), campo);
                sequencialCampos.put(rs.getString("COLUMN_NAME").toUpperCase(), new Integer(rs.getInt("KEY_SEQ")));
            }
            if (indiceTabelaBO != null) {
                indiceTabelaBO.setSequencialCampos(sequencialCampos);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return indiceTabelaBO;
    }

    private Map<String, IndiceTabelaBO> getIndicesTabela(DatabaseMetaData meta, TabelaBO tabelaBO) throws BBException {
        LinkedHashMap<String, IndiceTabelaBO> indices = new LinkedHashMap<String, IndiceTabelaBO>();
        LinkedHashMap<String, IndiceTabelaBO> indicesAntes = new LinkedHashMap<String, IndiceTabelaBO>();
        try {
            ResultSet rs = meta.getIndexInfo("", "", tabelaBO.getNome(), false, false);
            while (rs.next()) {
                String nomeIndice = rs.getString("INDEX_NAME");
                IndiceTabelaBO indiceTabelaBO = (IndiceTabelaBO)indicesAntes.get(nomeIndice.toUpperCase());
                if (indiceTabelaBO != null || nomeIndice.indexOf("XPK") != -1 || nomeIndice.indexOf("XIF") != -1 || nomeIndice.indexOf("RDB$") != -1 || nomeIndice.indexOf("PRIMARY") != -1 || nomeIndice.indexOf("FOREIGN") != -1 || nomeIndice.indexOf("PK_") != -1 || nomeIndice.indexOf("FK_") != -1) continue;
                indiceTabelaBO = new IndiceTabelaBO(nomeIndice);
                indiceTabelaBO.setUnico(!rs.getBoolean("NON_UNIQUE"));
                indiceTabelaBO.setOrdenacao(rs.getString("ASC_OR_DESC"));
                indiceTabelaBO.getCampos().put(rs.getString("COLUMN_NAME").toUpperCase(), tabelaBO.getCampos().get(rs.getString("COLUMN_NAME").toUpperCase()));
                tabelaBO.getIndices().put(indiceTabelaBO.getNome().toUpperCase(), indiceTabelaBO);
                indicesAntes.put(rs.getString("INDEX_NAME").toUpperCase(), indiceTabelaBO);
                indices.put(indiceTabelaBO.getNome().toUpperCase(), indiceTabelaBO);
                ++this.contadorIndice;
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return indices;
    }

    private Map<String, CampoTabelaBO> getCamposTabela(DatabaseMetaData meta, String nomeTela) throws BBException {
        LinkedHashMap<String, CampoTabelaBO> campos = new LinkedHashMap<String, CampoTabelaBO>();
        try {
            ResultSet rs = meta.getColumns("", "", nomeTela, null);
            while (rs.next()) {
                CampoTabelaBO campo = new CampoTabelaBO(rs.getString("COLUMN_NAME"));
                campo.setTipoCampo(rs.getString("TYPE_NAME"));
                campo.setTamanho(rs.getInt("COLUMN_SIZE"));
                campo.setPermiteNulo(!rs.getString("IS_NULLABLE").equalsIgnoreCase("NO"));
                campo.setSequencial(rs.getInt("ORDINAL_POSITION"));
                if (campo.getTipoCampo().indexOf("CHAR") != -1) {
                    campo.setTipoCampo(String.valueOf(campo.getTipoCampo()) + "(" + campo.getTamanho() + ")");
                } else if (campo.getTipoCampo().indexOf("DECIMAL") != -1) {
                    campo.setTipoCampo(String.valueOf(campo.getTipoCampo()) + "(" + campo.getTamanho() + ", 2)");
                }
                campos.put(campo.getNomeCampo().toUpperCase(), campo);
            }
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return campos;
    }

    public void bloquearBancoDados() throws BBException {
    }

    public void liberarBancoDados() throws BBException {
    }

    public void gerarXML(String versaoBD, String nomePasta, String nomeServico, Map<String, String> tabelasGerar, Map<String, String> tabelasBasicas, Map<String, String> mapFiltrosSQL) throws BBException {
        String nomeArquivo = "tabelas_" + nomeServico.toLowerCase() + ".xml";
        nomePasta = String.valueOf(nomePasta) + nomeServico.toLowerCase() + "/";
        Element tabelas = new Element("tabelas");
        Element versao = new Element("versao");
        versao.setAttribute("vrs", versaoBD);
        Element eTabela = null;
        Element eCampo = null;
        Element eIndice = null;
        Element eRelacionamento = null;
        tabelas.addContent(versao);
        Map<String, TabelaBO> listTabelas = this.getTabelasBancoDados();
        for (TabelaBO tabelaBO : listTabelas.values()) {
            if (tabelasGerar.get(tabelaBO.getNome().toUpperCase()) == null) continue;
            tabelaBO.setBasica(this.verificarBasica(tabelaBO.getNome(), tabelasBasicas));
            eTabela = new Element("tabela");
            eTabela.setAttribute("nome", tabelaBO.getNome());
            eTabela.setAttribute("versao", "1.0");
            eTabela.setAttribute("basica", tabelaBO.getBasica());
            eTabela.setAttribute("sobreescrever", "N");
            for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
                eCampo = new Element("campo");
                eCampo.setAttribute("nome", campoTabelaBO.getNomeCampo());
                eCampo.setAttribute("tipo", campoTabelaBO.getTipoCampo());
                eCampo.setAttribute("tamanho", String.valueOf(campoTabelaBO.getTamanho()));
                eCampo.setAttribute("permitenulo", campoTabelaBO.isPermiteNulo() ? "S" : "N");
                eCampo.setAttribute("sequencial", String.valueOf(campoTabelaBO.getSequencial()));
                eTabela.addContent(eCampo);
            }
            if (tabelaBO.getChavePrimaria() != null) {
                Element eChave = new Element("chaveprimaria");
                eChave.setAttribute("nome", String.valueOf(tabelaBO.getNome()) + "_PK");
                for (CampoTabelaBO campoTabelaBO : tabelaBO.getChavePrimaria().getCampos().values()) {
                    Element eCampoChave = new Element("campo");
                    eCampoChave.setAttribute("nome", campoTabelaBO.getNomeCampo());
                    eCampoChave.setAttribute("sequencial", "" + tabelaBO.getChavePrimaria().getSequencialCampos().get(campoTabelaBO.getNomeCampo().toUpperCase()));
                    eChave.addContent(eCampoChave);
                }
                eTabela.addContent(eChave);
            }
            int icnt = 0;
            for (IndiceTabelaBO indiceTabelaBO : tabelaBO.getIndices().values()) {
                eIndice = new Element("indice");
                eIndice.setAttribute("nome", String.valueOf(tabelaBO.getNome()) + "_IND_" + UtilString.completarAEsquerda("" + ++icnt, "0", 4));
                eIndice.setAttribute("unico", indiceTabelaBO.isUnico() ? "S" : "N");
                eIndice.setAttribute("ordenacao", indiceTabelaBO.getOrdenacao());
                for (CampoTabelaBO campoTabelaBO : indiceTabelaBO.getCampos().values()) {
                    eCampo = new Element("campo");
                    eCampo.setAttribute("nome", campoTabelaBO.getNomeCampo());
                    eIndice.addContent(eCampo);
                }
                eTabela.addContent(eIndice);
            }
            int iposic = 0;
            for (RelacionamentoTabelaBO relacionamentoTabelaBO : tabelaBO.getRelacionamentos().values()) {
                eRelacionamento = new Element("relacionamento");
                eRelacionamento.setAttribute("nome", String.valueOf(tabelaBO.getNome()) + "_" + relacionamentoTabelaBO.getTabelaOrigem().getNome() + "_FK");
                eRelacionamento.setAttribute("nometabelaorigem", relacionamentoTabelaBO.getTabelaOrigem().getNome());
                for (CampoRelacionamentoBO campoRelacionamentoBO : relacionamentoTabelaBO.getCampos().values()) {
                    eCampo = new Element("campo");
                    eCampo.setAttribute("origem", campoRelacionamentoBO.getNomeOrigem().getNomeCampo());
                    eCampo.setAttribute("destino", campoRelacionamentoBO.getNomeDestino().getNomeCampo());
                    eCampo.setAttribute("sequencial", String.valueOf(++iposic));
                    eRelacionamento.addContent(eCampo);
                }
                eTabela.addContent(eRelacionamento);
            }
            tabelas.addContent(eTabela);
        }
        Document doc = new Document();
        doc.setRootElement(tabelas);
        try {
            XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
            File saida = new File(String.valueOf(nomePasta) + "/" + nomeArquivo);
            FileOutputStream fos = new FileOutputStream(saida);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            osw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            xout.output(doc.getContent(), (Writer)osw);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        this.gerarTabelasBasicas(listTabelas, tabelasBasicas, mapFiltrosSQL, nomePasta, nomeServico);
    }

    private String verificarBasica(String nomeTabela, Map<String, String> tabelasBasicas) {
        String nomeTabelaBasica = tabelasBasicas.get(nomeTabela.toUpperCase());
        return nomeTabelaBasica == null ? "N" : "S";
    }

    private void gerarTabelasBasicas(Map<String, TabelaBO> listTabelas, Map<String, String> tabelasBasicas, Map<String, String> mapFiltrosSQL, String nomePasta, String nomeServico) throws BBException {
        for (String nomeTabela : tabelasBasicas.values()) {
            String s_sql = "SELECT * FROM " + nomeTabela;
            TabelaBO tabelaBO = listTabelas.get(nomeTabela.toUpperCase());
            System.out.println("Gerando tabela B\u00e1sica: " + nomeTabela);
            boolean acrescentouFiltro = false;
            if (tabelaBO == null) continue;
            Element tabela = new Element("tab_" + nomeTabela.toLowerCase());
            Element linha = null;
            try {
                for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
                    if (!"TX_IDFR_SRVC".equalsIgnoreCase(campoTabelaBO.getNomeCampo())) continue;
                    s_sql = String.valueOf(s_sql) + " WHERE TX_IDFR_SRVC='" + nomeServico + "'";
                    acrescentouFiltro = true;
                    break;
                }
                String filtroSQL = mapFiltrosSQL.get(nomeTabela.toUpperCase());
                if (filtroSQL != null && filtroSQL.length() > 0) {
                    s_sql = String.valueOf(s_sql) + (acrescentouFiltro ? " AND " : " WHERE ") + filtroSQL;
                }
                System.out.println(s_sql);
                ResultSet resultSet = this.executarQueryResult(s_sql);
                while (resultSet.next()) {
                    linha = new Element(nomeTabela.toLowerCase());
                    for (CampoTabelaBO campoTabelaBO : tabelaBO.getCampos().values()) {
                        linha.setAttribute(campoTabelaBO.getNomeCampo(), this.getStringFromCampo(campoTabelaBO, resultSet));
                    }
                    tabela.addContent(linha);
                }
                if (tabela.getChildren().size() <= 0) continue;
                Document doc = new Document();
                doc.setRootElement(tabela);
                try {
                    XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                    FileOutputStream fos = new FileOutputStream(new File((String.valueOf(nomePasta) + "tab_" + nomeTabela.toLowerCase() + ".xml").toLowerCase()));
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    osw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
                    xout.output(doc.getContent(), (Writer)osw);
                    fos.close();
                }
                catch (IOException e) {
                    throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
                }
            }
            catch (SQLException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
    }

    public boolean verificarAtualizacaoBancoDados() throws BBException {
        if (!this.getServicoAplicacaoDAO().testarExistenciaTabela()) {
            return true;
        }
        return this.getServicoAplicacaoDAO().verificarAtualizacaoBancoDados();
    }

    public boolean verificarAtualizacaoModulo() throws BBException {
        if (!this.getServicoAplicacaoDAO().testarExistenciaTabela()) {
            return true;
        }
        return this.getServicoAplicacaoDAO().verificarAtualizacaoModulo();
    }

    private String getValorSql(CampoTabelaBO campo, String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return "null";
        }
        if (campo.getTipoCampo().toLowerCase().indexOf("char") >= 0) {
            return "'" + valor.trim() + "'";
        }
        if (campo.getTipoCampo().toLowerCase().indexOf("date") >= 0 || campo.getTipoCampo().toLowerCase().indexOf("timestamp") >= 0) {
            return "'" + valor.substring(3, 5) + "/" + valor.substring(0, 2) + "/" + valor.subSequence(6, 10) + "'";
        }
        return valor;
    }

    public void atualizarRegistroModuloBancoDados(String nomeModulo, String versaoBancoXML, PluginInfo info) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        if (servicoAplicacaoTO == null) {
            servicoAplicacaoTO = new ServicoAplicacaoTO();
            servicoAplicacaoTO.setTextoIdentificadorServico(nomeModulo);
            servicoAplicacaoTO.setTextoNome(nomeModulo);
            servicoAplicacaoTO.setNumeroIdentificadorUsuarioInstalador(1);
            servicoAplicacaoTO.setDataInstalacao(new java.util.Date());
            servicoAplicacaoTO.setTextoDescricao(info.getTitulo());
            servicoAplicacaoTO.setCodigoTipoSegmento(info.getTipoSegmento());
            servicoAplicacaoTO.setNumeroIdentificadorUsuarioInstalador(1);
            servicoAplicacaoTO.setIndicadorEstadoServico(false);
            servicoAplicacaoTO.setIndicadorPrimeiraExecucao(true);
        } else {
            servicoAplicacaoTO.setIndicadorEstadoInstalacao(Util.parseLong(UtilString.completarADireita(UtilString.removerCaracteres(versaoBancoXML), "0", 5)) > Util.parseLong(UtilString.completarADireita(servicoAplicacaoTO.getIndicadorEstadoInstalacao(), "0", 5)) ? "T" : servicoAplicacaoTO.getIndicadorEstadoInstalacao());
        }
        servicoAplicacaoTO.setIndicadorEstadoInstalacao(true);
        servicoAplicacaoTO.setTextoVersaoBaseDados(versaoBancoXML);
        this.getServicoAplicacaoDAO().gravarServico(servicoAplicacaoTO);
    }

    public void registrarDadosAplicativo(String nomeModulo, PluginInfo pluginInfo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        if (servicoAplicacaoTO != null && (servicoAplicacaoTO.getTextoVersaoBaseDados() == null || servicoAplicacaoTO.getTextoVersaoBaseDados().equals(""))) {
            servicoAplicacaoTO.setTextoVersaoBaseDados("1.00.00");
        }
        if (servicoAplicacaoTO == null) {
            servicoAplicacaoTO = new ServicoAplicacaoTO();
            servicoAplicacaoTO.setNumeroIdentificadorUsuarioInstalador(1);
            servicoAplicacaoTO.setTextoIdentificadorServico(nomeModulo);
            servicoAplicacaoTO.setTextoNome(nomeModulo);
            servicoAplicacaoTO.setCodigoTipoSegmento(pluginInfo.getTipoSegmento());
            servicoAplicacaoTO.setIndicadorEstadoInstalacao("T");
            servicoAplicacaoTO.setIndicadorEstadoServico(false);
            servicoAplicacaoTO.setIndicadorPrimeiraExecucao(true);
            servicoAplicacaoTO.setNumeroDiasRetencaoDados(360);
            servicoAplicacaoTO.setNumeroFrequenciaExpurgo(360);
        } else if (servicoAplicacaoTO != null && Integer.parseInt(pluginInfo.getVersaodb().replace(".", "")) > Integer.parseInt(servicoAplicacaoTO.getTextoVersaoBaseDados().replace(".", ""))) {
            servicoAplicacaoTO.setIndicadorEstadoInstalacao("T");
        } else {
            servicoAplicacaoTO.setIndicadorEstadoInstalacao("V");
        }
        servicoAplicacaoTO.setTextoVersao(UtilString.removerCaracteres(pluginInfo.getVersao()));
        servicoAplicacaoTO.setTextoVersaoBaseDados(pluginInfo.getVersaodb());
        servicoAplicacaoTO.setDataInstalacao(new java.util.Date());
        servicoAplicacaoTO.setTextoDescricao(pluginInfo.getTitulo());
        if (this.verificarNovaVersaoBD(nomeModulo, this.getIniciarUtilizacaoModel().getVersaoBancoXML(nomeModulo))) {
            servicoAplicacaoTO.setIndicadorEstadoInstalacao("T");
        }
        this.getServicoAplicacaoDAO().gravarServico(servicoAplicacaoTO);
    }

    private IniciarUtilizacaoModel getIniciarUtilizacaoModel() {
        if (this.iniciarUtilizacaoModel == null) {
            this.iniciarUtilizacaoModel = new IniciarUtilizacaoModel();
        }
        return this.iniciarUtilizacaoModel;
    }

    public void setIniciarUtilizacaoModel(IniciarUtilizacaoModel iniciarUtilizacaoModel) {
        this.iniciarUtilizacaoModel = iniciarUtilizacaoModel;
    }

    public boolean vericarRegistroAplicativoInstalado(String nomeModulo) throws BBException {
        if ("GAC".equalsIgnoreCase(nomeModulo)) {
            return true;
        }
        if (!this.getServicoAplicacaoDAO().testarExistenciaTabela()) {
            return false;
        }
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        return servicoAplicacaoTO != null;
    }

    public boolean verificarPrimeiraExecucao(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        return servicoAplicacaoTO == null || !"2".equalsIgnoreCase(servicoAplicacaoTO.getIndicadorPrimeiraExecucao());
    }

    public boolean verificaVersaoDemonstracao(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        return servicoAplicacaoTO == null || !servicoAplicacaoTO.isIndicadorEstadoConfiguracaoServico();
    }

    public boolean testarExpurgoCadastroVencido(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        if (servicoAplicacaoTO.getDataExecucaoUltimoExpurgo() == null) {
            servicoAplicacaoTO.setDataExecucaoUltimoExpurgo(new java.util.Date());
            servicoAplicacaoTO.setDataInstalacao(new java.util.Date());
            servicoAplicacaoTO.setDataMigracaoDados(new java.util.Date());
            this.getServicoAplicacaoDAO().gravarServico(servicoAplicacaoTO);
        }
        if (servicoAplicacaoTO != null && servicoAplicacaoTO.getDataExecucaoUltimoExpurgo() != null) {
            java.util.Date hoje = this.getDataAtual();
            java.util.Date dataExpurgoAdDias = UtilSomadoresDeData.adicionarDias(servicoAplicacaoTO.getDataExecucaoUltimoExpurgo(), servicoAplicacaoTO.getNumeroFrequenciaExpurgo());
            boolean retorno = UtilComparadorDeDataMaior.comparar(hoje, dataExpurgoAdDias).equals(hoje);
            return retorno;
        }
        return false;
    }

    public void atualizarDataUltimaExecucao(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        if (servicoAplicacaoTO != null) {
            java.util.Date hoje = this.getDataAtual();
            servicoAplicacaoTO.setDataExecucaoUltimoExpurgo(hoje);
            this.getServicoAplicacaoDAO().gravarServico(servicoAplicacaoTO);
        }
    }

    private java.util.Date getDataAtual() {
        return DataFactory.getInstance().novoDate();
    }

    public boolean testarCopiaSeguranca(ConfiguracaoGerenciadorAplicativoClienteTODecorator to) throws BBException {
        Iterator<ControleCopiaSegurancaTO> iterator;
        List<ControleCopiaSegurancaTO> listaControleCopiaSegurancaTO = this.getControleCopiaSegurancaDAO().getMaximoDataBackup();
        if (!listaControleCopiaSegurancaTO.isEmpty() && (iterator = listaControleCopiaSegurancaTO.iterator()).hasNext()) {
            ControleCopiaSegurancaTO controleCopiaSegurancaTO = iterator.next();
            java.util.Date hoje = this.getDataAtual();
            java.util.Date dataBackupAdDias = UtilSomadoresDeData.adicionarDias(controleCopiaSegurancaTO.getDataEfetivacaoCopiaSeguranca(), to.getNumeroDiasCopiaSeguranca());
            boolean retorno = UtilComparadorDeDataMaior.comparar(hoje, dataBackupAdDias).equals(hoje);
            return retorno;
        }
        return false;
    }

    public List<String> consultarServicosAtualizarBD() throws BBException {
        return this.getServicoAplicacaoDAO().consultarServicosAtualizarBD();
    }

    public List<String> consultarServicosAtualizarSemAlteracaoDeBD() throws BBException {
        return this.getServicoAplicacaoDAO().consultarServicosAtualizarSemAlteracaoDeBD();
    }

    public void atualizarPrimeiraExecucao(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        if (servicoAplicacaoTO == null) {
            Plugin plugin = PluginController.getPlugin(nomeModulo);
            servicoAplicacaoTO = new ServicoAplicacaoTO();
            servicoAplicacaoTO.setTextoIdentificadorServico(nomeModulo);
            servicoAplicacaoTO.setTextoNome(nomeModulo);
            servicoAplicacaoTO.setNumeroIdentificadorUsuarioInstalador(1);
            servicoAplicacaoTO.setDataInstalacao(new java.util.Date());
            servicoAplicacaoTO.setTextoDescricao(plugin.getTitulo());
            servicoAplicacaoTO.setCodigoTipoSegmento(UtilConversorDeInteger.converterParaPrimitivo(plugin.getTipoSegmento()));
            servicoAplicacaoTO.setNumeroIdentificadorUsuarioInstalador(1);
            servicoAplicacaoTO.setIndicadorEstadoInstalacao("D");
            servicoAplicacaoTO.setIndicadorEstadoServico(false);
        }
        servicoAplicacaoTO.setIndicadorPrimeiraExecucao(false);
        this.getServicoAplicacaoDAO().gravarServico(servicoAplicacaoTO);
    }

    public void atualizarAplicativoConfigurado(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        servicoAplicacaoTO.setIndicadorEstadoConfiguracaoServico(true);
        servicoAplicacaoTO.setIndicadorEstadoServico(true);
        this.getServicoAplicacaoDAO().gravarServico(servicoAplicacaoTO);
    }

    public boolean testarCopiaSeguranca() throws BBException {
        try {
            Date dtUltimaCopia = null;
            Integer numeroDias = new Integer(0);
            Statement sment = this.getConexao().createStatement();
            String sql = "SELECT DT_EFTC_COP_SGCA FROM CTL_COP_SGCA  WHERE CD_IDFR_COP_SGCA = (SELECT MAX(CD_IDFR_COP_SGCA) FROM CTL_COP_SGCA)";
            ResultSet rs = sment.executeQuery(sql);
            if (rs.next()) {
                dtUltimaCopia = rs.getDate(1);
                rs.close();
            } else {
                this.definaDataInicialDaInstalacaoComoDataBackup(dtUltimaCopia);
            }
            sql = "SELECT NR_DD_COP_SGCA FROM CFG_GRDR_SIS_CLI";
            rs = sment.executeQuery(sql);
            if (rs.next()) {
                numeroDias = new Integer(rs.getInt(1));
                rs.close();
            }
            if (dtUltimaCopia != null && numeroDias != 0) {
                java.util.Date hoje = this.getDataAtual();
                java.util.Date dataBackupAdDias = UtilSomadoresDeData.adicionarDias(dtUltimaCopia, numeroDias);
                boolean retorno = UtilComparadorDeDataMaior.comparar(hoje, dataBackupAdDias).equals(hoje);
                rs.close();
                sment.close();
                return retorno;
            }
            dtUltimaCopia = null;
            sql = "SELECT DT_ULT_COP_SGCA FROM CFG_GRDR_SIS_CLI";
            rs = sment.executeQuery(sql);
            if (rs.next()) {
                dtUltimaCopia = rs.getDate(1);
                rs.close();
            }
            if (dtUltimaCopia == null) {
                this.definaDataInicialDaInstalacaoCFGSSISCLIComoDataBackp(dtUltimaCopia);
            }
            if (dtUltimaCopia != null && numeroDias != 0) {
                java.util.Date hoje = this.getDataAtual();
                java.util.Date dataBackupAdDias = UtilSomadoresDeData.adicionarDias(dtUltimaCopia, numeroDias);
                boolean retorno = UtilComparadorDeDataMaior.comparar(hoje, dataBackupAdDias).equals(hoje);
                rs.close();
                sment.close();
                return retorno;
            }
            rs.close();
            sment.close();
            return false;
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    private void definaDataInicialDaInstalacaoCFGSSISCLIComoDataBackp(java.util.Date dtUltimaCopia) throws BBException {
        Statement psment = null;
        try {
            try {
                String sql = "UPDATE CFG_GRDR_SIS_CLI SET DT_ULT_COP_SGCA = ? WHERE TX_IDFR_SRVC = ?";
                psment = this.getConexao().prepareStatement(sql);
                psment.setDate(1, new Date(new java.util.Date().getTime()));
                psment.setString(2, "GAC");
                int resultado = psment.executeUpdate();
                if (resultado > 0) {
                    dtUltimaCopia = new java.util.Date();
                }
            }
            catch (SQLException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        finally {
            if (psment != null) {
                try {
                    psment.close();
                }
                catch (SQLException e) {
                    throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
                }
            }
        }
    }

    private void definaDataInicialDaInstalacaoComoDataBackup(java.util.Date dtUltimaCopia) throws BBException {
        Statement psment = null;
        try {
            try {
                String sql = "INSERT INTO CTL_COP_SGCA (CD_IDFR_COP_SGCA,DT_EFTC_COP_SGCA) VALUES (?,?)";
                psment = this.getConexao().prepareStatement(sql);
                psment.setInt(1, 1);
                psment.setDate(2, new Date(new java.util.Date().getTime()));
                int resultado = psment.executeUpdate();
                if (resultado > 0) {
                    dtUltimaCopia = new java.util.Date();
                }
            }
            catch (SQLException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        finally {
            if (psment != null) {
                try {
                    psment.close();
                }
                catch (SQLException e) {
                    throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
                }
            }
        }
    }

    public ConfiguracaoGerenciadorAplicativoClienteTODecorator getConfiguracaoGerenciadorAplicativoClienteTODecorator() {
        if (this.configuracaoGerenciadorAplicativoClienteTODecorator == null) {
            this.configuracaoGerenciadorAplicativoClienteTODecorator = new ConfiguracaoGerenciadorAplicativoClienteTODecorator();
        }
        return this.configuracaoGerenciadorAplicativoClienteTODecorator;
    }

    public boolean verificarNovaVersaoBD(String nomeModulo, String versaoInstaladaBD) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        return servicoAplicacaoTO != null && (versaoInstaladaBD == null || versaoInstaladaBD.trim().length() == 0 || Util.parseLong(versaoInstaladaBD) > Util.parseLong(servicoAplicacaoTO.getTextoVersaoBaseDados()));
    }

    public void setServicoAplicacaoDAO(ServicoAplicacaoDAO servicoAplicacaoDAO) {
        this.servicoAplicacaoDAO = servicoAplicacaoDAO;
    }

    public boolean verificarAplicativoConfigurado(String nomeServico) throws BBException {
        return this.getServicoAplicacaoDAO().verificarAplicativoConfigurado(nomeServico);
    }

    public void desvincularConvenioEConvenenteDemonstracao(String nomeServico) throws BBException {
        this.getServicoAplicacaoDAO().desvincularConvenioEConvenenteDemonstracao(nomeServico);
    }
}

