/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.CamposLeiauteDAO;
import br.com.bb.plugins.gac.integracao.dao.LeiauteDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTOId;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ImportarDadosExternoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.LeiauteTODecorator;
import br.com.politec.generico.objeto.UtilObjeto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterLeiauteArquivoImportacaoModel
extends PluginModelAbstrato {
    private LeiauteDAO leiauteDAO;
    private CamposLeiauteDAO camposLeiauteDAO;

    public PaginadorTO consultar(LeiauteTODecorator leiauteTODecorator) {
        return this.getLeiauteDAO().consultarTodosSemTemplates(leiauteTODecorator);
    }

    public LeiauteTO consultarIncluirIMP() {
        if (this.getServicoAtual().equals("GAC")) {
            return this.getLeiauteDAO().consultarIncluirIMP("GAC", 1, 1);
        }
        if (this.getServicoAtual().equals("DBT")) {
            return this.getLeiauteDAO().consultarIncluirIMP("DBT", 3, 3);
        }
        return null;
    }

    public LeiauteTO consultarIncluirEXP() {
        if (this.getServicoAtual().equals("GAC")) {
            return this.getLeiauteDAO().consultarIncluirEXP("GAC", 2, 2);
        }
        if (this.getServicoAtual().equals("DBT")) {
            return this.getLeiauteDAO().consultarIncluirEXP("DBT", 4, 4);
        }
        return null;
    }

    public LeiauteDAO getLeiauteDAO() {
        return this.leiauteDAO;
    }

    public void setLeiauteDAO(LeiauteDAO leiauteDAO) {
        this.leiauteDAO = leiauteDAO;
    }

    public PaginadorTO listar(LeiauteTODecorator leiauteTO) throws BBException {
        leiauteTO.setTextoIdentificadorServico(this.getServicoAtual());
        return this.getLeiauteDAO().consultarPorTipoServicoSemTemplate(leiauteTO);
    }

    public Collection<LeiauteTO> consultarDBT(ImportarDadosExternoTODecorator importarDadosExternoTODecorato) {
        LeiauteTO leiauteTO = this.getFabricaDeTO().novoLeiauteTO();
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        servicoTO.setTextoIdentificadorServico("DBT");
        leiauteTO.setTipoLeiauteTO(importarDadosExternoTODecorato.getTipoLeiauteTO());
        leiauteTO.setServicoTO(servicoTO);
        LeiauteTODecorator leiauteTODecorator = this.getFabricaDeTO().novoLeiauteTODecorator(leiauteTO);
        leiauteTODecorator.setPaginaAtual(0);
        PaginadorTO paginadorTO = this.getLeiauteDAO().consultarPorTipoServicoSemTemplate(leiauteTODecorator);
        return paginadorTO.getColecaoDeRegistros();
    }

    public void excluir(LeiauteTO leiauteTO) {
        this.getLeiauteDAO().excluir(leiauteTO);
    }

    public LeiauteTO incluir(LeiauteTO leiauteTO) throws BBException {
        LeiauteTODecorator decorator = new LeiauteTODecorator();
        decorator.setLeiauteTO(leiauteTO);
        Set<CamposLeiauteTO> camposLeiauteTOs = leiauteTO.getCamposLeiauteTOs();
        if (this.getLeiauteDAO().isNomeLeiauteIgual(decorator)) {
            throw new BBException("MN049");
        }
        this.validarLeiaute(leiauteTO);
        leiauteTO.setCamposLeiauteTOs(null);
        LeiauteTO to = this.getLeiauteDAO().incluir(leiauteTO);
        int nuleiaute = to.getNumeroLeiaute();
        int numeroCampoLeiaute = 1;
        HashSet<CamposLeiauteTO> tos = new HashSet<CamposLeiauteTO>(0);
        for (CamposLeiauteTO camposLeiauteTO : camposLeiauteTOs) {
            CamposLeiauteTOId id = this.getFabricaDeTO().novoCamposLeiauteTOId();
            CamposLeiauteTO cto = this.getFabricaDeTO().novoCamposLeiauteTO();
            id.setNumeroLeiaute(nuleiaute);
            id.setNumeroCampoLeiaute(numeroCampoLeiaute++);
            cto.setNumeroPosicaoInicio(camposLeiauteTO.getNumeroPosicaoInicio());
            cto.setNumeroTamanhoCampo(camposLeiauteTO.getNumeroTamanhoCampo());
            cto.setNumeroTamanhoMaximo(camposLeiauteTO.getNumeroTamanhoMaximo());
            cto.setTextoDescricaoCampo(camposLeiauteTO.getTextoDescricaoCampo());
            cto.setTextoNomeCampo(camposLeiauteTO.getTextoNomeCampo());
            cto.setId(id);
            this.getCamposLeiauteDAO().incluirSemIncrementoDeChave(cto);
            tos.add(cto);
        }
        to.setCamposLeiauteTOs(tos);
        return to;
    }

    public void editar(LeiauteTO leiauteTO) throws BBException {
        this.validarLeiaute(leiauteTO);
        LeiauteTODecorator decorator = new LeiauteTODecorator();
        decorator.setLeiauteTO(leiauteTO);
        ArrayList<LeiauteTO> tos = new ArrayList<LeiauteTO>(this.getLeiauteDAO().getNomeLeiauteIgual(decorator));
        int i = 0;
        while (i < tos.size()) {
            LeiauteTO to = tos.get(i);
            if (to.getNumeroLeiaute().intValue() != leiauteTO.getNumeroLeiaute().intValue() && to.getTextoDescricaoLeiaute().equals(leiauteTO.getTextoDescricaoLeiaute())) {
                throw new BBException("MN049");
            }
            ++i;
        }
        this.getLeiauteDAO().alterar(leiauteTO);
    }

    private void verificaTamanhoLeiaute(int somatorioTamanhoCampos, Integer numeroTamanhoRegistro) throws BBException {
        if (numeroTamanhoRegistro < somatorioTamanhoCampos) {
            throw new BBException("MN011");
        }
    }

    private void verificaSobreposicaoCampos(LeiauteTO leiauteTO, CamposLeiauteTO camposLeiauteTO) throws BBException {
        int numeroPosicaoInicio = camposLeiauteTO.getNumeroPosicaoInicio();
        int tamanhoCampo = camposLeiauteTO.getNumeroTamanhoCampo();
        if (tamanhoCampo == 0) {
            return;
        }
        String descricaoCampo = camposLeiauteTO.getTextoDescricaoCampo().trim();
        for (CamposLeiauteTO camposLeiauteTO2 : leiauteTO.getCamposLeiauteTOs()) {
            if (camposLeiauteTO == camposLeiauteTO2) continue;
            int numeroPosicaoInicio2 = camposLeiauteTO2.getNumeroPosicaoInicio();
            int tamanhoCampo2 = camposLeiauteTO2.getNumeroTamanhoCampo();
            if (tamanhoCampo2 == 0) continue;
            String descricaoCampo2 = camposLeiauteTO2.getTextoDescricaoCampo();
            if (!this.NumeroEstaEntre(numeroPosicaoInicio2, numeroPosicaoInicio, numeroPosicaoInicio + tamanhoCampo - 1)) continue;
            System.out.println(String.valueOf(descricaoCampo) + " " + descricaoCampo2);
            throw new BBException("MN070", " Campo que excede: " + descricaoCampo + ", campo afetado: " + descricaoCampo2);
        }
    }

    private boolean NumeroEstaEntre(int numeroPosicaoInicio2, int numeroPosicaoInicio, int posicaoFinalCampo) {
        return numeroPosicaoInicio2 >= numeroPosicaoInicio && numeroPosicaoInicio2 <= posicaoFinalCampo;
    }

    private void verificaTamanhoCampo(CamposLeiauteTO camposLeiauteTO, LeiauteTO to) throws BBException {
        Integer numeroTamanhoCampo = camposLeiauteTO.getNumeroTamanhoCampo();
        Integer numeroTamanhoMaximo = camposLeiauteTO.getNumeroTamanhoMaximo();
        if (!UtilObjeto.isReferencia(numeroTamanhoCampo) || this.isTamanhoCampoMenorQueUm(numeroTamanhoCampo) || this.isTamanhoCampoMaiorPermitido(numeroTamanhoCampo, numeroTamanhoMaximo)) {
            throw new BBException("MN069", " Descri\u00e7\u00e3o do campo: " + camposLeiauteTO.getTextoDescricaoCampo() + ", tamanho cadastrado para campo: " + numeroTamanhoCampo + ", tamanho m\u00e1ximo permitido: " + numeroTamanhoMaximo);
        }
        if (this.isTamanhoCampoMaiorPermitido(camposLeiauteTO.getNumeroPosicaoInicio() + numeroTamanhoCampo - 1, to.getNumeroTamanhoRegistro())) {
            throw new BBException("MN069", " Tamanho total: " + (camposLeiauteTO.getNumeroPosicaoInicio() + numeroTamanhoCampo - 1) + ", tamanho m\u00e1ximo permitido para o registro: " + to.getNumeroTamanhoRegistro());
        }
    }

    private boolean isTamanhoCampoMaiorPermitido(Integer numeroTamanhoCampo, Integer numeroTamanhoMaximo) {
        return numeroTamanhoCampo > numeroTamanhoMaximo;
    }

    private boolean isTamanhoCampoMenorQueUm(Integer numeroTamanhoCampo) {
        return numeroTamanhoCampo < 1;
    }

    public Collection<LeiauteTO> consultarGAC() {
        LeiauteTO leiauteTO = this.getFabricaDeTO().novoLeiauteTO();
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        servicoTO.setTextoIdentificadorServico("GAC");
        leiauteTO.setServicoTO(servicoTO);
        return this.getLeiauteDAO().consultarPeloServico(leiauteTO);
    }

    public CamposLeiauteDAO getCamposLeiauteDAO() {
        return this.camposLeiauteDAO;
    }

    public void setCamposLeiauteDAO(CamposLeiauteDAO camposLeiauteDAO) {
        this.camposLeiauteDAO = camposLeiauteDAO;
    }

    private void validarLeiaute(LeiauteTO leiauteTO) throws BBException {
        int somatorioTamanhoCampos = 0;
        ValidadorCampo vc = new ValidadorCampo();
        for (CamposLeiauteTO camposLeiauteTO : leiauteTO.getCamposLeiauteTOs()) {
            somatorioTamanhoCampos += camposLeiauteTO.getNumeroTamanhoCampo().intValue();
            this.verificaTamanhoCampo(camposLeiauteTO, leiauteTO);
            this.verificaSobreposicaoCampos(leiauteTO, camposLeiauteTO);
            if (!vc.Adiciona(camposLeiauteTO.getNumeroPosicaoInicio(), camposLeiauteTO.getNumeroTamanhoCampo())) continue;
            throw new BBException("MN012");
        }
        this.verificaTamanhoLeiaute(somatorioTamanhoCampos, leiauteTO.getNumeroTamanhoRegistro());
    }

    public Collection<LeiauteTO> consultarGAC(ImportarDadosExternoTODecorator importarDadosExternoTODecorato) {
        LeiauteTO leiauteTO = this.getFabricaDeTO().novoLeiauteTO();
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        servicoTO.setTextoIdentificadorServico("GAC");
        leiauteTO.setTipoLeiauteTO(importarDadosExternoTODecorato.getTipoLeiauteTO());
        leiauteTO.setServicoTO(servicoTO);
        LeiauteTODecorator leiauteTODecorator = this.getFabricaDeTO().novoLeiauteTODecorator(leiauteTO);
        leiauteTODecorator.setPaginaAtual(0);
        PaginadorTO paginadorTO = this.getLeiauteDAO().consultarPorTipoServicoSemTemplate(leiauteTODecorator);
        return paginadorTO.getColecaoDeRegistros();
    }

    protected class ValidadorCampo {
        private int inicio = 0;
        private int fim = 0;
        private int tamanho = 0;
        private ArrayList<ValidadorCampo> colecao;

        protected ValidadorCampo() {
        }

        private boolean Adiciona(int inicio, int tamanho) {
            ValidadorCampo vc = new ValidadorCampo();
            vc.setInicio(inicio);
            vc.setFim(inicio + tamanho);
            vc.setTamanho(tamanho);
            this.getColecao().add(vc);
            return this.validaColecao(vc);
        }

        private boolean validaColecao(ValidadorCampo vco) {
            boolean resultado = false;
            int i = 0;
            while (i < this.getColecao().size()) {
                ValidadorCampo dest = (ValidadorCampo)this.getColecao().get(i);
                if (!dest.equals(vco) && vco.getFim() > dest.getInicio() && vco.getFim() <= dest.getFim()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public int getInicio() {
            return this.inicio;
        }

        public void setInicio(int inicio) {
            this.inicio = inicio;
        }

        public int getFim() {
            return this.fim;
        }

        public void setFim(int fim) {
            this.fim = fim;
        }

        public ArrayList getColecao() {
            if (this.colecao == null) {
                this.colecao = new ArrayList(1);
            }
            return this.colecao;
        }

        public void setColecao(ArrayList colecao) {
            this.colecao = colecao;
        }

        public int getTamanho() {
            return this.tamanho;
        }

        public void setTamanho(int tamanho) {
            this.tamanho = tamanho;
        }
    }
}

