/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.AuditoriaDAO;
import br.com.bb.plugins.gac.integracao.dao.EstadoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.PermissaoGrupoDAO;
import br.com.bb.plugins.gac.integracao.dao.PermissaoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.UsuarioDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.AuditoriaTO;
import br.com.bb.plugins.gac.negocio.to.EstadoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.negocio.to.decorator.UsuarioTODecorator;
import br.com.bb.plugins.gac.util.Criptografia;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import br.com.politec.generico.string.UtilString;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public class ManterUsuarioModel
extends PluginModelAbstrato {
    private UsuarioDAO usuarioDAO;
    private EstadoUsuarioDAO estadoUsuarioDAO;
    private AuditoriaDAO auditoriaDAO;
    private PermissaoUsuarioDAO permissaoUsuarioDAO;
    private PermissaoGrupoDAO permissaoGrupoDAO;

    public AuditoriaDAO getAuditoriaDAO() {
        return this.auditoriaDAO;
    }

    public void setAuditoriaDAO(AuditoriaDAO auditoriaDAO) {
        this.auditoriaDAO = auditoriaDAO;
    }

    public PaginadorTO listar(UsuarioTODecorator to) {
        return this.getUsuarioDAO().consultarTodos(to);
    }

    public UsuarioTO listarPorNome(UsuarioTO usuarioTO) {
        return this.getUsuarioDAO().listarPorNome(usuarioTO);
    }

    public UsuarioTO incluir(UsuarioTODecorator to) {
        UsuarioTO usuarioTO = null;
        UsuarioTO usu = this.getUsuarioDAO().listarPorNome(to.getUsuarioTO());
        if (!this.isReferencia(usu)) {
            EstadoUsuarioTO estadoUsuarioTO = (EstadoUsuarioTO)((Object)this.getEstadoUsuarioDAO().listar(1));
            to.getUsuarioTO().setEstadoUsuarioTO(estadoUsuarioTO);
            to.getUsuarioTO().setDataCadastramentoUsuario(Calendar.getInstance().getTime());
            to.getUsuarioTO().setIndicadorAlteracaoSenha(Character.valueOf('S'));
            usuarioTO = this.getUsuarioDAO().incluir(to.getUsuarioTO());
        }
        return usuarioTO;
    }

    public void alterarSenha(UsuarioTODecorator usuarioTODecorator) throws BBException {
        UsuarioTO usuarioTOLogado = this.recuperaUsuarioLogado(usuarioTODecorator);
        usuarioTOLogado.setTextoSenha(Criptografia.cifrar(UtilString.minuscula(usuarioTODecorator.getTextoSenhaNova())));
        usuarioTOLogado.setIndicadorAlteracaoSenha(Character.valueOf('N'));
        this.getUsuarioDAO().alterar(usuarioTOLogado);
    }

    private UsuarioTO recuperaUsuarioLogado(UsuarioTODecorator usuarioTODecorator) {
        PluginControladorDeAcesso acesso = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
        usuarioTODecorator.setNumeroIdentificadorUsuario(acesso.getNumeroIdentificadorUsuario());
        UsuarioTO usuarioTOAlterar = this.getUsuarioDAO().listar(usuarioTODecorator.getUsuarioTO());
        return usuarioTOAlterar;
    }

    private void verificaSenhaNovaIgualSenhaConfirmacao(UsuarioTODecorator usuarioTODecorator) throws BBException {
        if (this.ehSenhaNovaDiferenteDaSenhaConfirmacao(usuarioTODecorator)) {
            throw new BBException("MN043");
        }
    }

    private boolean ehSenhaNovaDiferenteDaSenhaConfirmacao(UsuarioTODecorator usuarioTODecorator) {
        return !UtilString.isStringsIguais(UtilString.minuscula(usuarioTODecorator.getTextoSenhaNova()), UtilString.minuscula(usuarioTODecorator.getTextoSenhaConfirmar()));
    }

    private void verificaSenhaInformadaDiferenteDaSenhaAtual(UsuarioTODecorator usuarioTODecorator) throws BBException {
        if (this.ehUmaNovaSenhaIgualASenhaAnterior(usuarioTODecorator)) {
            UtilMensagem.getInstancia().getMensagem("MN016");
            throw new BBException("MN016");
        }
    }

    private boolean ehUmaNovaSenhaIgualASenhaAnterior(UsuarioTODecorator usuarioTODecorator) {
        return UtilString.isStringsIguais(UtilString.minuscula(usuarioTODecorator.getTextoSenhaAtualInformada()), UtilString.minuscula(usuarioTODecorator.getTextoSenhaNova()));
    }

    private void verificaAutenticidadeDaSenhaInformada(UsuarioTODecorator usuarioTODecorator, UsuarioTO usuarioTOAlterar) throws BBException {
        if (this.naoEhSenhaDoUsuarioAtual(usuarioTODecorator, usuarioTOAlterar)) {
            throw new BBException("MP037");
        }
    }

    private boolean naoEhSenhaDoUsuarioAtual(UsuarioTODecorator usuarioTODecorator, UsuarioTO usuarioTOAlterar) {
        return !UtilString.isStringsIguais(UtilString.minuscula(usuarioTODecorator.getTextoSenhaAtualInformada()), Criptografia.decifrar(UtilString.minuscula(usuarioTOAlterar.getTextoSenha())));
    }

    public UsuarioDAO getUsuarioDAO() {
        return this.usuarioDAO;
    }

    public void setUsuarioDAO(UsuarioDAO usuarioDAO) {
        this.usuarioDAO = usuarioDAO;
    }

    public void editar(UsuarioTODecorator to) throws BBException {
        UsuarioTO usu;
        Collection<UsuarioTO> usuarios;
        if ((to.getGrupoUsuarioTO() == null || to.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario() != null && to.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario() != 1) && (usuarios = this.getUsuarioDAO().consultar(null, 1, 1)).size() < 2) {
            if (usuarios.size() == 1) {
                UsuarioTO usuTmp;
                Iterator<UsuarioTO> iterator = usuarios.iterator();
                if (iterator.hasNext() && (usuTmp = iterator.next()).getNumeroIdentificadorUsuario().intValue() == to.getNumeroIdentificadorUsuario().intValue()) {
                    throw new BBException("MN055");
                }
            } else {
                throw new BBException("MN055");
            }
        }
        if (this.isReferencia(usu = this.getUsuarioDAO().listarOutroUsuarioPorNome(to.getUsuarioTO()))) {
            throw new BBException("MP032");
        }
        this.getUsuarioDAO().alterar(to.getUsuarioTO());
    }

    public boolean excluir(UsuarioTODecorator to) throws BBException {
        Collection<UsuarioTO> usuarios;
        boolean resultado = false;
        if (to.getGrupoUsuarioTO() != null && to.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario() != null && to.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario() == 1 && (usuarios = this.getUsuarioDAO().consultar(null, 1, 1)).size() < 2) {
            return false;
        }
        Collection<AuditoriaTO> auditUsuario = this.getAuditoriaDAO().consultarPorUsuario(to.getUsuarioTO());
        boolean bl = resultado = auditUsuario.size() != 0;
        if (!resultado) {
            this.getUsuarioDAO().excluir(to.getUsuarioTO().getNumeroIdentificadorUsuario());
        }
        return !resultado;
    }

    public EstadoUsuarioDAO getEstadoUsuarioDAO() {
        return this.estadoUsuarioDAO;
    }

    public void setEstadoUsuarioDAO(EstadoUsuarioDAO estadoUsuarioDAO) {
        this.estadoUsuarioDAO = estadoUsuarioDAO;
    }

    public void ativar(UsuarioTODecorator usuarioTODecorator) {
        this.getUsuarioDAO().ativar(usuarioTODecorator);
    }

    public void desativar(UsuarioTODecorator usuarioTODecorator) {
        this.getUsuarioDAO().desativar(usuarioTODecorator);
    }

    public PermissaoUsuarioDAO getPermissaoUsuarioDAO() {
        return this.permissaoUsuarioDAO;
    }

    public void setPermissaoUsuarioDAO(PermissaoUsuarioDAO permissaoUsuarioDAO) {
        this.permissaoUsuarioDAO = permissaoUsuarioDAO;
    }

    public PermissaoGrupoDAO getPermissaoGrupoDAO() {
        return this.permissaoGrupoDAO;
    }

    public void setPermissaoGrupoDAO(PermissaoGrupoDAO permissaoGrupoDAO) {
        this.permissaoGrupoDAO = permissaoGrupoDAO;
    }

    public boolean verificaAutenticidadeDaSenhaInformada(UsuarioTODecorator usuarioTODecorator) {
        UsuarioTO usuarioTO = this.recuperaUsuarioLogado(usuarioTODecorator);
        return this.naoEhSenhaDoUsuarioAtual(usuarioTODecorator, usuarioTO);
    }

    public boolean haSenhaInformadaDiferenteDaSenhaAtual(UsuarioTODecorator usuarioTODecorator) {
        return this.ehUmaNovaSenhaIgualASenhaAnterior(usuarioTODecorator);
    }

    public boolean haSenhaNovaIgualSenhaConfirmacao(UsuarioTODecorator usuarioTODecorator) {
        return this.ehSenhaNovaDiferenteDaSenhaConfirmacao(usuarioTODecorator);
    }

    public String consultarSenha(UsuarioTO usuario) {
        return Criptografia.decifrar(this.getUsuarioDAO().consultarSenha(usuario));
    }
}

