/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.service;

import br.com.bb.plugins.gac.negocio.service.AtualizarSistemaService;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.controller.servico.AbstractService;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelAtualizacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelInstalacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoInstaladoBO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtualizarSistemaServiceImpl
extends AbstractService
implements AtualizarSistemaService {
    private List<Plugin> pluginsMap = new ArrayList<Plugin>();

    @Override
    public void LerConfiguracoes() {
        ConfiguracaoProperties config = ConfiguracaoProperties.getConfiguracaoProperties();
        File fileapp = new File(String.valueOf(config.getDirTemp()) + "/aplicativos.xml");
        SAXBuilder sax = new SAXBuilder();
        this.pluginsMap.clear();
        try {
            Document doc = sax.build(fileapp);
            Element tab = doc.getRootElement();
            List lista = tab.getChildren("aplicativo");
            for (Element element : lista) {
                Plugin plugin = new Plugin();
                plugin.setNome(element.getChildText("sigla"));
                plugin.setTitulo(element.getChildText("titulo"));
                plugin.setVersao(element.getChildText("versao"));
                plugin.setVersaoDB(element.getChildText("versaodb"));
                plugin.setDatapacote(element.getChildText("datapacote"));
                plugin.setNomejar(element.getChildText("nomejar"));
                plugin.setVersaominimagac(element.getChildText("versaominimagac"));
                System.out.println("Versao minima gac: " + element.getChildText("versaominimagac"));
                plugin.setTamanho(Util.parseLong(element.getChildText("tamanho")));
                this.pluginsMap.add(plugin);
            }
        }
        catch (JDOMException e) {
            System.out.println("Ocorreu o erro: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Ocorreu o erro: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public Vector<AplicativoInstaladoBO> BuscaAplicativosInstalados() {
        Vector<AplicativoInstaladoBO> apps = new Vector<AplicativoInstaladoBO>();
        Iterator<Plugin> iter = PluginController.getInstance().getPlugins().iterator();
        AplicativoInstaladoBO appgacinst = new AplicativoInstaladoBO("GAC", "GAC", "1.0", "19/11/2007", "22/11/2007", "ADMINISTRADOR");
        apps.add(appgacinst);
        while (iter.hasNext()) {
            Plugin o = iter.next();
            if (!(o instanceof Plugin)) continue;
            Plugin plg = o;
            AplicativoInstaladoBO appinst = new AplicativoInstaladoBO(plg.getNome(), plg.getTitulo(), plg.getVersao(), plg.getDatapacote(), "22/11/2007", "ADMINISTRADOR");
            apps.add(appinst);
        }
        return apps;
    }

    @Override
    public Vector<AplicativoDisponivelAtualizacaoBO> BuscaAplicativosDisponiveisAtualizacao() {
        Vector<AplicativoDisponivelAtualizacaoBO> apps = new Vector<AplicativoDisponivelAtualizacaoBO>();
        for (Plugin o : PluginController.getInstance().getPlugins()) {
            Plugin plg;
            Plugin plgretorno;
            if (!(o instanceof Plugin) || (plgretorno = this.ExisteAtualizacao(plg = o)) == null) continue;
            AplicativoDisponivelAtualizacaoBO appinst = new AplicativoDisponivelAtualizacaoBO(plg.getNome(), plg.getTitulo(), plg.getVersao(), plgretorno.getVersao(), plgretorno.getDatapacote(), "", plgretorno.getNomejar(), plgretorno.getTamanho(), "2.0");
            apps.add(appinst);
        }
        return apps;
    }

    private Plugin ExisteAtualizacao(Plugin plg) {
        Iterator<Plugin> iter = this.pluginsMap.iterator();
        Plugin plgretorno = null;
        while (iter.hasNext()) {
            Plugin o = iter.next();
            if (!(o instanceof Plugin)) continue;
            Plugin plugin = o;
            if (!plg.getNome().equals(plugin.getNome()) || !this.EProximaAtualizacao(plg, plgretorno, plugin)) continue;
            plgretorno = plugin;
        }
        return plgretorno;
    }

    private boolean EProximaAtualizacao(Plugin plg, Plugin plgretorno, Plugin plugin) {
        boolean result = false;
        result = plgretorno == null ? Util.getDiasDaData(plg.getDatapacote()) < Util.getDiasDaData(plugin.getDatapacote()) : Util.getDiasDaData(plgretorno.getDatapacote()) > Util.getDiasDaData(plugin.getDatapacote());
        return result;
    }

    @Override
    public Vector<AplicativoDisponivelInstalacaoBO> BuscaAplicativosDisponiveisInstalacao() {
        Vector<AplicativoDisponivelInstalacaoBO> apps = new Vector<AplicativoDisponivelInstalacaoBO>();
        for (Plugin o : this.pluginsMap) {
            Plugin plg;
            if (!(o instanceof Plugin) || this.PluginInstalado(plg = o)) continue;
            AplicativoDisponivelInstalacaoBO appinst = new AplicativoDisponivelInstalacaoBO(plg.getNome(), plg.getTitulo(), plg.getVersao(), plg.getDatapacote(), "", plg.getNomejar(), plg.getTamanho(), "2.0");
            apps.add(appinst);
        }
        return apps;
    }

    private boolean PluginInstalado(Plugin plg) {
        for (Plugin o : PluginController.getInstance().getPlugins()) {
            Plugin plugin;
            if (!(o instanceof Plugin) || !(plugin = o).getNome().equals(plg.getNome())) continue;
            return true;
        }
        return false;
    }
}

