/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.service;

import br.com.bb.plugins.gac.integracao.dao.EstadoGrupoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.EstadoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.GrupoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.UsuarioDAO;
import br.com.bb.plugins.gac.negocio.service.UsuarioService;
import br.com.bb.plugins.gac.negocio.to.EstadoGrupoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.EstadoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.util.controller.servico.AbstractService;
import java.util.Collection;
import org.hibernate.Hibernate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsuarioServiceImpl
extends AbstractService
implements UsuarioService {
    private UsuarioDAO usuarioDAO;
    private GrupoUsuarioDAO grupoUsuarioDAO;
    private EstadoGrupoUsuarioDAO estadoGrupoUsuarioDAO;
    private EstadoUsuarioDAO estadoUsuarioDAO;

    @Override
    public Collection<UsuarioTO> findAllUsuarios() {
        return this.usuarioDAO.consultar();
    }

    @Override
    public Collection findUsuarioPorFiltro(String usuario, int grupo, int situacao) {
        return this.usuarioDAO.consultar(usuario, grupo, situacao);
    }

    @Override
    public void gravaUsuario(UsuarioTO usu) {
        this.usuarioDAO.incluirOuAlterar(usu);
    }

    @Override
    public void removeUsuario(UsuarioTO usu) {
    }

    @Override
    public Collection<GrupoUsuarioTO> findAllGrupos() {
        return this.grupoUsuarioDAO.consultar();
    }

    public EstadoUsuarioDAO getEstadoUsuarioDAO() {
        return this.estadoUsuarioDAO;
    }

    public void setEstadoUsuarioDAO(EstadoUsuarioDAO estadoUsuarioDAO) {
        this.estadoUsuarioDAO = estadoUsuarioDAO;
    }

    public GrupoUsuarioDAO getGrupoUsuarioDAO() {
        return this.grupoUsuarioDAO;
    }

    public void setGrupoUsuarioDAO(GrupoUsuarioDAO grupoUsuarioDAO) {
        this.grupoUsuarioDAO = grupoUsuarioDAO;
    }

    @Override
    public UsuarioDAO getUsuarioDAO() {
        return this.usuarioDAO;
    }

    public void setUsuarioDAO(UsuarioDAO usuarioDAO) {
        this.usuarioDAO = usuarioDAO;
    }

    @Override
    public Collection<EstadoGrupoUsuarioTO> findAllEstados() {
        return this.estadoGrupoUsuarioDAO.consultar();
    }

    public EstadoGrupoUsuarioDAO getEstadoGrupoUsuarioDAO() {
        return this.estadoGrupoUsuarioDAO;
    }

    public void setEstadoGrupoUsuarioDAO(EstadoGrupoUsuarioDAO estadoGrupoUsuarioDAO) {
        this.estadoGrupoUsuarioDAO = estadoGrupoUsuarioDAO;
    }

    @Override
    public Collection findNomePorFiltro(String nome, int grupo, int situacao) {
        return this.usuarioDAO.consultarPorNomeNoSistema(nome, grupo, situacao);
    }

    @Override
    public EstadoUsuarioTO findEstadoUsuarioTO(Integer id) {
        return (EstadoUsuarioTO)((Object)this.estadoUsuarioDAO.listar(id));
    }

    @Override
    public UsuarioTO getUsuarioTO(Integer id) {
        UsuarioTO usuto = (UsuarioTO)((Object)this.usuarioDAO.listar(id));
        Hibernate.initialize((Object)usuto.getGrupoUsuarioTO());
        Hibernate.initialize((Object)usuto.getEstadoUsuarioTO());
        return usuto;
    }
}

