/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.to;

import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTOId;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="IDFR")
public class IdentificadorTO
extends PluginTOAbstrato {
    private IdentificadorTOId id;
    private String nomeIdentificador;
    private Integer numeroTamanhoIdentificador;
    private String textoMascara;
    private String textoMascaraSaida;
    private Character indicadorDominio;
    private Integer numeroQuantidadeMinima;
    private Integer numeroQuantidadeMaxima;
    private Character indicadorComplemento;
    private Character textoMascaraIdentificadora;
    private Character textoIdentificadorInscricaoDebito;
    private Character indicadorEstadoIdentificador;
    private TipoDocumentoTO tipoDocumentoTO;
    private Set<IdentificacaoTO> identificacaoTOs = new LinkedHashSet<IdentificacaoTO>(0);
    private Set<ConvenenteTO> convenenteTOs = new LinkedHashSet<ConvenenteTO>(0);

    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="textoIdentificador", column=@Column(name="TX_IDFR", nullable=false)), @AttributeOverride(name="codigoTipoDocumento", column=@Column(name="CD_TIP_DOC", nullable=false))})
    public IdentificadorTOId getId() {
        if (this.id == null) {
            this.id = new IdentificadorTOId();
        }
        return this.id;
    }

    public void setId(IdentificadorTOId id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CD_TIP_DOC", nullable=false, insertable=false, updatable=false)
    public TipoDocumentoTO getTipoDocumentoTO() {
        return this.tipoDocumentoTO;
    }

    public void setTipoDocumentoTO(TipoDocumentoTO tipoDocumentoTO) {
        this.tipoDocumentoTO = tipoDocumentoTO;
    }

    @Column(name="NM_IDFR", nullable=false, length=50)
    public String getNomeIdentificador() {
        return this.nomeIdentificador;
    }

    public void setNomeIdentificador(String nomeIdentificador) {
        this.nomeIdentificador = nomeIdentificador;
    }

    @Column(name="NR_TAM_IDFR")
    public Integer getNumeroTamanhoIdentificador() {
        return this.numeroTamanhoIdentificador;
    }

    public void setNumeroTamanhoIdentificador(Integer numeroTamanhoIdentificador) {
        this.numeroTamanhoIdentificador = numeroTamanhoIdentificador;
    }

    @Column(name="TX_MCR", length=50)
    public String getTextoMascara() {
        return this.textoMascara;
    }

    public void setTextoMascara(String textoMascara) {
        this.textoMascara = textoMascara;
    }

    @Column(name="TX_MCR_SAID", length=50)
    public String getTextoMascaraSaida() {
        return this.textoMascaraSaida;
    }

    public void setTextoMascaraSaida(String textoMascaraSaida) {
        this.textoMascaraSaida = textoMascaraSaida;
    }

    @Column(name="IN_DOM", length=1)
    public Character getIndicadorDominio() {
        return this.indicadorDominio;
    }

    public void setIndicadorDominio(Character indicadorDominio) {
        this.indicadorDominio = indicadorDominio;
    }

    @Column(name="NR_QT_MIN")
    public Integer getNumeroQuantidadeMinima() {
        return this.numeroQuantidadeMinima;
    }

    public void setNumeroQuantidadeMinima(Integer numeroQuantidadeMinima) {
        this.numeroQuantidadeMinima = numeroQuantidadeMinima;
    }

    @Column(name="NR_QT_MAX")
    public Integer getNumeroQuantidadeMaxima() {
        return this.numeroQuantidadeMaxima;
    }

    public void setNumeroQuantidadeMaxima(Integer numeroQuantidadeMaxima) {
        this.numeroQuantidadeMaxima = numeroQuantidadeMaxima;
    }

    @Column(name="IN_CMPT", length=1)
    public Character getIndicadorComplemento() {
        return this.indicadorComplemento;
    }

    public void setIndicadorComplemento(Character indicadorComplemento) {
        this.indicadorComplemento = indicadorComplemento;
    }

    @Column(name="TX_MCR_IDFR", length=1)
    public Character getTextoMascaraIdentificadora() {
        return this.textoMascaraIdentificadora;
    }

    public void setTextoMascaraIdentificadora(Character textoMascaraIdentificadora) {
        this.textoMascaraIdentificadora = textoMascaraIdentificadora;
    }

    @Column(name="TX_IDFR_ISCR_DEB", length=1)
    public Character getTextoIdentificadorInscricaoDebito() {
        return this.textoIdentificadorInscricaoDebito;
    }

    public void setTextoIdentificadorInscricaoDebito(Character textoIdentificadorInscricaoDebito) {
        this.textoIdentificadorInscricaoDebito = textoIdentificadorInscricaoDebito;
    }

    @Column(name="IN_EST_IDFR", length=1)
    public Character getIndicadorEstadoIdentificador() {
        return this.indicadorEstadoIdentificador;
    }

    public void setIndicadorEstadoIdentificador(Character indicadorEstadoIdentificador) {
        this.indicadorEstadoIdentificador = indicadorEstadoIdentificador;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="identificadorTO")
    public Set<IdentificacaoTO> getIdentificacaoTOs() {
        return this.identificacaoTOs;
    }

    public void setIdentificacaoTOs(Set<IdentificacaoTO> identificacaoTOs) {
        this.identificacaoTOs = identificacaoTOs;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="identificadorTO")
    public Set<ConvenenteTO> getConvenenteTOs() {
        return this.convenenteTOs;
    }

    public void setConvenenteTOs(Set<ConvenenteTO> convenenteTOs) {
        this.convenenteTOs = convenenteTOs;
    }

    public String toString() {
        return this.getNomeIdentificador();
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            IdentificadorTO identificadorTO = (IdentificadorTO)obj;
            return this.getId().getCodigoTipoDocumento() == identificadorTO.getId().getCodigoTipoDocumento();
        }
        return false;
    }
}

