/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.to;

import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.politec.generico.objeto.UtilObjeto;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="LAUT")
public class LeiauteTO
extends PluginTOAbstrato {
    private Integer numeroLeiaute;
    private TipoLeiauteTO tipoLeiauteTO;
    private String textoDescricaoLeiaute;
    private Integer numeroTamanhoRegistro;
    private String textoArquivoOrigem;
    private Character indicadorLeiauteModelo;
    private Character indicadorEstadoLeiaute;
    private Set<CamposLeiauteTO> camposLeiauteTOs = new HashSet<CamposLeiauteTO>(0);

    @GenericGenerator(name="generator", strategy="increment")
    @Id
    @GeneratedValue(generator="generator")
    @Column(name="NR_LAUT", unique=true, nullable=false)
    public Integer getNumeroLeiaute() {
        return this.numeroLeiaute;
    }

    public void setNumeroLeiaute(Integer numeroLeiaute) {
        this.numeroLeiaute = numeroLeiaute;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="TX_IDFR_SRVC", nullable=false), @JoinColumn(name="CD_TIP_LAUT", nullable=false), @JoinColumn(name="TX_TIP_OPR", nullable=false)})
    public TipoLeiauteTO getTipoLeiauteTO() {
        return this.tipoLeiauteTO;
    }

    public void setTipoLeiauteTO(TipoLeiauteTO tipoLeiauteTO) {
        this.tipoLeiauteTO = tipoLeiauteTO;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TX_IDFR_SRVC", nullable=false, insertable=false, updatable=false)
    public ServicoTO getServicoTO() {
        TipoLeiauteTO tipoLeiauteTO = this.getTipoLeiauteTO();
        ServicoTO servicoTO = null;
        if (UtilObjeto.isReferencia(tipoLeiauteTO)) {
            servicoTO = tipoLeiauteTO.getServicoTO();
        }
        return servicoTO;
    }

    public void setServicoTO(ServicoTO servicoTO) {
        TipoLeiauteTO tipoLeiauteTO = this.getTipoLeiauteTO();
        if (!UtilObjeto.isReferencia(tipoLeiauteTO)) {
            tipoLeiauteTO = this.getTOFactory().novoTipoLeiauteTO();
            this.setTipoLeiauteTO(tipoLeiauteTO);
        }
        this.getTipoLeiauteTO().setServicoTO(servicoTO);
        this.getTipoLeiauteTO().getId().setTextoIdentificadorServico(servicoTO.getTextoIdentificadorServico());
    }

    @Column(name="TX_DCR_LAUT", length=50)
    public String getTextoDescricaoLeiaute() {
        return this.textoDescricaoLeiaute;
    }

    public void setTextoDescricaoLeiaute(String textoDescricaoLeiaute) {
        this.textoDescricaoLeiaute = textoDescricaoLeiaute;
    }

    @Column(name="NR_TAM_REG", updatable=true)
    public Integer getNumeroTamanhoRegistro() {
        return this.numeroTamanhoRegistro;
    }

    public void setNumeroTamanhoRegistro(Integer numeroTamanhoRegistro) {
        this.numeroTamanhoRegistro = numeroTamanhoRegistro;
    }

    @Column(name="TX_ARQ_OGM", length=50)
    public String getTextoArquivoOrigem() {
        return this.textoArquivoOrigem;
    }

    public void setTextoArquivoOrigem(String textoArquivoOrigem) {
        this.textoArquivoOrigem = textoArquivoOrigem;
    }

    @Column(name="IN_LAUT_MOD", length=1)
    public Character getIndicadorLeiauteModelo() {
        return this.indicadorLeiauteModelo;
    }

    public void setIndicadorLeiauteModelo(Character indicadorLeiauteModelo) {
        this.indicadorLeiauteModelo = indicadorLeiauteModelo;
    }

    @Column(name="IN_EST_LAUT", length=1)
    public Character getIndicadorEstadoLeiaute() {
        return this.indicadorEstadoLeiaute;
    }

    public void setIndicadorEstadoLeiaute(Character indicadorEstadoLeiaute) {
        this.indicadorEstadoLeiaute = indicadorEstadoLeiaute;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="leiauteTO")
    @OrderBy(value="numeroPosicaoInicio")
    public Set<CamposLeiauteTO> getCamposLeiauteTOs() {
        return this.camposLeiauteTOs;
    }

    public void setCamposLeiauteTOs(Set<CamposLeiauteTO> camposLeiauteTOs) {
        this.camposLeiauteTOs = camposLeiauteTOs;
    }

    @Transient
    public String getTextoTipoOperacao() {
        return this.getTipoLeiauteTO().getTextoTipoOperacao();
    }

    public void setTextoTipoOperacao(String textoTipoOperacao) {
        this.getTipoLeiauteTO().setTextoTipoOperacao(textoTipoOperacao);
    }

    public String toString() {
        return this.getTextoDescricaoLeiaute();
    }
}

