/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.to.decorator;

import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.util.dominio.UtilDominioCamposDeLeiaute;

public class CamposLeiauteTODecorator
extends PluginTODecoratorAbstrato {
    private static final long serialVersionUID = 1L;
    private CamposLeiauteTO camposLeiauteTO;
    private boolean campoObrigatorio;
    private String campoObrigatorioDescricao;
    private Character formato;
    private String formatoDescricao;
    public static final String ALFANUMERICO = "alfanum\u00e9rico";
    public static final String NUMERICO = "num\u00e9rico";

    public CamposLeiauteTODecorator() {
    }

    public CamposLeiauteTODecorator(CamposLeiauteTO camposLeiauteTO) {
        this.camposLeiauteTO = camposLeiauteTO;
        this.campoObrigatorio = UtilDominioCamposDeLeiaute.getInstancia().isCampoObrigatorio(camposLeiauteTO);
        this.formato = UtilDominioCamposDeLeiaute.getInstancia().getFormato(camposLeiauteTO);
        this.campoObrigatorioDescricao = this.descricaoObrigatorio();
        this.formatoDescricao = this.descricaoFormato();
    }

    public CamposLeiauteTO getCamposLeiauteTO() {
        if (this.camposLeiauteTO == null) {
            this.camposLeiauteTO = new CamposLeiauteTO();
        }
        return this.camposLeiauteTO;
    }

    public void setCamposLeiauteTO(CamposLeiauteTO camposLeiauteTO) {
        this.camposLeiauteTO = camposLeiauteTO;
    }

    public boolean isCampoObrigatorio() {
        return this.campoObrigatorio;
    }

    public void setCampoObrigatorio(boolean campoObrigatorio) {
        this.campoObrigatorio = campoObrigatorio;
    }

    public LeiauteTO getLeiauteTO() {
        return this.getCamposLeiauteTO().getLeiauteTO();
    }

    public String getTextoDescricaoCampo() {
        return this.getCamposLeiauteTO().getTextoDescricaoCampo();
    }

    public String getTextoNomeCampo() {
        return this.getCamposLeiauteTO().getTextoNomeCampo();
    }

    public Integer getNumeroPosicaoInicio() {
        return this.getCamposLeiauteTO().getNumeroPosicaoInicio();
    }

    public Integer getNumeroTamanhoCampo() {
        return this.getCamposLeiauteTO().getNumeroTamanhoCampo();
    }

    public Integer getNumeroTamanhoMaximo() {
        return this.getCamposLeiauteTO().getNumeroTamanhoMaximo();
    }

    public Character getIndicadorEstadoCamposLeiaute() {
        return this.getCamposLeiauteTO().getIndicadorEstadoCamposLeiaute();
    }

    public void setLeiauteTO(LeiauteTO leiauteTO) {
        this.getCamposLeiauteTO().setLeiauteTO(leiauteTO);
    }

    public void setTextoDescricaoCampo(String textoDescricaoCampo) {
        this.getCamposLeiauteTO().setTextoDescricaoCampo(textoDescricaoCampo);
    }

    public void setTextoNomeCampo(String textoNomeCampo) {
        this.getCamposLeiauteTO().setTextoNomeCampo(textoNomeCampo);
    }

    public void setNumeroPosicaoInicio(Integer numeroPosicaoInicio) {
        this.getCamposLeiauteTO().setNumeroPosicaoInicio(numeroPosicaoInicio);
    }

    public void setNumeroTamanhoCampo(Integer numeroTamanhoCampo) {
        this.getCamposLeiauteTO().setNumeroTamanhoCampo(numeroTamanhoCampo);
    }

    public void setNumeroTamanhoMaximo(Integer numeroTamanhoMaximo) {
        this.getCamposLeiauteTO().setNumeroTamanhoMaximo(numeroTamanhoMaximo);
    }

    public void setIndicadorEstadoCamposLeiaute(Character indicadorEstadoCamposLeiaute) {
        this.getCamposLeiauteTO().setIndicadorEstadoCamposLeiaute(indicadorEstadoCamposLeiaute);
    }

    public Character getFormato() {
        return this.formato;
    }

    public String getFormatoString() {
        return this.formato.toString();
    }

    private String descricaoFormato() {
        switch (this.formato.charValue()) {
            case 'A': {
                return ALFANUMERICO;
            }
            case 'N': {
                return NUMERICO;
            }
        }
        return null;
    }

    private String descricaoObrigatorio() {
        return this.campoObrigatorio ? "obrigat\u00f3rio" : "opcional";
    }

    public void setFormato(Character formato) {
        this.formato = formato;
    }

    public String getCampoObrigatorioDescricao() {
        if (this.campoObrigatorioDescricao == null) {
            this.campoObrigatorioDescricao = this.descricaoObrigatorio();
        }
        return this.campoObrigatorioDescricao;
    }

    public String getFormatoDescricao() {
        if (this.formatoDescricao == null) {
            this.formatoDescricao = this.descricaoFormato();
        }
        return this.formatoDescricao;
    }

    public void setCampoObrigatorioDescricao(String campoObrigatorioDescricao) {
        this.campoObrigatorioDescricao = campoObrigatorioDescricao;
    }

    public void setFormatoDescricao(String formatoDescricao) {
        this.formatoDescricao = formatoDescricao;
    }
}

