/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.to.decorator;

import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificacaoTODecorator;
import br.com.bb.plugins.gac.util.Utilitarios;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvenenteTODecorator
extends PluginTODecoratorAbstrato {
    private ConvenenteTO convenente;
    private Collection<TipoDocumentoTO> colecaoTipoDocumento;
    private boolean apagarDocumento;
    private IdentificadorTO identificadorProprio;
    private ServicoTO servico;

    public String getTextoNome() {
        return this.getPessoaTO().getTextoNome();
    }

    public String getInscricao() {
        String inscricao = null;
        Set<IdentificacaoTO> set = this.getPessoaTO().getIdentificacaoTOs();
        for (IdentificacaoTO to : set) {
            IdentificacaoTODecorator decorador = this.getTOFactory().novoIdentificacaoTODecorator();
            decorador.setIdentificacaoTO(to);
            inscricao = this.isPessoaFisica(decorador) || decorador.getNomeIdentificador().trim().equalsIgnoreCase("CNPJ") || decorador.getIdentificadorTO().getId().getCodigoTipoDocumento() < 9 ? Utilitarios.formatarCPFouCNPJ(decorador.getTextoIdentificacao().trim()) : decorador.getTextoIdentificacao().trim();
        }
        return inscricao;
    }

    private boolean isPessoaFisica(IdentificacaoTODecorator to) {
        return this.getPessoaTO().getTipoPessoaTO().getCodigoTipoPessoa() == 1 && to.getNomeIdentificador().equalsIgnoreCase("CPF");
    }

    public ConvenenteTO getConvenente() {
        return this.convenente;
    }

    public void setConvenente(ConvenenteTO convenente) {
        this.convenente = convenente;
    }

    public String getTextoIdentificacaoDaPessoa() {
        return this.getIdentificacaoTO().getId().getTextoIdentificacao();
    }

    public String getNumeroInscricao() {
        return this.getIdentificacaoTO().getId().getTextoIdentificacao();
    }

    public void setNumeroInscricao(String inscricao) {
        this.getIdentificacaoTO().setTextoComplemento(inscricao);
    }

    public IdentificacaoTO getIdentificacaoTO() {
        Set<IdentificacaoTO> colecaoIdentificacaoTO = this.getPessoaTO().getIdentificacaoTOs();
        IdentificacaoTO resultado = this.getTOFactory().novoIdentificacaoTO();
        for (IdentificacaoTO identificacaoTO : colecaoIdentificacaoTO) {
            TipoDocumentoTO tipoDocumentoTO = identificacaoTO.getTipoDocumentoTO();
            if (!this.isPessoaFisica(tipoDocumentoTO) && !this.isPessoaJuridica(tipoDocumentoTO)) continue;
            resultado = identificacaoTO;
        }
        return resultado;
    }

    public PessoaTO getPessoaTO() {
        return this.getConvenente().getPessoaTO();
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.getConvenente().setPessoaTO(pessoaTO);
    }

    private boolean isPessoaJuridica(TipoDocumentoTO tipoDocumentoTO) {
        if (this.getPessoaTO() == null || this.getPessoaTO().getTipoPessoaTO() == null || tipoDocumentoTO == null) {
            return false;
        }
        return this.getPessoaTO().getTipoPessoaTO().getCodigoTipoPessoa() == 2 && tipoDocumentoTO.getTextoDescricao().equals("CNPJ");
    }

    private boolean isPessoaFisica(TipoDocumentoTO tipoDocumentoTO) {
        if (this.getPessoaTO() == null || this.getPessoaTO().getTipoPessoaTO() == null || tipoDocumentoTO == null) {
            return false;
        }
        return this.getPessoaTO().getTipoPessoaTO().getCodigoTipoPessoa() == 1 && tipoDocumentoTO.getTextoDescricao().equals("CPF");
    }

    public Collection<TipoDocumentoTO> getColecaoTipoDocumento() {
        return this.colecaoTipoDocumento;
    }

    public void setColecaoTipoDocumento(Collection<TipoDocumentoTO> colecaoTipoDocumento) {
        this.colecaoTipoDocumento = colecaoTipoDocumento;
    }

    public Integer getCodigoTipoPessoa() {
        return this.getTipoPessoaTO().getCodigoTipoPessoa();
    }

    public TipoPessoaTO getTipoPessoaTO() {
        return this.getPessoaTO().getTipoPessoaTO();
    }

    public boolean isApagarDocumento() {
        return this.apagarDocumento;
    }

    public void setApagarDocumento(boolean apagarDocumento) {
        this.apagarDocumento = apagarDocumento;
    }

    public IdentificadorTO getIdentificadorProprio(boolean carrega) {
        if (this.identificadorProprio == null) {
            this.identificadorProprio = this.getTOFactory().novoIdentificadorTO();
        }
        if (carrega) {
            Set<IdentificacaoTO> set = this.getPessoaTO().getIdentificacaoTOs();
            for (IdentificacaoTO to : set) {
                IdentificacaoTODecorator decorador = this.getTOFactory().novoIdentificacaoTODecorator();
                decorador.setIdentificacaoTO(to);
                if (this.isPessoaFisica(decorador) || decorador.getNomeIdentificador().trim().equalsIgnoreCase("CNPJ") || decorador.getNomeIdentificador().trim().equalsIgnoreCase("CPF")) continue;
                this.identificadorProprio = to.getIdentificadorTO();
                break;
            }
        }
        return this.identificadorProprio;
    }

    public void setIdentificadorProprio(IdentificadorTO identificadorProprio) {
        this.identificadorProprio = identificadorProprio;
    }

    public ServicoTO getServico() {
        if (this.servico == null) {
            this.servico = new ServicoTO();
        }
        return this.servico;
    }

    public void setServico(ServicoTO servico) {
        this.servico = servico;
    }
}

