/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.JarUtils;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.ZipUtils;
import br.com.bb.plugins.gac.util.view.UtilPluginEmbutido;
import br.com.politec.generico.arquivo.UtilArquivo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Scanner;

public class Ajuda {
    private static final String BARRA = "/";
    private static String arquivoVersaoAjudaHTML = "versao.ini";

    public static String procuraURL(String ajudaZIP, String paginaInicialAjuda, String nomeModulo) throws BBException {
        String dirPrograma = ConfiguracaoProperties.getConfiguracaoProperties().getDirProg();
        return Ajuda.montaPathAjudaPlugins(ajudaZIP, paginaInicialAjuda, nomeModulo, dirPrograma);
    }

    private static String montaPathAjudaPlugins(String ajudaZIP, String paginaInicialAjuda, String nomeModulo, String dirPrograma) throws BBException {
        String pathAjuda = String.valueOf(dirPrograma) + "/ajuda/";
        String pluginJar = String.valueOf(dirPrograma) + Ajuda.obtenhaDiretorioPlugin(nomeModulo) + ".jar";
        String pathAjudaModulo = String.valueOf(pathAjuda) + Ajuda.obtenhaPLuginEmbutidoOuNomeModulo(nomeModulo) + BARRA;
        String pathAjudaModuloInicial = String.valueOf(pathAjudaModulo) + paginaInicialAjuda;
        String pathAjudaModuloVersao = String.valueOf(pathAjudaModulo) + arquivoVersaoAjudaHTML;
        File fileAjudaModuloInicial = new File(pathAjudaModuloInicial);
        String versaoAjudaLocal = UtilArquivo.getTextoDoArquivo(pathAjudaModuloVersao);
        String versaoAjudaHTMLJar = Ajuda.obtenhaVersaoAjudaHTML(ajudaZIP, arquivoVersaoAjudaHTML, nomeModulo);
        if (Util.parseLong(versaoAjudaLocal) < Util.parseLong(versaoAjudaHTMLJar)) {
            Ajuda.instalaAjuda(pluginJar, ajudaZIP, pathAjuda, pathAjudaModulo);
        }
        if (!fileAjudaModuloInicial.exists()) {
            Ajuda.instalaAjuda(pluginJar, ajudaZIP, pathAjuda, pathAjudaModulo);
        }
        if (!fileAjudaModuloInicial.exists()) {
            throw new BBException("Erro ao abrir o Ajuda. Tente o caminho " + pathAjudaModuloInicial);
        }
        return pathAjudaModuloInicial;
    }

    public static String obtenhaPLuginEmbutidoOuNomeModulo(String nomeModulo) {
        if (UtilPluginEmbutido.busca(nomeModulo.toUpperCase()) != null) {
            return UtilPluginEmbutido.busca(nomeModulo.toUpperCase()).toLowerCase();
        }
        return nomeModulo;
    }

    private static String obtenhaDiretorioPlugin(String nomeModulo) {
        return "GAC".equalsIgnoreCase(nomeModulo) ? "/bb" + nomeModulo : "/plugins/bb" + nomeModulo;
    }

    private static void instalaAjuda(String pluginJar, String zipAjudaModulo, String pathAjuda, String pathAjudaModulo) throws BBException {
        File fileAjudaModulo = new File(pathAjudaModulo);
        if (!fileAjudaModulo.exists()) {
            fileAjudaModulo.mkdirs();
        }
        if (fileAjudaModulo.exists()) {
            JarUtils.descompacta(pluginJar, zipAjudaModulo, ConfiguracaoProperties.getConfiguracaoProperties().getDirTemp());
            ZipUtils.descompacta(String.valueOf(ConfiguracaoProperties.getConfiguracaoProperties().getDirTemp()) + zipAjudaModulo, pathAjuda);
        }
    }

    private static String obtenhaVersaoAjudaHTML(String zipAjudaModulo, String arquivoVersaoAjudaHTMLDoJar, String nomeModulo) throws BBException {
        String dirPrograma = ConfiguracaoProperties.getConfiguracaoProperties().getDirProg();
        String pluginJar = String.valueOf(dirPrograma) + Ajuda.obtenhaDiretorioPlugin(nomeModulo) + ".jar";
        String versaoiniDoZIP = String.valueOf(nomeModulo) + BARRA + arquivoVersaoAjudaHTMLDoJar;
        byte[] ajudaDBTZipBytes = JarUtils.descompacta(pluginJar, zipAjudaModulo);
        byte[] versaoiniBytes = ZipUtils.descompacta(ajudaDBTZipBytes, versaoiniDoZIP);
        ByteArrayInputStream bis = new ByteArrayInputStream(versaoiniBytes);
        Scanner scanner = new Scanner(new BufferedInputStream(bis));
        return scanner.next();
    }

    public static void existe(String url) throws BBException {
        File fileAjuda = new File(url);
        if (!fileAjuda.exists()) {
            throw new BBException("Erro ao abrir o Ajuda. Tente o caminho " + url);
        }
    }
}

