/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.StringUtil;
import br.com.bb.plugins.gac.util.bean.BeanUtil;
import java.util.Calendar;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorUtil
implements Comparator<Object> {
    public static final int ORDEM_ASCENDENTE = 0;
    public static final int ORDEM_DESCENDENTE = 1;
    private String[] campos;
    private int ordem;

    private ComparatorUtil(String[] campos, int ordem) {
        this.campos = campos;
        this.ordem = ordem;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        Object[] objsArg0 = new Object[this.campos.length];
        Object[] objsArg1 = new Object[this.campos.length];
        int i = 0;
        while (i < this.campos.length) {
            String[] atributos = StringUtil.split(this.campos[i], '.');
            try {
                objsArg0[i] = BeanUtil.getValorAtributos(arg0, atributos);
                objsArg1[i] = BeanUtil.getValorAtributos(arg1, atributos);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            ++i;
        }
        i = 0;
        while (i < objsArg0.length) {
            if (objsArg0[i] == null || objsArg1[i] == null) {
                int valorComparacao = 0;
                if (objsArg0[i] == null && objsArg1[i] != null) {
                    int n = valorComparacao = this.ordem == 1 ? -1 : 1;
                }
                if (objsArg1[i] == null && objsArg0[i] != null) {
                    valorComparacao = this.ordem == 1 ? 1 : -1;
                }
                return valorComparacao;
            }
            if (objsArg0[i] instanceof Comparable) {
                int valorComparacao = 0;
                try {
                    valorComparacao = ((Comparable)objsArg0[i]).compareTo(objsArg1[i]);
                }
                catch (NullPointerException npe) {
                    throw new IllegalArgumentException("Erro comparando os objetos, pois o campo '" + this.campos[i] + "' possui conte\u00fado nulo.");
                }
                if (valorComparacao != 0) {
                    return this.ordem == 1 ? -valorComparacao : valorComparacao;
                }
            } else if (objsArg0[i] instanceof Calendar) {
                if (((Calendar)objsArg0[i]).after(objsArg1[i])) {
                    return this.ordem == 1 ? -1 : 1;
                }
                if (((Calendar)objsArg0[i]).before(objsArg1[i])) {
                    return this.ordem == 1 ? 1 : -1;
                }
            } else {
                throw new IllegalArgumentException("O tipo do campo " + this.campos[i] + " n\u00e3o permite efetuar compara\u00e7\u00f5es.");
            }
            ++i;
        }
        return 0;
    }

    public static Comparator getComparator(String[] campos, int ordem) {
        return new ComparatorUtil(campos, ordem);
    }
}

