/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.negocio.model.MapearDiretorioModel;
import br.com.bb.plugins.gac.negocio.to.decorator.DiretoriosTODecorator;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class DiretoriosGACUtil {
    static Set<String> listaAcoesComandoRemessa = new LinkedHashSet<String>();
    static Set<String> listaAcoesComandnoRetorno = new LinkedHashSet<String>();

    static {
        listaAcoesComandoRemessa.add("CHQGERARREMESSACHEQUE");
        listaAcoesComandoRemessa.add("CHQRECUPERARREMESSAS");
        listaAcoesComandoRemessa.add("CLTGERARREMESSATITULOS");
        listaAcoesComandoRemessa.add("CLTGERARREMESSAGUIA");
        listaAcoesComandoRemessa.add("CLTRECUPERARREMESSAS");
        listaAcoesComandoRemessa.add("CPBGERARREMESSA");
        listaAcoesComandoRemessa.add("CPBRECUPERARCADASTROS");
        listaAcoesComandoRemessa.add("CPBRECUPERARCREDITOS");
        listaAcoesComandoRemessa.add("CTAGERARREMESSAFAVORECIDOCTA");
        listaAcoesComandoRemessa.add("CTAREMESSARECUPERAR");
        listaAcoesComandoRemessa.add("DBTGERREMESSA");
        listaAcoesComandoRemessa.add("DBTREMGERAR");
        listaAcoesComandoRemessa.add("DBTREMREC");
        listaAcoesComandoRemessa.add("DBTRECUPREMESSA");
        listaAcoesComandoRemessa.add("DJCGERARREMESSA");
        listaAcoesComandoRemessa.add("DJCRECUPERARREMESSA");
        listaAcoesComandoRemessa.add("EMPGERAREMPENHOS");
        listaAcoesComandoRemessa.add("EMPGERARCADASTROS");
        listaAcoesComandoRemessa.add("EMPRECUPERARREMESSA");
        listaAcoesComandoRemessa.add("GSBGERARREMESSAGUIA");
        listaAcoesComandoRemessa.add("GSBRECUPERARREMESSAS");
        listaAcoesComandoRemessa.add("IMAGERARREMESSA");
        listaAcoesComandoRemessa.add("IMARECUPERARREMESSA");
        listaAcoesComandoRemessa.add("PAGGERARREMESSA");
        listaAcoesComandoRemessa.add("PAGRECUPERARREMESSA");
        listaAcoesComandoRemessa.add("TOCGERARARQUIVOBB");
        listaAcoesComandoRemessa.add("TRIFILTROGERARREMESSA");
        listaAcoesComandoRemessa.add("TRIRECUPERARREMESSA");
        listaAcoesComandnoRetorno.add("CHQPROCESSARRETORNO");
        listaAcoesComandnoRetorno.add("CLTPROCESSARRETORNO");
        listaAcoesComandnoRetorno.add("CLTPROCESSALISTABLOQUETOELETRONICO");
        listaAcoesComandnoRetorno.add("CLTCONCILIARLANCAMENTOS");
        listaAcoesComandnoRetorno.add("CLTCONSULTARARQUIVOSRETORNO");
        listaAcoesComandnoRetorno.add("CLTBLOQELET");
        listaAcoesComandnoRetorno.add("CPBPROCESSARBENEFICIOS");
        listaAcoesComandnoRetorno.add("CTA_PROCESSAR_RETORNO_LISTA_ARQUIVOS");
        listaAcoesComandnoRetorno.add("DBTRETPROC");
        listaAcoesComandnoRetorno.add("DBTPROCRETORNO");
        listaAcoesComandnoRetorno.add("DJCPROCESSARDESPESAS");
        listaAcoesComandnoRetorno.add("EMPPROCESSAREMPENHOS");
        listaAcoesComandnoRetorno.add("GSBPROCESSARRETORNO");
        listaAcoesComandnoRetorno.add("IMAPROCESSARRETORNO");
        listaAcoesComandnoRetorno.add("PAGPROCESSARRETORNO");
        listaAcoesComandnoRetorno.add("TRIPROCESSAR");
        listaAcoesComandnoRetorno.add("TRIPROCESSARRETORNO");
    }

    private static void alteraRetorno() {
        if (!DiretoriosGACUtil.isProcessamentoArquivosRetornoPadrao()) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("DIR_CONTEXTO", "DIR_RETORNO");
            context.put("LABEL_SELECIONA_DIRETORIO", "Retorno");
            ControlableView view = ViewController.getInstance().goToView("viewAlterarDiretorio", context);
            view.doShow(context);
        }
    }

    private static void alteraRemessa() {
        if (!DiretoriosGACUtil.isGeracaoArquivosRemessaPadrao()) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("DIR_CONTEXTO", "DIR_REMESSA");
            context.put("LABEL_SELECIONA_DIRETORIO", "Remessa");
            ControlableView view = ViewController.getInstance().goToView("viewAlterarDiretorio", context);
            view.doShow(context);
        }
    }

    static boolean isProcessamentoArquivosRetornoPadrao() {
        DiretoriosTODecorator decorator = new MapearDiretorioModel().recuperarDiretorios();
        return decorator.isProcessamentoArquivosRetornoPadrao();
    }

    static boolean isGeracaoArquivosRemessaPadrao() {
        DiretoriosTODecorator decorator = new MapearDiretorioModel().recuperarDiretorios();
        return decorator.isGeracaoArquivosRemessaPadrao();
    }

    public static void selecionaDiretorio(String nomeAcaoComando) {
        if (listaAcoesComandoRemessa.contains(nomeAcaoComando)) {
            DiretoriosGACUtil.alteraRemessa();
            return;
        }
        if (listaAcoesComandnoRetorno.contains(nomeAcaoComando)) {
            DiretoriosGACUtil.alteraRetorno();
            return;
        }
    }
}

