/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.politec.infra.util.UtilLog;
import java.io.BufferedInputStream;
import java.io.DataInputStream;

public class ExecutaEspera {
    private static boolean verbose = true;

    public static void setVerbose(boolean verboseFlag) {
        verbose = verboseFlag;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static boolean exec(String command) {
        return ExecutaEspera.exec(command, false, false);
    }

    public static boolean execWait(String command) {
        return ExecutaEspera.exec(command, false, true);
    }

    public static boolean execPrint(String command) {
        return ExecutaEspera.exec(command, true, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean exec(String command, boolean printResults, boolean wait) {
        printResults = true;
        if (verbose) {
            ExecutaEspera.printSeparator();
            System.out.println("Executing '" + command + "'.");
        }
        try {
            Process p = Runtime.getRuntime().exec(command);
            if (printResults) {
                BufferedInputStream buffer = new BufferedInputStream(p.getInputStream());
                DataInputStream commandResult = new DataInputStream(buffer);
                String s = null;
                try {
                    while (true) {
                        if ((s = commandResult.readLine()) == null) {
                            commandResult.close();
                            if (p.exitValue() == 0) return true;
                            if (!verbose) return false;
                            ExecutaEspera.printError(String.valueOf(command) + " -- p.exitValue() != 0");
                            return false;
                        }
                        System.out.println("Output: " + s);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return true;
                }
            }
            if (!wait) return true;
            try {
                System.out.println(" ");
                int returnVal = p.waitFor();
                if (returnVal == 0) return true;
                if (!verbose) return false;
                ExecutaEspera.printError(command);
                return false;
            }
            catch (Exception e) {
                UtilLog.getLog().debug(e);
                if (!verbose) return false;
                ExecutaEspera.printError(command, e);
                return false;
            }
        }
        catch (Exception e) {
            if (verbose) {
                ExecutaEspera.printError(command, e);
            }
            e.printStackTrace();
            return false;
        }
    }

    private static void printError(String command, Exception e) {
        System.out.println("Error doing exec(" + command + "): " + e.getMessage());
        System.out.println("Did you specify the full pathname?");
    }

    private static void printError(String command) {
        System.out.println("Error executing '" + command + "'.");
    }

    private static void printSeparator() {
        System.out.println("==============================================");
    }
}

